# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import Optional
from datetime import datetime
from typing_extensions import Literal

from .._models import BaseModel
from .shared.safety_violation import SafetyViolation

__all__ = ["ShieldCallStep"]


class ShieldCallStep(BaseModel):
    step_id: str
    """The ID of the step."""

    step_type: Literal["shield_call"]

    turn_id: str
    """The ID of the turn."""

    completed_at: Optional[datetime] = None
    """The time the step completed."""

    started_at: Optional[datetime] = None
    """The time the step started."""

    violation: Optional[SafetyViolation] = None
    """The violation from the shield call."""
