# -*- coding: utf-8 -*-

from typing import TYPE_CHECKING

from ..enums import IntEnum as IntEnumBase


if TYPE_CHECKING:
    from enum import IntEnum

__all__ = ("EMsg",)


# fmt: off

class EMsg(IntEnumBase):
    Invalid: "IntEnum"                                                  = 0
    Multi: "IntEnum"                                                    = 1
    ProtobufWrapped: "IntEnum"                                          = 2

    GenericReply: "IntEnum"                                             = 100
    BaseGeneral: "IntEnum"                                              = 100
    DestJobFailed: "IntEnum"                                            = 113
    Alert: "IntEnum"                                                    = 115
    SCIDRequest: "IntEnum"                                              = 120
    SCIDResponse: "IntEnum"                                             = 121
    JobHeartbeat: "IntEnum"                                             = 123
    HubConnect: "IntEnum"                                               = 124
    Subscribe: "IntEnum"                                                = 126
    RouteMessage: "IntEnum"                                             = 127
    WGRequest: "IntEnum"                                                = 130
    WGResponse: "IntEnum"                                               = 131
    KeepAlive: "IntEnum"                                                = 132
    WebAPIJobRequest: "IntEnum"                                         = 133
    WebAPIJobResponse: "IntEnum"                                        = 134
    ClientSessionStart: "IntEnum"                                       = 135
    ClientSessionEnd: "IntEnum"                                         = 136
    ClientSessionUpdate: "IntEnum"                                      = 137
    StatsDeprecated: "IntEnum"                                          = 138
    Ping: "IntEnum"                                                     = 139
    PingResponse: "IntEnum"                                             = 140
    Stats: "IntEnum"                                                    = 141
    RequestFullStatsBlock: "IntEnum"                                    = 142
    LoadDBOCacheItem: "IntEnum"                                         = 143
    LoadDBOCacheItemResponse: "IntEnum"                                 = 144
    InvalidateDBOCacheItems: "IntEnum"                                  = 145
    ServiceMethod: "IntEnum"                                            = 146
    ServiceMethodResponse: "IntEnum"                                    = 147
    ClientPackageVersions: "IntEnum"                                    = 148
    TimestampRequest: "IntEnum"                                         = 149
    TimestampResponse: "IntEnum"                                        = 150
    ServiceMethodCallFromClient: "IntEnum"                              = 151
    ServiceMethodSendToClient: "IntEnum"                                = 152

    AssignSysID: "IntEnum"                                              = 200
    BaseShell: "IntEnum"                                                = 200
    Exit: "IntEnum"                                                     = 201
    DirRequest: "IntEnum"                                               = 202
    DirResponse: "IntEnum"                                              = 203
    ZipRequest: "IntEnum"                                               = 204
    ZipResponse: "IntEnum"                                              = 205
    UpdateRecordResponse: "IntEnum"                                     = 215
    UpdateCreditCardRequest: "IntEnum"                                  = 221
    UpdateUserBanResponse: "IntEnum"                                    = 225
    PrepareToExit: "IntEnum"                                            = 226
    ContentDescriptionUpdate: "IntEnum"                                 = 227
    TestResetServer: "IntEnum"                                          = 228
    UniverseChanged: "IntEnum"                                          = 229
    ShellConfigInfoUpdate: "IntEnum"                                    = 230
    RequestWindowsEventLogEntries: "IntEnum"                            = 233
    ProvideWindowsEventLogEntries: "IntEnum"                            = 234
    ShellSearchLogs: "IntEnum"                                          = 235
    ShellSearchLogsResponse: "IntEnum"                                  = 236
    ShellCheckWindowsUpdates: "IntEnum"                                 = 237
    ShellCheckWindowsUpdatesResponse: "IntEnum"                         = 238
    TestFlushDelayedSQL: "IntEnum"                                      = 240
    TestFlushDelayedSQLResponse: "IntEnum"                              = 241
    EnsureExecuteScheduledTask_TEST: "IntEnum"                          = 242
    EnsureExecuteScheduledTaskResponse_TEST: "IntEnum"                  = 243
    UpdateScheduledTaskEnableState_TEST: "IntEnum"                      = 244
    UpdateScheduledTaskEnableStateResponse_TEST: "IntEnum"              = 245
    ContentDescriptionDeltaUpdate: "IntEnum"                            = 246

    Heartbeat: "IntEnum"                                                = 300
    BaseGM: "IntEnum"                                                   = 300
    ShellFailed: "IntEnum"                                              = 301
    ExitShells: "IntEnum"                                               = 307
    ExitShell: "IntEnum"                                                = 308
    GracefulExitShell: "IntEnum"                                        = 309
    LicenseProcessingComplete: "IntEnum"                                = 316
    SetTestFlag: "IntEnum"                                              = 317
    QueuedEmailsComplete: "IntEnum"                                     = 318
    GMReportPHPError: "IntEnum"                                         = 319
    GMDRMSync: "IntEnum"                                                = 320
    PhysicalBoxInventory: "IntEnum"                                     = 321
    UpdateConfigFile: "IntEnum"                                         = 322
    TestInitDB: "IntEnum"                                               = 323
    GMWriteConfigToSQL: "IntEnum"                                       = 324
    GMLoadActivationCodes: "IntEnum"                                    = 325
    GMQueueForFBS: "IntEnum"                                            = 326
    GMSchemaConversionResults: "IntEnum"                                = 327
    GMWriteShellFailureToSQL: "IntEnum"                                 = 329
    GMWriteStatsToSOS: "IntEnum"                                        = 330
    GMGetServiceMethodRouting: "IntEnum"                                = 331
    GMGetServiceMethodRoutingResponse: "IntEnum"                        = 332

    GMTestNextBuildSchemaConversion: "IntEnum"                          = 334
    GMTestNextBuildSchemaConversionResponse: "IntEnum"                  = 335
    ExpectShellRestart: "IntEnum"                                       = 336
    HotFixProgress: "IntEnum"                                           = 337

    BaseAIS: "IntEnum"                                                  = 400
    AISRequestContentDescription: "IntEnum"                             = 402
    AISUpdateAppInfo: "IntEnum"                                         = 403
    AISGetPackageChangeNumber: "IntEnum"                                = 405
    AISGetPackageChangeNumberResponse: "IntEnum"                        = 406
    AIGetAppGCFlags: "IntEnum"                                          = 423
    AIGetAppGCFlagsResponse: "IntEnum"                                  = 424
    AIGetAppList: "IntEnum"                                             = 425
    AIGetAppListResponse: "IntEnum"                                     = 426
    AISGetCouponDefinition: "IntEnum"                                   = 429
    AISGetCouponDefinitionResponse: "IntEnum"                           = 430
    AISUpdateSlaveContentDescription: "IntEnum"                         = 431
    AISUpdateSlaveContentDescriptionResponse: "IntEnum"                 = 432
    AISTestEnableGC: "IntEnum"                                          = 433

    BaseAM: "IntEnum"                                                   = 500
    AMUpdateUserBanRequest: "IntEnum"                                   = 504
    AMAddLicense: "IntEnum"                                             = 505
    AMSendSystemIMToUser: "IntEnum"                                     = 508
    AMExtendLicense: "IntEnum"                                          = 509
    AMAddMinutesToLicense: "IntEnum"                                    = 510
    AMCancelLicense: "IntEnum"                                          = 511
    AMInitPurchase: "IntEnum"                                           = 512
    AMPurchaseResponse: "IntEnum"                                       = 513
    AMGetFinalPrice: "IntEnum"                                          = 514
    AMGetFinalPriceResponse: "IntEnum"                                  = 515
    AMGetLegacyGameKey: "IntEnum"                                       = 516
    AMGetLegacyGameKeyResponse: "IntEnum"                               = 517
    AMFindHungTransactions: "IntEnum"                                   = 518
    AMSetAccountTrustedRequest: "IntEnum"                               = 519
    AMCancelPurchase: "IntEnum"                                         = 522
    AMNewChallenge: "IntEnum"                                           = 523
    AMLoadOEMTickets: "IntEnum"                                         = 524
    AMFixPendingPurchase: "IntEnum"                                     = 525
    AMFixPendingPurchaseResponse: "IntEnum"                             = 526
    AMIsUserBanned: "IntEnum"                                           = 527
    AMRegisterKey: "IntEnum"                                            = 528
    AMLoadActivationCodes: "IntEnum"                                    = 529
    AMLoadActivationCodesResponse: "IntEnum"                            = 530
    AMLookupKeyResponse: "IntEnum"                                      = 531
    AMLookupKey: "IntEnum"                                              = 532
    AMChatCleanup: "IntEnum"                                            = 533
    AMClanCleanup: "IntEnum"                                            = 534
    AMFixPendingRefund: "IntEnum"                                       = 535
    AMReverseChargeback: "IntEnum"                                      = 536
    AMReverseChargebackResponse: "IntEnum"                              = 537
    AMClanCleanupList: "IntEnum"                                        = 538
    AMGetLicenses: "IntEnum"                                            = 539
    AMGetLicensesResponse: "IntEnum"                                    = 540
    AMSendCartRepurchase: "IntEnum"                                     = 541
    AMSendCartRepurchaseResponse: "IntEnum"                             = 542
    AllowUserToPlayQuery: "IntEnum"                                     = 550
    AllowUserToPlayResponse: "IntEnum"                                  = 551
    AMVerfiyUser: "IntEnum"                                             = 552
    AMClientNotPlaying: "IntEnum"                                       = 553
    AMClientRequestFriendship: "IntEnum"                                = 554
    AMRelayPublishStatus: "IntEnum"                                     = 555
    AMInitPurchaseResponse: "IntEnum"                                   = 560
    AMRevokePurchaseResponse: "IntEnum"                                 = 561
    AMRefreshGuestPasses: "IntEnum"                                     = 563
    AMGrantGuestPasses: "IntEnum"                                       = 566
    AMClanDataUpdated: "IntEnum"                                        = 567
    AMReloadAccount: "IntEnum"                                          = 568
    AMClientChatMsgRelay: "IntEnum"                                     = 569
    AMChatMulti: "IntEnum"                                              = 570
    AMClientChatInviteRelay: "IntEnum"                                  = 571
    AMChatInvite: "IntEnum"                                             = 572
    AMClientJoinChatRelay: "IntEnum"                                    = 573
    AMClientChatMemberInfoRelay: "IntEnum"                              = 574
    AMPublishChatMemberInfo: "IntEnum"                                  = 575
    AMClientAcceptFriendInvite: "IntEnum"                               = 576
    AMChatEnter: "IntEnum"                                              = 577
    AMClientPublishRemovalFromSource: "IntEnum"                         = 578
    AMChatActionResult: "IntEnum"                                       = 579
    AMFindAccounts: "IntEnum"                                           = 580
    AMFindAccountsResponse: "IntEnum"                                   = 581
    AMRequestAccountData: "IntEnum"                                     = 582
    AMRequestAccountDataResponse: "IntEnum"                             = 583
    AMSetAccountFlags: "IntEnum"                                        = 584
    AMCreateClan: "IntEnum"                                             = 586
    AMCreateClanResponse: "IntEnum"                                     = 587
    AMGetClanDetails: "IntEnum"                                         = 588
    AMGetClanDetailsResponse: "IntEnum"                                 = 589
    AMSetPersonaName: "IntEnum"                                         = 590
    AMSetAvatar: "IntEnum"                                              = 591
    AMAuthenticateUser: "IntEnum"                                       = 592
    AMAuthenticateUserResponse: "IntEnum"                               = 593
    AMP2PIntroducerMessage: "IntEnum"                                   = 596
    ClientChatAction: "IntEnum"                                         = 597
    AMClientChatActionRelay: "IntEnum"                                  = 598

    ReqChallenge: "IntEnum"                                             = 600
    BaseVS: "IntEnum"                                                   = 600
    VACResponse: "IntEnum"                                              = 601
    ReqChallengeTest: "IntEnum"                                         = 602
    VSMarkCheat: "IntEnum"                                              = 604
    VSAddCheat: "IntEnum"                                               = 605
    VSPurgeCodeModDB: "IntEnum"                                         = 606
    VSGetChallengeResults: "IntEnum"                                    = 607
    VSChallengeResultText: "IntEnum"                                    = 608
    VSReportLingerer: "IntEnum"                                         = 609
    VSRequestManagedChallenge: "IntEnum"                                = 610
    VSLoadDBFinished: "IntEnum"                                         = 611

    BaseDRMS: "IntEnum"                                                 = 625
    DRMBuildBlobRequest: "IntEnum"                                      = 628
    DRMBuildBlobResponse: "IntEnum"                                     = 629
    DRMResolveGuidRequest: "IntEnum"                                    = 630
    DRMResolveGuidResponse: "IntEnum"                                   = 631
    DRMVariabilityReport: "IntEnum"                                     = 633
    DRMVariabilityReportResponse: "IntEnum"                             = 634
    DRMStabilityReport: "IntEnum"                                       = 635
    DRMStabilityReportResponse: "IntEnum"                               = 636
    DRMDetailsReportRequest: "IntEnum"                                  = 637
    DRMDetailsReportResponse: "IntEnum"                                 = 638
    DRMProcessFile: "IntEnum"                                           = 639
    DRMAdminUpdate: "IntEnum"                                           = 640
    DRMAdminUpdateResponse: "IntEnum"                                   = 641
    DRMSync: "IntEnum"                                                  = 642
    DRMSyncResponse: "IntEnum"                                          = 643
    DRMProcessFileResponse: "IntEnum"                                   = 644
    DRMEmptyGuidCache: "IntEnum"                                        = 645
    DRMEmptyGuidCacheResponse: "IntEnum"                                = 646

    BaseCS: "IntEnum"                                                   = 650

    BaseClient: "IntEnum"                                               = 700
    ClientHeartBeat: "IntEnum"                                          = 703
    ClientVACResponse: "IntEnum"                                        = 704
    ClientLogOff: "IntEnum"                                             = 706
    ClientNoUDPConnectivity: "IntEnum"                                  = 707
    ClientConnectionStats: "IntEnum"                                    = 710
    ClientPingResponse: "IntEnum"                                       = 712
    ClientRemoveFriend: "IntEnum"                                       = 714
    ClientGamesPlayedNoDataBlob: "IntEnum"                              = 715
    ClientChangeStatus: "IntEnum"                                       = 716
    ClientVacStatusResponse: "IntEnum"                                  = 717
    ClientFriendMsg: "IntEnum"                                          = 718
    ClientSystemIM: "IntEnum"                                           = 726
    ClientSystemIMAck: "IntEnum"                                        = 727
    ClientGetLicenses: "IntEnum"                                        = 728
    ClientGetLegacyGameKey: "IntEnum"                                   = 730
    ClientAckVACBan2: "IntEnum"                                         = 732
    ClientGetPurchaseReceipts: "IntEnum"                                = 736
    ClientAckGuestPass: "IntEnum"                                       = 740
    ClientRedeemGuestPass: "IntEnum"                                    = 741
    ClientGamesPlayed: "IntEnum"                                        = 742
    ClientRegisterKey: "IntEnum"                                        = 743
    ClientInviteUserToClan: "IntEnum"                                   = 744
    ClientAcknowledgeClanInvite: "IntEnum"                              = 745
    ClientPurchaseWithMachineID: "IntEnum"                              = 746
    ClientAppUsageEvent: "IntEnum"                                      = 747
    ClientLogOnResponse: "IntEnum"                                      = 751
    ClientSetHeartbeatRate: "IntEnum"                                   = 755
    ClientLoggedOff: "IntEnum"                                          = 757
    GSApprove: "IntEnum"                                                = 758
    GSDeny: "IntEnum"                                                   = 759
    GSKick: "IntEnum"                                                   = 760
    ClientCreateAcctResponse: "IntEnum"                                 = 761
    ClientPurchaseResponse: "IntEnum"                                   = 763
    ClientPing: "IntEnum"                                               = 764
    ClientNOP: "IntEnum"                                                = 765
    ClientPersonaState: "IntEnum"                                       = 766
    ClientFriendsList: "IntEnum"                                        = 767
    ClientAccountInfo: "IntEnum"                                        = 768
    ClientNewsUpdate: "IntEnum"                                         = 771
    ClientGameConnectDeny: "IntEnum"                                    = 773
    GSStatusReply: "IntEnum"                                            = 774
    ClientGameConnectTokens: "IntEnum"                                  = 779
    ClientLicenseList: "IntEnum"                                        = 780
    ClientVACBanStatus: "IntEnum"                                       = 782
    ClientCMList: "IntEnum"                                             = 783
    ClientEncryptPct: "IntEnum"                                         = 784
    ClientGetLegacyGameKeyResponse: "IntEnum"                           = 785
    ClientAddFriend: "IntEnum"                                          = 791
    ClientAddFriendResponse: "IntEnum"                                  = 792
    ClientAckGuestPassResponse: "IntEnum"                               = 796
    ClientRedeemGuestPassResponse: "IntEnum"                            = 797
    ClientUpdateGuestPassesList: "IntEnum"                              = 798
    ClientChatMsg: "IntEnum"                                            = 799
    ClientChatInvite: "IntEnum"                                         = 800
    ClientJoinChat: "IntEnum"                                           = 801
    ClientChatMemberInfo: "IntEnum"                                     = 802
    ClientPasswordChangeResponse: "IntEnum"                             = 805
    ClientChatEnter: "IntEnum"                                          = 807
    ClientFriendRemovedFromSource: "IntEnum"                            = 808
    ClientCreateChat: "IntEnum"                                         = 809
    ClientCreateChatResponse: "IntEnum"                                 = 810
    ClientP2PIntroducerMessage: "IntEnum"                               = 813
    ClientChatActionResult: "IntEnum"                                   = 814
    ClientRequestFriendData: "IntEnum"                                  = 815
    ClientGetUserStats: "IntEnum"                                       = 818
    ClientGetUserStatsResponse: "IntEnum"                               = 819
    ClientStoreUserStats: "IntEnum"                                     = 820
    ClientStoreUserStatsResponse: "IntEnum"                             = 821
    ClientClanState: "IntEnum"                                          = 822
    ClientServiceModule: "IntEnum"                                      = 830
    ClientServiceCall: "IntEnum"                                        = 831
    ClientServiceCallResponse: "IntEnum"                                = 832
    ClientNatTraversalStatEvent: "IntEnum"                              = 839
    ClientSteamUsageEvent: "IntEnum"                                    = 842
    ClientCheckPassword: "IntEnum"                                      = 845
    ClientResetPassword: "IntEnum"                                      = 846
    ClientCheckPasswordResponse: "IntEnum"                              = 848
    ClientResetPasswordResponse: "IntEnum"                              = 849
    ClientSessionToken: "IntEnum"                                       = 850
    ClientDRMProblemReport: "IntEnum"                                   = 851
    ClientSetIgnoreFriend: "IntEnum"                                    = 855
    ClientSetIgnoreFriendResponse: "IntEnum"                            = 856
    ClientGetAppOwnershipTicket: "IntEnum"                              = 857
    ClientGetAppOwnershipTicketResponse: "IntEnum"                      = 858
    ClientGetLobbyListResponse: "IntEnum"                               = 860
    ClientServerList: "IntEnum"                                         = 880
    ClientDRMBlobRequest: "IntEnum"                                     = 896
    ClientDRMBlobResponse: "IntEnum"                                    = 897

    BaseGameServer: "IntEnum"                                           = 900
    GSDisconnectNotice: "IntEnum"                                       = 901
    GSStatus: "IntEnum"                                                 = 903
    GSUserPlaying: "IntEnum"                                            = 905
    GSStatus2: "IntEnum"                                                = 906
    GSStatusUpdate_Unused: "IntEnum"                                    = 907
    GSServerType: "IntEnum"                                             = 908
    GSPlayerList: "IntEnum"                                             = 909
    GSGetUserAchievementStatus: "IntEnum"                               = 910
    GSGetUserAchievementStatusResponse: "IntEnum"                       = 911
    GSGetPlayStats: "IntEnum"                                           = 918
    GSGetPlayStatsResponse: "IntEnum"                                   = 919
    GSGetUserGroupStatus: "IntEnum"                                     = 920
    AMGetUserGroupStatus: "IntEnum"                                     = 921
    AMGetUserGroupStatusResponse: "IntEnum"                             = 922
    GSGetUserGroupStatusResponse: "IntEnum"                             = 923
    GSGetReputation: "IntEnum"                                          = 936
    GSGetReputationResponse: "IntEnum"                                  = 937
    GSAssociateWithClan: "IntEnum"                                      = 938
    GSAssociateWithClanResponse: "IntEnum"                              = 939
    GSComputeNewPlayerCompatibility: "IntEnum"                          = 940
    GSComputeNewPlayerCompatibilityResponse: "IntEnum"                  = 941

    AdminCmd: "IntEnum"                                                 = 1000
    BaseAdmin: "IntEnum"                                                = 1000
    AdminCmdResponse: "IntEnum"                                         = 1004
    AdminLogListenRequest: "IntEnum"                                    = 1005
    AdminLogEvent: "IntEnum"                                            = 1006
    UniverseData: "IntEnum"                                             = 1010
    AdminSpew: "IntEnum"                                                = 1019
    AdminConsoleTitle: "IntEnum"                                        = 1020
    AdminGCSpew: "IntEnum"                                              = 1023
    AdminGCCommand: "IntEnum"                                           = 1024
    AdminGCGetCommandList: "IntEnum"                                    = 1025
    AdminGCGetCommandListResponse: "IntEnum"                            = 1026
    FBSConnectionData: "IntEnum"                                        = 1027
    AdminMsgSpew: "IntEnum"                                             = 1028

    FBSReqVersion: "IntEnum"                                            = 1100
    BaseFBS: "IntEnum"                                                  = 1100
    FBSVersionInfo: "IntEnum"                                           = 1101
    FBSForceRefresh: "IntEnum"                                          = 1102
    FBSForceBounce: "IntEnum"                                           = 1103
    FBSDeployPackage: "IntEnum"                                         = 1104
    FBSDeployResponse: "IntEnum"                                        = 1105
    FBSUpdateBootstrapper: "IntEnum"                                    = 1106
    FBSSetState: "IntEnum"                                              = 1107
    FBSApplyOSUpdates: "IntEnum"                                        = 1108
    FBSRunCMDScript: "IntEnum"                                          = 1109
    FBSRebootBox: "IntEnum"                                             = 1110
    FBSSetBigBrotherMode: "IntEnum"                                     = 1111
    FBSMinidumpServer: "IntEnum"                                        = 1112
    FBSDeployHotFixPackage: "IntEnum"                                   = 1114
    FBSDeployHotFixResponse: "IntEnum"                                  = 1115
    FBSDownloadHotFix: "IntEnum"                                        = 1116
    FBSDownloadHotFixResponse: "IntEnum"                                = 1117
    FBSUpdateTargetConfigFile: "IntEnum"                                = 1118
    FBSApplyAccountCred: "IntEnum"                                      = 1119
    FBSApplyAccountCredResponse: "IntEnum"                              = 1120
    FBSSetShellCount: "IntEnum"                                         = 1121
    FBSTerminateShell: "IntEnum"                                        = 1122
    FBSQueryGMForRequest: "IntEnum"                                     = 1123
    FBSQueryGMResponse: "IntEnum"                                       = 1124
    FBSTerminateZombies: "IntEnum"                                      = 1125
    FBSInfoFromBootstrapper: "IntEnum"                                  = 1126
    FBSRebootBoxResponse: "IntEnum"                                     = 1127
    FBSBootstrapperPackageRequest: "IntEnum"                            = 1128
    FBSBootstrapperPackageResponse: "IntEnum"                           = 1129
    FBSBootstrapperGetPackageChunk: "IntEnum"                           = 1130
    FBSBootstrapperGetPackageChunkResponse: "IntEnum"                   = 1131
    FBSBootstrapperPackageTransferProgress: "IntEnum"                   = 1132
    FBSRestartBootstrapper: "IntEnum"                                   = 1133
    FBSPauseFrozenDumps: "IntEnum"                                      = 1134

    FileXferRequest: "IntEnum"                                          = 1200
    BaseFileXfer: "IntEnum"                                             = 1200
    FileXferResponse: "IntEnum"                                         = 1201
    FileXferData: "IntEnum"                                             = 1202
    FileXferEnd: "IntEnum"                                              = 1203
    FileXferDataAck: "IntEnum"                                          = 1204

    ChannelAuthChallenge: "IntEnum"                                     = 1300
    BaseChannelAuth: "IntEnum"                                          = 1300
    ChannelAuthResponse: "IntEnum"                                      = 1301
    ChannelAuthResult: "IntEnum"                                        = 1302
    ChannelEncryptRequest: "IntEnum"                                    = 1303
    ChannelEncryptResponse: "IntEnum"                                   = 1304
    ChannelEncryptResult: "IntEnum"                                     = 1305

    BaseBS: "IntEnum"                                                   = 1400
    BSPurchaseStart: "IntEnum"                                          = 1401
    BSPurchaseResponse: "IntEnum"                                       = 1402
    BSAuthenticateCCTrans: "IntEnum"                                    = 1403
    BSAuthenticateCCTransResponse: "IntEnum"                            = 1404
    BSSettleComplete: "IntEnum"                                         = 1406
    BSInitPayPalTxn: "IntEnum"                                          = 1408
    BSInitPayPalTxnResponse: "IntEnum"                                  = 1409
    BSGetPayPalUserInfo: "IntEnum"                                      = 1410
    BSGetPayPalUserInfoResponse: "IntEnum"                              = 1411
    BSPaymentInstrBan: "IntEnum"                                        = 1417
    BSPaymentInstrBanResponse: "IntEnum"                                = 1418
    BSInitGCBankXferTxn: "IntEnum"                                      = 1421
    BSInitGCBankXferTxnResponse: "IntEnum"                              = 1422
    BSCommitGCTxn: "IntEnum"                                            = 1425
    BSQueryTransactionStatus: "IntEnum"                                 = 1426
    BSQueryTransactionStatusResponse: "IntEnum"                         = 1427
    BSQueryPaymentInstUsage: "IntEnum"                                  = 1431
    BSQueryPaymentInstResponse: "IntEnum"                               = 1432
    BSQueryTxnExtendedInfo: "IntEnum"                                   = 1433
    BSQueryTxnExtendedInfoResponse: "IntEnum"                           = 1434
    BSUpdateConversionRates: "IntEnum"                                  = 1435
    BSPurchaseRunFraudChecks: "IntEnum"                                 = 1437
    BSPurchaseRunFraudChecksResponse: "IntEnum"                         = 1438
    BSQueryBankInformation: "IntEnum"                                   = 1440
    BSQueryBankInformationResponse: "IntEnum"                           = 1441
    BSValidateXsollaSignature: "IntEnum"                                = 1445
    BSValidateXsollaSignatureResponse: "IntEnum"                        = 1446
    BSQiwiWalletInvoice: "IntEnum"                                      = 1448
    BSQiwiWalletInvoiceResponse: "IntEnum"                              = 1449
    BSUpdateInventoryFromProPack: "IntEnum"                             = 1450
    BSUpdateInventoryFromProPackResponse: "IntEnum"                     = 1451
    BSSendShippingRequest: "IntEnum"                                    = 1452
    BSSendShippingRequestResponse: "IntEnum"                            = 1453
    BSGetProPackOrderStatus: "IntEnum"                                  = 1454
    BSGetProPackOrderStatusResponse: "IntEnum"                          = 1455
    BSCheckJobRunning: "IntEnum"                                        = 1456
    BSCheckJobRunningResponse: "IntEnum"                                = 1457
    BSResetPackagePurchaseRateLimit: "IntEnum"                          = 1458
    BSResetPackagePurchaseRateLimitResponse: "IntEnum"                  = 1459
    BSUpdatePaymentData: "IntEnum"                                      = 1460
    BSUpdatePaymentDataResponse: "IntEnum"                              = 1461
    BSGetBillingAddress: "IntEnum"                                      = 1462
    BSGetBillingAddressResponse: "IntEnum"                              = 1463
    BSGetCreditCardInfo: "IntEnum"                                      = 1464
    BSGetCreditCardInfoResponse: "IntEnum"                              = 1465
    BSRemoveExpiredPaymentData: "IntEnum"                               = 1468
    BSRemoveExpiredPaymentDataResponse: "IntEnum"                       = 1469
    BSConvertToCurrentKeys: "IntEnum"                                   = 1470
    BSConvertToCurrentKeysResponse: "IntEnum"                           = 1471
    BSInitPurchase: "IntEnum"                                           = 1472
    BSInitPurchaseResponse: "IntEnum"                                   = 1473
    BSCompletePurchase: "IntEnum"                                       = 1474
    BSCompletePurchaseResponse: "IntEnum"                               = 1475
    BSPruneCardUsageStats: "IntEnum"                                    = 1476
    BSPruneCardUsageStatsResponse: "IntEnum"                            = 1477
    BSStoreBankInformation: "IntEnum"                                   = 1478
    BSStoreBankInformationResponse: "IntEnum"                           = 1479
    BSVerifyPOSAKey: "IntEnum"                                          = 1480
    BSVerifyPOSAKeyResponse: "IntEnum"                                  = 1481
    BSReverseRedeemPOSAKey: "IntEnum"                                   = 1482
    BSReverseRedeemPOSAKeyResponse: "IntEnum"                           = 1483
    BSQueryFindCreditCard: "IntEnum"                                    = 1484
    BSQueryFindCreditCardResponse: "IntEnum"                            = 1485
    BSStatusInquiryPOSAKey: "IntEnum"                                   = 1486
    BSStatusInquiryPOSAKeyResponse: "IntEnum"                           = 1487
    BSBoaCompraConfirmProductDelivery: "IntEnum"                        = 1494
    BSBoaCompraConfirmProductDeliveryResponse: "IntEnum"                = 1495
    BSGenerateBoaCompraMD5: "IntEnum"                                   = 1496
    BSGenerateBoaCompraMD5Response: "IntEnum"                           = 1497
    BSCommitWPTxn: "IntEnum"                                            = 1498
    BSCommitAdyenTxn: "IntEnum"                                         = 1499
    BaseATS: "IntEnum"                                                  = 1500
    ATSStartStressTest: "IntEnum"                                       = 1501
    ATSStopStressTest: "IntEnum"                                        = 1502
    ATSRunFailServerTest: "IntEnum"                                     = 1503
    ATSUFSPerfTestTask: "IntEnum"                                       = 1504
    ATSUFSPerfTestResponse: "IntEnum"                                   = 1505
    ATSCycleTCM: "IntEnum"                                              = 1506
    ATSInitDRMSStressTest: "IntEnum"                                    = 1507
    ATSCallTest: "IntEnum"                                              = 1508
    ATSCallTestReply: "IntEnum"                                         = 1509
    ATSStartExternalStress: "IntEnum"                                   = 1510
    ATSExternalStressJobStart: "IntEnum"                                = 1511
    ATSExternalStressJobQueued: "IntEnum"                               = 1512
    ATSExternalStressJobRunning: "IntEnum"                              = 1513
    ATSExternalStressJobStopped: "IntEnum"                              = 1514
    ATSExternalStressJobStopAll: "IntEnum"                              = 1515
    ATSExternalStressActionResult: "IntEnum"                            = 1516
    ATSStarted: "IntEnum"                                               = 1517
    ATSCSPerfTestTask: "IntEnum"                                        = 1518
    ATSCSPerfTestResponse: "IntEnum"                                    = 1519

    BaseDP: "IntEnum"                                                   = 1600
    DPSetPublishingState: "IntEnum"                                     = 1601
    DPUniquePlayersStat: "IntEnum"                                      = 1603
    DPStreamingUniquePlayersStat: "IntEnum"                             = 1604
    DPBlockingStats: "IntEnum"                                          = 1607
    DPNatTraversalStats: "IntEnum"                                      = 1608
    DPCloudStats: "IntEnum"                                             = 1612
    DPAchievementStats: "IntEnum"                                       = 1613
    DPGetPlayerCount: "IntEnum"                                         = 1615
    DPGetPlayerCountResponse: "IntEnum"                                 = 1616
    DPGameServersPlayersStats: "IntEnum"                                = 1617
    ClientDPCheckSpecialSurvey: "IntEnum"                               = 1620
    ClientDPCheckSpecialSurveyResponse: "IntEnum"                       = 1621
    ClientDPSendSpecialSurveyResponse: "IntEnum"                        = 1622
    ClientDPSendSpecialSurveyResponseReply: "IntEnum"                   = 1623
    DPStoreSaleStatistics: "IntEnum"                                    = 1624
    ClientDPUpdateAppJobReport: "IntEnum"                               = 1625
    DPUpdateContentEvent: "IntEnum"                                     = 1626
    ClientDPUnsignedInstallScript: "IntEnum"                            = 1627
    DPPartnerMicroTxns: "IntEnum"                                       = 1628
    DPPartnerMicroTxnsResponse: "IntEnum"                               = 1629
    ClientDPContentStatsReport: "IntEnum"                               = 1630
    DPVRUniquePlayersStat: "IntEnum"                                    = 1631

    BaseCM: "IntEnum"                                                   = 1700
    CMSetAllowState: "IntEnum"                                          = 1701
    CMSpewAllowState: "IntEnum"                                         = 1702
    CMSessionRejected: "IntEnum"                                        = 1703
    CMSetSecrets: "IntEnum"                                             = 1704
    CMGetSecrets: "IntEnum"                                             = 1705



    BaseGC: "IntEnum"                                                   = 2200
    GCCmdRevive: "IntEnum"                                              = 2203
    GCCmdDown: "IntEnum"                                                = 2206
    GCCmdDeploy: "IntEnum"                                              = 2207
    GCCmdDeployResponse: "IntEnum"                                      = 2208
    GCCmdSwitch: "IntEnum"                                              = 2209
    AMRefreshSessions: "IntEnum"                                        = 2210
    GCAchievementAwarded: "IntEnum"                                     = 2212
    GCSystemMessage: "IntEnum"                                          = 2213
    GCCmdStatus: "IntEnum"                                              = 2216
    GCInterAppMessage: "IntEnum"                                        = 2219
    GCGetEmailTemplate: "IntEnum"                                       = 2220
    GCGetEmailTemplateResponse: "IntEnum"                               = 2221
    GCHRelay: "IntEnum"                                                 = 2222
    GCHRelayToClient: "IntEnum"                                         = 2223
    GCHUpdateSession: "IntEnum"                                         = 2224
    GCHRequestUpdateSession: "IntEnum"                                  = 2225
    GCHRequestStatus: "IntEnum"                                         = 2226
    GCHRequestStatusResponse: "IntEnum"                                 = 2227
    GCHAccountVacStatusChange: "IntEnum"                                = 2228
    GCHSpawnGC: "IntEnum"                                               = 2229
    GCHSpawnGCResponse: "IntEnum"                                       = 2230
    GCHKillGC: "IntEnum"                                                = 2231
    GCHKillGCResponse: "IntEnum"                                        = 2232
    GCHAccountTradeBanStatusChange: "IntEnum"                           = 2233
    GCHAccountLockStatusChange: "IntEnum"                               = 2234
    GCHVacVerificationChange: "IntEnum"                                 = 2235
    GCHAccountPhoneNumberChange: "IntEnum"                              = 2236
    GCHAccountTwoFactorChange: "IntEnum"                                = 2237
    GCHInviteUserToLobby: "IntEnum"                                     = 2238

    BaseP2P: "IntEnum"                                                  = 2500
    P2PIntroducerMessage: "IntEnum"                                     = 2502

    BaseSM: "IntEnum"                                                   = 2900
    SMExpensiveReport: "IntEnum"                                        = 2902
    SMHourlyReport: "IntEnum"                                           = 2903
    SMPartitionRenames: "IntEnum"                                       = 2905
    SMMonitorSpace: "IntEnum"                                           = 2906
    SMTestNextBuildSchemaConversion: "IntEnum"                          = 2907
    SMTestNextBuildSchemaConversionResponse: "IntEnum"                  = 2908

    BaseTest: "IntEnum"                                                 = 3000
    FailServer: "IntEnum"                                               = 3000
    JobHeartbeatTest: "IntEnum"                                         = 3001
    JobHeartbeatTestResponse: "IntEnum"                                 = 3002

    BaseFTSRange: "IntEnum"                                             = 3100

    BaseCCSRange: "IntEnum"                                             = 3150
    CCSDeleteAllCommentsByAuthor: "IntEnum"                             = 3161
    CCSDeleteAllCommentsByAuthorResponse: "IntEnum"                     = 3162

    BaseLBSRange: "IntEnum"                                             = 3200
    LBSSetScore: "IntEnum"                                              = 3201
    LBSSetScoreResponse: "IntEnum"                                      = 3202
    LBSFindOrCreateLB: "IntEnum"                                        = 3203
    LBSFindOrCreateLBResponse: "IntEnum"                                = 3204
    LBSGetLBEntries: "IntEnum"                                          = 3205
    LBSGetLBEntriesResponse: "IntEnum"                                  = 3206
    LBSGetLBList: "IntEnum"                                             = 3207
    LBSGetLBListResponse: "IntEnum"                                     = 3208
    LBSSetLBDetails: "IntEnum"                                          = 3209
    LBSDeleteLB: "IntEnum"                                              = 3210
    LBSDeleteLBEntry: "IntEnum"                                         = 3211
    LBSResetLB: "IntEnum"                                               = 3212
    LBSResetLBResponse: "IntEnum"                                       = 3213
    LBSDeleteLBResponse: "IntEnum"                                      = 3214

    BaseOGS: "IntEnum"                                                  = 3400
    OGSBeginSession: "IntEnum"                                          = 3401
    OGSBeginSessionResponse: "IntEnum"                                  = 3402
    OGSEndSession: "IntEnum"                                            = 3403
    OGSEndSessionResponse: "IntEnum"                                    = 3404
    OGSWriteAppSessionRow: "IntEnum"                                    = 3406

    BaseBRP: "IntEnum"                                                  = 3600
    BRPStartShippingJobs: "IntEnum"                                     = 3601
    BRPProcessUSBankReports: "IntEnum"                                  = 3602
    BRPProcessGCReports: "IntEnum"                                      = 3603
    BRPProcessPPReports: "IntEnum"                                      = 3604
    BRPCommitGC: "IntEnum"                                              = 3607
    BRPCommitGCResponse: "IntEnum"                                      = 3608
    BRPFindHungTransactions: "IntEnum"                                  = 3609
    BRPCheckFinanceCloseOutDate: "IntEnum"                              = 3610
    BRPProcessLicenses: "IntEnum"                                       = 3611
    BRPProcessLicensesResponse: "IntEnum"                               = 3612
    BRPRemoveExpiredPaymentData: "IntEnum"                              = 3613
    BRPRemoveExpiredPaymentDataResponse: "IntEnum"                      = 3614
    BRPConvertToCurrentKeys: "IntEnum"                                  = 3615
    BRPConvertToCurrentKeysResponse: "IntEnum"                          = 3616
    BRPPruneCardUsageStats: "IntEnum"                                   = 3617
    BRPPruneCardUsageStatsResponse: "IntEnum"                           = 3618
    BRPCheckActivationCodes: "IntEnum"                                  = 3619
    BRPCheckActivationCodesResponse: "IntEnum"                          = 3620
    BRPCommitWP: "IntEnum"                                              = 3621
    BRPCommitWPResponse: "IntEnum"                                      = 3622
    BRPProcessWPReports: "IntEnum"                                      = 3623
    BRPProcessPaymentRules: "IntEnum"                                   = 3624
    BRPProcessPartnerPayments: "IntEnum"                                = 3625
    BRPCheckSettlementReports: "IntEnum"                                = 3626
    BRPPostTaxToAvalara: "IntEnum"                                      = 3628
    BRPPostTransactionTax: "IntEnum"                                    = 3629
    BRPPostTransactionTaxResponse: "IntEnum"                            = 3630
    BRPProcessIMReports: "IntEnum"                                      = 3631

    BaseAMRange2: "IntEnum"                                             = 4000
    AMCreateChat: "IntEnum"                                             = 4001
    AMCreateChatResponse: "IntEnum"                                     = 4002
    AMSetProfileURL: "IntEnum"                                          = 4005
    AMGetAccountEmailAddress: "IntEnum"                                 = 4006
    AMGetAccountEmailAddressResponse: "IntEnum"                         = 4007
    AMRequestClanData: "IntEnum"                                        = 4008
    AMRouteToClients: "IntEnum"                                         = 4009
    AMLeaveClan: "IntEnum"                                              = 4010
    AMClanPermissions: "IntEnum"                                        = 4011
    AMClanPermissionsResponse: "IntEnum"                                = 4012
    AMCreateClanEventDummyForRateLimiting: "IntEnum"                    = 4013
    AMUpdateClanEventDummyForRateLimiting: "IntEnum"                    = 4015
    AMCreateClanEventResponse: "IntEnum"                                = 4014
    AMUpdateClanEvent: "IntEnum"                                        = 4015
    AMUpdateClanEventResponse: "IntEnum"                                = 4016
    AMGetClanEvents: "IntEnum"                                          = 4017
    AMGetClanEventsResponse: "IntEnum"                                  = 4018
    AMDeleteClanEvent: "IntEnum"                                        = 4019
    AMDeleteClanEventResponse: "IntEnum"                                = 4020
    AMSetClanPermissionSettings: "IntEnum"                              = 4021
    AMSetClanPermissionSettingsResponse: "IntEnum"                      = 4022
    AMGetClanPermissionSettings: "IntEnum"                              = 4023
    AMGetClanPermissionSettingsResponse: "IntEnum"                      = 4024
    AMPublishChatRoomInfo: "IntEnum"                                    = 4025
    ClientChatRoomInfo: "IntEnum"                                       = 4026
    AMGetClanHistory: "IntEnum"                                         = 4039
    AMGetClanHistoryResponse: "IntEnum"                                 = 4040
    AMGetClanPermissionBits: "IntEnum"                                  = 4041
    AMGetClanPermissionBitsResponse: "IntEnum"                          = 4042
    AMSetClanPermissionBits: "IntEnum"                                  = 4043
    AMSetClanPermissionBitsResponse: "IntEnum"                          = 4044
    AMSessionInfoRequest: "IntEnum"                                     = 4045
    AMSessionInfoResponse: "IntEnum"                                    = 4046
    AMValidateWGToken: "IntEnum"                                        = 4047
    AMGetSingleClanEvent: "IntEnum"                                     = 4048
    AMGetSingleClanEventResponse: "IntEnum"                             = 4049
    AMGetClanRank: "IntEnum"                                            = 4050
    AMGetClanRankResponse: "IntEnum"                                    = 4051
    AMSetClanRank: "IntEnum"                                            = 4052
    AMSetClanRankResponse: "IntEnum"                                    = 4053
    AMGetClanPOTW: "IntEnum"                                            = 4054
    AMGetClanPOTWResponse: "IntEnum"                                    = 4055
    AMSetClanPOTW: "IntEnum"                                            = 4056
    AMSetClanPOTWResponse: "IntEnum"                                    = 4057
    AMDumpUser: "IntEnum"                                               = 4059
    AMKickUserFromClan: "IntEnum"                                       = 4060
    AMAddFounderToClan: "IntEnum"                                       = 4061
    AMValidateWGTokenResponse: "IntEnum"                                = 4062
    AMSetCommunityState: "IntEnum"                                      = 4063
    AMSetAccountDetails: "IntEnum"                                      = 4064
    AMGetChatBanList: "IntEnum"                                         = 4065
    AMGetChatBanListResponse: "IntEnum"                                 = 4066
    AMUnBanFromChat: "IntEnum"                                          = 4067
    AMSetClanDetails: "IntEnum"                                         = 4068
    AMGetAccountLinks: "IntEnum"                                        = 4069
    AMGetAccountLinksResponse: "IntEnum"                                = 4070
    AMSetAccountLinks: "IntEnum"                                        = 4071
    AMSetAccountLinksResponse: "IntEnum"                                = 4072
    UGSGetUserGameStats: "IntEnum"                                      = 4073
    UGSGetUserGameStatsResponse: "IntEnum"                              = 4074
    AMCheckClanMembership: "IntEnum"                                    = 4075
    AMGetClanMembers: "IntEnum"                                         = 4076
    AMGetClanMembersResponse: "IntEnum"                                 = 4077
    AMJoinPublicClan: "IntEnum"                                         = 4078
    AMNotifyChatOfClanChange: "IntEnum"                                 = 4079
    AMResubmitPurchase: "IntEnum"                                       = 4080
    AMAddFriend: "IntEnum"                                              = 4081
    AMAddFriendResponse: "IntEnum"                                      = 4082
    AMRemoveFriend: "IntEnum"                                           = 4083
    AMDumpClan: "IntEnum"                                               = 4084
    AMChangeClanOwner: "IntEnum"                                        = 4085
    AMCancelEasyCollect: "IntEnum"                                      = 4086
    AMCancelEasyCollectResponse: "IntEnum"                              = 4087
    AMClansInCommon: "IntEnum"                                          = 4090
    AMClansInCommonResponse: "IntEnum"                                  = 4091
    AMIsValidAccountID: "IntEnum"                                       = 4092
    AMConvertClan: "IntEnum"                                            = 4093
    AMWipeFriendsList: "IntEnum"                                        = 4095
    AMSetIgnored: "IntEnum"                                             = 4096
    AMClansInCommonCountResponse: "IntEnum"                             = 4097
    AMFriendsList: "IntEnum"                                            = 4098
    AMFriendsListResponse: "IntEnum"                                    = 4099
    AMFriendsInCommon: "IntEnum"                                        = 4100
    AMFriendsInCommonResponse: "IntEnum"                                = 4101
    AMFriendsInCommonCountResponse: "IntEnum"                           = 4102
    AMClansInCommonCount: "IntEnum"                                     = 4103
    AMChallengeVerdict: "IntEnum"                                       = 4104
    AMChallengeNotification: "IntEnum"                                  = 4105
    AMFindGSByIP: "IntEnum"                                             = 4106
    AMFoundGSByIP: "IntEnum"                                            = 4107
    AMGiftRevoked: "IntEnum"                                            = 4108
    AMCreateAccountRecord: "IntEnum"                                    = 4109
    AMUserClanList: "IntEnum"                                           = 4110
    AMUserClanListResponse: "IntEnum"                                   = 4111
    AMGetAccountDetails2: "IntEnum"                                     = 4112
    AMGetAccountDetailsResponse2: "IntEnum"                             = 4113
    AMSetCommunityProfileSettings: "IntEnum"                            = 4114
    AMSetCommunityProfileSettingsResponse: "IntEnum"                    = 4115
    AMGetCommunityPrivacyState: "IntEnum"                               = 4116
    AMGetCommunityPrivacyStateResponse: "IntEnum"                       = 4117
    AMCheckClanInviteRateLimiting: "IntEnum"                            = 4118
    UGSGetUserAchievementStatus: "IntEnum"                              = 4119
    AMGetIgnored: "IntEnum"                                             = 4120
    AMGetIgnoredResponse: "IntEnum"                                     = 4121
    AMSetIgnoredResponse: "IntEnum"                                     = 4122
    AMSetFriendRelationshipNone: "IntEnum"                              = 4123
    AMGetFriendRelationship: "IntEnum"                                  = 4124
    AMGetFriendRelationshipResponse: "IntEnum"                          = 4125
    AMServiceModulesCache: "IntEnum"                                    = 4126
    AMServiceModulesCall: "IntEnum"                                     = 4127
    AMServiceModulesCallResponse: "IntEnum"                             = 4128
    AMGetCaptchaDataForIP: "IntEnum"                                    = 4129
    AMGetCaptchaDataForIPResponse: "IntEnum"                            = 4130
    AMValidateCaptchaDataForIP: "IntEnum"                               = 4131
    AMValidateCaptchaDataForIPResponse: "IntEnum"                       = 4132
    AMTrackFailedAuthByIP: "IntEnum"                                    = 4133
    AMGetCaptchaDataByGID: "IntEnum"                                    = 4134
    AMGetCaptchaDataByGIDResponse: "IntEnum"                            = 4135
    CommunityAddFriendNews: "IntEnum"                                   = 4140
    AMFindClanUser: "IntEnum"                                           = 4143
    AMFindClanUserResponse: "IntEnum"                                   = 4144
    AMBanFromChat: "IntEnum"                                            = 4145
    AMGetUserNewsSubscriptions: "IntEnum"                               = 4147
    AMGetUserNewsSubscriptionsResponse: "IntEnum"                       = 4148
    AMSetUserNewsSubscriptions: "IntEnum"                               = 4149
    AMSendQueuedEmails: "IntEnum"                                       = 4152
    AMSetLicenseFlags: "IntEnum"                                        = 4153
    CommunityDeleteUserNews: "IntEnum"                                  = 4155
    AMAllowUserFilesRequest: "IntEnum"                                  = 4156
    AMAllowUserFilesResponse: "IntEnum"                                 = 4157
    AMGetAccountStatus: "IntEnum"                                       = 4158
    AMGetAccountStatusResponse: "IntEnum"                               = 4159
    AMEditBanReason: "IntEnum"                                          = 4160
    AMCheckClanMembershipResponse: "IntEnum"                            = 4161
    AMProbeClanMembershipList: "IntEnum"                                = 4162
    AMProbeClanMembershipListResponse: "IntEnum"                        = 4163
    UGSGetUserAchievementStatusResponse: "IntEnum"                      = 4164
    AMGetFriendsLobbies: "IntEnum"                                      = 4165
    AMGetFriendsLobbiesResponse: "IntEnum"                              = 4166
    AMGetUserFriendNewsResponse: "IntEnum"                              = 4172
    CommunityGetUserFriendNews: "IntEnum"                               = 4173
    AMGetUserClansNewsResponse: "IntEnum"                               = 4174
    AMGetUserClansNews: "IntEnum"                                       = 4175
    AMGetPreviousCBAccount: "IntEnum"                                   = 4184
    AMGetPreviousCBAccountResponse: "IntEnum"                           = 4185
    AMGetUserLicenseHistory: "IntEnum"                                  = 4190
    AMGetUserLicenseHistoryResponse: "IntEnum"                          = 4191
    AMSupportChangePassword: "IntEnum"                                  = 4194
    AMSupportChangeEmail: "IntEnum"                                     = 4195
    AMResetUserVerificationGSByIP: "IntEnum"                            = 4197
    AMUpdateGSPlayStats: "IntEnum"                                      = 4198
    AMSupportEnableOrDisable: "IntEnum"                                 = 4199
    AMGetPurchaseStatus: "IntEnum"                                      = 4206
    AMSupportIsAccountEnabled: "IntEnum"                                = 4209
    AMSupportIsAccountEnabledResponse: "IntEnum"                        = 4210
    UGSGetUserStats: "IntEnum"                                          = 4211
    AMSupportKickSession: "IntEnum"                                     = 4212
    AMGSSearch: "IntEnum"                                               = 4213
    MarketingMessageUpdate: "IntEnum"                                   = 4216
    ChatServerRouteFriendMsg: "IntEnum"                                 = 4219
    AMTicketAuthRequestOrResponse: "IntEnum"                            = 4220
    AMVerifyDepotManagementRights: "IntEnum"                            = 4222
    AMVerifyDepotManagementRightsResponse: "IntEnum"                    = 4223
    AMAddFreeLicense: "IntEnum"                                         = 4224
    AMValidateEmailLink: "IntEnum"                                      = 4231
    AMValidateEmailLinkResponse: "IntEnum"                              = 4232
    UGSStoreUserStats: "IntEnum"                                        = 4236
    AMDeleteStoredCard: "IntEnum"                                       = 4241
    AMRevokeLegacyGameKeys: "IntEnum"                                   = 4242
    AMGetWalletDetails: "IntEnum"                                       = 4244
    AMGetWalletDetailsResponse: "IntEnum"                               = 4245
    AMDeleteStoredPaymentInfo: "IntEnum"                                = 4246
    AMGetStoredPaymentSummary: "IntEnum"                                = 4247
    AMGetStoredPaymentSummaryResponse: "IntEnum"                        = 4248
    AMGetWalletConversionRate: "IntEnum"                                = 4249
    AMGetWalletConversionRateResponse: "IntEnum"                        = 4250
    AMConvertWallet: "IntEnum"                                          = 4251
    AMConvertWalletResponse: "IntEnum"                                  = 4252
    AMSetPreApproval: "IntEnum"                                         = 4255
    AMSetPreApprovalResponse: "IntEnum"                                 = 4256
    AMCreateRefund: "IntEnum"                                           = 4258
    AMCreateRefundResponse: "IntEnum"                                   = 4259
    AMCreateChargeback: "IntEnum"                                       = 4260
    AMCreateChargebackResponse: "IntEnum"                               = 4261
    AMCreateDispute: "IntEnum"                                          = 4262
    AMCreateDisputeResponse: "IntEnum"                                  = 4263
    AMClearDispute: "IntEnum"                                           = 4264
    AMCreateFinancialAdjustment: "IntEnum"                              = 4265
    AMPlayerNicknameList: "IntEnum"                                     = 4266
    AMPlayerNicknameListResponse: "IntEnum"                             = 4267
    AMSetDRMTestConfig: "IntEnum"                                       = 4268
    AMGetUserCurrentGameInfo: "IntEnum"                                 = 4269
    AMGetUserCurrentGameInfoResponse: "IntEnum"                         = 4270
    AMGetGSPlayerList: "IntEnum"                                        = 4271
    AMGetGSPlayerListResponse: "IntEnum"                                = 4272
    AMGetGameMembers: "IntEnum"                                         = 4276
    AMGetGameMembersResponse: "IntEnum"                                 = 4277
    AMGetSteamIDForMicroTxn: "IntEnum"                                  = 4278
    AMGetSteamIDForMicroTxnResponse: "IntEnum"                          = 4279
    AMSetPartnerMember: "IntEnum"                                       = 4280
    AMRemovePublisherUser: "IntEnum"                                    = 4281
    AMGetUserLicenseList: "IntEnum"                                     = 4282
    AMGetUserLicenseListResponse: "IntEnum"                             = 4283
    AMReloadGameGroupPolicy: "IntEnum"                                  = 4284
    AMAddFreeLicenseResponse: "IntEnum"                                 = 4285
    AMVACStatusUpdate: "IntEnum"                                        = 4286
    AMGetAccountDetails: "IntEnum"                                      = 4287
    AMGetAccountDetailsResponse: "IntEnum"                              = 4288
    AMGetPlayerLinkDetails: "IntEnum"                                   = 4289
    AMGetPlayerLinkDetailsResponse: "IntEnum"                           = 4290
    AMGetAccountFlagsForWGSpoofing: "IntEnum"                           = 4294
    AMGetAccountFlagsForWGSpoofingResponse: "IntEnum"                   = 4295
    AMGetClanOfficers: "IntEnum"                                        = 4298
    AMGetClanOfficersResponse: "IntEnum"                                = 4299
    AMNameChange: "IntEnum"                                             = 4300
    AMGetNameHistory: "IntEnum"                                         = 4301
    AMGetNameHistoryResponse: "IntEnum"                                 = 4302
    AMUpdateProviderStatus: "IntEnum"                                   = 4305
    AMSupportRemoveAccountSecurity: "IntEnum"                           = 4307
    AMIsAccountInCaptchaGracePeriod: "IntEnum"                          = 4308
    AMIsAccountInCaptchaGracePeriodResponse: "IntEnum"                  = 4309
    AMAccountPS3Unlink: "IntEnum"                                       = 4310
    AMAccountPS3UnlinkResponse: "IntEnum"                               = 4311
    UGSStoreUserStatsResponse: "IntEnum"                                = 4312
    AMGetAccountPSNInfo: "IntEnum"                                      = 4313
    AMGetAccountPSNInfoResponse: "IntEnum"                              = 4314
    AMAuthenticatedPlayerList: "IntEnum"                                = 4315
    AMGetUserGifts: "IntEnum"                                           = 4316
    AMGetUserGiftsResponse: "IntEnum"                                   = 4317
    AMTransferLockedGifts: "IntEnum"                                    = 4320
    AMTransferLockedGiftsResponse: "IntEnum"                            = 4321
    AMPlayerHostedOnGameServer: "IntEnum"                               = 4322
    AMGetAccountBanInfo: "IntEnum"                                      = 4323
    AMGetAccountBanInfoResponse: "IntEnum"                              = 4324
    AMRecordBanEnforcement: "IntEnum"                                   = 4325
    AMRollbackGiftTransfer: "IntEnum"                                   = 4326
    AMRollbackGiftTransferResponse: "IntEnum"                           = 4327
    AMHandlePendingTransaction: "IntEnum"                               = 4328
    AMRequestClanDetails: "IntEnum"                                     = 4329
    AMDeleteStoredPaypalAgreement: "IntEnum"                            = 4330
    AMGameServerUpdate: "IntEnum"                                       = 4331
    AMGameServerRemove: "IntEnum"                                       = 4332
    AMGetPaypalAgreements: "IntEnum"                                    = 4333
    AMGetPaypalAgreementsResponse: "IntEnum"                            = 4334
    AMGameServerPlayerCompatibilityCheck: "IntEnum"                     = 4335
    AMGameServerPlayerCompatibilityCheckResponse: "IntEnum"             = 4336
    AMRenewLicense: "IntEnum"                                           = 4337
    AMGetAccountCommunityBanInfo: "IntEnum"                             = 4338
    AMGetAccountCommunityBanInfoResponse: "IntEnum"                     = 4339
    AMGameServerAccountChangePassword: "IntEnum"                        = 4340
    AMGameServerAccountDeleteAccount: "IntEnum"                         = 4341
    AMRenewAgreement: "IntEnum"                                         = 4342
    AMXsollaPayment: "IntEnum"                                          = 4344
    AMXsollaPaymentResponse: "IntEnum"                                  = 4345
    AMAcctAllowedToPurchase: "IntEnum"                                  = 4346
    AMAcctAllowedToPurchaseResponse: "IntEnum"                          = 4347
    AMSwapKioskDeposit: "IntEnum"                                       = 4348
    AMSwapKioskDepositResponse: "IntEnum"                               = 4349
    AMSetUserGiftUnowned: "IntEnum"                                     = 4350
    AMSetUserGiftUnownedResponse: "IntEnum"                             = 4351
    AMClaimUnownedUserGift: "IntEnum"                                   = 4352
    AMClaimUnownedUserGiftResponse: "IntEnum"                           = 4353
    AMSetClanName: "IntEnum"                                            = 4354
    AMSetClanNameResponse: "IntEnum"                                    = 4355
    AMGrantCoupon: "IntEnum"                                            = 4356
    AMGrantCouponResponse: "IntEnum"                                    = 4357
    AMIsPackageRestrictedInUserCountry: "IntEnum"                       = 4358
    AMIsPackageRestrictedInUserCountryResponse: "IntEnum"               = 4359
    AMHandlePendingTransactionResponse: "IntEnum"                       = 4360
    AMGrantGuestPasses2: "IntEnum"                                      = 4361
    AMGrantGuestPasses2Response: "IntEnum"                              = 4362
    AMSessionQuery: "IntEnum"                                           = 4363
    AMSessionQueryResponse: "IntEnum"                                   = 4364
    AMGetPlayerBanDetails: "IntEnum"                                    = 4365
    AMGetPlayerBanDetailsResponse: "IntEnum"                            = 4366
    AMFinalizePurchase: "IntEnum"                                       = 4367
    AMFinalizePurchaseResponse: "IntEnum"                               = 4368
    AMPersonaChangeResponse: "IntEnum"                                  = 4372
    AMGetClanDetailsForForumCreation: "IntEnum"                         = 4373
    AMGetClanDetailsForForumCreationResponse: "IntEnum"                 = 4374
    AMGetPendingNotificationCount: "IntEnum"                            = 4375
    AMGetPendingNotificationCountResponse: "IntEnum"                    = 4376
    AMPasswordHashUpgrade: "IntEnum"                                    = 4377
    AMMoPayPayment: "IntEnum"                                           = 4378
    AMMoPayPaymentResponse: "IntEnum"                                   = 4379
    AMBoaCompraPayment: "IntEnum"                                       = 4380
    AMBoaCompraPaymentResponse: "IntEnum"                               = 4381
    AMExpireCaptchaByGID: "IntEnum"                                     = 4382
    AMCompleteExternalPurchase: "IntEnum"                               = 4383
    AMCompleteExternalPurchaseResponse: "IntEnum"                       = 4384
    AMResolveNegativeWalletCredits: "IntEnum"                           = 4385
    AMResolveNegativeWalletCreditsResponse: "IntEnum"                   = 4386
    AMPayelpPayment: "IntEnum"                                          = 4387
    AMPayelpPaymentResponse: "IntEnum"                                  = 4388
    AMPlayerGetClanBasicDetails: "IntEnum"                              = 4389
    AMPlayerGetClanBasicDetailsResponse: "IntEnum"                      = 4390
    AMMOLPayment: "IntEnum"                                             = 4391
    AMMOLPaymentResponse: "IntEnum"                                     = 4392
    GetUserIPCountry: "IntEnum"                                         = 4393
    GetUserIPCountryResponse: "IntEnum"                                 = 4394
    NotificationOfSuspiciousActivity: "IntEnum"                         = 4395
    AMDegicaPayment: "IntEnum"                                          = 4396
    AMDegicaPaymentResponse: "IntEnum"                                  = 4397
    AMEClubPayment: "IntEnum"                                           = 4398
    AMEClubPaymentResponse: "IntEnum"                                   = 4399
    AMPayPalPaymentsHubPayment: "IntEnum"                               = 4400
    AMPayPalPaymentsHubPaymentResponse: "IntEnum"                       = 4401
    AMTwoFactorRecoverAuthenticatorRequest: "IntEnum"                   = 4402
    AMTwoFactorRecoverAuthenticatorResponse: "IntEnum"                  = 4403
    AMSmart2PayPayment: "IntEnum"                                       = 4404
    AMSmart2PayPaymentResponse: "IntEnum"                               = 4405
    AMValidatePasswordResetCodeAndSendSmsRequest: "IntEnum"             = 4406
    AMValidatePasswordResetCodeAndSendSmsResponse: "IntEnum"            = 4407
    AMGetAccountResetDetailsRequest: "IntEnum"                          = 4408
    AMGetAccountResetDetailsResponse: "IntEnum"                         = 4409
    AMBitPayPayment: "IntEnum"                                          = 4410
    AMBitPayPaymentResponse: "IntEnum"                                  = 4411
    AMSendAccountInfoUpdate: "IntEnum"                                  = 4412
    AMSendScheduledGift: "IntEnum"                                      = 4413
    AMNodwinPayment: "IntEnum"                                          = 4414
    AMNodwinPaymentResponse: "IntEnum"                                  = 4415
    AMResolveWalletRevoke: "IntEnum"                                    = 4416
    AMResolveWalletReverseRevoke: "IntEnum"                             = 4417
    AMFundedPayment: "IntEnum"                                          = 4418
    AMFundedPaymentResponse: "IntEnum"                                  = 4419
    AMRequestPersonaUpdateForChatServer: "IntEnum"                      = 4420
    AMPerfectWorldPayment: "IntEnum"                                    = 4421
    AMPerfectWorldPaymentResponse: "IntEnum"                            = 4422

    BasePSRange: "IntEnum"                                              = 5000
    PSCreateShoppingCart: "IntEnum"                                     = 5001
    PSCreateShoppingCartResponse: "IntEnum"                             = 5002
    PSIsValidShoppingCart: "IntEnum"                                    = 5003
    PSIsValidShoppingCartResponse: "IntEnum"                            = 5004
    PSAddPackageToShoppingCart: "IntEnum"                               = 5005
    PSAddPackageToShoppingCartResponse: "IntEnum"                       = 5006
    PSRemoveLineItemFromShoppingCart: "IntEnum"                         = 5007
    PSRemoveLineItemFromShoppingCartResponse: "IntEnum"                 = 5008
    PSGetShoppingCartContents: "IntEnum"                                = 5009
    PSGetShoppingCartContentsResponse: "IntEnum"                        = 5010
    PSAddWalletCreditToShoppingCart: "IntEnum"                          = 5011
    PSAddWalletCreditToShoppingCartResponse: "IntEnum"                  = 5012

    BaseUFSRange: "IntEnum"                                             = 5200
    ClientUFSUploadFileRequest: "IntEnum"                               = 5202
    ClientUFSUploadFileResponse: "IntEnum"                              = 5203
    ClientUFSUploadFileChunk: "IntEnum"                                 = 5204
    ClientUFSUploadFileFinished: "IntEnum"                              = 5205
    ClientUFSGetFileListForApp: "IntEnum"                               = 5206
    ClientUFSGetFileListForAppResponse: "IntEnum"                       = 5207
    ClientUFSDownloadRequest: "IntEnum"                                 = 5210
    ClientUFSDownloadResponse: "IntEnum"                                = 5211
    ClientUFSDownloadChunk: "IntEnum"                                   = 5212
    ClientUFSLoginRequest: "IntEnum"                                    = 5213
    ClientUFSLoginResponse: "IntEnum"                                   = 5214
    UFSReloadPartitionInfo: "IntEnum"                                   = 5215
    ClientUFSTransferHeartbeat: "IntEnum"                               = 5216
    UFSSynchronizeFile: "IntEnum"                                       = 5217
    UFSSynchronizeFileResponse: "IntEnum"                               = 5218
    ClientUFSDeleteFileRequest: "IntEnum"                               = 5219
    ClientUFSDeleteFileResponse: "IntEnum"                              = 5220
    UFSDownloadRequest: "IntEnum"                                       = 5221
    UFSDownloadResponse: "IntEnum"                                      = 5222
    UFSDownloadChunk: "IntEnum"                                         = 5223
    ClientUFSGetUGCDetails: "IntEnum"                                   = 5226
    ClientUFSGetUGCDetailsResponse: "IntEnum"                           = 5227
    UFSUpdateFileFlags: "IntEnum"                                       = 5228
    UFSUpdateFileFlagsResponse: "IntEnum"                               = 5229
    ClientUFSGetSingleFileInfo: "IntEnum"                               = 5230
    ClientUFSGetSingleFileInfoResponse: "IntEnum"                       = 5231
    ClientUFSShareFile: "IntEnum"                                       = 5232
    ClientUFSShareFileResponse: "IntEnum"                               = 5233
    UFSReloadAccount: "IntEnum"                                         = 5234
    UFSReloadAccountResponse: "IntEnum"                                 = 5235
    UFSUpdateRecordBatched: "IntEnum"                                   = 5236
    UFSUpdateRecordBatchedResponse: "IntEnum"                           = 5237
    UFSMigrateFile: "IntEnum"                                           = 5238
    UFSMigrateFileResponse: "IntEnum"                                   = 5239
    UFSGetUGCURLs: "IntEnum"                                            = 5240
    UFSGetUGCURLsResponse: "IntEnum"                                    = 5241
    UFSHttpUploadFileFinishRequest: "IntEnum"                           = 5242
    UFSHttpUploadFileFinishResponse: "IntEnum"                          = 5243
    UFSDownloadStartRequest: "IntEnum"                                  = 5244
    UFSDownloadStartResponse: "IntEnum"                                 = 5245
    UFSDownloadChunkRequest: "IntEnum"                                  = 5246
    UFSDownloadChunkResponse: "IntEnum"                                 = 5247
    UFSDownloadFinishRequest: "IntEnum"                                 = 5248
    UFSDownloadFinishResponse: "IntEnum"                                = 5249
    UFSFlushURLCache: "IntEnum"                                         = 5250
    ClientUFSUploadCommit: "IntEnum"                                    = 5251
    ClientUFSUploadCommitResponse: "IntEnum"                            = 5252
    UFSMigrateFileAppID: "IntEnum"                                      = 5253
    UFSMigrateFileAppIDResponse: "IntEnum"                              = 5254

    BaseClient2: "IntEnum"                                              = 5400
    ClientRequestForgottenPasswordEmail: "IntEnum"                      = 5401
    ClientRequestForgottenPasswordEmailResponse: "IntEnum"              = 5402
    ClientCreateAccountResponse: "IntEnum"                              = 5403
    ClientResetForgottenPassword: "IntEnum"                             = 5404
    ClientResetForgottenPasswordResponse: "IntEnum"                     = 5405
    ClientCreateAccount2: "IntEnum"                                     = 5406
    ClientInformOfResetForgottenPassword: "IntEnum"                     = 5407
    ClientInformOfResetForgottenPasswordResponse: "IntEnum"             = 5408
    ClientGamesPlayedWithDataBlob: "IntEnum"                            = 5410
    ClientUpdateUserGameInfo: "IntEnum"                                 = 5411
    ClientFileToDownload: "IntEnum"                                     = 5412
    ClientFileToDownloadResponse: "IntEnum"                             = 5413
    ClientLBSSetScore: "IntEnum"                                        = 5414
    ClientLBSSetScoreResponse: "IntEnum"                                = 5415
    ClientLBSFindOrCreateLB: "IntEnum"                                  = 5416
    ClientLBSFindOrCreateLBResponse: "IntEnum"                          = 5417
    ClientLBSGetLBEntries: "IntEnum"                                    = 5418
    ClientLBSGetLBEntriesResponse: "IntEnum"                            = 5419
    ClientChatDeclined: "IntEnum"                                       = 5426
    ClientFriendMsgIncoming: "IntEnum"                                  = 5427
    ClientTicketAuthComplete: "IntEnum"                                 = 5429
    ClientIsLimitedAccount: "IntEnum"                                   = 5430
    ClientRequestAuthList: "IntEnum"                                    = 5431
    ClientAuthList: "IntEnum"                                           = 5432
    ClientStat: "IntEnum"                                               = 5433
    ClientP2PConnectionInfo: "IntEnum"                                  = 5434
    ClientP2PConnectionFailInfo: "IntEnum"                              = 5435
    ClientGetDepotDecryptionKey: "IntEnum"                              = 5438
    ClientGetDepotDecryptionKeyResponse: "IntEnum"                      = 5439
    GSPerformHardwareSurvey: "IntEnum"                                  = 5440
    ClientEnableTestLicense: "IntEnum"                                  = 5443
    ClientEnableTestLicenseResponse: "IntEnum"                          = 5444
    ClientDisableTestLicense: "IntEnum"                                 = 5445
    ClientDisableTestLicenseResponse: "IntEnum"                         = 5446
    ClientRequestValidationMail: "IntEnum"                              = 5448
    ClientRequestValidationMailResponse: "IntEnum"                      = 5449
    ClientCheckAppBetaPassword: "IntEnum"                               = 5450
    ClientCheckAppBetaPasswordResponse: "IntEnum"                       = 5451
    ClientToGC: "IntEnum"                                               = 5452
    ClientFromGC: "IntEnum"                                             = 5453
    ClientRequestChangeMail: "IntEnum"                                  = 5454
    ClientRequestChangeMailResponse: "IntEnum"                          = 5455
    ClientEmailAddrInfo: "IntEnum"                                      = 5456
    ClientPasswordChange3: "IntEnum"                                    = 5457
    ClientEmailChange3: "IntEnum"                                       = 5458
    ClientPersonalQAChange3: "IntEnum"                                  = 5459
    ClientResetForgottenPassword3: "IntEnum"                            = 5460
    ClientRequestForgottenPasswordEmail3: "IntEnum"                     = 5461
    ClientNewLoginKey: "IntEnum"                                        = 5463
    ClientNewLoginKeyAccepted: "IntEnum"                                = 5464
    ClientStoreUserStats2: "IntEnum"                                    = 5466
    ClientStatsUpdated: "IntEnum"                                       = 5467
    ClientActivateOEMLicense: "IntEnum"                                 = 5468
    ClientRegisterOEMMachine: "IntEnum"                                 = 5469
    ClientRegisterOEMMachineResponse: "IntEnum"                         = 5470
    ClientRequestedClientStats: "IntEnum"                               = 5480
    ClientStat2Int32: "IntEnum"                                         = 5481
    ClientStat2: "IntEnum"                                              = 5482
    ClientVerifyPassword: "IntEnum"                                     = 5483
    ClientVerifyPasswordResponse: "IntEnum"                             = 5484
    ClientDRMDownloadRequest: "IntEnum"                                 = 5485
    ClientDRMDownloadResponse: "IntEnum"                                = 5486
    ClientDRMFinalResult: "IntEnum"                                     = 5487
    ClientGetFriendsWhoPlayGame: "IntEnum"                              = 5488
    ClientGetFriendsWhoPlayGameResponse: "IntEnum"                      = 5489
    ClientOGSBeginSession: "IntEnum"                                    = 5490
    ClientOGSBeginSessionResponse: "IntEnum"                            = 5491
    ClientOGSEndSession: "IntEnum"                                      = 5492
    ClientOGSEndSessionResponse: "IntEnum"                              = 5493
    ClientOGSWriteRow: "IntEnum"                                        = 5494
    ClientDRMTest: "IntEnum"                                            = 5495
    ClientDRMTestResult: "IntEnum"                                      = 5496
    ClientServerUnavailable: "IntEnum"                                  = 5500
    ClientServersAvailable: "IntEnum"                                   = 5501
    ClientRegisterAuthTicketWithCM: "IntEnum"                           = 5502
    ClientGCMsgFailed: "IntEnum"                                        = 5503
    ClientMicroTxnAuthRequest: "IntEnum"                                = 5504
    ClientMicroTxnAuthorize: "IntEnum"                                  = 5505
    ClientMicroTxnAuthorizeResponse: "IntEnum"                          = 5506
    ClientAppMinutesPlayedData: "IntEnum"                               = 5507
    ClientGetMicroTxnInfo: "IntEnum"                                    = 5508
    ClientGetMicroTxnInfoResponse: "IntEnum"                            = 5509
    ClientMarketingMessageUpdate2: "IntEnum"                            = 5510
    ClientDeregisterWithServer: "IntEnum"                               = 5511
    ClientSubscribeToPersonaFeed: "IntEnum"                             = 5512
    ClientLogon: "IntEnum"                                              = 5514
    ClientGetClientDetails: "IntEnum"                                   = 5515
    ClientGetClientDetailsResponse: "IntEnum"                           = 5516
    ClientReportOverlayDetourFailure: "IntEnum"                         = 5517
    ClientGetClientAppList: "IntEnum"                                   = 5518
    ClientGetClientAppListResponse: "IntEnum"                           = 5519
    ClientInstallClientApp: "IntEnum"                                   = 5520
    ClientInstallClientAppResponse: "IntEnum"                           = 5521
    ClientUninstallClientApp: "IntEnum"                                 = 5522
    ClientUninstallClientAppResponse: "IntEnum"                         = 5523
    ClientSetClientAppUpdateState: "IntEnum"                            = 5524
    ClientSetClientAppUpdateStateResponse: "IntEnum"                    = 5525
    ClientRequestEncryptedAppTicket: "IntEnum"                          = 5526
    ClientRequestEncryptedAppTicketResponse: "IntEnum"                  = 5527
    ClientWalletInfoUpdate: "IntEnum"                                   = 5528
    ClientLBSSetUGC: "IntEnum"                                          = 5529
    ClientLBSSetUGCResponse: "IntEnum"                                  = 5530
    ClientAMGetClanOfficers: "IntEnum"                                  = 5531
    ClientAMGetClanOfficersResponse: "IntEnum"                          = 5532
    ClientFriendProfileInfo: "IntEnum"                                  = 5535
    ClientFriendProfileInfoResponse: "IntEnum"                          = 5536
    ClientUpdateMachineAuth: "IntEnum"                                  = 5537
    ClientUpdateMachineAuthResponse: "IntEnum"                          = 5538
    ClientReadMachineAuth: "IntEnum"                                    = 5539
    ClientReadMachineAuthResponse: "IntEnum"                            = 5540
    ClientRequestMachineAuth: "IntEnum"                                 = 5541
    ClientRequestMachineAuthResponse: "IntEnum"                         = 5542
    ClientScreenshotsChanged: "IntEnum"                                 = 5543
    ClientEmailChange4: "IntEnum"                                       = 5544
    ClientEmailChangeResponse4: "IntEnum"                               = 5545
    ClientGetCDNAuthToken: "IntEnum"                                    = 5546
    ClientGetCDNAuthTokenResponse: "IntEnum"                            = 5547
    ClientDownloadRateStatistics: "IntEnum"                             = 5548
    ClientRequestAccountData: "IntEnum"                                 = 5549
    ClientRequestAccountDataResponse: "IntEnum"                         = 5550
    ClientResetForgottenPassword4: "IntEnum"                            = 5551
    ClientHideFriend: "IntEnum"                                         = 5552
    ClientFriendsGroupsList: "IntEnum"                                  = 5553
    ClientGetClanActivityCounts: "IntEnum"                              = 5554
    ClientGetClanActivityCountsResponse: "IntEnum"                      = 5555
    ClientOGSReportString: "IntEnum"                                    = 5556
    ClientOGSReportBug: "IntEnum"                                       = 5557
    ClientSentLogs: "IntEnum"                                           = 5558
    ClientLogonGameServer: "IntEnum"                                    = 5559
    AMClientCreateFriendsGroup: "IntEnum"                               = 5560
    AMClientCreateFriendsGroupResponse: "IntEnum"                       = 5561
    AMClientDeleteFriendsGroup: "IntEnum"                               = 5562
    AMClientDeleteFriendsGroupResponse: "IntEnum"                       = 5563
    AMClientManageFriendsGroup: "IntEnum"                               = 5564
    AMClientManageFriendsGroupResponse: "IntEnum"                       = 5565
    AMClientAddFriendToGroup: "IntEnum"                                 = 5566
    AMClientAddFriendToGroupResponse: "IntEnum"                         = 5567
    AMClientRemoveFriendFromGroup: "IntEnum"                            = 5568
    AMClientRemoveFriendFromGroupResponse: "IntEnum"                    = 5569
    ClientAMGetPersonaNameHistory: "IntEnum"                            = 5570
    ClientAMGetPersonaNameHistoryResponse: "IntEnum"                    = 5571
    ClientRequestFreeLicense: "IntEnum"                                 = 5572
    ClientRequestFreeLicenseResponse: "IntEnum"                         = 5573
    ClientDRMDownloadRequestWithCrashData: "IntEnum"                    = 5574
    ClientAuthListAck: "IntEnum"                                        = 5575
    ClientItemAnnouncements: "IntEnum"                                  = 5576
    ClientRequestItemAnnouncements: "IntEnum"                           = 5577
    ClientFriendMsgEchoToSender: "IntEnum"                              = 5578
    ClientOGSGameServerPingSample: "IntEnum"                            = 5581
    ClientCommentNotifications: "IntEnum"                               = 5582
    ClientRequestCommentNotifications: "IntEnum"                        = 5583
    ClientPersonaChangeResponse: "IntEnum"                              = 5584
    ClientRequestWebAPIAuthenticateUserNonce: "IntEnum"                 = 5585
    ClientRequestWebAPIAuthenticateUserNonceResponse: "IntEnum"         = 5586
    ClientPlayerNicknameList: "IntEnum"                                 = 5587
    AMClientSetPlayerNickname: "IntEnum"                                = 5588
    AMClientSetPlayerNicknameResponse: "IntEnum"                        = 5589
    ClientCreateAccountProto: "IntEnum"                                 = 5590
    ClientCreateAccountProtoResponse: "IntEnum"                         = 5591
    ClientGetNumberOfCurrentPlayersDP: "IntEnum"                        = 5592
    ClientGetNumberOfCurrentPlayersDPResponse: "IntEnum"                = 5593
    ClientServiceMethodLegacy: "IntEnum"                                = 5594
    ClientServiceMethodLegacyResponse: "IntEnum"                        = 5595
    ClientFriendUserStatusPublished: "IntEnum"                          = 5596
    ClientCurrentUIMode: "IntEnum"                                      = 5597
    ClientVanityURLChangedNotification: "IntEnum"                       = 5598
    ClientUserNotifications: "IntEnum"                                  = 5599

    BaseDFS: "IntEnum"                                                  = 5600
    DFSGetFile: "IntEnum"                                               = 5601
    DFSInstallLocalFile: "IntEnum"                                      = 5602
    DFSConnection: "IntEnum"                                            = 5603
    DFSConnectionReply: "IntEnum"                                       = 5604
    ClientDFSAuthenticateRequest: "IntEnum"                             = 5605
    ClientDFSAuthenticateResponse: "IntEnum"                            = 5606
    ClientDFSEndSession: "IntEnum"                                      = 5607
    DFSPurgeFile: "IntEnum"                                             = 5608
    DFSRouteFile: "IntEnum"                                             = 5609
    DFSGetFileFromServer: "IntEnum"                                     = 5610
    DFSAcceptedResponse: "IntEnum"                                      = 5611
    DFSRequestPingback: "IntEnum"                                       = 5612
    DFSRecvTransmitFile: "IntEnum"                                      = 5613
    DFSSendTransmitFile: "IntEnum"                                      = 5614
    DFSRequestPingback2: "IntEnum"                                      = 5615
    DFSResponsePingback2: "IntEnum"                                     = 5616
    ClientDFSDownloadStatus: "IntEnum"                                  = 5617
    DFSStartTransfer: "IntEnum"                                         = 5618
    DFSTransferComplete: "IntEnum"                                      = 5619
    DFSRouteFileResponse: "IntEnum"                                     = 5620
    ClientNetworkingCertRequest: "IntEnum"                              = 5621
    ClientNetworkingCertRequestResponse: "IntEnum"                      = 5622
    ClientChallengeRequest: "IntEnum"                                   = 5623
    ClientChallengeResponse: "IntEnum"                                  = 5624
    BadgeCraftedNotification: "IntEnum"                                 = 5625
    ClientNetworkingMobileCertRequest: "IntEnum"                        = 5626
    ClientNetworkingMobileCertRequestResponse: "IntEnum"                = 5627

    BaseMDS: "IntEnum"                                                  = 5800
    AMToMDSGetDepotDecryptionKey: "IntEnum"                             = 5812
    MDSToAMGetDepotDecryptionKeyResponse: "IntEnum"                     = 5813
    MDSContentServerConfigRequest: "IntEnum"                            = 5827
    MDSContentServerConfig: "IntEnum"                                   = 5828
    MDSGetDepotManifest: "IntEnum"                                      = 5829
    MDSGetDepotManifestResponse: "IntEnum"                              = 5830
    MDSGetDepotManifestChunk: "IntEnum"                                 = 5831
    MDSGetDepotChunk: "IntEnum"                                         = 5832
    MDSGetDepotChunkResponse: "IntEnum"                                 = 5833
    MDSGetDepotChunkChunk: "IntEnum"                                    = 5834
    MDSGetServerListForUser: "IntEnum"                                  = 5836
    MDSGetServerListForUserResponse: "IntEnum"                          = 5837
    MDSToCSFlushChunk: "IntEnum"                                        = 5844
    MDSMigrateChunk: "IntEnum"                                          = 5847
    MDSMigrateChunkResponse: "IntEnum"                                  = 5848
    MDSToCSFlushManifest: "IntEnum"                                     = 5849
    CSBase: "IntEnum"                                                   = 6200
    CSPing: "IntEnum"                                                   = 6201
    CSPingResponse: "IntEnum"                                           = 6202

    GMSBase: "IntEnum"                                                  = 6400
    GMSGameServerReplicate: "IntEnum"                                   = 6401
    ClientGMSServerQuery: "IntEnum"                                     = 6403
    GMSClientServerQueryResponse: "IntEnum"                             = 6404
    AMGMSGameServerUpdate: "IntEnum"                                    = 6405
    AMGMSGameServerRemove: "IntEnum"                                    = 6406
    GameServerOutOfDate: "IntEnum"                                      = 6407

    DeviceAuthorizationBase: "IntEnum"                                  = 6500
    ClientAuthorizeLocalDeviceRequest: "IntEnum"                        = 6501
    ClientAuthorizeLocalDeviceResponse: "IntEnum"                       = 6502
    ClientDeauthorizeDeviceRequest: "IntEnum"                           = 6503
    ClientDeauthorizeDevice: "IntEnum"                                  = 6504
    ClientUseLocalDeviceAuthorizations: "IntEnum"                       = 6505
    ClientGetAuthorizedDevices: "IntEnum"                               = 6506
    ClientGetAuthorizedDevicesResponse: "IntEnum"                       = 6507
    AMNotifySessionDeviceAuthorized: "IntEnum"                          = 6508
    ClientAuthorizeLocalDeviceNotification: "IntEnum"                   = 6509

    MMSBase: "IntEnum"                                                  = 6600
    ClientMMSCreateLobby: "IntEnum"                                     = 6601
    ClientMMSCreateLobbyResponse: "IntEnum"                             = 6602
    ClientMMSJoinLobby: "IntEnum"                                       = 6603
    ClientMMSJoinLobbyResponse: "IntEnum"                               = 6604
    ClientMMSLeaveLobby: "IntEnum"                                      = 6605
    ClientMMSLeaveLobbyResponse: "IntEnum"                              = 6606
    ClientMMSGetLobbyList: "IntEnum"                                    = 6607
    ClientMMSGetLobbyListResponse: "IntEnum"                            = 6608
    ClientMMSSetLobbyData: "IntEnum"                                    = 6609
    ClientMMSSetLobbyDataResponse: "IntEnum"                            = 6610
    ClientMMSGetLobbyData: "IntEnum"                                    = 6611
    ClientMMSLobbyData: "IntEnum"                                       = 6612
    ClientMMSSendLobbyChatMsg: "IntEnum"                                = 6613
    ClientMMSLobbyChatMsg: "IntEnum"                                    = 6614
    ClientMMSSetLobbyOwner: "IntEnum"                                   = 6615
    ClientMMSSetLobbyOwnerResponse: "IntEnum"                           = 6616
    ClientMMSSetLobbyGameServer: "IntEnum"                              = 6617
    ClientMMSLobbyGameServerSet: "IntEnum"                              = 6618
    ClientMMSUserJoinedLobby: "IntEnum"                                 = 6619
    ClientMMSUserLeftLobby: "IntEnum"                                   = 6620
    ClientMMSInviteToLobby: "IntEnum"                                   = 6621
    ClientMMSFlushFrenemyListCache: "IntEnum"                           = 6622
    ClientMMSFlushFrenemyListCacheResponse: "IntEnum"                   = 6623
    ClientMMSSetLobbyLinked: "IntEnum"                                  = 6624
    ClientMMSSetRatelimitPolicyOnClient: "IntEnum"                      = 6625
    ClientMMSGetLobbyStatus: "IntEnum"                                  = 6626
    ClientMMSGetLobbyStatusResponse: "IntEnum"                          = 6627
    MMSGetLobbyList: "IntEnum"                                          = 6628
    MMSGetLobbyListResponse: "IntEnum"                                  = 6629
    NonStdMsgBase: "IntEnum"                                            = 6800
    NonStdMsgMemcached: "IntEnum"                                       = 6801
    NonStdMsgHTTPServer: "IntEnum"                                      = 6802
    NonStdMsgHTTPClient: "IntEnum"                                      = 6803
    NonStdMsgWGResponse: "IntEnum"                                      = 6804
    NonStdMsgPHPSimulator: "IntEnum"                                    = 6805
    NonStdMsgChase: "IntEnum"                                           = 6806
    NonStdMsgDFSTransfer: "IntEnum"                                     = 6807
    NonStdMsgTests: "IntEnum"                                           = 6808
    NonStdMsgUMQpipeAAPL: "IntEnum"                                     = 6809
    NonStdMsgSyslog: "IntEnum"                                          = 6810
    NonStdMsgLogsink: "IntEnum"                                         = 6811
    NonStdMsgSteam2Emulator: "IntEnum"                                  = 6812
    NonStdMsgRTMPServer: "IntEnum"                                      = 6813
    NonStdMsgWebSocket: "IntEnum"                                       = 6814
    NonStdMsgRedis: "IntEnum"                                           = 6815

    UDSBase: "IntEnum"                                                  = 7000
    ClientUDSP2PSessionStarted: "IntEnum"                               = 7001
    ClientUDSP2PSessionEnded: "IntEnum"                                 = 7002
    UDSRenderUserAuth: "IntEnum"                                        = 7003
    UDSRenderUserAuthResponse: "IntEnum"                                = 7004
    ClientInviteToGame: "IntEnum"                                       = 7005
    UDSHasSession: "IntEnum"                                            = 7006
    UDSHasSessionResponse: "IntEnum"                                    = 7007

    MPASBase: "IntEnum"                                                 = 7100
    MPASVacBanReset: "IntEnum"                                          = 7101

    KGSBase: "IntEnum"                                                  = 7200

    UCMBase: "IntEnum"                                                  = 7300
    ClientUCMAddScreenshot: "IntEnum"                                   = 7301
    ClientUCMAddScreenshotResponse: "IntEnum"                           = 7302
    UCMResetCommunityContent: "IntEnum"                                 = 7307
    UCMResetCommunityContentResponse: "IntEnum"                         = 7308
    ClientUCMDeleteScreenshot: "IntEnum"                                = 7309
    ClientUCMDeleteScreenshotResponse: "IntEnum"                        = 7310
    ClientUCMPublishFile: "IntEnum"                                     = 7311
    ClientUCMPublishFileResponse: "IntEnum"                             = 7312
    ClientUCMDeletePublishedFile: "IntEnum"                             = 7315
    ClientUCMDeletePublishedFileResponse: "IntEnum"                     = 7316
    ClientUCMEnumerateUserPublishedFiles: "IntEnum"                     = 7317
    ClientUCMEnumerateUserPublishedFilesResponse: "IntEnum"             = 7318
    ClientUCMEnumerateUserSubscribedFiles: "IntEnum"                    = 7321
    ClientUCMEnumerateUserSubscribedFilesResponse: "IntEnum"            = 7322
    ClientUCMUpdatePublishedFile: "IntEnum"                             = 7325
    ClientUCMUpdatePublishedFileResponse: "IntEnum"                     = 7326
    UCMUpdatePublishedFile: "IntEnum"                                   = 7327
    UCMUpdatePublishedFileResponse: "IntEnum"                           = 7328
    UCMDeletePublishedFile: "IntEnum"                                   = 7329
    UCMDeletePublishedFileResponse: "IntEnum"                           = 7330
    UCMUpdatePublishedFileStat: "IntEnum"                               = 7331
    UCMUpdatePublishedFileBan: "IntEnum"                                = 7332
    UCMUpdatePublishedFileBanResponse: "IntEnum"                        = 7333
    UCMReloadPublishedFile: "IntEnum"                                   = 7337
    UCMReloadUserFileListCaches: "IntEnum"                              = 7338
    UCMPublishedFileReported: "IntEnum"                                 = 7339
    UCMPublishedFilePreviewAdd: "IntEnum"                               = 7341
    UCMPublishedFilePreviewAddResponse: "IntEnum"                       = 7342
    UCMPublishedFilePreviewRemove: "IntEnum"                            = 7343
    UCMPublishedFilePreviewRemoveResponse: "IntEnum"                    = 7344
    ClientUCMPublishedFileSubscribed: "IntEnum"                         = 7347
    ClientUCMPublishedFileUnsubscribed: "IntEnum"                       = 7348
    UCMPublishedFileSubscribed: "IntEnum"                               = 7349
    UCMPublishedFileUnsubscribed: "IntEnum"                             = 7350
    UCMPublishFile: "IntEnum"                                           = 7351
    UCMPublishFileResponse: "IntEnum"                                   = 7352
    UCMPublishedFileChildAdd: "IntEnum"                                 = 7353
    UCMPublishedFileChildAddResponse: "IntEnum"                         = 7354
    UCMPublishedFileChildRemove: "IntEnum"                              = 7355
    UCMPublishedFileChildRemoveResponse: "IntEnum"                      = 7356
    UCMPublishedFileParentChanged: "IntEnum"                            = 7359
    ClientUCMGetPublishedFilesForUser: "IntEnum"                        = 7360
    ClientUCMGetPublishedFilesForUserResponse: "IntEnum"                = 7361
    ClientUCMSetUserPublishedFileAction: "IntEnum"                      = 7364
    ClientUCMSetUserPublishedFileActionResponse: "IntEnum"              = 7365
    ClientUCMEnumeratePublishedFilesByUserAction: "IntEnum"             = 7366
    ClientUCMEnumeratePublishedFilesByUserActionResponse: "IntEnum"     = 7367
    ClientUCMPublishedFileDeleted: "IntEnum"                            = 7368
    UCMGetUserSubscribedFiles: "IntEnum"                                = 7369
    UCMGetUserSubscribedFilesResponse: "IntEnum"                        = 7370
    UCMFixStatsPublishedFile: "IntEnum"                                 = 7371
    ClientUCMEnumerateUserSubscribedFilesWithUpdates: "IntEnum"         = 7378
    ClientUCMEnumerateUserSubscribedFilesWithUpdatesResponse: "IntEnum" = 7379
    UCMPublishedFileContentUpdated: "IntEnum"                           = 7380
    ClientUCMPublishedFileUpdated: "IntEnum"                            = 7381
    ClientWorkshopItemChangesRequest: "IntEnum"                         = 7382
    ClientWorkshopItemChangesResponse: "IntEnum"                        = 7383
    ClientWorkshopItemInfoRequest: "IntEnum"                            = 7384
    ClientWorkshopItemInfoResponse: "IntEnum"                           = 7385

    FSBase: "IntEnum"                                                   = 7500
    ClientRichPresenceUpload: "IntEnum"                                 = 7501
    ClientRichPresenceRequest: "IntEnum"                                = 7502
    ClientRichPresenceInfo: "IntEnum"                                   = 7503
    FSRichPresenceRequest: "IntEnum"                                    = 7504
    FSRichPresenceResponse: "IntEnum"                                   = 7505
    FSComputeFrenematrix: "IntEnum"                                     = 7506
    FSComputeFrenematrixResponse: "IntEnum"                             = 7507
    FSPlayStatusNotification: "IntEnum"                                 = 7508
    FSAddOrRemoveFollower: "IntEnum"                                    = 7510
    FSAddOrRemoveFollowerResponse: "IntEnum"                            = 7511
    FSUpdateFollowingList: "IntEnum"                                    = 7512
    FSCommentNotification: "IntEnum"                                    = 7513
    FSCommentNotificationViewed: "IntEnum"                              = 7514
    ClientFSGetFollowerCount: "IntEnum"                                 = 7515
    ClientFSGetFollowerCountResponse: "IntEnum"                         = 7516
    ClientFSGetIsFollowing: "IntEnum"                                   = 7517
    ClientFSGetIsFollowingResponse: "IntEnum"                           = 7518
    ClientFSEnumerateFollowingList: "IntEnum"                           = 7519
    ClientFSEnumerateFollowingListResponse: "IntEnum"                   = 7520
    FSGetPendingNotificationCount: "IntEnum"                            = 7521
    FSGetPendingNotificationCountResponse: "IntEnum"                    = 7522
    ClientChatOfflineMessageNotification: "IntEnum"                     = 7523
    ClientChatRequestOfflineMessageCount: "IntEnum"                     = 7524
    ClientChatGetFriendMessageHistory: "IntEnum"                        = 7525
    ClientChatGetFriendMessageHistoryResponse: "IntEnum"                = 7526
    ClientChatGetFriendMessageHistoryForOfflineMessages: "IntEnum"      = 7527
    ClientFSGetFriendsSteamLevels: "IntEnum"                            = 7528
    ClientFSGetFriendsSteamLevelsResponse: "IntEnum"                    = 7529
    AMRequestFriendData: "IntEnum"                                      = 7530

    CEGVersionSetEnableDisableRequest: "IntEnum"                        = 7600
    DRMRange2: "IntEnum"                                                = 7600
    CEGVersionSetEnableDisableResponse: "IntEnum"                       = 7601
    CEGPropStatusDRMSRequest: "IntEnum"                                 = 7602
    CEGPropStatusDRMSResponse: "IntEnum"                                = 7603
    CEGWhackFailureReportRequest: "IntEnum"                             = 7604
    CEGWhackFailureReportResponse: "IntEnum"                            = 7605
    DRMSFetchVersionSet: "IntEnum"                                      = 7606
    DRMSFetchVersionSetResponse: "IntEnum"                              = 7607

    EconBase: "IntEnum"                                                 = 7700
    EconTrading_InitiateTradeRequest: "IntEnum"                         = 7701
    EconTrading_InitiateTradeProposed: "IntEnum"                        = 7702
    EconTrading_InitiateTradeResponse: "IntEnum"                        = 7703
    EconTrading_InitiateTradeResult: "IntEnum"                          = 7704
    EconTrading_StartSession: "IntEnum"                                 = 7705
    EconTrading_CancelTradeRequest: "IntEnum"                           = 7706
    EconFlushInventoryCache: "IntEnum"                                  = 7707
    EconFlushInventoryCacheResponse: "IntEnum"                          = 7708
    EconCDKeyProcessTransaction: "IntEnum"                              = 7711
    EconCDKeyProcessTransactionResponse: "IntEnum"                      = 7712
    EconGetErrorLogs: "IntEnum"                                         = 7713
    EconGetErrorLogsResponse: "IntEnum"                                 = 7714

    RMRange: "IntEnum"                                                  = 7800
    RMTestVerisignOTP: "IntEnum"                                        = 7800
    RMTestVerisignOTPResponse: "IntEnum"                                = 7801
    RMDeleteMemcachedKeys: "IntEnum"                                    = 7803
    RMRemoteInvoke: "IntEnum"                                           = 7804
    BadLoginIPList: "IntEnum"                                           = 7805
    RMMsgTraceAddTrigger: "IntEnum"                                     = 7806
    RMMsgTraceRemoveTrigger: "IntEnum"                                  = 7807
    RMMsgTraceEvent: "IntEnum"                                          = 7808

    UGSUpdateGlobalStats: "IntEnum"                                     = 7900
    UGSBase: "IntEnum"                                                  = 7900
    ClientUGSGetGlobalStats: "IntEnum"                                  = 7901
    ClientUGSGetGlobalStatsResponse: "IntEnum"                          = 7902

    StoreBase: "IntEnum"                                                = 8000

    UMQLogonRequest: "IntEnum"                                          = 8100
    UMQBase: "IntEnum"                                                  = 8100
    UMQLogonResponse: "IntEnum"                                         = 8101
    UMQLogoffRequest: "IntEnum"                                         = 8102
    UMQLogoffResponse: "IntEnum"                                        = 8103
    UMQSendChatMessage: "IntEnum"                                       = 8104
    UMQIncomingChatMessage: "IntEnum"                                   = 8105
    UMQPoll: "IntEnum"                                                  = 8106
    UMQPollResults: "IntEnum"                                           = 8107
    UMQ2AM_ClientMsgBatch: "IntEnum"                                    = 8108

    WorkshopBase: "IntEnum"                                             = 8200

    WebAPIValidateOAuth2Token: "IntEnum"                                = 8300
    WebAPIBase: "IntEnum"                                               = 8300
    WebAPIValidateOAuth2TokenResponse: "IntEnum"                        = 8301
    WebAPIRegisterGCInterfaces: "IntEnum"                               = 8303
    WebAPIInvalidateOAuthClientCache: "IntEnum"                         = 8304
    WebAPIInvalidateOAuthTokenCache: "IntEnum"                          = 8305
    WebAPISetSecrets: "IntEnum"                                         = 8306

    BackpackBase: "IntEnum"                                             = 8400
    BackpackAddToCurrency: "IntEnum"                                    = 8401
    BackpackAddToCurrencyResponse: "IntEnum"                            = 8402

    CREBase: "IntEnum"                                                  = 8500
    CREItemVoteSummary: "IntEnum"                                       = 8503
    CREItemVoteSummaryResponse: "IntEnum"                               = 8504
    CREUpdateUserPublishedItemVote: "IntEnum"                           = 8507
    CREUpdateUserPublishedItemVoteResponse: "IntEnum"                   = 8508
    CREGetUserPublishedItemVoteDetails: "IntEnum"                       = 8509
    CREGetUserPublishedItemVoteDetailsResponse: "IntEnum"               = 8510
    CREEnumeratePublishedFiles: "IntEnum"                               = 8511
    CREEnumeratePublishedFilesResponse: "IntEnum"                       = 8512
    CREPublishedFileVoteAdded: "IntEnum"                                = 8513

    SecretsRequestCredentialPair: "IntEnum"                             = 8600
    SecretsBase: "IntEnum"                                              = 8600
    SecretsCredentialPairResponse: "IntEnum"                            = 8601

    BoxMonitorReportRequest: "IntEnum"                                  = 8700
    BoxMonitorBase: "IntEnum"                                           = 8700
    BoxMonitorReportResponse: "IntEnum"                                 = 8701

    LogsinkWriteReport: "IntEnum"                                       = 8800
    LogsinkBase: "IntEnum"                                              = 8800

    PICSBase: "IntEnum"                                                 = 8900
    ClientPICSChangesSinceRequest: "IntEnum"                            = 8901
    ClientPICSChangesSinceResponse: "IntEnum"                           = 8902
    ClientPICSProductInfoRequest: "IntEnum"                             = 8903
    ClientPICSProductInfoResponse: "IntEnum"                            = 8904
    ClientPICSAccessTokenRequest: "IntEnum"                             = 8905
    ClientPICSAccessTokenResponse: "IntEnum"                            = 8906

    WorkerProcess: "IntEnum"                                            = 9000
    WorkerProcessPingRequest: "IntEnum"                                 = 9000
    WorkerProcessPingResponse: "IntEnum"                                = 9001
    WorkerProcessShutdown: "IntEnum"                                    = 9002

    DRMWorkerProcess: "IntEnum"                                         = 9100
    DRMWorkerProcessDRMAndSign: "IntEnum"                               = 9100
    DRMWorkerProcessDRMAndSignResponse: "IntEnum"                       = 9101
    DRMWorkerProcessSteamworksInfoRequest: "IntEnum"                    = 9102
    DRMWorkerProcessSteamworksInfoResponse: "IntEnum"                   = 9103
    DRMWorkerProcessInstallDRMDLLRequest: "IntEnum"                     = 9104
    DRMWorkerProcessInstallDRMDLLResponse: "IntEnum"                    = 9105
    DRMWorkerProcessSecretIdStringRequest: "IntEnum"                    = 9106
    DRMWorkerProcessSecretIdStringResponse: "IntEnum"                   = 9107
    DRMWorkerProcessInstallProcessedFilesRequest: "IntEnum"             = 9110
    DRMWorkerProcessInstallProcessedFilesResponse: "IntEnum"            = 9111
    DRMWorkerProcessExamineBlobRequest: "IntEnum"                       = 9112
    DRMWorkerProcessExamineBlobResponse: "IntEnum"                      = 9113
    DRMWorkerProcessDescribeSecretRequest: "IntEnum"                    = 9114
    DRMWorkerProcessDescribeSecretResponse: "IntEnum"                   = 9115
    DRMWorkerProcessBackfillOriginalRequest: "IntEnum"                  = 9116
    DRMWorkerProcessBackfillOriginalResponse: "IntEnum"                 = 9117
    DRMWorkerProcessValidateDRMDLLRequest: "IntEnum"                    = 9118
    DRMWorkerProcessValidateDRMDLLResponse: "IntEnum"                   = 9119
    DRMWorkerProcessValidateFileRequest: "IntEnum"                      = 9120
    DRMWorkerProcessValidateFileResponse: "IntEnum"                     = 9121
    DRMWorkerProcessSplitAndInstallRequest: "IntEnum"                   = 9122
    DRMWorkerProcessSplitAndInstallResponse: "IntEnum"                  = 9123
    DRMWorkerProcessGetBlobRequest: "IntEnum"                           = 9124
    DRMWorkerProcessGetBlobResponse: "IntEnum"                          = 9125
    DRMWorkerProcessEvaluateCrashRequest: "IntEnum"                     = 9126
    DRMWorkerProcessEvaluateCrashResponse: "IntEnum"                    = 9127
    DRMWorkerProcessAnalyzeFileRequest: "IntEnum"                       = 9128
    DRMWorkerProcessAnalyzeFileResponse: "IntEnum"                      = 9129
    DRMWorkerProcessUnpackBlobRequest: "IntEnum"                        = 9130
    DRMWorkerProcessUnpackBlobResponse: "IntEnum"                       = 9131
    DRMWorkerProcessInstallAllRequest: "IntEnum"                        = 9132
    DRMWorkerProcessInstallAllResponse: "IntEnum"                       = 9133

    TestWorkerProcess: "IntEnum"                                        = 9200
    TestWorkerProcessLoadUnloadModuleRequest: "IntEnum"                 = 9200
    TestWorkerProcessLoadUnloadModuleResponse: "IntEnum"                = 9201
    TestWorkerProcessServiceModuleCallRequest: "IntEnum"                = 9202
    TestWorkerProcessServiceModuleCallResponse: "IntEnum"               = 9203

    QuestServerBase: "IntEnum"                                          = 9300

    ClientGetEmoticonList: "IntEnum"                                    = 9330
    ClientEmoticonList: "IntEnum"                                       = 9331

    SLCUserSessionStatus: "IntEnum"                                     = 9400
    SLCBase: "IntEnum"                                                  = 9400
    SLCRequestUserSessionStatus: "IntEnum"                              = 9401
    SLCSharedLicensesLockStatus: "IntEnum"                              = 9402
    ClientSharedLibraryLockStatus: "IntEnum"                            = 9405
    ClientSharedLibraryStopPlaying: "IntEnum"                           = 9406
    SLCOwnerLibraryChanged: "IntEnum"                                   = 9407
    SLCSharedLibraryChanged: "IntEnum"                                  = 9408

    RemoteClientAuth_OBSOLETE: "IntEnum"                                = 9500
    RemoteClientBase: "IntEnum"                                         = 9500
    RemoteClientAuthResponse_OBSOLETE: "IntEnum"                        = 9501
    RemoteClientAppStatus: "IntEnum"                                    = 9502
    RemoteClientStartStream: "IntEnum"                                  = 9503
    RemoteClientStartStreamResponse: "IntEnum"                          = 9504
    RemoteClientPing: "IntEnum"                                         = 9505
    RemoteClientPingResponse: "IntEnum"                                 = 9506
    ClientUnlockStreaming: "IntEnum"                                    = 9507
    ClientUnlockStreamingResponse: "IntEnum"                            = 9508
    RemoteClientAcceptEULA: "IntEnum"                                   = 9509
    RemoteClientGetControllerConfig: "IntEnum"                          = 9510
    RemoteClientGetControllerConfigResponse: "IntEnum"                  = 9511
    RemoteClientStreamingEnabled: "IntEnum"                             = 9512
    ClientUnlockHEVC: "IntEnum"                                         = 9513
    ClientUnlockHEVCResponse: "IntEnum"                                 = 9514
    RemoteClientStatusRequest: "IntEnum"                                = 9515
    RemoteClientStatusResponse: "IntEnum"                               = 9516

    ClientPlayingSessionState: "IntEnum"                                = 9600
    ClientConcurrentSessionsBase: "IntEnum"                             = 9600
    ClientKickPlayingSession: "IntEnum"                                 = 9601

    ClientBroadcastBase: "IntEnum"                                      = 9700
    ClientBroadcastFrames: "IntEnum"                                    = 9701
    ClientBroadcastDisconnect: "IntEnum"                                = 9702
    ClientBroadcastScreenshot: "IntEnum"                                = 9703
    ClientBroadcastUploadConfig: "IntEnum"                              = 9704

    BaseClient3: "IntEnum"                                              = 9800
    ClientVoiceCallPreAuthorizeResponse: "IntEnum"                      = 9801
    ClientServerTimestampRequest: "IntEnum"                             = 9802
    ClientServerTimestampResponse: "IntEnum"                            = 9803

    ClientLANP2PRequestChunk: "IntEnum"                                 = 9900
    ClientLANP2PBase: "IntEnum"                                         = 9900
    ClientLANP2PRequestChunkResponse: "IntEnum"                         = 9901
    ClientLANP2PMax: "IntEnum"                                          = 9999

    NotifyWatchdog: "IntEnum"                                           = 10000

    ClientSiteLicenseSiteInfoNotification: "IntEnum"                    = 10100
    ClientSiteLicenseBase: "IntEnum"                                    = 10100
    ClientSiteLicenseCheckout: "IntEnum"                                = 10101
    ClientSiteLicenseCheckoutResponse: "IntEnum"                        = 10102
    ClientSiteLicenseGetAvailableSeats: "IntEnum"                       = 10103
    ClientSiteLicenseGetAvailableSeatsResponse: "IntEnum"               = 10104
    ClientSiteLicenseGetContentCacheInfo: "IntEnum"                     = 10105
    ClientSiteLicenseGetContentCacheInfoResponse: "IntEnum"             = 10106

    ChatServerGetPendingNotificationCount: "IntEnum"                    = 12000
    BaseChatServer: "IntEnum"                                           = 12000
    ChatServerGetPendingNotificationCountResponse: "IntEnum"            = 12001

    ServerSecretChanged: "IntEnum"                                      = 12100
    BaseSecretServer: "IntEnum"                                         = 12100
