"""
    FactSet Global Prices API

    The FactSet Global Prices API provides end of day market pricing content using cloud and microservices technology, encompassing both pricing as well as corporate actions and events data.</p>   # noqa: E501

    The version of the OpenAPI document: 1.7.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.FactSetGlobalPrices.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.FactSetGlobalPrices.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.FactSetGlobalPrices.exceptions import ApiException
from fds.sdk.FactSetGlobalPrices.model.batch_status_response import BatchStatusResponse
from fds.sdk.FactSetGlobalPrices.model.shares_outstanding_request import SharesOutstandingRequest
from fds.sdk.FactSetGlobalPrices.model.shares_outstanding_response import SharesOutstandingResponse
from fds.sdk.FactSetGlobalPrices.model.so_error_response import SoErrorResponse



class GetSharesOutstandingResponseWrapper:
    def __init__(self, status_code: int, response: object):
        """
        This constructor initializes the new GetSharesOutstandingResponseWrapper
        to status_code, response

        Args:
            response (object): Raw response
            status_code (int): Http status code of the response
        """

        self.status_code = status_code
        self.response = response

    def get_status_code(self) -> int:
        """
        Returns: Http status code of the response
        """
        return self.status_code

    def get_response(self) -> object:
        """
        Returns: Raw Object response
        """
        return self.response

    def get_response_200(self) -> SharesOutstandingResponse:
        """
        Raises: ApiException: Invalid response getter called.

        Returns: Array of security shares outstanding information for a given date range and list of securities
        """
        if self.status_code != 200:
            raise ApiException(
                status=500,
                reason="Invalid response getter called. get_response_200 can't return a " + self.status_code + " response"
            )
        return self.response

    def get_response_202(self) -> BatchStatusResponse:
        """
        Raises: ApiException: Invalid response getter called.

        Returns: Batch request has been accepted.
        """
        if self.status_code != 202:
            raise ApiException(
                status=500,
                reason="Invalid response getter called. get_response_202 can't return a " + self.status_code + " response"
            )
        return self.response


class PostSharesOutstandingResponseWrapper:
    def __init__(self, status_code: int, response: object):
        """
        This constructor initializes the new PostSharesOutstandingResponseWrapper
        to status_code, response

        Args:
            response (object): Raw response
            status_code (int): Http status code of the response
        """

        self.status_code = status_code
        self.response = response

    def get_status_code(self) -> int:
        """
        Returns: Http status code of the response
        """
        return self.status_code

    def get_response(self) -> object:
        """
        Returns: Raw Object response
        """
        return self.response

    def get_response_200(self) -> SharesOutstandingResponse:
        """
        Raises: ApiException: Invalid response getter called.

        Returns: Array of shares outstanding
        """
        if self.status_code != 200:
            raise ApiException(
                status=500,
                reason="Invalid response getter called. get_response_200 can't return a " + self.status_code + " response"
            )
        return self.response

    def get_response_202(self) -> BatchStatusResponse:
        """
        Raises: ApiException: Invalid response getter called.

        Returns: Batch request has been accepted.
        """
        if self.status_code != 202:
            raise ApiException(
                status=500,
                reason="Invalid response getter called. get_response_202 can't return a " + self.status_code + " response"
            )
        return self.response




class SharesOutstandingApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self.get_shares_outstanding_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (SharesOutstandingResponse,), 202: (BatchStatusResponse,), 400: (SoErrorResponse,), 401: (SoErrorResponse,), 403: (SoErrorResponse,), 415: (SoErrorResponse,), 500: (SoErrorResponse,),  },
                  GetSharesOutstandingResponseWrapper
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/factset-global-prices/v1/security-shares',
                'operation_id': 'get_shares_outstanding',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ids',
                    'start_date',
                    'end_date',
                    'frequency',
                    'calendar',
                    'batch',
                ],
                'required': [
                    'ids',
                ],
                'nullable': [
                ],
                'enum': [
                    'frequency',
                    'calendar',
                    'batch',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('frequency',): {

                        "D": "D",
                        "AD": "AD",
                        "W": "W",
                        "M": "M",
                        "AM": "AM",
                        "AQ": "AQ",
                        "CQ": "CQ",
                        "ASA": "ASA",
                        "CSA": "CSA",
                        "AY": "AY",
                        "CY": "CY"
                    },
                    ('calendar',): {

                        "FIVEDAY": "FIVEDAY",
                        "SEVENDAY": "SEVENDAY",
                        "US": "US"
                    },
                    ('batch',): {

                        "Y": "Y",
                        "N": "N"
                    },
                },
                'openapi_types': {
                    'ids':
                        ([str],),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'frequency':
                        (str,),
                    'calendar':
                        (str,),
                    'batch':
                        (str,),
                },
                'attribute_map': {
                    'ids': 'ids',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'frequency': 'frequency',
                    'calendar': 'calendar',
                    'batch': 'batch',
                },
                'location_map': {
                    'ids': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'frequency': 'query',
                    'calendar': 'query',
                    'batch': 'query',
                },
                'collection_format_map': {
                    'ids': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.post_shares_outstanding_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (SharesOutstandingResponse,), 202: (BatchStatusResponse,), 400: (SoErrorResponse,), 401: (SoErrorResponse,), 403: (SoErrorResponse,), 415: (SoErrorResponse,), 500: (SoErrorResponse,),  },
                  PostSharesOutstandingResponseWrapper
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/factset-global-prices/v1/security-shares',
                'operation_id': 'post_shares_outstanding',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'shares_outstanding_request',
                ],
                'required': [
                    'shares_outstanding_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'shares_outstanding_request':
                        (SharesOutstandingRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'shares_outstanding_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )


    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")


    def get_shares_outstanding(
        self,
        ids,
        **kwargs
    ) -> GetSharesOutstandingResponseWrapper:
        """Gets Shares Outstanding information for securities.  # noqa: E501

        Returns security level shares outstanding data for the given ids and dates. At this time, all values returned are split adjusted.  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            ids ([str]): The requested list of security identifiers. Accepted ID types include Market Tickers, SEDOL, ISINs, CUSIPs, or FactSet Permanent Ids.<p>***ids limit** =  500 per non-batch request / 1000 per batch request for a single day and 50 per multi-day request*</p> *<p>Make note, GET Method URL request lines are also limited to a total length of 8192 bytes (8KB). In cases where the service allows for thousands of ids, which may lead to exceeding this request line limit of 8KB, it's advised for any requests with large request lines to be requested through the respective \"POST\" method.</p>*

        Keyword Args:
            start_date (str): The start date requested for a given date range in **YYYY-MM-DD** format. The input start date must be before the input end date. Future dates (T+1) are not accepted in this endpoint. . [optional] if omitted the server will use the default value of "2021-08-27T00:00:00.000Z"
            end_date (str): The end date requested for a given date range in **YYYY-MM-DD** format. The input end date must be after the input start date. Future dates (T+1) are not accepted in this endpoint. . [optional]
            frequency (str): Controls the display frequency of the data returned.   * **D** = Daily   * **AD** = Actual Daily   * **W** = Weekly, based on the last day of the week of the start date.   * **M** = Monthly, based on the last trading day of the month.   * **AM** = Monthly, based on the start date (e.g., if the start date is June 16, data is displayed for June 16, May 16, April 16 etc.).   * **AQ** =  Actual Quarterly   * **CQ** = Quarterly based on the last trading day of the calendar quarter (March, June, September, or December).   * **ASA** = Actual Semi-annual   * **CSA** = Calendar Semi-annual   * **AY** = Actual Annual, based on the start date.   * **CY** = Calendar Annual, based on the last trading day of the calendar year.    . [optional] if omitted the server will use the default value of "D"
            calendar (str): Calendar of data returned. SEVENDAY includes weekends.. [optional] if omitted the server will use the default value of "FIVEDAY"
            batch (str): Enables the ability to asynchronously \"batch\" the request, supporting a long-running request for up to 20 minutes. Upon requesting batch=Y, the service will respond with an HTTP Status Code of 202. Once a batch request is submitted, use batch status to see if the job has been completed. Once completed, retrieve the results of the request via batch-result. When using Batch, ids limit is increased to 10000 ids per request, though limits on query string via GET method still apply. It's advised to submit large lists of ids via POST method. <B>Please note that the number of unique currencies present in the requested ids is limited to 50 per request.</B> . [optional] if omitted the server will use the default value of "N"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            GetSharesOutstandingResponseWrapper
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['ids'] = \
            ids
        return self.get_shares_outstanding_endpoint.call_with_http_info(**kwargs)

    def get_shares_outstanding_with_http_info(
        self,
        ids,
        **kwargs
    ) -> typing.Tuple[GetSharesOutstandingResponseWrapper, int, typing.MutableMapping]:
        """Gets Shares Outstanding information for securities.  # noqa: E501

        Returns security level shares outstanding data for the given ids and dates. At this time, all values returned are split adjusted.  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            ids ([str]): The requested list of security identifiers. Accepted ID types include Market Tickers, SEDOL, ISINs, CUSIPs, or FactSet Permanent Ids.<p>***ids limit** =  500 per non-batch request / 1000 per batch request for a single day and 50 per multi-day request*</p> *<p>Make note, GET Method URL request lines are also limited to a total length of 8192 bytes (8KB). In cases where the service allows for thousands of ids, which may lead to exceeding this request line limit of 8KB, it's advised for any requests with large request lines to be requested through the respective \"POST\" method.</p>*

        Keyword Args:
            start_date (str): The start date requested for a given date range in **YYYY-MM-DD** format. The input start date must be before the input end date. Future dates (T+1) are not accepted in this endpoint. . [optional] if omitted the server will use the default value of "2021-08-27T00:00:00.000Z"
            end_date (str): The end date requested for a given date range in **YYYY-MM-DD** format. The input end date must be after the input start date. Future dates (T+1) are not accepted in this endpoint. . [optional]
            frequency (str): Controls the display frequency of the data returned.   * **D** = Daily   * **AD** = Actual Daily   * **W** = Weekly, based on the last day of the week of the start date.   * **M** = Monthly, based on the last trading day of the month.   * **AM** = Monthly, based on the start date (e.g., if the start date is June 16, data is displayed for June 16, May 16, April 16 etc.).   * **AQ** =  Actual Quarterly   * **CQ** = Quarterly based on the last trading day of the calendar quarter (March, June, September, or December).   * **ASA** = Actual Semi-annual   * **CSA** = Calendar Semi-annual   * **AY** = Actual Annual, based on the start date.   * **CY** = Calendar Annual, based on the last trading day of the calendar year.    . [optional] if omitted the server will use the default value of "D"
            calendar (str): Calendar of data returned. SEVENDAY includes weekends.. [optional] if omitted the server will use the default value of "FIVEDAY"
            batch (str): Enables the ability to asynchronously \"batch\" the request, supporting a long-running request for up to 20 minutes. Upon requesting batch=Y, the service will respond with an HTTP Status Code of 202. Once a batch request is submitted, use batch status to see if the job has been completed. Once completed, retrieve the results of the request via batch-result. When using Batch, ids limit is increased to 10000 ids per request, though limits on query string via GET method still apply. It's advised to submit large lists of ids via POST method. <B>Please note that the number of unique currencies present in the requested ids is limited to 50 per request.</B> . [optional] if omitted the server will use the default value of "N"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            GetSharesOutstandingResponseWrapper
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['ids'] = \
            ids
        return self.get_shares_outstanding_endpoint.call_with_http_info(**kwargs)

    def get_shares_outstanding_async(
        self,
        ids,
        **kwargs
    ) -> "ApplyResult[GetSharesOutstandingResponseWrapper]":
        """Gets Shares Outstanding information for securities.  # noqa: E501

        Returns security level shares outstanding data for the given ids and dates. At this time, all values returned are split adjusted.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            ids ([str]): The requested list of security identifiers. Accepted ID types include Market Tickers, SEDOL, ISINs, CUSIPs, or FactSet Permanent Ids.<p>***ids limit** =  500 per non-batch request / 1000 per batch request for a single day and 50 per multi-day request*</p> *<p>Make note, GET Method URL request lines are also limited to a total length of 8192 bytes (8KB). In cases where the service allows for thousands of ids, which may lead to exceeding this request line limit of 8KB, it's advised for any requests with large request lines to be requested through the respective \"POST\" method.</p>*

        Keyword Args:
            start_date (str): The start date requested for a given date range in **YYYY-MM-DD** format. The input start date must be before the input end date. Future dates (T+1) are not accepted in this endpoint. . [optional] if omitted the server will use the default value of "2021-08-27T00:00:00.000Z"
            end_date (str): The end date requested for a given date range in **YYYY-MM-DD** format. The input end date must be after the input start date. Future dates (T+1) are not accepted in this endpoint. . [optional]
            frequency (str): Controls the display frequency of the data returned.   * **D** = Daily   * **AD** = Actual Daily   * **W** = Weekly, based on the last day of the week of the start date.   * **M** = Monthly, based on the last trading day of the month.   * **AM** = Monthly, based on the start date (e.g., if the start date is June 16, data is displayed for June 16, May 16, April 16 etc.).   * **AQ** =  Actual Quarterly   * **CQ** = Quarterly based on the last trading day of the calendar quarter (March, June, September, or December).   * **ASA** = Actual Semi-annual   * **CSA** = Calendar Semi-annual   * **AY** = Actual Annual, based on the start date.   * **CY** = Calendar Annual, based on the last trading day of the calendar year.    . [optional] if omitted the server will use the default value of "D"
            calendar (str): Calendar of data returned. SEVENDAY includes weekends.. [optional] if omitted the server will use the default value of "FIVEDAY"
            batch (str): Enables the ability to asynchronously \"batch\" the request, supporting a long-running request for up to 20 minutes. Upon requesting batch=Y, the service will respond with an HTTP Status Code of 202. Once a batch request is submitted, use batch status to see if the job has been completed. Once completed, retrieve the results of the request via batch-result. When using Batch, ids limit is increased to 10000 ids per request, though limits on query string via GET method still apply. It's advised to submit large lists of ids via POST method. <B>Please note that the number of unique currencies present in the requested ids is limited to 50 per request.</B> . [optional] if omitted the server will use the default value of "N"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[GetSharesOutstandingResponseWrapper]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['ids'] = \
            ids
        return self.get_shares_outstanding_endpoint.call_with_http_info(**kwargs)

    def get_shares_outstanding_with_http_info_async(
        self,
        ids,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[GetSharesOutstandingResponseWrapper, int, typing.MutableMapping]]":
        """Gets Shares Outstanding information for securities.  # noqa: E501

        Returns security level shares outstanding data for the given ids and dates. At this time, all values returned are split adjusted.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            ids ([str]): The requested list of security identifiers. Accepted ID types include Market Tickers, SEDOL, ISINs, CUSIPs, or FactSet Permanent Ids.<p>***ids limit** =  500 per non-batch request / 1000 per batch request for a single day and 50 per multi-day request*</p> *<p>Make note, GET Method URL request lines are also limited to a total length of 8192 bytes (8KB). In cases where the service allows for thousands of ids, which may lead to exceeding this request line limit of 8KB, it's advised for any requests with large request lines to be requested through the respective \"POST\" method.</p>*

        Keyword Args:
            start_date (str): The start date requested for a given date range in **YYYY-MM-DD** format. The input start date must be before the input end date. Future dates (T+1) are not accepted in this endpoint. . [optional] if omitted the server will use the default value of "2021-08-27T00:00:00.000Z"
            end_date (str): The end date requested for a given date range in **YYYY-MM-DD** format. The input end date must be after the input start date. Future dates (T+1) are not accepted in this endpoint. . [optional]
            frequency (str): Controls the display frequency of the data returned.   * **D** = Daily   * **AD** = Actual Daily   * **W** = Weekly, based on the last day of the week of the start date.   * **M** = Monthly, based on the last trading day of the month.   * **AM** = Monthly, based on the start date (e.g., if the start date is June 16, data is displayed for June 16, May 16, April 16 etc.).   * **AQ** =  Actual Quarterly   * **CQ** = Quarterly based on the last trading day of the calendar quarter (March, June, September, or December).   * **ASA** = Actual Semi-annual   * **CSA** = Calendar Semi-annual   * **AY** = Actual Annual, based on the start date.   * **CY** = Calendar Annual, based on the last trading day of the calendar year.    . [optional] if omitted the server will use the default value of "D"
            calendar (str): Calendar of data returned. SEVENDAY includes weekends.. [optional] if omitted the server will use the default value of "FIVEDAY"
            batch (str): Enables the ability to asynchronously \"batch\" the request, supporting a long-running request for up to 20 minutes. Upon requesting batch=Y, the service will respond with an HTTP Status Code of 202. Once a batch request is submitted, use batch status to see if the job has been completed. Once completed, retrieve the results of the request via batch-result. When using Batch, ids limit is increased to 10000 ids per request, though limits on query string via GET method still apply. It's advised to submit large lists of ids via POST method. <B>Please note that the number of unique currencies present in the requested ids is limited to 50 per request.</B> . [optional] if omitted the server will use the default value of "N"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(GetSharesOutstandingResponseWrapper, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['ids'] = \
            ids
        return self.get_shares_outstanding_endpoint.call_with_http_info(**kwargs)


    def post_shares_outstanding(
        self,
        shares_outstanding_request,
        **kwargs
    ) -> PostSharesOutstandingResponseWrapper:
        """Gets Shares Outstanding information for securities.  # noqa: E501

        Returns security level shares outstanding data for the given ids and dates. At this time, all values returned are split adjusted.  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            shares_outstanding_request (SharesOutstandingRequest): Request object for `Shares Outstanding`.

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            PostSharesOutstandingResponseWrapper
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['shares_outstanding_request'] = \
            shares_outstanding_request
        return self.post_shares_outstanding_endpoint.call_with_http_info(**kwargs)

    def post_shares_outstanding_with_http_info(
        self,
        shares_outstanding_request,
        **kwargs
    ) -> typing.Tuple[PostSharesOutstandingResponseWrapper, int, typing.MutableMapping]:
        """Gets Shares Outstanding information for securities.  # noqa: E501

        Returns security level shares outstanding data for the given ids and dates. At this time, all values returned are split adjusted.  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            shares_outstanding_request (SharesOutstandingRequest): Request object for `Shares Outstanding`.

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            PostSharesOutstandingResponseWrapper
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['shares_outstanding_request'] = \
            shares_outstanding_request
        return self.post_shares_outstanding_endpoint.call_with_http_info(**kwargs)

    def post_shares_outstanding_async(
        self,
        shares_outstanding_request,
        **kwargs
    ) -> "ApplyResult[PostSharesOutstandingResponseWrapper]":
        """Gets Shares Outstanding information for securities.  # noqa: E501

        Returns security level shares outstanding data for the given ids and dates. At this time, all values returned are split adjusted.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            shares_outstanding_request (SharesOutstandingRequest): Request object for `Shares Outstanding`.

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[PostSharesOutstandingResponseWrapper]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['shares_outstanding_request'] = \
            shares_outstanding_request
        return self.post_shares_outstanding_endpoint.call_with_http_info(**kwargs)

    def post_shares_outstanding_with_http_info_async(
        self,
        shares_outstanding_request,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[PostSharesOutstandingResponseWrapper, int, typing.MutableMapping]]":
        """Gets Shares Outstanding information for securities.  # noqa: E501

        Returns security level shares outstanding data for the given ids and dates. At this time, all values returned are split adjusted.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            shares_outstanding_request (SharesOutstandingRequest): Request object for `Shares Outstanding`.

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(PostSharesOutstandingResponseWrapper, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['shares_outstanding_request'] = \
            shares_outstanding_request
        return self.post_shares_outstanding_endpoint.call_with_http_info(**kwargs)


