"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import artifact.artifact.v1alpha.object_pb2
import builtins
import collections.abc
import common.healthcheck.v1beta.healthcheck_pb2
import common.run.v1alpha.run_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _CatalogType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CatalogTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CatalogType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CATALOG_TYPE_UNSPECIFIED: _CatalogType.ValueType  # 0
    """UNSPECIFIED"""
    CATALOG_TYPE_PERSISTENT: _CatalogType.ValueType  # 1
    """PERSISTENT"""
    CATALOG_TYPE_EPHEMERAL: _CatalogType.ValueType  # 2
    """EPHEMERAL"""

class CatalogType(_CatalogType, metaclass=_CatalogTypeEnumTypeWrapper):
    """Catalog Type. e.g. "persistent" or "ephemeral" """

CATALOG_TYPE_UNSPECIFIED: CatalogType.ValueType  # 0
"""UNSPECIFIED"""
CATALOG_TYPE_PERSISTENT: CatalogType.ValueType  # 1
"""PERSISTENT"""
CATALOG_TYPE_EPHEMERAL: CatalogType.ValueType  # 2
"""EPHEMERAL"""
global___CatalogType = CatalogType

class _FileProcessStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _FileProcessStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_FileProcessStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    FILE_PROCESS_STATUS_UNSPECIFIED: _FileProcessStatus.ValueType  # 0
    """UNSPECIFIED"""
    FILE_PROCESS_STATUS_NOTSTARTED: _FileProcessStatus.ValueType  # 1
    """NOTSTARTED"""
    FILE_PROCESS_STATUS_WAITING: _FileProcessStatus.ValueType  # 2
    """file is waiting for embedding process"""
    FILE_PROCESS_STATUS_CONVERTING: _FileProcessStatus.ValueType  # 3
    """file is converting"""
    FILE_PROCESS_STATUS_CHUNKING: _FileProcessStatus.ValueType  # 4
    """file is chunking"""
    FILE_PROCESS_STATUS_EMBEDDING: _FileProcessStatus.ValueType  # 5
    """file is embedding"""
    FILE_PROCESS_STATUS_COMPLETED: _FileProcessStatus.ValueType  # 6
    """completed"""
    FILE_PROCESS_STATUS_FAILED: _FileProcessStatus.ValueType  # 7
    """failed"""
    FILE_PROCESS_STATUS_SUMMARIZING: _FileProcessStatus.ValueType  # 8
    """file is summarizing"""

class FileProcessStatus(_FileProcessStatus, metaclass=_FileProcessStatusEnumTypeWrapper):
    """file embedding process status"""

FILE_PROCESS_STATUS_UNSPECIFIED: FileProcessStatus.ValueType  # 0
"""UNSPECIFIED"""
FILE_PROCESS_STATUS_NOTSTARTED: FileProcessStatus.ValueType  # 1
"""NOTSTARTED"""
FILE_PROCESS_STATUS_WAITING: FileProcessStatus.ValueType  # 2
"""file is waiting for embedding process"""
FILE_PROCESS_STATUS_CONVERTING: FileProcessStatus.ValueType  # 3
"""file is converting"""
FILE_PROCESS_STATUS_CHUNKING: FileProcessStatus.ValueType  # 4
"""file is chunking"""
FILE_PROCESS_STATUS_EMBEDDING: FileProcessStatus.ValueType  # 5
"""file is embedding"""
FILE_PROCESS_STATUS_COMPLETED: FileProcessStatus.ValueType  # 6
"""completed"""
FILE_PROCESS_STATUS_FAILED: FileProcessStatus.ValueType  # 7
"""failed"""
FILE_PROCESS_STATUS_SUMMARIZING: FileProcessStatus.ValueType  # 8
"""file is summarizing"""
global___FileProcessStatus = FileProcessStatus

class _FileType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _FileTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_FileType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    FILE_TYPE_UNSPECIFIED: _FileType.ValueType  # 0
    """unspecified"""
    FILE_TYPE_TEXT: _FileType.ValueType  # 1
    """text"""
    FILE_TYPE_PDF: _FileType.ValueType  # 2
    """PDF"""
    FILE_TYPE_MARKDOWN: _FileType.ValueType  # 3
    """MARKDOWN"""
    FILE_TYPE_PNG: _FileType.ValueType  # 4
    """PNG(not supported yet)"""
    FILE_TYPE_JPEG: _FileType.ValueType  # 5
    """JPEG(not supported yet)"""
    FILE_TYPE_JPG: _FileType.ValueType  # 6
    """JPG(not supported yet)"""
    FILE_TYPE_HTML: _FileType.ValueType  # 7
    """HTML"""
    FILE_TYPE_DOCX: _FileType.ValueType  # 8
    """DOCX"""
    FILE_TYPE_DOC: _FileType.ValueType  # 9
    """DOC"""
    FILE_TYPE_PPT: _FileType.ValueType  # 10
    """PPT"""
    FILE_TYPE_PPTX: _FileType.ValueType  # 11
    """PPTX"""
    FILE_TYPE_XLS: _FileType.ValueType  # 12
    """XLS"""
    FILE_TYPE_XLSX: _FileType.ValueType  # 13
    """XLSX"""
    FILE_TYPE_CSV: _FileType.ValueType  # 14
    """CSV"""

class FileType(_FileType, metaclass=_FileTypeEnumTypeWrapper):
    """file type"""

FILE_TYPE_UNSPECIFIED: FileType.ValueType  # 0
"""unspecified"""
FILE_TYPE_TEXT: FileType.ValueType  # 1
"""text"""
FILE_TYPE_PDF: FileType.ValueType  # 2
"""PDF"""
FILE_TYPE_MARKDOWN: FileType.ValueType  # 3
"""MARKDOWN"""
FILE_TYPE_PNG: FileType.ValueType  # 4
"""PNG(not supported yet)"""
FILE_TYPE_JPEG: FileType.ValueType  # 5
"""JPEG(not supported yet)"""
FILE_TYPE_JPG: FileType.ValueType  # 6
"""JPG(not supported yet)"""
FILE_TYPE_HTML: FileType.ValueType  # 7
"""HTML"""
FILE_TYPE_DOCX: FileType.ValueType  # 8
"""DOCX"""
FILE_TYPE_DOC: FileType.ValueType  # 9
"""DOC"""
FILE_TYPE_PPT: FileType.ValueType  # 10
"""PPT"""
FILE_TYPE_PPTX: FileType.ValueType  # 11
"""PPTX"""
FILE_TYPE_XLS: FileType.ValueType  # 12
"""XLS"""
FILE_TYPE_XLSX: FileType.ValueType  # 13
"""XLSX"""
FILE_TYPE_CSV: FileType.ValueType  # 14
"""CSV"""
global___FileType = FileType

class _CatalogRunAction:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CatalogRunActionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CatalogRunAction.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CATALOG_RUN_ACTION_UNSPECIFIED: _CatalogRunAction.ValueType  # 0
    """Unspecified."""
    CATALOG_RUN_ACTION_CREATE: _CatalogRunAction.ValueType  # 1
    """Create catalog."""
    CATALOG_RUN_ACTION_UPDATE: _CatalogRunAction.ValueType  # 2
    """Update catalog."""
    CATALOG_RUN_ACTION_DELETE: _CatalogRunAction.ValueType  # 3
    """Delete catalog."""
    CATALOG_RUN_ACTION_CREATE_FILE: _CatalogRunAction.ValueType  # 4
    """Upload catalog file."""
    CATALOG_RUN_ACTION_PROCESS_FILE: _CatalogRunAction.ValueType  # 5
    """Process catalog file."""
    CATALOG_RUN_ACTION_DELETE_FILE: _CatalogRunAction.ValueType  # 6
    """Delete catalog file."""

class CatalogRunAction(_CatalogRunAction, metaclass=_CatalogRunActionEnumTypeWrapper):
    """CatalogRunAction describes the actions a user has over a catalog."""

CATALOG_RUN_ACTION_UNSPECIFIED: CatalogRunAction.ValueType  # 0
"""Unspecified."""
CATALOG_RUN_ACTION_CREATE: CatalogRunAction.ValueType  # 1
"""Create catalog."""
CATALOG_RUN_ACTION_UPDATE: CatalogRunAction.ValueType  # 2
"""Update catalog."""
CATALOG_RUN_ACTION_DELETE: CatalogRunAction.ValueType  # 3
"""Delete catalog."""
CATALOG_RUN_ACTION_CREATE_FILE: CatalogRunAction.ValueType  # 4
"""Upload catalog file."""
CATALOG_RUN_ACTION_PROCESS_FILE: CatalogRunAction.ValueType  # 5
"""Process catalog file."""
CATALOG_RUN_ACTION_DELETE_FILE: CatalogRunAction.ValueType  # 6
"""Delete catalog file."""
global___CatalogRunAction = CatalogRunAction

@typing_extensions.final
class LivenessRequest(google.protobuf.message.Message):
    """LivenessRequest represents a request to check a service liveness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def health_check_request(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest:
        """HealthCheckRequest message"""
    def __init__(
        self,
        *,
        health_check_request: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_health_check_request", b"_health_check_request"]) -> typing_extensions.Literal["health_check_request"] | None: ...

global___LivenessRequest = LivenessRequest

@typing_extensions.final
class LivenessResponse(google.protobuf.message.Message):
    """LivenessResponse represents a response for a service liveness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def health_check_response(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse:
        """HealthCheckResponse message"""
    def __init__(
        self,
        *,
        health_check_response: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> None: ...

global___LivenessResponse = LivenessResponse

@typing_extensions.final
class ReadinessRequest(google.protobuf.message.Message):
    """ReadinessRequest represents a request to check a service readiness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def health_check_request(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest:
        """HealthCheckRequest message"""
    def __init__(
        self,
        *,
        health_check_request: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_health_check_request", b"_health_check_request"]) -> typing_extensions.Literal["health_check_request"] | None: ...

global___ReadinessRequest = ReadinessRequest

@typing_extensions.final
class ReadinessResponse(google.protobuf.message.Message):
    """ReadinessResponse represents a response for a service readiness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def health_check_response(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse:
        """HealthCheckResponse message"""
    def __init__(
        self,
        *,
        health_check_response: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> None: ...

global___ReadinessResponse = ReadinessResponse

@typing_extensions.final
class RepositoryTag(google.protobuf.message.Message):
    """

    This API is under development and, therefore, some of its entities and
    endpoints are not implemented yet. This section aims to give context about the
    current interface and how it fits in the Artifact vision.

    # Artifact

    The Artifact domain is responsible of storing data that will later be used for
    processing unstructured data. Artifact will support the following types of
    data:

    - Repositories
    - Objects
    - Vectors

    ## Repositories

    An implementation of the [OCI Distribution Specification](https://github.com/opencontainers/distribution-spec?tab=readme-ov-file)
    is used to manage versioned content. The main use for repositories is storing
    container images that can be used to deploy AI models or pipelines.

    The ID of a repository has 2 segments, the owner (an Instill user or
    organization) and the content ID (the AI model or pipeline ID), e.g.
    `curious-wombat/llava-34b`.

    ## Objects

    Raw data is stored in binary blobs. Object storage allows users to upload data
    (e.g. images, audio) that can be used by pipelines or to store the results or a
    pipeline trigger.

    ## Vectors

    Vector embeddings have their own storage, which allows fast retrieval and similarity search.

    RepositoryTag contains information about the version of some content in a
    repository.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    DIGEST_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the tag, defined by its parent repository and ID.
    - Format: `repositories/{repository.id}/tags/{tag.id}`.
    """
    id: builtins.str
    """The tag identifier."""
    digest: builtins.str
    """The Artifact backend will register the tag digest and timestamp when a
    new version is pushed. However, the registry remains the source of truth
    for tags, so if this information isn't found in the Artifact database,
    these fields will be empty.

    Unique identifier, computed from the manifest the tag refers to.
    """
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Tag update time, i.e. timestamp of the last push."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        id: builtins.str = ...,
        digest: builtins.str = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["digest", b"digest", "id", b"id", "name", b"name", "update_time", b"update_time"]) -> None: ...

global___RepositoryTag = RepositoryTag

@typing_extensions.final
class ListRepositoryTagsRequest(google.protobuf.message.Message):
    """ListRepositoryTagsRequest represents a request to list the tags of a
    repository.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of tags to return. The default and cap values are 10
    and 100, respectively.
    """
    page: builtins.int
    """Page number."""
    parent: builtins.str
    """The repository holding the different versions of a given content.
    - Format: `repositories/{repository.id}`.
    - Example: `repositories/flaming-wombat/llama-2-7b`.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page: builtins.int | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page", b"_page", "_page_size", b"_page_size", "page", b"page", "page_size", b"page_size"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page", b"_page", "_page_size", b"_page_size", "page", b"page", "page_size", b"page_size", "parent", b"parent"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page", b"_page"]) -> typing_extensions.Literal["page"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...

global___ListRepositoryTagsRequest = ListRepositoryTagsRequest

@typing_extensions.final
class ListRepositoryTagsResponse(google.protobuf.message.Message):
    """ListRepositoryTagsResponse contains a list of container image tags."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TAGS_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RepositoryTag]:
        """A list of repository tags."""
    total_size: builtins.int
    """Total number of tags."""
    page_size: builtins.int
    """The requested page size."""
    page: builtins.int
    """The requested page offset."""
    def __init__(
        self,
        *,
        tags: collections.abc.Iterable[global___RepositoryTag] | None = ...,
        total_size: builtins.int = ...,
        page_size: builtins.int = ...,
        page: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page", b"page", "page_size", b"page_size", "tags", b"tags", "total_size", b"total_size"]) -> None: ...

global___ListRepositoryTagsResponse = ListRepositoryTagsResponse

@typing_extensions.final
class CreateRepositoryTagRequest(google.protobuf.message.Message):
    """CreateRepositoryTagRequest represents a request to add a tag to a given
    repository.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TAG_FIELD_NUMBER: builtins.int
    @property
    def tag(self) -> global___RepositoryTag:
        """The tag information."""
    def __init__(
        self,
        *,
        tag: global___RepositoryTag | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["tag", b"tag"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["tag", b"tag"]) -> None: ...

global___CreateRepositoryTagRequest = CreateRepositoryTagRequest

@typing_extensions.final
class CreateRepositoryTagResponse(google.protobuf.message.Message):
    """CreateRepositoryTagResponse contains the created tag."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TAG_FIELD_NUMBER: builtins.int
    @property
    def tag(self) -> global___RepositoryTag:
        """The created tag."""
    def __init__(
        self,
        *,
        tag: global___RepositoryTag | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["tag", b"tag"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["tag", b"tag"]) -> None: ...

global___CreateRepositoryTagResponse = CreateRepositoryTagResponse

@typing_extensions.final
class GetRepositoryTagRequest(google.protobuf.message.Message):
    """GetRepositoryTagRequest represents a request to add a tag to a given
    repository.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the tag, defined by its parent repository and ID.
    - Format: `repositories/{repository.id}/tags/{tag.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___GetRepositoryTagRequest = GetRepositoryTagRequest

@typing_extensions.final
class GetRepositoryTagResponse(google.protobuf.message.Message):
    """GetRepositoryTagResponse contains the created tag."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TAG_FIELD_NUMBER: builtins.int
    @property
    def tag(self) -> global___RepositoryTag:
        """The created tag."""
    def __init__(
        self,
        *,
        tag: global___RepositoryTag | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["tag", b"tag"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["tag", b"tag"]) -> None: ...

global___GetRepositoryTagResponse = GetRepositoryTagResponse

@typing_extensions.final
class DeleteRepositoryTagRequest(google.protobuf.message.Message):
    """DeleteRepositoryTagRequest represents a request to delete a tag to a given
    repository.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the tag, defined by its parent repository and ID.
    - Format: `repositories/{repository.id}/tags/{tag.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteRepositoryTagRequest = DeleteRepositoryTagRequest

@typing_extensions.final
class DeleteRepositoryTagResponse(google.protobuf.message.Message):
    """DeleteRepositoryTagResponse represent an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteRepositoryTagResponse = DeleteRepositoryTagResponse

@typing_extensions.final
class ObjectURL(google.protobuf.message.Message):
    """ObjectUploadURL"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UID_FIELD_NUMBER: builtins.int
    NAMESPACE_UID_FIELD_NUMBER: builtins.int
    OBJECT_UID_FIELD_NUMBER: builtins.int
    URL_EXPIRE_AT_FIELD_NUMBER: builtins.int
    MINIO_URL_PATH_FIELD_NUMBER: builtins.int
    ENCODED_URL_PATH_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    DELETE_TIME_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """The unique identifier of the ObjectURL"""
    namespace_uid: builtins.str
    """The namespace UID associated with this ObjectURL"""
    object_uid: builtins.str
    """The object UID associated with this ObjectURL"""
    @property
    def url_expire_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The expiration time of the URL"""
    minio_url_path: builtins.str
    """The MinIO URL path"""
    encoded_url_path: builtins.str
    """The encoded URL path"""
    type: builtins.str
    """The type of URL (download or upload)"""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The creation time of the ObjectURL"""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The last update time of the ObjectURL"""
    @property
    def delete_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The deletion time of the ObjectURL, if applicable"""
    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        namespace_uid: builtins.str = ...,
        object_uid: builtins.str = ...,
        url_expire_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        minio_url_path: builtins.str = ...,
        encoded_url_path: builtins.str = ...,
        type: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        delete_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_delete_time", b"_delete_time", "create_time", b"create_time", "delete_time", b"delete_time", "update_time", b"update_time", "url_expire_at", b"url_expire_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_delete_time", b"_delete_time", "create_time", b"create_time", "delete_time", b"delete_time", "encoded_url_path", b"encoded_url_path", "minio_url_path", b"minio_url_path", "namespace_uid", b"namespace_uid", "object_uid", b"object_uid", "type", b"type", "uid", b"uid", "update_time", b"update_time", "url_expire_at", b"url_expire_at"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_delete_time", b"_delete_time"]) -> typing_extensions.Literal["delete_time"] | None: ...

global___ObjectURL = ObjectURL

@typing_extensions.final
class GetObjectRequest(google.protobuf.message.Message):
    """GetObjectRequest"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UID_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """object uid"""
    def __init__(
        self,
        *,
        uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["uid", b"uid"]) -> None: ...

global___GetObjectRequest = GetObjectRequest

@typing_extensions.final
class GetObjectResponse(google.protobuf.message.Message):
    """GetObjectResponse"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OBJECT_FIELD_NUMBER: builtins.int
    @property
    def object(self) -> artifact.artifact.v1alpha.object_pb2.Object:
        """object"""
    def __init__(
        self,
        *,
        object: artifact.artifact.v1alpha.object_pb2.Object | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["object", b"object"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["object", b"object"]) -> None: ...

global___GetObjectResponse = GetObjectResponse

@typing_extensions.final
class GetObjectURLRequest(google.protobuf.message.Message):
    """GetObjectURLRequest"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UID_FIELD_NUMBER: builtins.int
    ENCODED_URL_PATH_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """object url uid"""
    encoded_url_path: builtins.str
    """encoded url path. artifact first use uid to get object url,
    if not exist, then use encoded url path to get object url
    """
    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        encoded_url_path: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_encoded_url_path", b"_encoded_url_path", "encoded_url_path", b"encoded_url_path"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_encoded_url_path", b"_encoded_url_path", "encoded_url_path", b"encoded_url_path", "uid", b"uid"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_encoded_url_path", b"_encoded_url_path"]) -> typing_extensions.Literal["encoded_url_path"] | None: ...

global___GetObjectURLRequest = GetObjectURLRequest

@typing_extensions.final
class GetObjectURLResponse(google.protobuf.message.Message):
    """GetObjectURLResponse"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OBJECT_URL_FIELD_NUMBER: builtins.int
    @property
    def object_url(self) -> global___ObjectURL:
        """object url"""
    def __init__(
        self,
        *,
        object_url: global___ObjectURL | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["object_url", b"object_url"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["object_url", b"object_url"]) -> None: ...

global___GetObjectURLResponse = GetObjectURLResponse

@typing_extensions.final
class UpdateObjectRequest(google.protobuf.message.Message):
    """UpdateObjectRequest"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UID_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    IS_UPLOADED_FIELD_NUMBER: builtins.int
    LAST_MODIFIED_TIME_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """object uid"""
    size: builtins.int
    """size"""
    type: builtins.str
    """type"""
    is_uploaded: builtins.bool
    """is upload"""
    @property
    def last_modified_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """last modified time"""
    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        size: builtins.int | None = ...,
        type: builtins.str | None = ...,
        is_uploaded: builtins.bool | None = ...,
        last_modified_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_is_uploaded", b"_is_uploaded", "_last_modified_time", b"_last_modified_time", "_size", b"_size", "_type", b"_type", "is_uploaded", b"is_uploaded", "last_modified_time", b"last_modified_time", "size", b"size", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_is_uploaded", b"_is_uploaded", "_last_modified_time", b"_last_modified_time", "_size", b"_size", "_type", b"_type", "is_uploaded", b"is_uploaded", "last_modified_time", b"last_modified_time", "size", b"size", "type", b"type", "uid", b"uid"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_is_uploaded", b"_is_uploaded"]) -> typing_extensions.Literal["is_uploaded"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_last_modified_time", b"_last_modified_time"]) -> typing_extensions.Literal["last_modified_time"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_size", b"_size"]) -> typing_extensions.Literal["size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_type", b"_type"]) -> typing_extensions.Literal["type"] | None: ...

global___UpdateObjectRequest = UpdateObjectRequest

@typing_extensions.final
class UpdateObjectResponse(google.protobuf.message.Message):
    """UpdateObjectResponse"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OBJECT_FIELD_NUMBER: builtins.int
    @property
    def object(self) -> artifact.artifact.v1alpha.object_pb2.Object:
        """object"""
    def __init__(
        self,
        *,
        object: artifact.artifact.v1alpha.object_pb2.Object | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["object", b"object"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["object", b"object"]) -> None: ...

global___UpdateObjectResponse = UpdateObjectResponse

@typing_extensions.final
class Catalog(google.protobuf.message.Message):
    """Catalog represents a catalog."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CATALOG_UID_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    OWNER_NAME_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    CONVERTING_PIPELINES_FIELD_NUMBER: builtins.int
    SPLITTING_PIPELINES_FIELD_NUMBER: builtins.int
    EMBEDDING_PIPELINES_FIELD_NUMBER: builtins.int
    DOWNSTREAM_APPS_FIELD_NUMBER: builtins.int
    TOTAL_FILES_FIELD_NUMBER: builtins.int
    TOTAL_TOKENS_FIELD_NUMBER: builtins.int
    USED_STORAGE_FIELD_NUMBER: builtins.int
    SUMMARIZING_PIPELINES_FIELD_NUMBER: builtins.int
    catalog_uid: builtins.str
    """The catalog uid."""
    catalog_id: builtins.str
    """The catalog id."""
    name: builtins.str
    """The catalog name."""
    description: builtins.str
    """The catalog description."""
    create_time: builtins.str
    """The creation time of the catalog."""
    update_time: builtins.str
    """The last update time of the catalog."""
    owner_name: builtins.str
    """The owner/namespace of the catalog."""
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The catalog tags."""
    @property
    def converting_pipelines(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The catalog converting pipelines."""
    @property
    def splitting_pipelines(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The catalog splitting pipelines."""
    @property
    def embedding_pipelines(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The catalog embedding pipelines."""
    @property
    def downstream_apps(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The downstream apps"""
    total_files: builtins.int
    """The total files in catalog."""
    total_tokens: builtins.int
    """The total tokens in catalog."""
    used_storage: builtins.int
    """The current used storage in catalog."""
    @property
    def summarizing_pipelines(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The catalog summarizing pipelines."""
    def __init__(
        self,
        *,
        catalog_uid: builtins.str = ...,
        catalog_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        create_time: builtins.str = ...,
        update_time: builtins.str = ...,
        owner_name: builtins.str = ...,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
        converting_pipelines: collections.abc.Iterable[builtins.str] | None = ...,
        splitting_pipelines: collections.abc.Iterable[builtins.str] | None = ...,
        embedding_pipelines: collections.abc.Iterable[builtins.str] | None = ...,
        downstream_apps: collections.abc.Iterable[builtins.str] | None = ...,
        total_files: builtins.int = ...,
        total_tokens: builtins.int = ...,
        used_storage: builtins.int = ...,
        summarizing_pipelines: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["catalog_id", b"catalog_id", "catalog_uid", b"catalog_uid", "converting_pipelines", b"converting_pipelines", "create_time", b"create_time", "description", b"description", "downstream_apps", b"downstream_apps", "embedding_pipelines", b"embedding_pipelines", "name", b"name", "owner_name", b"owner_name", "splitting_pipelines", b"splitting_pipelines", "summarizing_pipelines", b"summarizing_pipelines", "tags", b"tags", "total_files", b"total_files", "total_tokens", b"total_tokens", "update_time", b"update_time", "used_storage", b"used_storage"]) -> None: ...

global___Catalog = Catalog

@typing_extensions.final
class CreateCatalogRequest(google.protobuf.message.Message):
    """CreateCatalogRequest represents a request to create a catalog."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The catalog's owner(namespaces)."""
    name: builtins.str
    """The catalog name."""
    description: builtins.str
    """The catalog description."""
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The catalog tags."""
    type: global___CatalogType.ValueType
    """The catalog type. default is PERSISTENT"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
        type: global___CatalogType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "name", b"name", "namespace_id", b"namespace_id", "tags", b"tags", "type", b"type"]) -> None: ...

global___CreateCatalogRequest = CreateCatalogRequest

@typing_extensions.final
class CreateCatalogResponse(google.protobuf.message.Message):
    """CreateCatalogResponse represents a response for creating a catalog."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CATALOG_FIELD_NUMBER: builtins.int
    @property
    def catalog(self) -> global___Catalog:
        """The created catalog."""
    def __init__(
        self,
        *,
        catalog: global___Catalog | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["catalog", b"catalog"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["catalog", b"catalog"]) -> None: ...

global___CreateCatalogResponse = CreateCatalogResponse

@typing_extensions.final
class ListCatalogsRequest(google.protobuf.message.Message):
    """Request message for ListCatalogs(not include the ephemeral catalogs)"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """User ID for which to list the catalogs"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["namespace_id", b"namespace_id"]) -> None: ...

global___ListCatalogsRequest = ListCatalogsRequest

@typing_extensions.final
class ListCatalogsResponse(google.protobuf.message.Message):
    """GetCatalogsResponse represents a response for getting all catalogs from users."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CATALOGS_FIELD_NUMBER: builtins.int
    @property
    def catalogs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Catalog]:
        """The catalogs container."""
    def __init__(
        self,
        *,
        catalogs: collections.abc.Iterable[global___Catalog] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["catalogs", b"catalogs"]) -> None: ...

global___ListCatalogsResponse = ListCatalogsResponse

@typing_extensions.final
class UpdateCatalogRequest(google.protobuf.message.Message):
    """UpdateCatalogRequest represents a request to update a catalog."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CATALOG_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    catalog_id: builtins.str
    """The catalog id."""
    description: builtins.str
    """The catalog description."""
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The catalog tags."""
    namespace_id: builtins.str
    """The catalog owner(namespace)."""
    def __init__(
        self,
        *,
        catalog_id: builtins.str = ...,
        description: builtins.str = ...,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
        namespace_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["catalog_id", b"catalog_id", "description", b"description", "namespace_id", b"namespace_id", "tags", b"tags"]) -> None: ...

global___UpdateCatalogRequest = UpdateCatalogRequest

@typing_extensions.final
class UpdateCatalogResponse(google.protobuf.message.Message):
    """UpdateCatalogResponse represents a response for updating a catalog."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CATALOG_FIELD_NUMBER: builtins.int
    @property
    def catalog(self) -> global___Catalog:
        """The updated catalog."""
    def __init__(
        self,
        *,
        catalog: global___Catalog | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["catalog", b"catalog"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["catalog", b"catalog"]) -> None: ...

global___UpdateCatalogResponse = UpdateCatalogResponse

@typing_extensions.final
class DeleteCatalogRequest(google.protobuf.message.Message):
    """DeleteCatalogRequest represents a request to delete a catalog."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The owner's id. i.e. namespace."""
    catalog_id: builtins.str
    """The catalog id."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        catalog_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["catalog_id", b"catalog_id", "namespace_id", b"namespace_id"]) -> None: ...

global___DeleteCatalogRequest = DeleteCatalogRequest

@typing_extensions.final
class DeleteCatalogResponse(google.protobuf.message.Message):
    """DeleteCatalogResponse represents a response for deleting a catalog."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CATALOG_FIELD_NUMBER: builtins.int
    @property
    def catalog(self) -> global___Catalog:
        """The catalog identifier."""
    def __init__(
        self,
        *,
        catalog: global___Catalog | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["catalog", b"catalog"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["catalog", b"catalog"]) -> None: ...

global___DeleteCatalogResponse = DeleteCatalogResponse

@typing_extensions.final
class File(google.protobuf.message.Message):
    """file"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_UID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    PROCESS_STATUS_FIELD_NUMBER: builtins.int
    PROCESS_OUTCOME_FIELD_NUMBER: builtins.int
    RETRIEVABLE_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    OWNER_UID_FIELD_NUMBER: builtins.int
    CREATOR_UID_FIELD_NUMBER: builtins.int
    CATALOG_UID_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    DELETE_TIME_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    TOTAL_CHUNKS_FIELD_NUMBER: builtins.int
    TOTAL_TOKENS_FIELD_NUMBER: builtins.int
    EXTERNAL_METADATA_FIELD_NUMBER: builtins.int
    OBJECT_UID_FIELD_NUMBER: builtins.int
    SUMMARY_FIELD_NUMBER: builtins.int
    DOWNLOAD_URL_FIELD_NUMBER: builtins.int
    file_uid: builtins.str
    """file uid"""
    name: builtins.str
    """file name"""
    type: global___FileType.ValueType
    """file type"""
    process_status: global___FileProcessStatus.ValueType
    """file process status"""
    process_outcome: builtins.str
    """file process message"""
    retrievable: builtins.bool
    """retrievable(this is reserved for future use)"""
    content: builtins.str
    """content(this is reserved for future use)"""
    owner_uid: builtins.str
    """owner/namespace uid"""
    creator_uid: builtins.str
    """creator uid from authn token"""
    catalog_uid: builtins.str
    """catalog uid"""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """create time"""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """update time"""
    @property
    def delete_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """delete time"""
    size: builtins.int
    """file size in bytes"""
    total_chunks: builtins.int
    """total chunks"""
    total_tokens: builtins.int
    """total tokens"""
    @property
    def external_metadata(self) -> google.protobuf.struct_pb2.Struct:
        """Custom metadata provided by the user during file upload"""
    object_uid: builtins.str
    """objectUid in blob storage. user can upload to blob storage directly, then put objectUid here.
    then no need the base64 encoding for the file content.
    """
    summary: builtins.str
    """summary of the file"""
    download_url: builtins.str
    """download url of the file"""
    def __init__(
        self,
        *,
        file_uid: builtins.str = ...,
        name: builtins.str = ...,
        type: global___FileType.ValueType = ...,
        process_status: global___FileProcessStatus.ValueType = ...,
        process_outcome: builtins.str = ...,
        retrievable: builtins.bool = ...,
        content: builtins.str = ...,
        owner_uid: builtins.str = ...,
        creator_uid: builtins.str = ...,
        catalog_uid: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        delete_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        size: builtins.int = ...,
        total_chunks: builtins.int = ...,
        total_tokens: builtins.int = ...,
        external_metadata: google.protobuf.struct_pb2.Struct | None = ...,
        object_uid: builtins.str = ...,
        summary: builtins.str = ...,
        download_url: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_external_metadata", b"_external_metadata", "create_time", b"create_time", "delete_time", b"delete_time", "external_metadata", b"external_metadata", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_external_metadata", b"_external_metadata", "catalog_uid", b"catalog_uid", "content", b"content", "create_time", b"create_time", "creator_uid", b"creator_uid", "delete_time", b"delete_time", "download_url", b"download_url", "external_metadata", b"external_metadata", "file_uid", b"file_uid", "name", b"name", "object_uid", b"object_uid", "owner_uid", b"owner_uid", "process_outcome", b"process_outcome", "process_status", b"process_status", "retrievable", b"retrievable", "size", b"size", "summary", b"summary", "total_chunks", b"total_chunks", "total_tokens", b"total_tokens", "type", b"type", "update_time", b"update_time"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_external_metadata", b"_external_metadata"]) -> typing_extensions.Literal["external_metadata"] | None: ...

global___File = File

@typing_extensions.final
class UploadCatalogFileRequest(google.protobuf.message.Message):
    """upload file request"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    FILE_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """owner/namespace uid"""
    catalog_id: builtins.str
    """catalog id"""
    @property
    def file(self) -> global___File:
        """file"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        catalog_id: builtins.str = ...,
        file: global___File | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["file", b"file"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["catalog_id", b"catalog_id", "file", b"file", "namespace_id", b"namespace_id"]) -> None: ...

global___UploadCatalogFileRequest = UploadCatalogFileRequest

@typing_extensions.final
class UploadCatalogFileResponse(google.protobuf.message.Message):
    """upload file response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_FIELD_NUMBER: builtins.int
    @property
    def file(self) -> global___File:
        """file"""
    def __init__(
        self,
        *,
        file: global___File | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["file", b"file"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["file", b"file"]) -> None: ...

global___UploadCatalogFileResponse = UploadCatalogFileResponse

@typing_extensions.final
class DeleteCatalogFileRequest(google.protobuf.message.Message):
    """delete file request"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_UID_FIELD_NUMBER: builtins.int
    file_uid: builtins.str
    """The file uid."""
    def __init__(
        self,
        *,
        file_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["file_uid", b"file_uid"]) -> None: ...

global___DeleteCatalogFileRequest = DeleteCatalogFileRequest

@typing_extensions.final
class DeleteCatalogFileResponse(google.protobuf.message.Message):
    """delete file response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_UID_FIELD_NUMBER: builtins.int
    file_uid: builtins.str
    """The file uid."""
    def __init__(
        self,
        *,
        file_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["file_uid", b"file_uid"]) -> None: ...

global___DeleteCatalogFileResponse = DeleteCatalogFileResponse

@typing_extensions.final
class ProcessCatalogFilesRequest(google.protobuf.message.Message):
    """Process Catalog File Request"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_UIDS_FIELD_NUMBER: builtins.int
    @property
    def file_uids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The file uid."""
    def __init__(
        self,
        *,
        file_uids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["file_uids", b"file_uids"]) -> None: ...

global___ProcessCatalogFilesRequest = ProcessCatalogFilesRequest

@typing_extensions.final
class ProcessCatalogFilesResponse(google.protobuf.message.Message):
    """Process Catalog File Response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILES_FIELD_NUMBER: builtins.int
    @property
    def files(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___File]:
        """The file uid."""
    def __init__(
        self,
        *,
        files: collections.abc.Iterable[global___File] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["files", b"files"]) -> None: ...

global___ProcessCatalogFilesResponse = ProcessCatalogFilesResponse

@typing_extensions.final
class ListCatalogFilesFilter(google.protobuf.message.Message):
    """list file filter
    todo: support more parameters
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_UIDS_FIELD_NUMBER: builtins.int
    @property
    def file_uids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The file uids."""
    def __init__(
        self,
        *,
        file_uids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["file_uids", b"file_uids"]) -> None: ...

global___ListCatalogFilesFilter = ListCatalogFilesFilter

@typing_extensions.final
class ListCatalogFilesRequest(google.protobuf.message.Message):
    """list files request"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The owner/namespace uid id."""
    catalog_id: builtins.str
    """The catalog id."""
    page_size: builtins.int
    """The page size (default:10; max 100)."""
    page_token: builtins.str
    """The next page token(default from first file's token)."""
    @property
    def filter(self) -> global___ListCatalogFilesFilter:
        """The filter."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        catalog_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: global___ListCatalogFilesFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["filter", b"filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["catalog_id", b"catalog_id", "filter", b"filter", "namespace_id", b"namespace_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListCatalogFilesRequest = ListCatalogFilesRequest

@typing_extensions.final
class ListCatalogFilesResponse(google.protobuf.message.Message):
    """list files response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILES_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    @property
    def files(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___File]:
        """The list of files."""
    total_size: builtins.int
    """The total number of files."""
    page_size: builtins.int
    """The requested page size."""
    next_page_token: builtins.str
    """next page token"""
    @property
    def filter(self) -> global___ListCatalogFilesFilter:
        """The filter."""
    def __init__(
        self,
        *,
        files: collections.abc.Iterable[global___File] | None = ...,
        total_size: builtins.int = ...,
        page_size: builtins.int = ...,
        next_page_token: builtins.str = ...,
        filter: global___ListCatalogFilesFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["filter", b"filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["files", b"files", "filter", b"filter", "next_page_token", b"next_page_token", "page_size", b"page_size", "total_size", b"total_size"]) -> None: ...

global___ListCatalogFilesResponse = ListCatalogFilesResponse

@typing_extensions.final
class GetCatalogFileRequest(google.protobuf.message.Message):
    """GetCatalogFileRequest represents a request to get a catalog file."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    FILE_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The namespace id."""
    catalog_id: builtins.str
    """The catalog id."""
    file_uid: builtins.str
    """The file uid."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        catalog_id: builtins.str = ...,
        file_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["catalog_id", b"catalog_id", "file_uid", b"file_uid", "namespace_id", b"namespace_id"]) -> None: ...

global___GetCatalogFileRequest = GetCatalogFileRequest

@typing_extensions.final
class GetCatalogFileResponse(google.protobuf.message.Message):
    """GetCatalogFileResponse represents a response for getting a catalog file."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_FIELD_NUMBER: builtins.int
    @property
    def file(self) -> global___File:
        """The file."""
    def __init__(
        self,
        *,
        file: global___File | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["file", b"file"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["file", b"file"]) -> None: ...

global___GetCatalogFileResponse = GetCatalogFileResponse

@typing_extensions.final
class CatalogRun(google.protobuf.message.Message):
    """CatalogRun represents a single execution of a catalog action."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UID_FIELD_NUMBER: builtins.int
    CATALOG_UID_FIELD_NUMBER: builtins.int
    FILE_UIDS_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    TOTAL_DURATION_FIELD_NUMBER: builtins.int
    RUNNER_ID_FIELD_NUMBER: builtins.int
    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    COMPLETE_TIME_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    CREDIT_AMOUNT_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """Unique identifier for each run."""
    catalog_uid: builtins.str
    """catalog uid"""
    @property
    def file_uids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The file uids."""
    action: global___CatalogRunAction.ValueType
    """Action of the catalog run."""
    status: common.run.v1alpha.run_pb2.RunStatus.ValueType
    """Current status of the run."""
    source: common.run.v1alpha.run_pb2.RunSource.ValueType
    """Origin of the run."""
    total_duration: builtins.int
    """Time taken to complete the run in milliseconds."""
    runner_id: builtins.str
    """Runner ID. (User UID)"""
    namespace_id: builtins.str
    """Namespace ID."""
    @property
    def payload(self) -> google.protobuf.struct_pb2.Struct:
        """Run request payload."""
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the run started execution."""
    @property
    def complete_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the run completed."""
    error: builtins.str
    """Error message if the run failed."""
    credit_amount: builtins.float
    """Credits used of internal accounting metric."""
    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        catalog_uid: builtins.str = ...,
        file_uids: collections.abc.Iterable[builtins.str] | None = ...,
        action: global___CatalogRunAction.ValueType = ...,
        status: common.run.v1alpha.run_pb2.RunStatus.ValueType = ...,
        source: common.run.v1alpha.run_pb2.RunSource.ValueType = ...,
        total_duration: builtins.int | None = ...,
        runner_id: builtins.str | None = ...,
        namespace_id: builtins.str | None = ...,
        payload: google.protobuf.struct_pb2.Struct | None = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        complete_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        error: builtins.str | None = ...,
        credit_amount: builtins.float | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_complete_time", b"_complete_time", "_credit_amount", b"_credit_amount", "_error", b"_error", "_namespace_id", b"_namespace_id", "_payload", b"_payload", "_runner_id", b"_runner_id", "_total_duration", b"_total_duration", "complete_time", b"complete_time", "credit_amount", b"credit_amount", "error", b"error", "namespace_id", b"namespace_id", "payload", b"payload", "runner_id", b"runner_id", "start_time", b"start_time", "total_duration", b"total_duration"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_complete_time", b"_complete_time", "_credit_amount", b"_credit_amount", "_error", b"_error", "_namespace_id", b"_namespace_id", "_payload", b"_payload", "_runner_id", b"_runner_id", "_total_duration", b"_total_duration", "action", b"action", "catalog_uid", b"catalog_uid", "complete_time", b"complete_time", "credit_amount", b"credit_amount", "error", b"error", "file_uids", b"file_uids", "namespace_id", b"namespace_id", "payload", b"payload", "runner_id", b"runner_id", "source", b"source", "start_time", b"start_time", "status", b"status", "total_duration", b"total_duration", "uid", b"uid"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_complete_time", b"_complete_time"]) -> typing_extensions.Literal["complete_time"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_credit_amount", b"_credit_amount"]) -> typing_extensions.Literal["credit_amount"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_error", b"_error"]) -> typing_extensions.Literal["error"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_namespace_id", b"_namespace_id"]) -> typing_extensions.Literal["namespace_id"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_payload", b"_payload"]) -> typing_extensions.Literal["payload"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_runner_id", b"_runner_id"]) -> typing_extensions.Literal["runner_id"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_total_duration", b"_total_duration"]) -> typing_extensions.Literal["total_duration"] | None: ...

global___CatalogRun = CatalogRun

@typing_extensions.final
class ListCatalogRunsResponse(google.protobuf.message.Message):
    """ListCatalogRunsResponse is the response message for ListCatalogRuns."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CATALOG_RUNS_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    @property
    def catalog_runs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CatalogRun]:
        """The list of runs."""
    total_size: builtins.int
    """The total number of runs matching the request."""
    page: builtins.int
    """The current page number."""
    page_size: builtins.int
    """The number of items per page."""
    def __init__(
        self,
        *,
        catalog_runs: collections.abc.Iterable[global___CatalogRun] | None = ...,
        total_size: builtins.int = ...,
        page: builtins.int = ...,
        page_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["catalog_runs", b"catalog_runs", "page", b"page", "page_size", b"page_size", "total_size", b"total_size"]) -> None: ...

global___ListCatalogRunsResponse = ListCatalogRunsResponse

@typing_extensions.final
class ListCatalogRunsRequest(google.protobuf.message.Message):
    """ListCatalogRunsRequest is the request message for ListCatalogRuns."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the owner of the catalog."""
    catalog_id: builtins.str
    """The ID of the catalog for which the runs will be listed."""
    page: builtins.int
    """The page number to retrieve."""
    page_size: builtins.int
    """The maximum number of items per page to return. The default and cap values
    are 10 and 100, respectively.
    """
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    order_by: builtins.str
    """Order by field, with options for ordering by `id`, `create_time` or `update_time`.
    Format: `order_by=id` or `order_by=create_time desc`, default is `asc`.
    """
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        catalog_id: builtins.str = ...,
        page: builtins.int = ...,
        page_size: builtins.int = ...,
        filter: builtins.str | None = ...,
        order_by: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_order_by", b"_order_by", "filter", b"filter", "order_by", b"order_by"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_order_by", b"_order_by", "catalog_id", b"catalog_id", "filter", b"filter", "namespace_id", b"namespace_id", "order_by", b"order_by", "page", b"page", "page_size", b"page_size"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_order_by", b"_order_by"]) -> typing_extensions.Literal["order_by"] | None: ...

global___ListCatalogRunsRequest = ListCatalogRunsRequest

@typing_extensions.final
class MoveFileToCatalogRequest(google.protobuf.message.Message):
    """MoveFileToCatalogRequest represents a request to move a file to another catalog."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_UID_FIELD_NUMBER: builtins.int
    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    TO_CATALOG_ID_FIELD_NUMBER: builtins.int
    file_uid: builtins.str
    """The file uid."""
    namespace_id: builtins.str
    """namespace id"""
    catalog_id: builtins.str
    """catalog id"""
    to_catalog_id: builtins.str
    """The target catalog id."""
    def __init__(
        self,
        *,
        file_uid: builtins.str = ...,
        namespace_id: builtins.str = ...,
        catalog_id: builtins.str = ...,
        to_catalog_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["catalog_id", b"catalog_id", "file_uid", b"file_uid", "namespace_id", b"namespace_id", "to_catalog_id", b"to_catalog_id"]) -> None: ...

global___MoveFileToCatalogRequest = MoveFileToCatalogRequest

@typing_extensions.final
class MoveFileToCatalogResponse(google.protobuf.message.Message):
    """MoveFileToCatalogResponse represents a response for moving a file to another catalog."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_UID_FIELD_NUMBER: builtins.int
    file_uid: builtins.str
    """The file uid."""
    def __init__(
        self,
        *,
        file_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["file_uid", b"file_uid"]) -> None: ...

global___MoveFileToCatalogResponse = MoveFileToCatalogResponse
