"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _ReleaseStage:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ReleaseStageEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ReleaseStage.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    RELEASE_STAGE_UNSPECIFIED: _ReleaseStage.ValueType  # 0
    """Unspecified."""
    RELEASE_STAGE_ALPHA: _ReleaseStage.ValueType  # 1
    """Alpha."""
    RELEASE_STAGE_BETA: _ReleaseStage.ValueType  # 2
    """Beta."""
    RELEASE_STAGE_GENERALLY_AVAILABLE: _ReleaseStage.ValueType  # 3
    """Generally available."""
    RELEASE_STAGE_CUSTOM: _ReleaseStage.ValueType  # 4
    """Custom."""

class ReleaseStage(_ReleaseStage, metaclass=_ReleaseStageEnumTypeWrapper):
    """/////////////////////////////////////////////////////////////////

    ReleaseStage defines the stage of a release.
    """

RELEASE_STAGE_UNSPECIFIED: ReleaseStage.ValueType  # 0
"""Unspecified."""
RELEASE_STAGE_ALPHA: ReleaseStage.ValueType  # 1
"""Alpha."""
RELEASE_STAGE_BETA: ReleaseStage.ValueType  # 2
"""Beta."""
RELEASE_STAGE_GENERALLY_AVAILABLE: ReleaseStage.ValueType  # 3
"""Generally available."""
RELEASE_STAGE_CUSTOM: ReleaseStage.ValueType  # 4
"""Custom."""
global___ReleaseStage = ReleaseStage

class _View:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ViewEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_View.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    VIEW_UNSPECIFIED: _View.ValueType  # 0
    """Unspecified, equivalent to BASIC."""
    VIEW_BASIC: _View.ValueType  # 1
    """Default view, only includes basic information (omits `model_spec`)."""
    VIEW_FULL: _View.ValueType  # 2
    """Full representation."""

class View(_View, metaclass=_ViewEnumTypeWrapper):
    """View defines how a model definition is presented."""

VIEW_UNSPECIFIED: View.ValueType  # 0
"""Unspecified, equivalent to BASIC."""
VIEW_BASIC: View.ValueType  # 1
"""Default view, only includes basic information (omits `model_spec`)."""
VIEW_FULL: View.ValueType  # 2
"""Full representation."""
global___View = View

@typing_extensions.final
class ModelDefinition(google.protobuf.message.Message):
    """/////////////////////////////////////////////////////////////////

    ModelDefinition defines how to configure and import a model.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DOCUMENTATION_URL_FIELD_NUMBER: builtins.int
    ICON_FIELD_NUMBER: builtins.int
    RELEASE_STAGE_FIELD_NUMBER: builtins.int
    MODEL_SPEC_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by ID.
    - Format: `model-definitions/{id}`.
    """
    uid: builtins.str
    """Model definition UUID."""
    id: builtins.str
    """Model definition resource ID (used in `name` as the last segment). This
    conforms to RFC-1034, which restricts to letters, numbers, and hyphen,
    with the first character a letter, the last a letter or a number, and a 63
    character maximum.
    """
    title: builtins.str
    """Official display title."""
    documentation_url: builtins.str
    """Documentation URL."""
    icon: builtins.str
    """Display icon."""
    release_stage: global___ReleaseStage.ValueType
    """Release stage."""
    @property
    def model_spec(self) -> google.protobuf.struct_pb2.Struct:
        """The model specification represented by a JSON schema. It is used to
        validate the JSON configurations of a model created from a specific model
        source, and the resource spec which the model is desired to be deployed on.
        It must be a valid JSON that includes what fields are needed to
        create or display a model.
        """
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation time."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Update time."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        title: builtins.str = ...,
        documentation_url: builtins.str = ...,
        icon: builtins.str = ...,
        release_stage: global___ReleaseStage.ValueType = ...,
        model_spec: google.protobuf.struct_pb2.Struct | None = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "model_spec", b"model_spec", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "documentation_url", b"documentation_url", "icon", b"icon", "id", b"id", "model_spec", b"model_spec", "name", b"name", "release_stage", b"release_stage", "title", b"title", "uid", b"uid", "update_time", b"update_time"]) -> None: ...

global___ModelDefinition = ModelDefinition

@typing_extensions.final
class ListModelDefinitionsRequest(google.protobuf.message.Message):
    """ListModelDefinitionsRequest represents a request to list all supported model
    definitions.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of model definitions to return. If this parameter
    is unspecified, at most 10 definitions will be returned. The cap value for
    this parameter is 100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: global___View.ValueType
    """View allows clients to specify the desired resource view in the response."""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "_view", b"_view", "page_size", b"page_size", "page_token", b"page_token", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "_view", b"_view", "page_size", b"page_size", "page_token", b"page_token", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListModelDefinitionsRequest = ListModelDefinitionsRequest

@typing_extensions.final
class ListModelDefinitionsResponse(google.protobuf.message.Message):
    """ListModelDefinitionsResponse contains a list of model definitions."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_DEFINITIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def model_definitions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelDefinition]:
        """A list of model definition resources."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of model definitions."""
    def __init__(
        self,
        *,
        model_definitions: collections.abc.Iterable[global___ModelDefinition] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_definitions", b"model_definitions", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListModelDefinitionsResponse = ListModelDefinitionsResponse

@typing_extensions.final
class GetModelDefinitionRequest(google.protobuf.message.Message):
    """GetModelDefinitionRequest represents a request to fetch the details of a
    model definition.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VIEW_FIELD_NUMBER: builtins.int
    MODEL_DEFINITION_ID_FIELD_NUMBER: builtins.int
    view: global___View.ValueType
    """View allows clients to specify the desired resource view in the response."""
    model_definition_id: builtins.str
    """The resource name of the model definition, which allows its access by ID.
    - Format: `model-definitions/{id}`.
    """
    def __init__(
        self,
        *,
        view: global___View.ValueType | None = ...,
        model_definition_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "model_definition_id", b"model_definition_id", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetModelDefinitionRequest = GetModelDefinitionRequest

@typing_extensions.final
class GetModelDefinitionResponse(google.protobuf.message.Message):
    """GetModelDefinitionResponse contains the requested model definition."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_DEFINITION_FIELD_NUMBER: builtins.int
    @property
    def model_definition(self) -> global___ModelDefinition:
        """The model definition resource."""
    def __init__(
        self,
        *,
        model_definition: global___ModelDefinition | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model_definition", b"model_definition"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_definition", b"model_definition"]) -> None: ...

global___GetModelDefinitionResponse = GetModelDefinitionResponse
