"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import common.healthcheck.v1beta.healthcheck_pb2
import common.run.v1alpha.run_pb2
import common.task.v1alpha.task_pb2
import core.mgmt.v1beta.mgmt_pb2
import google.longrunning.operations_pb2
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import model.model.v1alpha.common_pb2
import model.model.v1alpha.model_definition_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _State:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _StateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_State.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    STATE_UNSPECIFIED: _State.ValueType  # 0
    """Unspecified. This state can occur while a model is under operation."""
    STATE_OFFLINE: _State.ValueType  # 1
    """Offline is the state when the model instance number is 0."""
    STATE_ACTIVE: _State.ValueType  # 3
    """Active is the state when a model is processing requests."""
    STATE_IDLE: _State.ValueType  # 4
    """Idle is the state when a model is alive but not processing requests."""
    STATE_ERROR: _State.ValueType  # 5
    """Error is the state when the model is undeployable."""
    STATE_STARTING: _State.ValueType  # 6
    """Starting is the state when the system is provisioning the necessary
    resources for the model
    """
    STATE_SCALING_UP: _State.ValueType  # 7
    """Scaling Up is the transition state when the system is provisioning compute
    resource for this model instance.
    """
    STATE_SCALING_DOWN: _State.ValueType  # 8
    """Scaling is the transition state when the system is releasing compute
    resource for this model instance.
    """

class State(_State, metaclass=_StateEnumTypeWrapper):
    """State describes the state of a model. See [Deploy
    Models](https://instill-ai.dev/docs/latest/model/deploy) for more
    information.
    """

STATE_UNSPECIFIED: State.ValueType  # 0
"""Unspecified. This state can occur while a model is under operation."""
STATE_OFFLINE: State.ValueType  # 1
"""Offline is the state when the model instance number is 0."""
STATE_ACTIVE: State.ValueType  # 3
"""Active is the state when a model is processing requests."""
STATE_IDLE: State.ValueType  # 4
"""Idle is the state when a model is alive but not processing requests."""
STATE_ERROR: State.ValueType  # 5
"""Error is the state when the model is undeployable."""
STATE_STARTING: State.ValueType  # 6
"""Starting is the state when the system is provisioning the necessary
resources for the model
"""
STATE_SCALING_UP: State.ValueType  # 7
"""Scaling Up is the transition state when the system is provisioning compute
resource for this model instance.
"""
STATE_SCALING_DOWN: State.ValueType  # 8
"""Scaling is the transition state when the system is releasing compute
resource for this model instance.
"""
global___State = State

@typing_extensions.final
class LivenessRequest(google.protobuf.message.Message):
    """LivenessRequest represents a request to check a service liveness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def health_check_request(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest:
        """HealthCheckRequest message"""
    def __init__(
        self,
        *,
        health_check_request: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_health_check_request", b"_health_check_request"]) -> typing_extensions.Literal["health_check_request"] | None: ...

global___LivenessRequest = LivenessRequest

@typing_extensions.final
class LivenessResponse(google.protobuf.message.Message):
    """LivenessResponse represents a response for a service liveness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def health_check_response(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse:
        """HealthCheckResponse message"""
    def __init__(
        self,
        *,
        health_check_response: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> None: ...

global___LivenessResponse = LivenessResponse

@typing_extensions.final
class ReadinessRequest(google.protobuf.message.Message):
    """ReadinessRequest represents a request to check a service readiness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def health_check_request(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest:
        """HealthCheckRequest message"""
    def __init__(
        self,
        *,
        health_check_request: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_health_check_request", b"_health_check_request"]) -> typing_extensions.Literal["health_check_request"] | None: ...

global___ReadinessRequest = ReadinessRequest

@typing_extensions.final
class ReadinessResponse(google.protobuf.message.Message):
    """ReadinessResponse represents a response for a service readiness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def health_check_response(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse:
        """HealthCheckResponse message"""
    def __init__(
        self,
        *,
        health_check_response: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> None: ...

global___ReadinessResponse = ReadinessResponse

@typing_extensions.final
class Region(google.protobuf.message.Message):
    """Region describes the supported cloud provider and regions, with
    their supported GPU respectively.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REGION_NAME_FIELD_NUMBER: builtins.int
    HARDWARE_FIELD_NUMBER: builtins.int
    region_name: builtins.str
    """Concatenate name of provider and region"""
    @property
    def hardware(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Hardware]:
        """Hardware describes the available hardware types in this region"""
    def __init__(
        self,
        *,
        region_name: builtins.str = ...,
        hardware: collections.abc.Iterable[global___Hardware] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["hardware", b"hardware", "region_name", b"region_name"]) -> None: ...

global___Region = Region

@typing_extensions.final
class Hardware(google.protobuf.message.Message):
    """Hardware describes the hardware title and string value that backend consumes."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TITLE_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    title: builtins.str
    """Hardware display title"""
    value: builtins.str
    """Hardware name value"""
    def __init__(
        self,
        *,
        title: builtins.str = ...,
        value: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["title", b"title", "value", b"value"]) -> None: ...

global___Hardware = Hardware

@typing_extensions.final
class ModelVersion(google.protobuf.message.Message):
    """ModelVersion contains information about the version of a model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    DIGEST_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The parent resource, i.e., the user that created the models.
    - Format: `users/{user.id}`.
    The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    The name of the Version.
    - Format: `users/{user.id}/models/{model.id}/versions/{version.id}`.
    """
    version: builtins.str
    """The model version identifier, which is equal to image tag."""
    digest: builtins.str
    """Unique identifier, computed from the manifest the Version refers to."""
    state: global___State.ValueType
    """Current state of this model version."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Version update time, i.e. timestamp of the last push."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
        digest: builtins.str = ...,
        state: global___State.ValueType = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["digest", b"digest", "name", b"name", "state", b"state", "update_time", b"update_time", "version", b"version"]) -> None: ...

global___ModelVersion = ModelVersion

@typing_extensions.final
class Model(google.protobuf.message.Message):
    """Model represents an AI model, i.e. a program that performs tasks as decision
    making or or pattern recognition based on its training data
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Visibility:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _VisibilityEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Model._Visibility.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VISIBILITY_UNSPECIFIED: Model._Visibility.ValueType  # 0
        """Unspecified, equivalent to PRIVATE."""
        VISIBILITY_PRIVATE: Model._Visibility.ValueType  # 1
        """Only the owner can see the model."""
        VISIBILITY_PUBLIC: Model._Visibility.ValueType  # 2
        """Other users can see the model."""

    class Visibility(_Visibility, metaclass=_VisibilityEnumTypeWrapper):
        """Visibility defines who can access the model."""

    VISIBILITY_UNSPECIFIED: Model.Visibility.ValueType  # 0
    """Unspecified, equivalent to PRIVATE."""
    VISIBILITY_PRIVATE: Model.Visibility.ValueType  # 1
    """Only the owner can see the model."""
    VISIBILITY_PUBLIC: Model.Visibility.ValueType  # 2
    """Other users can see the model."""

    @typing_extensions.final
    class Stats(google.protobuf.message.Message):
        """Statistic data"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NUMBER_OF_RUNS_FIELD_NUMBER: builtins.int
        LAST_RUN_TIME_FIELD_NUMBER: builtins.int
        number_of_runs: builtins.int
        """Number of model runs."""
        @property
        def last_run_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Last run time."""
        def __init__(
            self,
            *,
            number_of_runs: builtins.int = ...,
            last_run_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["last_run_time", b"last_run_time"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["last_run_time", b"last_run_time", "number_of_runs", b"number_of_runs"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    MODEL_DEFINITION_FIELD_NUMBER: builtins.int
    CONFIGURATION_FIELD_NUMBER: builtins.int
    TASK_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    DELETE_TIME_FIELD_NUMBER: builtins.int
    OWNER_NAME_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    REGION_FIELD_NUMBER: builtins.int
    HARDWARE_FIELD_NUMBER: builtins.int
    README_FIELD_NUMBER: builtins.int
    SOURCE_URL_FIELD_NUMBER: builtins.int
    DOCUMENTATION_URL_FIELD_NUMBER: builtins.int
    LICENSE_FIELD_NUMBER: builtins.int
    PROFILE_IMAGE_FIELD_NUMBER: builtins.int
    PERMISSION_FIELD_NUMBER: builtins.int
    INPUT_SCHEMA_FIELD_NUMBER: builtins.int
    OUTPUT_SCHEMA_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    VERSIONS_FIELD_NUMBER: builtins.int
    STATS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by owner and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    uid: builtins.str
    """Model UUID."""
    id: builtins.str
    """Model resource ID (used in `name` as the last segment). This conforms to
    RFC-1034, which restricts to letters, numbers, and hyphen, with the first
    character a letter, the last a letter or a number, and a 63 character
    maximum.
    """
    description: builtins.str
    """Model description."""
    model_definition: builtins.str
    """The model definition that has been used to import the model."""
    @property
    def configuration(self) -> google.protobuf.struct_pb2.Struct:
        """Model configuration. This field is validated against the model
        specification in the model definition (i.e. the `model_spec` field in the
        model definition).
        """
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """Model task."""
    visibility: global___Model.Visibility.ValueType
    """Model visibility."""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Model creation time."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Model update time."""
    @property
    def delete_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Model deletion time."""
    owner_name: builtins.str
    """Resource name of the owner."""
    @property
    def owner(self) -> core.mgmt.v1beta.mgmt_pb2.Owner:
        """Model owner."""
    region: builtins.str
    """Region of choice for the particular provider to host the model."""
    hardware: builtins.str
    """Hardware of choice to serve the model."""
    readme: builtins.str
    """README holds the model documentation."""
    source_url: builtins.str
    """A link to the source code of the model (e.g. to a GitHub repository)."""
    documentation_url: builtins.str
    """A link to any extra information."""
    license: builtins.str
    """License under which the model is distributed."""
    profile_image: builtins.str
    """Model profile image in base64 format."""
    @property
    def permission(self) -> model.model.v1alpha.common_pb2.Permission:
        """Permission defines how a pipeline can be used."""
    @property
    def input_schema(self) -> google.protobuf.struct_pb2.Struct:
        """Input schema for the model"""
    @property
    def output_schema(self) -> google.protobuf.struct_pb2.Struct:
        """Output schema for the model"""
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Tags."""
    @property
    def versions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Version names."""
    @property
    def stats(self) -> global___Model.Stats:
        """Statistic data."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        description: builtins.str | None = ...,
        model_definition: builtins.str = ...,
        configuration: google.protobuf.struct_pb2.Struct | None = ...,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        visibility: global___Model.Visibility.ValueType = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        delete_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        owner_name: builtins.str = ...,
        owner: core.mgmt.v1beta.mgmt_pb2.Owner | None = ...,
        region: builtins.str = ...,
        hardware: builtins.str = ...,
        readme: builtins.str | None = ...,
        source_url: builtins.str | None = ...,
        documentation_url: builtins.str | None = ...,
        license: builtins.str | None = ...,
        profile_image: builtins.str | None = ...,
        permission: model.model.v1alpha.common_pb2.Permission | None = ...,
        input_schema: google.protobuf.struct_pb2.Struct | None = ...,
        output_schema: google.protobuf.struct_pb2.Struct | None = ...,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
        versions: collections.abc.Iterable[builtins.str] | None = ...,
        stats: global___Model.Stats | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_description", b"_description", "_documentation_url", b"_documentation_url", "_license", b"_license", "_owner", b"_owner", "_profile_image", b"_profile_image", "_readme", b"_readme", "_source_url", b"_source_url", "configuration", b"configuration", "create_time", b"create_time", "delete_time", b"delete_time", "description", b"description", "documentation_url", b"documentation_url", "input_schema", b"input_schema", "license", b"license", "output_schema", b"output_schema", "owner", b"owner", "permission", b"permission", "profile_image", b"profile_image", "readme", b"readme", "source_url", b"source_url", "stats", b"stats", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_description", b"_description", "_documentation_url", b"_documentation_url", "_license", b"_license", "_owner", b"_owner", "_profile_image", b"_profile_image", "_readme", b"_readme", "_source_url", b"_source_url", "configuration", b"configuration", "create_time", b"create_time", "delete_time", b"delete_time", "description", b"description", "documentation_url", b"documentation_url", "hardware", b"hardware", "id", b"id", "input_schema", b"input_schema", "license", b"license", "model_definition", b"model_definition", "name", b"name", "output_schema", b"output_schema", "owner", b"owner", "owner_name", b"owner_name", "permission", b"permission", "profile_image", b"profile_image", "readme", b"readme", "region", b"region", "source_url", b"source_url", "stats", b"stats", "tags", b"tags", "task", b"task", "uid", b"uid", "update_time", b"update_time", "versions", b"versions", "visibility", b"visibility"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_description", b"_description"]) -> typing_extensions.Literal["description"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_documentation_url", b"_documentation_url"]) -> typing_extensions.Literal["documentation_url"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_license", b"_license"]) -> typing_extensions.Literal["license"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_owner", b"_owner"]) -> typing_extensions.Literal["owner"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_profile_image", b"_profile_image"]) -> typing_extensions.Literal["profile_image"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_readme", b"_readme"]) -> typing_extensions.Literal["readme"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_source_url", b"_source_url"]) -> typing_extensions.Literal["source_url"] | None: ...

global___Model = Model

@typing_extensions.final
class ListModelsRequest(google.protobuf.message.Message):
    """ListModelsRequest represents a request to list  models."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of models to return. If this parameter is unspecified,
    at most 10 models will be returned. The cap value for this parameter is
    100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired model view in the response."""
    show_deleted: builtins.bool
    """Include soft-deleted models in the result."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    visibility: global___Model.Visibility.ValueType
    """Limit results to pipelines with the specified visibility."""
    order_by: builtins.str
    """Order by field, with options for ordering by `id`, `create_time` or
    `update_time`. Format: `order_by=id` or `order_by=create_time desc`,
    default is `asc`.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
        show_deleted: builtins.bool | None = ...,
        filter: builtins.str | None = ...,
        visibility: global___Model.Visibility.ValueType | None = ...,
        order_by: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_order_by", b"_order_by", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "_visibility", b"_visibility", "filter", b"filter", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view", "visibility", b"visibility"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_order_by", b"_order_by", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "_visibility", b"_visibility", "filter", b"filter", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view", "visibility", b"visibility"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_order_by", b"_order_by"]) -> typing_extensions.Literal["order_by"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_visibility", b"_visibility"]) -> typing_extensions.Literal["visibility"] | None: ...

global___ListModelsRequest = ListModelsRequest

@typing_extensions.final
class ListModelsResponse(google.protobuf.message.Message):
    """ListModelsResponse contains a list of models."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODELS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Model]:
        """A list of model resources."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of models."""
    def __init__(
        self,
        *,
        models: collections.abc.Iterable[global___Model] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["models", b"models", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListModelsResponse = ListModelsResponse

@typing_extensions.final
class LookUpModelRequest(google.protobuf.message.Message):
    """LookUpModelRequest represents a request to query a model by its UID."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """The permalink of the model, which allows its access by UID.
    - Format: `models/{model.uid}`.
    """
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired model view in the response."""
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "permalink", b"permalink", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___LookUpModelRequest = LookUpModelRequest

@typing_extensions.final
class LookUpModelResponse(google.protobuf.message.Message):
    """LookUpModelResponse contains the requested model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The requested model."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___LookUpModelResponse = LookUpModelResponse

@typing_extensions.final
class ListNamespaceModelsRequest(google.protobuf.message.Message):
    """ListNamespaceModelsRequest represents a request to list namepsace models."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    page_size: builtins.int
    """The maximum number of models to return. If this parameter is unspecified,
    at most 10 models will be returned. The cap value for this parameter is
    100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired model view in the response."""
    show_deleted: builtins.bool
    """Include soft-deleted models in the result."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    visibility: global___Model.Visibility.ValueType
    """Limit results to pipelines with the specified visibility."""
    order_by: builtins.str
    """Order by field, with options for ordering by `id`, `create_time` or
    `update_time`. Format: `order_by=id` or `order_by=create_time desc`,
    default is `asc`.
    """
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
        show_deleted: builtins.bool | None = ...,
        filter: builtins.str | None = ...,
        visibility: global___Model.Visibility.ValueType | None = ...,
        order_by: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_order_by", b"_order_by", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "_visibility", b"_visibility", "filter", b"filter", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view", "visibility", b"visibility"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_order_by", b"_order_by", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "_visibility", b"_visibility", "filter", b"filter", "namespace_id", b"namespace_id", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view", "visibility", b"visibility"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_order_by", b"_order_by"]) -> typing_extensions.Literal["order_by"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_visibility", b"_visibility"]) -> typing_extensions.Literal["visibility"] | None: ...

global___ListNamespaceModelsRequest = ListNamespaceModelsRequest

@typing_extensions.final
class ListNamespaceModelsResponse(google.protobuf.message.Message):
    """ListNamespaceModelsResponse contains a list of models."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODELS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Model]:
        """A list of model resources."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of models."""
    def __init__(
        self,
        *,
        models: collections.abc.Iterable[global___Model] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["models", b"models", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListNamespaceModelsResponse = ListNamespaceModelsResponse

@typing_extensions.final
class CreateNamespaceModelRequest(google.protobuf.message.Message):
    """CreateNamespaceModelRequest represents a request from a namespace to create a
    model.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    @property
    def model(self) -> global___Model:
        """The properties of the model to be created."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model", "namespace_id", b"namespace_id"]) -> None: ...

global___CreateNamespaceModelRequest = CreateNamespaceModelRequest

@typing_extensions.final
class CreateNamespaceModelResponse(google.protobuf.message.Message):
    """CreateNamespaceModelResponse contains the created model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The created model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___CreateNamespaceModelResponse = CreateNamespaceModelResponse

@typing_extensions.final
class GetNamespaceModelRequest(google.protobuf.message.Message):
    """GetNamespaceModelRequest represents a request to fetch the details of a model
    owned by a namespace.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    model_id: builtins.str
    """Model ID"""
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired model view in the response."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        model_id: builtins.str = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "model_id", b"model_id", "namespace_id", b"namespace_id", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetNamespaceModelRequest = GetNamespaceModelRequest

@typing_extensions.final
class GetNamespaceModelResponse(google.protobuf.message.Message):
    """GetNamespaceModelResponse contains the requested model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___GetNamespaceModelResponse = GetNamespaceModelResponse

@typing_extensions.final
class UpdateNamespaceModelRequest(google.protobuf.message.Message):
    """UpdateNamespaceModelRequest represents a request to update a model owned by a
    namespace.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    model_id: builtins.str
    """Model ID"""
    @property
    def model(self) -> global___Model:
        """The model to update"""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The update mask specifies the subset of fields that should be modified.

        For more information about this field, see
        https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#field-mask.
        """
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        model_id: builtins.str = ...,
        model: global___Model | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model", "model_id", b"model_id", "namespace_id", b"namespace_id", "update_mask", b"update_mask"]) -> None: ...

global___UpdateNamespaceModelRequest = UpdateNamespaceModelRequest

@typing_extensions.final
class UpdateNamespaceModelResponse(google.protobuf.message.Message):
    """UpdateNamespaceModelResponse contains the updated model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The updated model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___UpdateNamespaceModelResponse = UpdateNamespaceModelResponse

@typing_extensions.final
class DeleteNamespaceModelRequest(google.protobuf.message.Message):
    """DeleteNamespaceModelRequest represents a request to delete a model owned by a
    namespace.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    model_id: builtins.str
    """Model ID"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        model_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_id", b"model_id", "namespace_id", b"namespace_id"]) -> None: ...

global___DeleteNamespaceModelRequest = DeleteNamespaceModelRequest

@typing_extensions.final
class DeleteNamespaceModelResponse(google.protobuf.message.Message):
    """DeleteNamespaceModelResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteNamespaceModelResponse = DeleteNamespaceModelResponse

@typing_extensions.final
class RenameNamespaceModelRequest(google.protobuf.message.Message):
    """RenameNamespaceModelRequest represents a request to rename a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    NEW_MODEL_ID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    model_id: builtins.str
    """Model ID"""
    new_model_id: builtins.str
    """The new resource ID. This will transform the resource name into
    `namespaces/{namespace.id}/models/{new_model_id}`.
    """
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        model_id: builtins.str = ...,
        new_model_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_id", b"model_id", "namespace_id", b"namespace_id", "new_model_id", b"new_model_id"]) -> None: ...

global___RenameNamespaceModelRequest = RenameNamespaceModelRequest

@typing_extensions.final
class RenameNamespaceModelResponse(google.protobuf.message.Message):
    """RenameNamespaceModelResponse contains a renamed model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The renamed model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___RenameNamespaceModelResponse = RenameNamespaceModelResponse

@typing_extensions.final
class WatchNamespaceModelRequest(google.protobuf.message.Message):
    """WatchNamespaceModelRequest represents a request to fetch current state of a
    model
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    model_id: builtins.str
    """Model ID"""
    version: builtins.str
    """Model version"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        model_id: builtins.str = ...,
        version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_id", b"model_id", "namespace_id", b"namespace_id", "version", b"version"]) -> None: ...

global___WatchNamespaceModelRequest = WatchNamespaceModelRequest

@typing_extensions.final
class WatchNamespaceModelResponse(google.protobuf.message.Message):
    """WatchNamespaceModelResponse contains the state of a model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    state: global___State.ValueType
    """State."""
    message: builtins.str
    """Detail description of the state"""
    def __init__(
        self,
        *,
        state: global___State.ValueType = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["message", b"message", "state", b"state"]) -> None: ...

global___WatchNamespaceModelResponse = WatchNamespaceModelResponse

@typing_extensions.final
class WatchNamespaceLatestModelRequest(google.protobuf.message.Message):
    """WatchNamespaceNamespaceLatestModelRequest represents a request to fetch
    current state of the latest model version.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    model_id: builtins.str
    """Model ID"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        model_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_id", b"model_id", "namespace_id", b"namespace_id"]) -> None: ...

global___WatchNamespaceLatestModelRequest = WatchNamespaceLatestModelRequest

@typing_extensions.final
class WatchNamespaceLatestModelResponse(google.protobuf.message.Message):
    """WatchNamespaceLatestModelResponse contains the state of the latest model
    version.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    state: global___State.ValueType
    """State."""
    message: builtins.str
    """Detail description of the state"""
    def __init__(
        self,
        *,
        state: global___State.ValueType = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["message", b"message", "state", b"state"]) -> None: ...

global___WatchNamespaceLatestModelResponse = WatchNamespaceLatestModelResponse

@typing_extensions.final
class ListNamespaceModelVersionsRequest(google.protobuf.message.Message):
    """ListNamespaceModelVersionsRequest represents a request to list all the
    versions of a model namespace of a namespace.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    model_id: builtins.str
    """Model ID"""
    page_size: builtins.int
    """The maximum number of versions to return. The default and cap values are 10
    and 100, respectively.
    """
    page: builtins.int
    """Page number."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        model_id: builtins.str = ...,
        page_size: builtins.int | None = ...,
        page: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page", b"_page", "_page_size", b"_page_size", "page", b"page", "page_size", b"page_size"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page", b"_page", "_page_size", b"_page_size", "model_id", b"model_id", "namespace_id", b"namespace_id", "page", b"page", "page_size", b"page_size"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page", b"_page"]) -> typing_extensions.Literal["page"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...

global___ListNamespaceModelVersionsRequest = ListNamespaceModelVersionsRequest

@typing_extensions.final
class ListNamespaceModelVersionsResponse(google.protobuf.message.Message):
    """ListNamespaceModelVersionsResponse contains a list of models."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSIONS_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    @property
    def versions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelVersion]:
        """A list of model resources."""
    total_size: builtins.int
    """Total number of versions."""
    page_size: builtins.int
    """The requested page size."""
    page: builtins.int
    """The requested page offset."""
    def __init__(
        self,
        *,
        versions: collections.abc.Iterable[global___ModelVersion] | None = ...,
        total_size: builtins.int = ...,
        page_size: builtins.int = ...,
        page: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page", b"page", "page_size", b"page_size", "total_size", b"total_size", "versions", b"versions"]) -> None: ...

global___ListNamespaceModelVersionsResponse = ListNamespaceModelVersionsResponse

@typing_extensions.final
class DeleteNamespaceModelVersionRequest(google.protobuf.message.Message):
    """DeleteNamespaceModelVersionRequest represents a request to delete a model
    version
     owned by a namespace.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    model_id: builtins.str
    """Model ID"""
    version: builtins.str
    """Model version"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        model_id: builtins.str = ...,
        version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_id", b"model_id", "namespace_id", b"namespace_id", "version", b"version"]) -> None: ...

global___DeleteNamespaceModelVersionRequest = DeleteNamespaceModelVersionRequest

@typing_extensions.final
class DeleteNamespaceModelVersionResponse(google.protobuf.message.Message):
    """DeleteNamespaceModelVersionResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteNamespaceModelVersionResponse = DeleteNamespaceModelVersionResponse

@typing_extensions.final
class TriggerNamespaceModelRequest(google.protobuf.message.Message):
    """TriggerNamespaceModelRequest represents a request to trigger a model
    inference.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    TASK_INPUTS_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    model_id: builtins.str
    """Model ID"""
    version: builtins.str
    """Model version"""
    @property
    def task_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference inputs."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        model_id: builtins.str = ...,
        version: builtins.str = ...,
        task_inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_id", b"model_id", "namespace_id", b"namespace_id", "task_inputs", b"task_inputs", "version", b"version"]) -> None: ...

global___TriggerNamespaceModelRequest = TriggerNamespaceModelRequest

@typing_extensions.final
class TriggerNamespaceModelResponse(google.protobuf.message.Message):
    """TriggerNamespaceModelResponse contains the model inference results."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_FIELD_NUMBER: builtins.int
    TASK_OUTPUTS_FIELD_NUMBER: builtins.int
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """Task type."""
    @property
    def task_outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference outputs."""
    def __init__(
        self,
        *,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        task_outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["task", b"task", "task_outputs", b"task_outputs"]) -> None: ...

global___TriggerNamespaceModelResponse = TriggerNamespaceModelResponse

@typing_extensions.final
class TriggerAsyncNamespaceModelRequest(google.protobuf.message.Message):
    """TriggerAsyncNamespaceModelRequest represents a request to trigger a model
    inference asynchronously.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    TASK_INPUTS_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    model_id: builtins.str
    """Model ID"""
    version: builtins.str
    """Model version"""
    @property
    def task_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference inputs."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        model_id: builtins.str = ...,
        version: builtins.str = ...,
        task_inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_id", b"model_id", "namespace_id", b"namespace_id", "task_inputs", b"task_inputs", "version", b"version"]) -> None: ...

global___TriggerAsyncNamespaceModelRequest = TriggerAsyncNamespaceModelRequest

@typing_extensions.final
class TriggerAsyncNamespaceModelResponse(google.protobuf.message.Message):
    """TriggerAsyncNamespaceModelResponse contains the information to access the
    status of an asynchronous model inference.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Long-running operation information."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___TriggerAsyncNamespaceModelResponse = TriggerAsyncNamespaceModelResponse

@typing_extensions.final
class TriggerNamespaceLatestModelRequest(google.protobuf.message.Message):
    """TriggerNamespaceLatestModelRequest represents a request to trigger a model
    inference with the latest uploaded version.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    TASK_INPUTS_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    model_id: builtins.str
    """Model ID"""
    @property
    def task_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference inputs."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        model_id: builtins.str = ...,
        task_inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_id", b"model_id", "namespace_id", b"namespace_id", "task_inputs", b"task_inputs"]) -> None: ...

global___TriggerNamespaceLatestModelRequest = TriggerNamespaceLatestModelRequest

@typing_extensions.final
class TriggerNamespaceLatestModelResponse(google.protobuf.message.Message):
    """TriggerNamespaceLatestModelResponse contains the model inference results."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_FIELD_NUMBER: builtins.int
    TASK_OUTPUTS_FIELD_NUMBER: builtins.int
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """Task type."""
    @property
    def task_outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference outputs."""
    def __init__(
        self,
        *,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        task_outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["task", b"task", "task_outputs", b"task_outputs"]) -> None: ...

global___TriggerNamespaceLatestModelResponse = TriggerNamespaceLatestModelResponse

@typing_extensions.final
class TriggerAsyncNamespaceLatestModelRequest(google.protobuf.message.Message):
    """TriggerAsyncNamespaceLatestModelRequest represents a request to trigger a
    model inference asynchronously with the latest uploaded version.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    TASK_INPUTS_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    model_id: builtins.str
    """Model ID"""
    @property
    def task_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference inputs."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        model_id: builtins.str = ...,
        task_inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_id", b"model_id", "namespace_id", b"namespace_id", "task_inputs", b"task_inputs"]) -> None: ...

global___TriggerAsyncNamespaceLatestModelRequest = TriggerAsyncNamespaceLatestModelRequest

@typing_extensions.final
class TriggerAsyncNamespaceLatestModelResponse(google.protobuf.message.Message):
    """TriggerAsyncNamespaceLatestModelResponse contains the information to access
    the status of an asynchronous model inference.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Long-running operation information."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___TriggerAsyncNamespaceLatestModelResponse = TriggerAsyncNamespaceLatestModelResponse

@typing_extensions.final
class TriggerNamespaceModelBinaryFileUploadRequest(google.protobuf.message.Message):
    """TriggerNamespaceModelBinaryFileUploadRequest represents a request trigger a
    model inference by uploading a binary file as the input.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    TASK_INPUT_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    model_id: builtins.str
    """Model ID"""
    version: builtins.str
    """Model version"""
    @property
    def task_input(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Inference input as a binary file."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        model_id: builtins.str = ...,
        version: builtins.str = ...,
        task_input: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_id", b"model_id", "namespace_id", b"namespace_id", "task_input", b"task_input", "version", b"version"]) -> None: ...

global___TriggerNamespaceModelBinaryFileUploadRequest = TriggerNamespaceModelBinaryFileUploadRequest

@typing_extensions.final
class TriggerNamespaceModelBinaryFileUploadResponse(google.protobuf.message.Message):
    """TriggerNamespaceModelBinaryFileUploadResponse contains the model inference
    results.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_FIELD_NUMBER: builtins.int
    TASK_OUTPUTS_FIELD_NUMBER: builtins.int
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """Task type."""
    @property
    def task_outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference outputs."""
    def __init__(
        self,
        *,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        task_outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["task", b"task", "task_outputs", b"task_outputs"]) -> None: ...

global___TriggerNamespaceModelBinaryFileUploadResponse = TriggerNamespaceModelBinaryFileUploadResponse

@typing_extensions.final
class TriggerNamespaceLatestModelBinaryFileUploadRequest(google.protobuf.message.Message):
    """TriggerNamespaceModelLatestBinaryFileUploadRequest represents a request
    trigger a model inference by uploading a binary file as the input.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    TASK_INPUT_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    model_id: builtins.str
    """Model ID"""
    @property
    def task_input(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Inference input as a binary file."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        model_id: builtins.str = ...,
        task_input: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_id", b"model_id", "namespace_id", b"namespace_id", "task_input", b"task_input"]) -> None: ...

global___TriggerNamespaceLatestModelBinaryFileUploadRequest = TriggerNamespaceLatestModelBinaryFileUploadRequest

@typing_extensions.final
class TriggerNamespaceLatestModelBinaryFileUploadResponse(google.protobuf.message.Message):
    """TriggerNamespaceLatestModelBinaryFileUploadResponse contains the model
    inference results.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_FIELD_NUMBER: builtins.int
    TASK_OUTPUTS_FIELD_NUMBER: builtins.int
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """Task type."""
    @property
    def task_outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Deleteted field.
        Model inference outputs.
        """
    def __init__(
        self,
        *,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        task_outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["task", b"task", "task_outputs", b"task_outputs"]) -> None: ...

global___TriggerNamespaceLatestModelBinaryFileUploadResponse = TriggerNamespaceLatestModelBinaryFileUploadResponse

@typing_extensions.final
class GetNamespaceLatestModelOperationRequest(google.protobuf.message.Message):
    """GetNamespaceLatestModelOperationRequest represents a request to fetch the
    latest long-running operation performed on a model for a namespace.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    model_id: builtins.str
    """Model ID"""
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired operation result in the
    response.
    """
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        model_id: builtins.str = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "model_id", b"model_id", "namespace_id", b"namespace_id", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetNamespaceLatestModelOperationRequest = GetNamespaceLatestModelOperationRequest

@typing_extensions.final
class GetNamespaceLatestModelOperationResponse(google.protobuf.message.Message):
    """GetNamespaceLatestModelOperationResponse represents a response to query a
    long-running operation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """The long-running operation."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___GetNamespaceLatestModelOperationResponse = GetNamespaceLatestModelOperationResponse

@typing_extensions.final
class GetNamespaceModelOperationRequest(google.protobuf.message.Message):
    """GetNamespaceModelOperationRequest represents a request to fetch the
    long-running operation performed on a particular model version for a
    namespace.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    model_id: builtins.str
    """Model ID"""
    version: builtins.str
    """Model version"""
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired operation result in the
    response.
    """
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        model_id: builtins.str = ...,
        version: builtins.str = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "model_id", b"model_id", "namespace_id", b"namespace_id", "version", b"version", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetNamespaceModelOperationRequest = GetNamespaceModelOperationRequest

@typing_extensions.final
class GetNamespaceModelOperationResponse(google.protobuf.message.Message):
    """GetNamespaceModelOperationResponse represents a response to query a
    long-running operation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """The long-running operation."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___GetNamespaceModelOperationResponse = GetNamespaceModelOperationResponse

@typing_extensions.final
class DeployNamespaceModelAdminRequest(google.protobuf.message.Message):
    """DeployNamespaceModelAdminRequest represents a request to deploy a model to
    online state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    DIGEST_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    model_id: builtins.str
    """Model ID"""
    version: builtins.str
    """Model version"""
    digest: builtins.str
    """Model image digest"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        model_id: builtins.str = ...,
        version: builtins.str = ...,
        digest: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["digest", b"digest", "model_id", b"model_id", "namespace_id", b"namespace_id", "version", b"version"]) -> None: ...

global___DeployNamespaceModelAdminRequest = DeployNamespaceModelAdminRequest

@typing_extensions.final
class DeployNamespaceModelAdminResponse(google.protobuf.message.Message):
    """DeployNamespaceModelAdminResponse represents a response for a deployed model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeployNamespaceModelAdminResponse = DeployNamespaceModelAdminResponse

@typing_extensions.final
class UndeployNamespaceModelAdminRequest(google.protobuf.message.Message):
    """UndeployNamespaceModelAdminRequest represents a request to undeploy a model
    to offline state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    DIGEST_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    model_id: builtins.str
    """Model ID"""
    version: builtins.str
    """Model version"""
    digest: builtins.str
    """Model image digest"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        model_id: builtins.str = ...,
        version: builtins.str = ...,
        digest: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["digest", b"digest", "model_id", b"model_id", "namespace_id", b"namespace_id", "version", b"version"]) -> None: ...

global___UndeployNamespaceModelAdminRequest = UndeployNamespaceModelAdminRequest

@typing_extensions.final
class UndeployNamespaceModelAdminResponse(google.protobuf.message.Message):
    """UndeployNamespaceModelAdminResponse represents a response for a undeployed
    model
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UndeployNamespaceModelAdminResponse = UndeployNamespaceModelAdminResponse

@typing_extensions.final
class CreateUserModelRequest(google.protobuf.message.Message):
    """CreateUserModelRequest represents a request from a user to create a model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The properties of the model to be created."""
    parent: builtins.str
    """The parent resource, i.e., the user that creates the model.
    Format: `users/{user.id}`.
    """
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model", "parent", b"parent"]) -> None: ...

global___CreateUserModelRequest = CreateUserModelRequest

@typing_extensions.final
class CreateUserModelResponse(google.protobuf.message.Message):
    """CreateUserModelResponse contains the created model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The created model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___CreateUserModelResponse = CreateUserModelResponse

@typing_extensions.final
class ListUserModelsRequest(google.protobuf.message.Message):
    """ListUserModelsRequest represents a request to list the models of a user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of models to return. If this parameter is unspecified,
    at most 10 models will be returned. The cap value for this parameter is
    100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired model view in the response."""
    parent: builtins.str
    """The parent resource, i.e., the user that created the models.
    - Format: `users/{user.id}`.
    """
    show_deleted: builtins.bool
    """Include soft-deleted models in the result."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    visibility: global___Model.Visibility.ValueType
    """Limit results to pipelines with the specified visibility."""
    order_by: builtins.str
    """Order by field, with options for ordering by `id`, `create_time` or
    `update_time`. Format: `order_by=id` or `order_by=create_time desc`,
    default is `asc`.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
        parent: builtins.str = ...,
        show_deleted: builtins.bool | None = ...,
        filter: builtins.str | None = ...,
        visibility: global___Model.Visibility.ValueType | None = ...,
        order_by: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_order_by", b"_order_by", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "_visibility", b"_visibility", "filter", b"filter", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view", "visibility", b"visibility"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_order_by", b"_order_by", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "_visibility", b"_visibility", "filter", b"filter", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token", "parent", b"parent", "show_deleted", b"show_deleted", "view", b"view", "visibility", b"visibility"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_order_by", b"_order_by"]) -> typing_extensions.Literal["order_by"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_visibility", b"_visibility"]) -> typing_extensions.Literal["visibility"] | None: ...

global___ListUserModelsRequest = ListUserModelsRequest

@typing_extensions.final
class ListUserModelsResponse(google.protobuf.message.Message):
    """ListUserModelsResponse contains a list of models."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODELS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Model]:
        """A list of model resources."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of models."""
    def __init__(
        self,
        *,
        models: collections.abc.Iterable[global___Model] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["models", b"models", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListUserModelsResponse = ListUserModelsResponse

@typing_extensions.final
class GetUserModelRequest(google.protobuf.message.Message):
    """GetUserModelRequest represents a request to fetch the details of a model
    owned by a user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired model view in the response."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetUserModelRequest = GetUserModelRequest

@typing_extensions.final
class GetUserModelResponse(google.protobuf.message.Message):
    """GetUserModelResponse contains the requested model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___GetUserModelResponse = GetUserModelResponse

@typing_extensions.final
class UpdateUserModelRequest(google.protobuf.message.Message):
    """UpdateUserModelRequest represents a request to update a model owned by a
    user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The model to update"""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The update mask specifies the subset of fields that should be modified.

        For more information about this field, see
        https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#field-mask.
        """
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model", "update_mask", b"update_mask"]) -> None: ...

global___UpdateUserModelRequest = UpdateUserModelRequest

@typing_extensions.final
class UpdateUserModelResponse(google.protobuf.message.Message):
    """UpdateUserModelResponse contains the updated model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The updated model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___UpdateUserModelResponse = UpdateUserModelResponse

@typing_extensions.final
class DeleteUserModelRequest(google.protobuf.message.Message):
    """DeleteUserModelRequest represents a request to delete a model owned by a
    user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteUserModelRequest = DeleteUserModelRequest

@typing_extensions.final
class DeleteUserModelResponse(google.protobuf.message.Message):
    """DeleteUserModelResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteUserModelResponse = DeleteUserModelResponse

@typing_extensions.final
class RenameUserModelRequest(google.protobuf.message.Message):
    """RenameUserModelRequest represents a request to rename a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    NEW_MODEL_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    new_model_id: builtins.str
    """The new resource ID. This will transform the resource name into
    `users/{user.id}/models/{new_model_id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        new_model_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "new_model_id", b"new_model_id"]) -> None: ...

global___RenameUserModelRequest = RenameUserModelRequest

@typing_extensions.final
class RenameUserModelResponse(google.protobuf.message.Message):
    """RenameUserModelResponse contains a renamed model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The renamed model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___RenameUserModelResponse = RenameUserModelResponse

@typing_extensions.final
class WatchUserModelRequest(google.protobuf.message.Message):
    """WatchUserModelRequest represents a request to fetch current state of a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    version: builtins.str
    """Model version"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "version", b"version"]) -> None: ...

global___WatchUserModelRequest = WatchUserModelRequest

@typing_extensions.final
class WatchUserModelResponse(google.protobuf.message.Message):
    """WatchUserModelResponse contains the state of a model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    state: global___State.ValueType
    """State."""
    message: builtins.str
    """Detail description of the state"""
    def __init__(
        self,
        *,
        state: global___State.ValueType = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["message", b"message", "state", b"state"]) -> None: ...

global___WatchUserModelResponse = WatchUserModelResponse

@typing_extensions.final
class WatchUserLatestModelRequest(google.protobuf.message.Message):
    """WatchUserLatestModelRequest represents a request to fetch current state of
    the latest model version.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___WatchUserLatestModelRequest = WatchUserLatestModelRequest

@typing_extensions.final
class WatchUserLatestModelResponse(google.protobuf.message.Message):
    """WatchUserLatestModelResponse contains the state of the latest model version."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    state: global___State.ValueType
    """State."""
    message: builtins.str
    """Detail description of the state"""
    def __init__(
        self,
        *,
        state: global___State.ValueType = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["message", b"message", "state", b"state"]) -> None: ...

global___WatchUserLatestModelResponse = WatchUserLatestModelResponse

@typing_extensions.final
class ListUserModelVersionsRequest(google.protobuf.message.Message):
    """ListUserModelVersionsRequest represents a request to list all the versions
    of a model namespace of a user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of versions to return. The default and cap values are 10
    and 100, respectively.
    """
    page: builtins.int
    """Page number."""
    name: builtins.str
    """The parent resource, i.e., the user that created the models.
    - Format: `users/{user.id}`.
    The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page: builtins.int | None = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page", b"_page", "_page_size", b"_page_size", "page", b"page", "page_size", b"page_size"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page", b"_page", "_page_size", b"_page_size", "name", b"name", "page", b"page", "page_size", b"page_size"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page", b"_page"]) -> typing_extensions.Literal["page"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...

global___ListUserModelVersionsRequest = ListUserModelVersionsRequest

@typing_extensions.final
class ListUserModelVersionsResponse(google.protobuf.message.Message):
    """ListUserModelVersionsResponse contains a list of models."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSIONS_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    @property
    def versions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelVersion]:
        """A list of model resources."""
    total_size: builtins.int
    """Total number of versions."""
    page_size: builtins.int
    """The requested page size."""
    page: builtins.int
    """The requested page offset."""
    def __init__(
        self,
        *,
        versions: collections.abc.Iterable[global___ModelVersion] | None = ...,
        total_size: builtins.int = ...,
        page_size: builtins.int = ...,
        page: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page", b"page", "page_size", b"page_size", "total_size", b"total_size", "versions", b"versions"]) -> None: ...

global___ListUserModelVersionsResponse = ListUserModelVersionsResponse

@typing_extensions.final
class DeleteUserModelVersionRequest(google.protobuf.message.Message):
    """DeleteUserModelVersionRequest represents a request to delete a model version
     owned by a user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    version: builtins.str
    """Model version"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "version", b"version"]) -> None: ...

global___DeleteUserModelVersionRequest = DeleteUserModelVersionRequest

@typing_extensions.final
class DeleteUserModelVersionResponse(google.protobuf.message.Message):
    """DeleteUserModelVersionResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteUserModelVersionResponse = DeleteUserModelVersionResponse

@typing_extensions.final
class TriggerUserModelRequest(google.protobuf.message.Message):
    """//////////////////////////////////
     Trigger methods
    //////////////////////////////////

    TriggerUserModelRequest represents a request to trigger a model inference.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    TASK_INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model , which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    version: builtins.str
    """Model version"""
    @property
    def task_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference inputs."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
        task_inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "task_inputs", b"task_inputs", "version", b"version"]) -> None: ...

global___TriggerUserModelRequest = TriggerUserModelRequest

@typing_extensions.final
class TriggerUserModelResponse(google.protobuf.message.Message):
    """TriggerUserModelResponse contains the model inference results."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_FIELD_NUMBER: builtins.int
    TASK_OUTPUTS_FIELD_NUMBER: builtins.int
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """Task type."""
    @property
    def task_outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference outputs."""
    def __init__(
        self,
        *,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        task_outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["task", b"task", "task_outputs", b"task_outputs"]) -> None: ...

global___TriggerUserModelResponse = TriggerUserModelResponse

@typing_extensions.final
class TriggerAsyncUserModelRequest(google.protobuf.message.Message):
    """TriggerAsyncUserModelRequest represents a request to trigger a model
    inference asynchronously.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    TASK_INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model , which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    version: builtins.str
    """Model version"""
    @property
    def task_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference inputs."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
        task_inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "task_inputs", b"task_inputs", "version", b"version"]) -> None: ...

global___TriggerAsyncUserModelRequest = TriggerAsyncUserModelRequest

@typing_extensions.final
class TriggerAsyncUserModelResponse(google.protobuf.message.Message):
    """TriggerAsyncUserModelResponse contains the information to access the
    status of an asynchronous model inference.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Long-running operation information."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___TriggerAsyncUserModelResponse = TriggerAsyncUserModelResponse

@typing_extensions.final
class TriggerUserLatestModelRequest(google.protobuf.message.Message):
    """TriggerUserLatestModelRequest represents a request to trigger a model
    inference with the latest uploaded version.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TASK_INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model , which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    @property
    def task_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference inputs."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        task_inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "task_inputs", b"task_inputs"]) -> None: ...

global___TriggerUserLatestModelRequest = TriggerUserLatestModelRequest

@typing_extensions.final
class TriggerUserLatestModelResponse(google.protobuf.message.Message):
    """TriggerUserLatestModelResponse contains the model inference results."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_FIELD_NUMBER: builtins.int
    TASK_OUTPUTS_FIELD_NUMBER: builtins.int
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """Task type."""
    @property
    def task_outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference outputs."""
    def __init__(
        self,
        *,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        task_outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["task", b"task", "task_outputs", b"task_outputs"]) -> None: ...

global___TriggerUserLatestModelResponse = TriggerUserLatestModelResponse

@typing_extensions.final
class TriggerAsyncUserLatestModelRequest(google.protobuf.message.Message):
    """TriggerAsyncUserLatestModelRequest represents a request to trigger a model
    inference asynchronously with the latest uploaded version.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TASK_INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model , which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    @property
    def task_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference inputs."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        task_inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "task_inputs", b"task_inputs"]) -> None: ...

global___TriggerAsyncUserLatestModelRequest = TriggerAsyncUserLatestModelRequest

@typing_extensions.final
class TriggerAsyncUserLatestModelResponse(google.protobuf.message.Message):
    """TriggerAsyncUserLatestModelResponse contains the information to access the
    status of an asynchronous model inference.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Long-running operation information."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___TriggerAsyncUserLatestModelResponse = TriggerAsyncUserLatestModelResponse

@typing_extensions.final
class TriggerUserModelBinaryFileUploadRequest(google.protobuf.message.Message):
    """TriggerUserModelBinaryFileUploadRequest represents a request trigger a model
    inference by uploading a binary file as the input.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    TASK_INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model , which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    version: builtins.str
    """Model version"""
    @property
    def task_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference inputs."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
        task_inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "task_inputs", b"task_inputs", "version", b"version"]) -> None: ...

global___TriggerUserModelBinaryFileUploadRequest = TriggerUserModelBinaryFileUploadRequest

@typing_extensions.final
class TriggerUserModelBinaryFileUploadResponse(google.protobuf.message.Message):
    """TriggerUserModelBinaryFileUploadResponse contains the model inference
    results.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_FIELD_NUMBER: builtins.int
    TASK_OUTPUTS_FIELD_NUMBER: builtins.int
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """Task type."""
    @property
    def task_outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference outputs."""
    def __init__(
        self,
        *,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        task_outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["task", b"task", "task_outputs", b"task_outputs"]) -> None: ...

global___TriggerUserModelBinaryFileUploadResponse = TriggerUserModelBinaryFileUploadResponse

@typing_extensions.final
class CreateOrganizationModelRequest(google.protobuf.message.Message):
    """//////////////////////////////////
     Organization methods
    //////////////////////////////////

    CreateOrganizationModelRequest represents a request from an organization to
    create a model.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The properties of the model to be created."""
    parent: builtins.str
    """The parent resource, i.e., the organization that creates the model.
    Format: `organizations/{organization.id}`.
    """
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model", "parent", b"parent"]) -> None: ...

global___CreateOrganizationModelRequest = CreateOrganizationModelRequest

@typing_extensions.final
class CreateOrganizationModelResponse(google.protobuf.message.Message):
    """CreateOrganizationModelResponse contains the created model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The created model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___CreateOrganizationModelResponse = CreateOrganizationModelResponse

@typing_extensions.final
class ListOrganizationModelsRequest(google.protobuf.message.Message):
    """ListOrganizationModelsRequest represents a request to list the models
    of an organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of models to return. If this parameter is unspecified,
    at most 10 models will be returned. The cap value for this parameter is
    100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired model view in the response."""
    parent: builtins.str
    """The parent resource, i.e., the organization that created the models.
    - Format: `organizations/{organizations.id}`.
    """
    show_deleted: builtins.bool
    """Include soft-deleted models in the result."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    visibility: global___Model.Visibility.ValueType
    """Limit results to pipelines with the specified visibility."""
    order_by: builtins.str
    """Order by field, with options for ordering by `id`, `create_time` or
    `update_time`. Format: `order_by=id` or `order_by=create_time desc`,
    default is `asc`.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
        parent: builtins.str = ...,
        show_deleted: builtins.bool | None = ...,
        filter: builtins.str | None = ...,
        visibility: global___Model.Visibility.ValueType | None = ...,
        order_by: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_order_by", b"_order_by", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "_visibility", b"_visibility", "filter", b"filter", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view", "visibility", b"visibility"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_order_by", b"_order_by", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "_visibility", b"_visibility", "filter", b"filter", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token", "parent", b"parent", "show_deleted", b"show_deleted", "view", b"view", "visibility", b"visibility"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_order_by", b"_order_by"]) -> typing_extensions.Literal["order_by"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_visibility", b"_visibility"]) -> typing_extensions.Literal["visibility"] | None: ...

global___ListOrganizationModelsRequest = ListOrganizationModelsRequest

@typing_extensions.final
class ListOrganizationModelsResponse(google.protobuf.message.Message):
    """ListOrganizationModelsResponse contains a list of models."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODELS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Model]:
        """A list of model resources."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of models."""
    def __init__(
        self,
        *,
        models: collections.abc.Iterable[global___Model] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["models", b"models", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListOrganizationModelsResponse = ListOrganizationModelsResponse

@typing_extensions.final
class GetOrganizationModelRequest(google.protobuf.message.Message):
    """GetOrganizationModelRequest represents a request to fetch the details of a
    model owned by an organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent
    organization and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired model view in the response."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetOrganizationModelRequest = GetOrganizationModelRequest

@typing_extensions.final
class GetOrganizationModelResponse(google.protobuf.message.Message):
    """GetOrganizationModelResponse contains the requested model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___GetOrganizationModelResponse = GetOrganizationModelResponse

@typing_extensions.final
class UpdateOrganizationModelRequest(google.protobuf.message.Message):
    """UpdateOrganizationModelRequest represents a request to update a model owned
    by an organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The model to update"""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The update mask specifies the subset of fields that should be modified.

        For more information about this field, see
        https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#field-mask.
        """
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model", "update_mask", b"update_mask"]) -> None: ...

global___UpdateOrganizationModelRequest = UpdateOrganizationModelRequest

@typing_extensions.final
class UpdateOrganizationModelResponse(google.protobuf.message.Message):
    """UpdateOrganizationModelResponse contains the updated model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The updated model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___UpdateOrganizationModelResponse = UpdateOrganizationModelResponse

@typing_extensions.final
class DeleteOrganizationModelRequest(google.protobuf.message.Message):
    """DeleteOrganizationModelRequest represents a request to delete a model owned
    by an organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent
    organization and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteOrganizationModelRequest = DeleteOrganizationModelRequest

@typing_extensions.final
class DeleteOrganizationModelResponse(google.protobuf.message.Message):
    """DeleteOrganizationModelResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteOrganizationModelResponse = DeleteOrganizationModelResponse

@typing_extensions.final
class RenameOrganizationModelRequest(google.protobuf.message.Message):
    """RenameOrganizationModelRequest represents a request to rename a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    NEW_MODEL_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent
    organization and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    new_model_id: builtins.str
    """The new resource ID. This will transform the resource name into
    `organizations/{organization.id}/models/{new_model_id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        new_model_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "new_model_id", b"new_model_id"]) -> None: ...

global___RenameOrganizationModelRequest = RenameOrganizationModelRequest

@typing_extensions.final
class RenameOrganizationModelResponse(google.protobuf.message.Message):
    """RenameOrganizationModelResponse contains a renamed model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The renamed model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___RenameOrganizationModelResponse = RenameOrganizationModelResponse

@typing_extensions.final
class WatchOrganizationModelRequest(google.protobuf.message.Message):
    """WatchOrganizationModelRequest represents a request to fetch current state of
    a model.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent
    organization and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    version: builtins.str
    """Model version"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "version", b"version"]) -> None: ...

global___WatchOrganizationModelRequest = WatchOrganizationModelRequest

@typing_extensions.final
class WatchOrganizationModelResponse(google.protobuf.message.Message):
    """WatchOrganizationModelResponse contains the state of a model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    state: global___State.ValueType
    """State."""
    message: builtins.str
    """Detail description of the state"""
    def __init__(
        self,
        *,
        state: global___State.ValueType = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["message", b"message", "state", b"state"]) -> None: ...

global___WatchOrganizationModelResponse = WatchOrganizationModelResponse

@typing_extensions.final
class WatchOrganizationLatestModelRequest(google.protobuf.message.Message):
    """WatchOrganizationLatestModelRequest represents a request to fetch current
    state of the latest model version
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent
    organization and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___WatchOrganizationLatestModelRequest = WatchOrganizationLatestModelRequest

@typing_extensions.final
class WatchOrganizationLatestModelResponse(google.protobuf.message.Message):
    """WatchOrganizationLatestModelResponse contains the state of the latest model
    version.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    state: global___State.ValueType
    """State."""
    message: builtins.str
    """Detail description of the state"""
    def __init__(
        self,
        *,
        state: global___State.ValueType = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["message", b"message", "state", b"state"]) -> None: ...

global___WatchOrganizationLatestModelResponse = WatchOrganizationLatestModelResponse

@typing_extensions.final
class ListOrganizationModelVersionsRequest(google.protobuf.message.Message):
    """ListOrganizationModelVersionsRequest represents a request to list all the
    versions of a model namespace of an organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of versions to return. The default and cap values are 10
    and 100, respectively.
    """
    page: builtins.int
    """Page number."""
    name: builtins.str
    """The parent resource, i.e., the user that created the models.
    - Format: `organizations/{organization.id}`.
    The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page: builtins.int | None = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page", b"_page", "_page_size", b"_page_size", "page", b"page", "page_size", b"page_size"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page", b"_page", "_page_size", b"_page_size", "name", b"name", "page", b"page", "page_size", b"page_size"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page", b"_page"]) -> typing_extensions.Literal["page"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...

global___ListOrganizationModelVersionsRequest = ListOrganizationModelVersionsRequest

@typing_extensions.final
class ListOrganizationModelVersionsResponse(google.protobuf.message.Message):
    """ListOrganizationModelVersionsResponse contains a list of models."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSIONS_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    @property
    def versions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelVersion]:
        """A list of model resources."""
    total_size: builtins.int
    """Total number of versions."""
    page_size: builtins.int
    """The requested page size."""
    page: builtins.int
    """The requested page offset."""
    def __init__(
        self,
        *,
        versions: collections.abc.Iterable[global___ModelVersion] | None = ...,
        total_size: builtins.int = ...,
        page_size: builtins.int = ...,
        page: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page", b"page", "page_size", b"page_size", "total_size", b"total_size", "versions", b"versions"]) -> None: ...

global___ListOrganizationModelVersionsResponse = ListOrganizationModelVersionsResponse

@typing_extensions.final
class DeleteOrganizationModelVersionRequest(google.protobuf.message.Message):
    """DeleteOrganizationModelVersionRequest represents a request to delete a model
    version
     owned by an organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The parent resource, i.e., the user that created the models.
    - Format: `organizations/{organization.id}`.
    The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    version: builtins.str
    """Model version"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "version", b"version"]) -> None: ...

global___DeleteOrganizationModelVersionRequest = DeleteOrganizationModelVersionRequest

@typing_extensions.final
class DeleteOrganizationModelVersionResponse(google.protobuf.message.Message):
    """DeleteOrganizationModelVersionResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteOrganizationModelVersionResponse = DeleteOrganizationModelVersionResponse

@typing_extensions.final
class TriggerOrganizationModelRequest(google.protobuf.message.Message):
    """TriggerOrganizationModelRequest represents a request to trigger a model
    inference.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    TASK_INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model , which allows its access by parent
    organization and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    version: builtins.str
    """Model version"""
    @property
    def task_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference inputs."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
        task_inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "task_inputs", b"task_inputs", "version", b"version"]) -> None: ...

global___TriggerOrganizationModelRequest = TriggerOrganizationModelRequest

@typing_extensions.final
class TriggerOrganizationModelResponse(google.protobuf.message.Message):
    """TriggerOrganizationModelResponse contains the model inference results."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_FIELD_NUMBER: builtins.int
    TASK_OUTPUTS_FIELD_NUMBER: builtins.int
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """Task type."""
    @property
    def task_outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference outputs."""
    def __init__(
        self,
        *,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        task_outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["task", b"task", "task_outputs", b"task_outputs"]) -> None: ...

global___TriggerOrganizationModelResponse = TriggerOrganizationModelResponse

@typing_extensions.final
class TriggerAsyncOrganizationModelRequest(google.protobuf.message.Message):
    """TriggerAsyncOrganizationModelRequest represents a request to trigger a model
    inference asynchronously
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    TASK_INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model , which allows its access by parent
    organization and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    version: builtins.str
    """Model version"""
    @property
    def task_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference inputs."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
        task_inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "task_inputs", b"task_inputs", "version", b"version"]) -> None: ...

global___TriggerAsyncOrganizationModelRequest = TriggerAsyncOrganizationModelRequest

@typing_extensions.final
class TriggerAsyncOrganizationModelResponse(google.protobuf.message.Message):
    """TriggerAsyncOrganizationModelResponse contains the information to access the
    status of an asynchronous model inference.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Long-running operation information."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___TriggerAsyncOrganizationModelResponse = TriggerAsyncOrganizationModelResponse

@typing_extensions.final
class TriggerOrganizationLatestModelRequest(google.protobuf.message.Message):
    """TriggerOrganizationLatestModelRequest represents a request to trigger a model
    inference.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TASK_INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model , which allows its access by parent
    organization and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    @property
    def task_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference inputs."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        task_inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "task_inputs", b"task_inputs"]) -> None: ...

global___TriggerOrganizationLatestModelRequest = TriggerOrganizationLatestModelRequest

@typing_extensions.final
class TriggerOrganizationLatestModelResponse(google.protobuf.message.Message):
    """TriggerOrganizationLatestModelResponse contains the model inference results."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_FIELD_NUMBER: builtins.int
    TASK_OUTPUTS_FIELD_NUMBER: builtins.int
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """Task type."""
    @property
    def task_outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference outputs."""
    def __init__(
        self,
        *,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        task_outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["task", b"task", "task_outputs", b"task_outputs"]) -> None: ...

global___TriggerOrganizationLatestModelResponse = TriggerOrganizationLatestModelResponse

@typing_extensions.final
class TriggerAsyncOrganizationLatestModelRequest(google.protobuf.message.Message):
    """TriggerAsyncOrganizationLatestModelRequest represents a request to trigger a
    model inference asynchronously
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TASK_INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model , which allows its access by parent
    organization and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    @property
    def task_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference inputs."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        task_inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "task_inputs", b"task_inputs"]) -> None: ...

global___TriggerAsyncOrganizationLatestModelRequest = TriggerAsyncOrganizationLatestModelRequest

@typing_extensions.final
class TriggerAsyncOrganizationLatestModelResponse(google.protobuf.message.Message):
    """TriggerAsyncOrganizationLatestModelResponse contains the information to
    access the status of an asynchronous model inference.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Long-running operation information."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___TriggerAsyncOrganizationLatestModelResponse = TriggerAsyncOrganizationLatestModelResponse

@typing_extensions.final
class TriggerOrganizationModelBinaryFileUploadRequest(google.protobuf.message.Message):
    """TriggerOrganizationModelBinaryFileUploadRequest represents a request trigger
    a model inference by uploading a binary file as the input.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    TASK_INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model , which allows its access by parent
    organization and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    version: builtins.str
    """Model version"""
    @property
    def task_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference inputs."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
        task_inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "task_inputs", b"task_inputs", "version", b"version"]) -> None: ...

global___TriggerOrganizationModelBinaryFileUploadRequest = TriggerOrganizationModelBinaryFileUploadRequest

@typing_extensions.final
class TriggerOrganizationModelBinaryFileUploadResponse(google.protobuf.message.Message):
    """TriggerOrganizationModelBinaryFileUploadResponse contains the model inference
    results.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_FIELD_NUMBER: builtins.int
    TASK_OUTPUTS_FIELD_NUMBER: builtins.int
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """Task type."""
    @property
    def task_outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference outputs."""
    def __init__(
        self,
        *,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        task_outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["task", b"task", "task_outputs", b"task_outputs"]) -> None: ...

global___TriggerOrganizationModelBinaryFileUploadResponse = TriggerOrganizationModelBinaryFileUploadResponse

@typing_extensions.final
class GetModelOperationRequest(google.protobuf.message.Message):
    """GetModelOperationRequest represents a request to fetch a long-running
    operation performed on a model.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_ID_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    operation_id: builtins.str
    """The resource name of the model, which allows its access ID."""
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired model view in the response."""
    def __init__(
        self,
        *,
        operation_id: builtins.str = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "operation_id", b"operation_id", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetModelOperationRequest = GetModelOperationRequest

@typing_extensions.final
class GetModelOperationResponse(google.protobuf.message.Message):
    """GetModelOperationRequest represents a request to query a long-running
    operation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """The long-running operation."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___GetModelOperationResponse = GetModelOperationResponse

@typing_extensions.final
class LatestOperation(google.protobuf.message.Message):
    """LatestOperation represents an internal message for GetLatestModelOperation
    Response
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_FIELD_NUMBER: builtins.int
    RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def request(self) -> global___TriggerNamespaceModelRequest:
        """Input request"""
    @property
    def response(self) -> global___TriggerNamespaceModelResponse:
        """Output response"""
    def __init__(
        self,
        *,
        request: global___TriggerNamespaceModelRequest | None = ...,
        response: global___TriggerNamespaceModelResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["request", b"request", "response", b"response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["request", b"request", "response", b"response"]) -> None: ...

global___LatestOperation = LatestOperation

@typing_extensions.final
class GetUserLatestModelOperationRequest(google.protobuf.message.Message):
    """GetUserLatestModelOperationRequest represents a request to fetch the latest
    long-running operation performed on a model for a user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired operation result in the
    response.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetUserLatestModelOperationRequest = GetUserLatestModelOperationRequest

@typing_extensions.final
class GetUserLatestModelOperationResponse(google.protobuf.message.Message):
    """GetUserLatestModelOperationRequest represents a request to query a
    long-running operation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """The long-running operation."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___GetUserLatestModelOperationResponse = GetUserLatestModelOperationResponse

@typing_extensions.final
class GetOrganizationLatestModelOperationRequest(google.protobuf.message.Message):
    """GetOrganizationLatestModelOperationRequest represents a request to fetch the
    latest long-running operation performed on a model for a user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent
    organization and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired operation result in the
    response.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetOrganizationLatestModelOperationRequest = GetOrganizationLatestModelOperationRequest

@typing_extensions.final
class GetOrganizationLatestModelOperationResponse(google.protobuf.message.Message):
    """GetOrganizationLatestModelOperationRequest represents a request to query a
    long-running operation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """The long-running operation."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___GetOrganizationLatestModelOperationResponse = GetOrganizationLatestModelOperationResponse

@typing_extensions.final
class ListAvailableRegionsRequest(google.protobuf.message.Message):
    """ListAvailableRegionsRequest represents a request to fetch a list
    of available regions and hardware types a model can be deployed on.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ListAvailableRegionsRequest = ListAvailableRegionsRequest

@typing_extensions.final
class ListAvailableRegionsResponse(google.protobuf.message.Message):
    """ListAvailableRegionsResponse contains a list of available
    regions and hardware types a model can be deployed on.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REGIONS_FIELD_NUMBER: builtins.int
    @property
    def regions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Region]:
        """A list of available region"""
    def __init__(
        self,
        *,
        regions: collections.abc.Iterable[global___Region] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["regions", b"regions"]) -> None: ...

global___ListAvailableRegionsResponse = ListAvailableRegionsResponse

@typing_extensions.final
class ListModelsAdminRequest(google.protobuf.message.Message):
    """========== Private endpoints

    ListModelsAdminRequest represents a request to list all models from all users
    by admin
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """Page size: the maximum number of resources to return. The service may
    return fewer than this value. If unspecified, at most 10 models will be
    returned. The maximum value is 100; values above 100 will be coereced to
    100.
    """
    page_token: builtins.str
    """Page token"""
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """Model view (default is VIEW_BASIC)
    VIEW_UNSPECIFIED/VIEW_BASIC: omit `Model.configuration`
    VIEW_FULL: show full information
    """
    show_deleted: builtins.bool
    """Return soft_deleted models"""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
        show_deleted: builtins.bool | None = ...,
        filter: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListModelsAdminRequest = ListModelsAdminRequest

@typing_extensions.final
class ListModelsAdminResponse(google.protobuf.message.Message):
    """ListModelsAdminResponse represents a response for a list of models"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODELS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Model]:
        """a list of Models"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total number of models."""
    def __init__(
        self,
        *,
        models: collections.abc.Iterable[global___Model] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["models", b"models", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListModelsAdminResponse = ListModelsAdminResponse

@typing_extensions.final
class LookUpModelAdminRequest(google.protobuf.message.Message):
    """LookUpModelAdminRequest represents a request to query a model via
    permalink by admin
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """Permalink of a model. For example:
    "models/{uid}"
    """
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """Model view (default is VIEW_BASIC)
    VIEW_UNSPECIFIED/VIEW_BASIC: omit `Model.configuration`
    VIEW_FULL: show full information
    """
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "permalink", b"permalink", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___LookUpModelAdminRequest = LookUpModelAdminRequest

@typing_extensions.final
class LookUpModelAdminResponse(google.protobuf.message.Message):
    """LookUpModelResponse represents a response for a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """A model resource"""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___LookUpModelAdminResponse = LookUpModelAdminResponse

@typing_extensions.final
class DeployUserModelAdminRequest(google.protobuf.message.Message):
    """DeployUserModelAdminRequest represents a request to deploy a model to online
    state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    DIGEST_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    version: builtins.str
    """Model version"""
    digest: builtins.str
    """Model image digest"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
        digest: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["digest", b"digest", "name", b"name", "version", b"version"]) -> None: ...

global___DeployUserModelAdminRequest = DeployUserModelAdminRequest

@typing_extensions.final
class DeployUserModelAdminResponse(google.protobuf.message.Message):
    """DeployUserModelAdminResponse represents a response for a deployed model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeployUserModelAdminResponse = DeployUserModelAdminResponse

@typing_extensions.final
class DeployOrganizationModelAdminRequest(google.protobuf.message.Message):
    """DeployOrganizationModelAdminRequest represents a request to deploy a model to
    online state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    DIGEST_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `organizations/{user.id}/models/{model.id}`.
    """
    version: builtins.str
    """Model version"""
    digest: builtins.str
    """Model image digest"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
        digest: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["digest", b"digest", "name", b"name", "version", b"version"]) -> None: ...

global___DeployOrganizationModelAdminRequest = DeployOrganizationModelAdminRequest

@typing_extensions.final
class DeployOrganizationModelAdminResponse(google.protobuf.message.Message):
    """DeployOrganizationModelAdminResponse represents a response for a deployed
    model
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeployOrganizationModelAdminResponse = DeployOrganizationModelAdminResponse

@typing_extensions.final
class UndeployUserModelAdminRequest(google.protobuf.message.Message):
    """UndeployUserModelAdminRequest represents a request to undeploy a model to
    offline state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    DIGEST_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    version: builtins.str
    """Model version"""
    digest: builtins.str
    """Model image digest"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
        digest: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["digest", b"digest", "name", b"name", "version", b"version"]) -> None: ...

global___UndeployUserModelAdminRequest = UndeployUserModelAdminRequest

@typing_extensions.final
class UndeployUserModelAdminResponse(google.protobuf.message.Message):
    """UndeployUserModelAdminResponse represents a response for a undeployed model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UndeployUserModelAdminResponse = UndeployUserModelAdminResponse

@typing_extensions.final
class UndeployOrganizationModelAdminRequest(google.protobuf.message.Message):
    """UndeployOrganizationModelAdminRequest represents a request to undeploy a
    model to offline state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    DIGEST_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    version: builtins.str
    """Model version"""
    digest: builtins.str
    """Model image digest"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
        digest: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["digest", b"digest", "name", b"name", "version", b"version"]) -> None: ...

global___UndeployOrganizationModelAdminRequest = UndeployOrganizationModelAdminRequest

@typing_extensions.final
class UndeployOrganizationModelAdminResponse(google.protobuf.message.Message):
    """UndeployOrganizationModelAdminResponse represents a response for a undeployed
    model
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UndeployOrganizationModelAdminResponse = UndeployOrganizationModelAdminResponse

@typing_extensions.final
class ModelRun(google.protobuf.message.Message):
    """ModelRun contains information about a run of models."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    TOTAL_DURATION_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    RUNNER_ID_FIELD_NUMBER: builtins.int
    CREDIT_AMOUNT_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    TASK_INPUTS_FIELD_NUMBER: builtins.int
    TASK_OUTPUTS_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    REQUESTER_ID_FIELD_NUMBER: builtins.int
    MODEL_NAMESPACE_ID_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """Model Run UUID."""
    status: common.run.v1alpha.run_pb2.RunStatus.ValueType
    """Model run status."""
    source: common.run.v1alpha.run_pb2.RunSource.ValueType
    """Run source."""
    total_duration: builtins.int
    """Run total duration in milliseconds."""
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Run end time."""
    runner_id: builtins.str
    """Runner ID. If current viewing requester does not have enough permission, it
    will return null.
    """
    credit_amount: builtins.float
    """The amount of Instill Credit consumed by the run. This field will only be
    present on Instill Cloud.
    """
    error: builtins.str
    """Error message occurred during model run."""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Model run created time."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Model run updated time."""
    version: builtins.str
    """The model version identifier, which is same as image tag."""
    @property
    def task_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference input."""
    @property
    def task_outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference outputs."""
    model_id: builtins.str
    """Model ID."""
    requester_id: builtins.str
    """Requester ID. The namespace used to trigger the run. This field might be
    empty if the model run belongs to a deleted namespace.
    """
    model_namespace_id: builtins.str
    """ID of the namespace that owns the model."""
    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        status: common.run.v1alpha.run_pb2.RunStatus.ValueType = ...,
        source: common.run.v1alpha.run_pb2.RunSource.ValueType = ...,
        total_duration: builtins.int | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        runner_id: builtins.str | None = ...,
        credit_amount: builtins.float | None = ...,
        error: builtins.str | None = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        version: builtins.str = ...,
        task_inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        task_outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        model_id: builtins.str | None = ...,
        requester_id: builtins.str = ...,
        model_namespace_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_credit_amount", b"_credit_amount", "_end_time", b"_end_time", "_error", b"_error", "_model_id", b"_model_id", "_runner_id", b"_runner_id", "_total_duration", b"_total_duration", "create_time", b"create_time", "credit_amount", b"credit_amount", "end_time", b"end_time", "error", b"error", "model_id", b"model_id", "runner_id", b"runner_id", "total_duration", b"total_duration", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_credit_amount", b"_credit_amount", "_end_time", b"_end_time", "_error", b"_error", "_model_id", b"_model_id", "_runner_id", b"_runner_id", "_total_duration", b"_total_duration", "create_time", b"create_time", "credit_amount", b"credit_amount", "end_time", b"end_time", "error", b"error", "model_id", b"model_id", "model_namespace_id", b"model_namespace_id", "requester_id", b"requester_id", "runner_id", b"runner_id", "source", b"source", "status", b"status", "task_inputs", b"task_inputs", "task_outputs", b"task_outputs", "total_duration", b"total_duration", "uid", b"uid", "update_time", b"update_time", "version", b"version"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_credit_amount", b"_credit_amount"]) -> typing_extensions.Literal["credit_amount"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_end_time", b"_end_time"]) -> typing_extensions.Literal["end_time"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_error", b"_error"]) -> typing_extensions.Literal["error"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_model_id", b"_model_id"]) -> typing_extensions.Literal["model_id"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_runner_id", b"_runner_id"]) -> typing_extensions.Literal["runner_id"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_total_duration", b"_total_duration"]) -> typing_extensions.Literal["total_duration"] | None: ...

global___ModelRun = ModelRun

@typing_extensions.final
class ListModelRunsRequest(google.protobuf.message.Message):
    """ListModelRunsRequest represents a request to list of model runs."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of runs to return. The default and cap values are 10
    and 100, respectively.
    """
    page: builtins.int
    """Page number."""
    order_by: builtins.str
    """Sort the results by the given expression.
    Format: `field [ASC | DESC], where `field` can be:
    - `create_time`
    - `update_time`
    By default, results are sorted by descending creation time.
    """
    namespace_id: builtins.str
    """Namespace ID."""
    model_id: builtins.str
    """Model ID."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    The filter can be applied to the following fields:
    - `create_time`
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page: builtins.int | None = ...,
        order_by: builtins.str | None = ...,
        namespace_id: builtins.str = ...,
        model_id: builtins.str = ...,
        filter: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_order_by", b"_order_by", "_page", b"_page", "_page_size", b"_page_size", "filter", b"filter", "order_by", b"order_by", "page", b"page", "page_size", b"page_size"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_order_by", b"_order_by", "_page", b"_page", "_page_size", b"_page_size", "filter", b"filter", "model_id", b"model_id", "namespace_id", b"namespace_id", "order_by", b"order_by", "page", b"page", "page_size", b"page_size"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_order_by", b"_order_by"]) -> typing_extensions.Literal["order_by"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page", b"_page"]) -> typing_extensions.Literal["page"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...

global___ListModelRunsRequest = ListModelRunsRequest

@typing_extensions.final
class ListModelRunsByRequesterRequest(google.protobuf.message.Message):
    """ListModelRunsByRequesterRequest is the request message for
    ListModelRunsByRequester.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    START_FIELD_NUMBER: builtins.int
    STOP_FIELD_NUMBER: builtins.int
    REQUESTER_ID_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of runs to return. The default and cap values are 10
    and 100, respectively.
    """
    page: builtins.int
    """Page number."""
    order_by: builtins.str
    """Sort the results by the given expression.
    Format: `field [ASC | DESC], where `field` can be:
    - `create_time`
    - `update_time`
    By default, results are sorted by descending creation time.
    """
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `status="RUN_STATUS_COMPLETED"`.
    The filter can be applied to the following fields:
    - `status`
    - `source`
    """
    @property
    def start(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Beginning of the time range from which the records will be fetched.
        The default value is the beginning of the current day, in UTC.
        """
    @property
    def stop(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """End of the time range from which the records will be fetched.
        The default value is the current timestamp.
        """
    requester_id: builtins.str
    """Requester ID."""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page: builtins.int | None = ...,
        order_by: builtins.str | None = ...,
        filter: builtins.str | None = ...,
        start: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        stop: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        requester_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_order_by", b"_order_by", "_page", b"_page", "_page_size", b"_page_size", "_start", b"_start", "_stop", b"_stop", "filter", b"filter", "order_by", b"order_by", "page", b"page", "page_size", b"page_size", "start", b"start", "stop", b"stop"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_order_by", b"_order_by", "_page", b"_page", "_page_size", b"_page_size", "_start", b"_start", "_stop", b"_stop", "filter", b"filter", "order_by", b"order_by", "page", b"page", "page_size", b"page_size", "requester_id", b"requester_id", "start", b"start", "stop", b"stop"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_order_by", b"_order_by"]) -> typing_extensions.Literal["order_by"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page", b"_page"]) -> typing_extensions.Literal["page"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_start", b"_start"]) -> typing_extensions.Literal["start"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_stop", b"_stop"]) -> typing_extensions.Literal["stop"] | None: ...

global___ListModelRunsByRequesterRequest = ListModelRunsByRequesterRequest

@typing_extensions.final
class ListModelRunsResponse(google.protobuf.message.Message):
    """ListModelRunsResponse contains a list of model runs."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUNS_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    @property
    def runs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelRun]:
        """A list of runs resources."""
    total_size: builtins.int
    """Total number of runs."""
    page_size: builtins.int
    """The requested page size."""
    page: builtins.int
    """The requested page offset."""
    def __init__(
        self,
        *,
        runs: collections.abc.Iterable[global___ModelRun] | None = ...,
        total_size: builtins.int = ...,
        page_size: builtins.int = ...,
        page: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page", b"page", "page_size", b"page_size", "runs", b"runs", "total_size", b"total_size"]) -> None: ...

global___ListModelRunsResponse = ListModelRunsResponse

@typing_extensions.final
class ListModelRunsByRequesterResponse(google.protobuf.message.Message):
    """ListModelRunsByRequesterResponse is the request message for
    ListModelRunsByRequester.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUNS_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    @property
    def runs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelRun]:
        """A list of runs resources."""
    total_size: builtins.int
    """Total number of runs."""
    page_size: builtins.int
    """The requested page size."""
    page: builtins.int
    """The requested page offset."""
    def __init__(
        self,
        *,
        runs: collections.abc.Iterable[global___ModelRun] | None = ...,
        total_size: builtins.int = ...,
        page_size: builtins.int = ...,
        page: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page", b"page", "page_size", b"page_size", "runs", b"runs", "total_size", b"total_size"]) -> None: ...

global___ListModelRunsByRequesterResponse = ListModelRunsByRequesterResponse
