# coding: utf-8

"""
    Workato Platform API

    Official Workato Platform API for managing recipes, connections, projects, and other automation resources.  ## Authentication All endpoints require a Bearer token in the Authorization header.  ## Base URL The base URL varies by region: - US: `https://www.workato.com` - EU: `https://app.eu.workato.com` - JP: `https://app.jp.workato.com` - SG: `https://app.sg.workato.com` - AU: `https://app.au.workato.com` - IL: `https://app.il.workato.com` - Trial: `https://app.trial.workato.com` 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from workato_platform_cli.client.workato_api.models.api_client_api_collections_inner import ApiClientApiCollectionsInner
from workato_platform_cli.client.workato_api.models.api_client_api_policies_inner import ApiClientApiPoliciesInner
from typing import Optional, Set
from typing_extensions import Self

class ApiClient(BaseModel):
    """
    ApiClient
    """ # noqa: E501
    id: StrictInt
    name: StrictStr
    description: Optional[StrictStr] = None
    active_api_keys_count: Optional[StrictInt] = None
    total_api_keys_count: Optional[StrictInt] = None
    created_at: datetime
    updated_at: datetime
    logo: Optional[StrictStr] = Field(description="URL to the client's logo image")
    logo_2x: Optional[StrictStr] = Field(description="URL to the client's high-resolution logo image")
    is_legacy: StrictBool
    email: Optional[StrictStr] = None
    auth_type: StrictStr
    api_token: Optional[StrictStr] = Field(default=None, description="API token (only returned for token auth type)")
    mtls_enabled: Optional[StrictBool] = None
    validation_formula: Optional[StrictStr] = None
    cert_bundle_ids: Optional[List[StrictInt]] = None
    api_policies: List[ApiClientApiPoliciesInner] = Field(description="List of API policies associated with the client")
    api_collections: List[ApiClientApiCollectionsInner] = Field(description="List of API collections associated with the client")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "active_api_keys_count", "total_api_keys_count", "created_at", "updated_at", "logo", "logo_2x", "is_legacy", "email", "auth_type", "api_token", "mtls_enabled", "validation_formula", "cert_bundle_ids", "api_policies", "api_collections"]

    @field_validator('auth_type')
    def auth_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['token', 'jwt', 'oauth2', 'oidc']):
            raise ValueError("must be one of enum values ('token', 'jwt', 'oauth2', 'oidc')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiClient from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in api_policies (list)
        _items = []
        if self.api_policies:
            for _item_api_policies in self.api_policies:
                if _item_api_policies:
                    _items.append(_item_api_policies.to_dict())
            _dict['api_policies'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in api_collections (list)
        _items = []
        if self.api_collections:
            for _item_api_collections in self.api_collections:
                if _item_api_collections:
                    _items.append(_item_api_collections.to_dict())
            _dict['api_collections'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if logo (nullable) is None
        # and model_fields_set contains the field
        if self.logo is None and "logo" in self.model_fields_set:
            _dict['logo'] = None

        # set to None if logo_2x (nullable) is None
        # and model_fields_set contains the field
        if self.logo_2x is None and "logo_2x" in self.model_fields_set:
            _dict['logo_2x'] = None

        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if api_token (nullable) is None
        # and model_fields_set contains the field
        if self.api_token is None and "api_token" in self.model_fields_set:
            _dict['api_token'] = None

        # set to None if mtls_enabled (nullable) is None
        # and model_fields_set contains the field
        if self.mtls_enabled is None and "mtls_enabled" in self.model_fields_set:
            _dict['mtls_enabled'] = None

        # set to None if validation_formula (nullable) is None
        # and model_fields_set contains the field
        if self.validation_formula is None and "validation_formula" in self.model_fields_set:
            _dict['validation_formula'] = None

        # set to None if cert_bundle_ids (nullable) is None
        # and model_fields_set contains the field
        if self.cert_bundle_ids is None and "cert_bundle_ids" in self.model_fields_set:
            _dict['cert_bundle_ids'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiClient from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "active_api_keys_count": obj.get("active_api_keys_count"),
            "total_api_keys_count": obj.get("total_api_keys_count"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "logo": obj.get("logo"),
            "logo_2x": obj.get("logo_2x"),
            "is_legacy": obj.get("is_legacy"),
            "email": obj.get("email"),
            "auth_type": obj.get("auth_type"),
            "api_token": obj.get("api_token"),
            "mtls_enabled": obj.get("mtls_enabled"),
            "validation_formula": obj.get("validation_formula"),
            "cert_bundle_ids": obj.get("cert_bundle_ids"),
            "api_policies": [ApiClientApiPoliciesInner.from_dict(_item) for _item in obj["api_policies"]] if obj.get("api_policies") is not None else None,
            "api_collections": [ApiClientApiCollectionsInner.from_dict(_item) for _item in obj["api_collections"]] if obj.get("api_collections") is not None else None
        })
        return _obj


