# coding: utf-8

"""
    Workato Platform API

    Official Workato Platform API for managing recipes, connections, projects, and other automation resources.  ## Authentication All endpoints require a Bearer token in the Authorization header.  ## Base URL The base URL varies by region: - US: `https://www.workato.com` - EU: `https://app.eu.workato.com` - JP: `https://app.jp.workato.com` - SG: `https://app.sg.workato.com` - AU: `https://app.au.workato.com` - IL: `https://app.il.workato.com` - Trial: `https://app.trial.workato.com` 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AssetReference(BaseModel):
    """
    AssetReference
    """ # noqa: E501
    id: StrictInt = Field(description="ID of the dependency")
    type: StrictStr = Field(description="Type of dependent asset")
    checked: Optional[StrictBool] = Field(default=True, description="Determines if the asset is included in the manifest")
    version: Optional[StrictInt] = Field(default=None, description="The version of the asset")
    folder: Optional[StrictStr] = Field(default='', description="The folder that contains the asset")
    absolute_path: StrictStr = Field(description="The absolute path of the asset")
    root_folder: Optional[StrictBool] = Field(default=False, description="Name root folder")
    unreachable: Optional[StrictBool] = Field(default=False, description="Whether the asset is unreachable")
    zip_name: Optional[StrictStr] = Field(default=None, description="Name in the exported zip file")
    __properties: ClassVar[List[str]] = ["id", "type", "checked", "version", "folder", "absolute_path", "root_folder", "unreachable", "zip_name"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['recipe', 'connection', 'lookup_table', 'workato_db_table', 'account_property', 'project_property', 'workato_schema', 'workato_template', 'lcap_app', 'lcap_page', 'custom_adapter', 'topic', 'api_group', 'api_endpoint']):
            raise ValueError("must be one of enum values ('recipe', 'connection', 'lookup_table', 'workato_db_table', 'account_property', 'project_property', 'workato_schema', 'workato_template', 'lcap_app', 'lcap_page', 'custom_adapter', 'topic', 'api_group', 'api_endpoint')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AssetReference from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AssetReference from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "checked": obj.get("checked") if obj.get("checked") is not None else True,
            "version": obj.get("version"),
            "folder": obj.get("folder") if obj.get("folder") is not None else '',
            "absolute_path": obj.get("absolute_path"),
            "root_folder": obj.get("root_folder") if obj.get("root_folder") is not None else False,
            "unreachable": obj.get("unreachable") if obj.get("unreachable") is not None else False,
            "zip_name": obj.get("zip_name")
        })
        return _obj


