# coding: utf-8

"""
    Workato Platform API

    Official Workato Platform API for managing recipes, connections, projects, and other automation resources.  ## Authentication All endpoints require a Bearer token in the Authorization header.  ## Base URL The base URL varies by region: - US: `https://www.workato.com` - EU: `https://app.eu.workato.com` - JP: `https://app.jp.workato.com` - SG: `https://app.sg.workato.com` - AU: `https://app.au.workato.com` - IL: `https://app.il.workato.com` - Trial: `https://app.trial.workato.com` 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from workato_platform_cli.client.workato_api.models.connector_version import ConnectorVersion
from typing import Optional, Set
from typing_extensions import Self

class CustomConnector(BaseModel):
    """
    CustomConnector
    """ # noqa: E501
    id: StrictInt
    name: StrictStr
    title: StrictStr
    latest_released_version: StrictInt
    latest_released_version_note: Optional[StrictStr]
    released_versions: List[ConnectorVersion]
    static_webhook_url: Optional[StrictStr]
    __properties: ClassVar[List[str]] = ["id", "name", "title", "latest_released_version", "latest_released_version_note", "released_versions", "static_webhook_url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CustomConnector from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in released_versions (list)
        _items = []
        if self.released_versions:
            for _item_released_versions in self.released_versions:
                if _item_released_versions:
                    _items.append(_item_released_versions.to_dict())
            _dict['released_versions'] = _items
        # set to None if latest_released_version_note (nullable) is None
        # and model_fields_set contains the field
        if self.latest_released_version_note is None and "latest_released_version_note" in self.model_fields_set:
            _dict['latest_released_version_note'] = None

        # set to None if static_webhook_url (nullable) is None
        # and model_fields_set contains the field
        if self.static_webhook_url is None and "static_webhook_url" in self.model_fields_set:
            _dict['static_webhook_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CustomConnector from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "title": obj.get("title"),
            "latest_released_version": obj.get("latest_released_version"),
            "latest_released_version_note": obj.get("latest_released_version_note"),
            "released_versions": [ConnectorVersion.from_dict(_item) for _item in obj["released_versions"]] if obj.get("released_versions") is not None else None,
            "static_webhook_url": obj.get("static_webhook_url")
        })
        return _obj


