# coding: utf-8

"""
    Workato Platform API

    Official Workato Platform API for managing recipes, connections, projects, and other automation resources.  ## Authentication All endpoints require a Bearer token in the Authorization header.  ## Base URL The base URL varies by region: - US: `https://www.workato.com` - EU: `https://app.eu.workato.com` - JP: `https://app.jp.workato.com` - SG: `https://app.sg.workato.com` - AU: `https://app.au.workato.com` - IL: `https://app.il.workato.com` - Trial: `https://app.trial.workato.com` 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from workato_platform_cli.client.workato_api.models.recipe_config_inner import RecipeConfigInner
from typing import Optional, Set
from typing_extensions import Self

class Recipe(BaseModel):
    """
    Recipe
    """ # noqa: E501
    id: StrictInt
    user_id: StrictInt
    name: StrictStr
    created_at: datetime
    updated_at: datetime
    copy_count: StrictInt
    trigger_application: Optional[StrictStr] = None
    action_applications: List[StrictStr]
    applications: List[StrictStr]
    description: StrictStr
    parameters_schema: List[Any]
    parameters: Dict[str, Any]
    webhook_url: Optional[StrictStr]
    folder_id: StrictInt
    running: StrictBool
    job_succeeded_count: StrictInt
    job_failed_count: StrictInt
    lifetime_task_count: StrictInt
    last_run_at: Optional[datetime] = None
    stopped_at: Optional[datetime] = None
    version_no: StrictInt
    stop_cause: Optional[StrictStr]
    config: List[RecipeConfigInner]
    trigger_closure: Optional[Any]
    code: StrictStr = Field(description="Recipe code (may be truncated if exclude_code is true)")
    author_name: StrictStr
    version_author_name: StrictStr
    version_author_email: StrictStr
    version_comment: Optional[StrictStr]
    tags: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["id", "user_id", "name", "created_at", "updated_at", "copy_count", "trigger_application", "action_applications", "applications", "description", "parameters_schema", "parameters", "webhook_url", "folder_id", "running", "job_succeeded_count", "job_failed_count", "lifetime_task_count", "last_run_at", "stopped_at", "version_no", "stop_cause", "config", "trigger_closure", "code", "author_name", "version_author_name", "version_author_email", "version_comment", "tags"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Recipe from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in config (list)
        _items = []
        if self.config:
            for _item_config in self.config:
                if _item_config:
                    _items.append(_item_config.to_dict())
            _dict['config'] = _items
        # set to None if webhook_url (nullable) is None
        # and model_fields_set contains the field
        if self.webhook_url is None and "webhook_url" in self.model_fields_set:
            _dict['webhook_url'] = None

        # set to None if stop_cause (nullable) is None
        # and model_fields_set contains the field
        if self.stop_cause is None and "stop_cause" in self.model_fields_set:
            _dict['stop_cause'] = None

        # set to None if trigger_closure (nullable) is None
        # and model_fields_set contains the field
        if self.trigger_closure is None and "trigger_closure" in self.model_fields_set:
            _dict['trigger_closure'] = None

        # set to None if version_comment (nullable) is None
        # and model_fields_set contains the field
        if self.version_comment is None and "version_comment" in self.model_fields_set:
            _dict['version_comment'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Recipe from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "user_id": obj.get("user_id"),
            "name": obj.get("name"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "copy_count": obj.get("copy_count"),
            "trigger_application": obj.get("trigger_application"),
            "action_applications": obj.get("action_applications"),
            "applications": obj.get("applications"),
            "description": obj.get("description"),
            "parameters_schema": obj.get("parameters_schema"),
            "parameters": obj.get("parameters"),
            "webhook_url": obj.get("webhook_url"),
            "folder_id": obj.get("folder_id"),
            "running": obj.get("running"),
            "job_succeeded_count": obj.get("job_succeeded_count"),
            "job_failed_count": obj.get("job_failed_count"),
            "lifetime_task_count": obj.get("lifetime_task_count"),
            "last_run_at": obj.get("last_run_at"),
            "stopped_at": obj.get("stopped_at"),
            "version_no": obj.get("version_no"),
            "stop_cause": obj.get("stop_cause"),
            "config": [RecipeConfigInner.from_dict(_item) for _item in obj["config"]] if obj.get("config") is not None else None,
            "trigger_closure": obj.get("trigger_closure"),
            "code": obj.get("code"),
            "author_name": obj.get("author_name"),
            "version_author_name": obj.get("version_author_name"),
            "version_author_email": obj.get("version_author_email"),
            "version_comment": obj.get("version_comment"),
            "tags": obj.get("tags")
        })
        return _obj


