# workato-platform-cli
Official Workato Platform API for managing recipes, connections, projects, and other automation resources.  ## Authentication All endpoints require a Bearer token in the Authorization header.  ## Base URL The base URL varies by region: - US: `https://www.workato.com` - EU: `https://app.eu.workato.com` - JP: `https://app.jp.workato.com` - SG: `https://app.sg.workato.com` - AU: `https://app.au.workato.com` - IL: `https://app.il.workato.com` - Trial: `https://app.trial.workato.com` 

The `workato_platform_cli.client.workato_api` package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Generator version: 7.16.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://docs.workato.com](https://docs.workato.com)

## Requirements.

Python 3.9+

## Installation & Usage

This python library package is generated without supporting files like setup.py or requirements files

To be able to use it, you will need these dependencies in your own package that uses this library:

* urllib3 >= 2.1.0, < 3.0.0
* python-dateutil >= 2.8.2
* aiohttp >= 3.8.4
* aiohttp-retry >= 2.8.3
* pydantic >= 2
* typing-extensions >= 4.7.1

## Getting Started

In your own code, to use this library to connect and interact with workato-platform-cli,
you can run the following:

```python

import workato_platform_cli.client.workato_api
from workato_platform_cli.client.workato_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://www.workato.com
# See configuration.py for a list of all supported configuration parameters.
configuration = workato_platform_cli.client.workato_api.Configuration(
    host = "https://www.workato.com"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: BearerAuth
configuration = workato_platform_cli.client.workato_api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
async with workato_platform_cli.client.workato_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = workato_platform_cli.client.workato_api.APIPlatformApi(api_client)
    api_client_create_request = workato_platform_cli.client.workato_api.ApiClientCreateRequest() # ApiClientCreateRequest | 

    try:
        # Create API client (v2)
        api_response = await api_instance.create_api_client(api_client_create_request)
        print("The response of APIPlatformApi->create_api_client:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling APIPlatformApi->create_api_client: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://www.workato.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APIPlatformApi* | [**create_api_client**](workato_platform_cli/client/workato_api/docs/APIPlatformApi.md#create_api_client) | **POST** /api/v2/api_clients | Create API client (v2)
*APIPlatformApi* | [**create_api_collection**](workato_platform_cli/client/workato_api/docs/APIPlatformApi.md#create_api_collection) | **POST** /api/api_collections | Create API collection
*APIPlatformApi* | [**create_api_key**](workato_platform_cli/client/workato_api/docs/APIPlatformApi.md#create_api_key) | **POST** /api/v2/api_clients/{api_client_id}/api_keys | Create an API key
*APIPlatformApi* | [**disable_api_endpoint**](workato_platform_cli/client/workato_api/docs/APIPlatformApi.md#disable_api_endpoint) | **PUT** /api/api_endpoints/{api_endpoint_id}/disable | Disable an API endpoint
*APIPlatformApi* | [**enable_api_endpoint**](workato_platform_cli/client/workato_api/docs/APIPlatformApi.md#enable_api_endpoint) | **PUT** /api/api_endpoints/{api_endpoint_id}/enable | Enable an API endpoint
*APIPlatformApi* | [**list_api_clients**](workato_platform_cli/client/workato_api/docs/APIPlatformApi.md#list_api_clients) | **GET** /api/v2/api_clients | List API clients (v2)
*APIPlatformApi* | [**list_api_collections**](workato_platform_cli/client/workato_api/docs/APIPlatformApi.md#list_api_collections) | **GET** /api/api_collections | List API collections
*APIPlatformApi* | [**list_api_endpoints**](workato_platform_cli/client/workato_api/docs/APIPlatformApi.md#list_api_endpoints) | **GET** /api/api_endpoints | List API endpoints
*APIPlatformApi* | [**list_api_keys**](workato_platform_cli/client/workato_api/docs/APIPlatformApi.md#list_api_keys) | **GET** /api/v2/api_clients/{api_client_id}/api_keys | List API keys
*APIPlatformApi* | [**refresh_api_key_secret**](workato_platform_cli/client/workato_api/docs/APIPlatformApi.md#refresh_api_key_secret) | **PUT** /api/v2/api_clients/{api_client_id}/api_keys/{api_key_id}/refresh_secret | Refresh API key secret
*ConnectionsApi* | [**create_connection**](workato_platform_cli/client/workato_api/docs/ConnectionsApi.md#create_connection) | **POST** /api/connections | Create a connection
*ConnectionsApi* | [**create_runtime_user_connection**](workato_platform_cli/client/workato_api/docs/ConnectionsApi.md#create_runtime_user_connection) | **POST** /api/connections/runtime_user_connections | Create OAuth runtime user connection
*ConnectionsApi* | [**get_connection_oauth_url**](workato_platform_cli/client/workato_api/docs/ConnectionsApi.md#get_connection_oauth_url) | **GET** /api/connections/runtime_user_connections/{connection_id}/get_oauth_url | Get OAuth URL for connection
*ConnectionsApi* | [**get_connection_picklist**](workato_platform_cli/client/workato_api/docs/ConnectionsApi.md#get_connection_picklist) | **POST** /api/connections/{connection_id}/pick_list | Get picklist values
*ConnectionsApi* | [**list_connections**](workato_platform_cli/client/workato_api/docs/ConnectionsApi.md#list_connections) | **GET** /api/connections | List connections
*ConnectionsApi* | [**update_connection**](workato_platform_cli/client/workato_api/docs/ConnectionsApi.md#update_connection) | **PUT** /api/connections/{connection_id} | Update a connection
*ConnectorsApi* | [**get_custom_connector_code**](workato_platform_cli/client/workato_api/docs/ConnectorsApi.md#get_custom_connector_code) | **GET** /api/custom_connectors/{id}/code | Get custom connector code
*ConnectorsApi* | [**list_custom_connectors**](workato_platform_cli/client/workato_api/docs/ConnectorsApi.md#list_custom_connectors) | **GET** /api/custom_connectors | List custom connectors
*ConnectorsApi* | [**list_platform_connectors**](workato_platform_cli/client/workato_api/docs/ConnectorsApi.md#list_platform_connectors) | **GET** /api/integrations/all | List platform connectors
*DataTablesApi* | [**create_data_table**](workato_platform_cli/client/workato_api/docs/DataTablesApi.md#create_data_table) | **POST** /api/data_tables | Create data table
*DataTablesApi* | [**list_data_tables**](workato_platform_cli/client/workato_api/docs/DataTablesApi.md#list_data_tables) | **GET** /api/data_tables | List data tables
*ExportApi* | [**create_export_manifest**](workato_platform_cli/client/workato_api/docs/ExportApi.md#create_export_manifest) | **POST** /api/export_manifests | Create an export manifest
*ExportApi* | [**list_assets_in_folder**](workato_platform_cli/client/workato_api/docs/ExportApi.md#list_assets_in_folder) | **GET** /api/export_manifests/folder_assets | View assets in a folder
*FoldersApi* | [**create_folder**](workato_platform_cli/client/workato_api/docs/FoldersApi.md#create_folder) | **POST** /api/folders | Create a folder
*FoldersApi* | [**list_folders**](workato_platform_cli/client/workato_api/docs/FoldersApi.md#list_folders) | **GET** /api/folders | List folders
*PackagesApi* | [**download_package**](workato_platform_cli/client/workato_api/docs/PackagesApi.md#download_package) | **GET** /api/packages/{package_id}/download | Download package
*PackagesApi* | [**export_package**](workato_platform_cli/client/workato_api/docs/PackagesApi.md#export_package) | **POST** /api/packages/export/{id} | Export a package based on a manifest
*PackagesApi* | [**get_package**](workato_platform_cli/client/workato_api/docs/PackagesApi.md#get_package) | **GET** /api/packages/{package_id} | Get package details
*PackagesApi* | [**import_package**](workato_platform_cli/client/workato_api/docs/PackagesApi.md#import_package) | **POST** /api/packages/import/{id} | Import a package into a folder
*ProjectsApi* | [**delete_project**](workato_platform_cli/client/workato_api/docs/ProjectsApi.md#delete_project) | **DELETE** /api/projects/{project_id} | Delete a project
*ProjectsApi* | [**list_projects**](workato_platform_cli/client/workato_api/docs/ProjectsApi.md#list_projects) | **GET** /api/projects | List projects
*PropertiesApi* | [**list_project_properties**](workato_platform_cli/client/workato_api/docs/PropertiesApi.md#list_project_properties) | **GET** /api/properties | List project properties
*PropertiesApi* | [**upsert_project_properties**](workato_platform_cli/client/workato_api/docs/PropertiesApi.md#upsert_project_properties) | **POST** /api/properties | Upsert project properties
*RecipesApi* | [**list_recipes**](workato_platform_cli/client/workato_api/docs/RecipesApi.md#list_recipes) | **GET** /api/recipes | List recipes
*RecipesApi* | [**start_recipe**](workato_platform_cli/client/workato_api/docs/RecipesApi.md#start_recipe) | **PUT** /api/recipes/{recipe_id}/start | Start a recipe
*RecipesApi* | [**stop_recipe**](workato_platform_cli/client/workato_api/docs/RecipesApi.md#stop_recipe) | **PUT** /api/recipes/{recipe_id}/stop | Stop a recipe
*RecipesApi* | [**update_recipe_connection**](workato_platform_cli/client/workato_api/docs/RecipesApi.md#update_recipe_connection) | **PUT** /api/recipes/{recipe_id}/connect | Update a connection for a recipe
*UsersApi* | [**get_workspace_details**](workato_platform_cli/client/workato_api/docs/UsersApi.md#get_workspace_details) | **GET** /api/users/me | Get current user information


## Documentation For Models

 - [ApiClient](workato_platform_cli/client/workato_api/docs/ApiClient.md)
 - [ApiClientApiCollectionsInner](workato_platform_cli/client/workato_api/docs/ApiClientApiCollectionsInner.md)
 - [ApiClientApiPoliciesInner](workato_platform_cli/client/workato_api/docs/ApiClientApiPoliciesInner.md)
 - [ApiClientCreateRequest](workato_platform_cli/client/workato_api/docs/ApiClientCreateRequest.md)
 - [ApiClientListResponse](workato_platform_cli/client/workato_api/docs/ApiClientListResponse.md)
 - [ApiClientResponse](workato_platform_cli/client/workato_api/docs/ApiClientResponse.md)
 - [ApiCollection](workato_platform_cli/client/workato_api/docs/ApiCollection.md)
 - [ApiCollectionCreateRequest](workato_platform_cli/client/workato_api/docs/ApiCollectionCreateRequest.md)
 - [ApiEndpoint](workato_platform_cli/client/workato_api/docs/ApiEndpoint.md)
 - [ApiKey](workato_platform_cli/client/workato_api/docs/ApiKey.md)
 - [ApiKeyCreateRequest](workato_platform_cli/client/workato_api/docs/ApiKeyCreateRequest.md)
 - [ApiKeyListResponse](workato_platform_cli/client/workato_api/docs/ApiKeyListResponse.md)
 - [ApiKeyResponse](workato_platform_cli/client/workato_api/docs/ApiKeyResponse.md)
 - [Asset](workato_platform_cli/client/workato_api/docs/Asset.md)
 - [AssetReference](workato_platform_cli/client/workato_api/docs/AssetReference.md)
 - [Connection](workato_platform_cli/client/workato_api/docs/Connection.md)
 - [ConnectionCreateRequest](workato_platform_cli/client/workato_api/docs/ConnectionCreateRequest.md)
 - [ConnectionUpdateRequest](workato_platform_cli/client/workato_api/docs/ConnectionUpdateRequest.md)
 - [ConnectorAction](workato_platform_cli/client/workato_api/docs/ConnectorAction.md)
 - [ConnectorVersion](workato_platform_cli/client/workato_api/docs/ConnectorVersion.md)
 - [CreateExportManifestRequest](workato_platform_cli/client/workato_api/docs/CreateExportManifestRequest.md)
 - [CreateFolderRequest](workato_platform_cli/client/workato_api/docs/CreateFolderRequest.md)
 - [CustomConnector](workato_platform_cli/client/workato_api/docs/CustomConnector.md)
 - [CustomConnectorCodeResponse](workato_platform_cli/client/workato_api/docs/CustomConnectorCodeResponse.md)
 - [CustomConnectorCodeResponseData](workato_platform_cli/client/workato_api/docs/CustomConnectorCodeResponseData.md)
 - [CustomConnectorListResponse](workato_platform_cli/client/workato_api/docs/CustomConnectorListResponse.md)
 - [DataTable](workato_platform_cli/client/workato_api/docs/DataTable.md)
 - [DataTableColumn](workato_platform_cli/client/workato_api/docs/DataTableColumn.md)
 - [DataTableColumnRequest](workato_platform_cli/client/workato_api/docs/DataTableColumnRequest.md)
 - [DataTableCreateRequest](workato_platform_cli/client/workato_api/docs/DataTableCreateRequest.md)
 - [DataTableCreateResponse](workato_platform_cli/client/workato_api/docs/DataTableCreateResponse.md)
 - [DataTableListResponse](workato_platform_cli/client/workato_api/docs/DataTableListResponse.md)
 - [DataTableRelation](workato_platform_cli/client/workato_api/docs/DataTableRelation.md)
 - [DeleteProject403Response](workato_platform_cli/client/workato_api/docs/DeleteProject403Response.md)
 - [Error](workato_platform_cli/client/workato_api/docs/Error.md)
 - [ExportManifestRequest](workato_platform_cli/client/workato_api/docs/ExportManifestRequest.md)
 - [ExportManifestResponse](workato_platform_cli/client/workato_api/docs/ExportManifestResponse.md)
 - [ExportManifestResponseResult](workato_platform_cli/client/workato_api/docs/ExportManifestResponseResult.md)
 - [Folder](workato_platform_cli/client/workato_api/docs/Folder.md)
 - [FolderAssetsResponse](workato_platform_cli/client/workato_api/docs/FolderAssetsResponse.md)
 - [FolderAssetsResponseResult](workato_platform_cli/client/workato_api/docs/FolderAssetsResponseResult.md)
 - [FolderCreationResponse](workato_platform_cli/client/workato_api/docs/FolderCreationResponse.md)
 - [ImportResults](workato_platform_cli/client/workato_api/docs/ImportResults.md)
 - [OAuthUrlResponse](workato_platform_cli/client/workato_api/docs/OAuthUrlResponse.md)
 - [OAuthUrlResponseData](workato_platform_cli/client/workato_api/docs/OAuthUrlResponseData.md)
 - [OpenApiSpec](workato_platform_cli/client/workato_api/docs/OpenApiSpec.md)
 - [PackageDetailsResponse](workato_platform_cli/client/workato_api/docs/PackageDetailsResponse.md)
 - [PackageDetailsResponseRecipeStatusInner](workato_platform_cli/client/workato_api/docs/PackageDetailsResponseRecipeStatusInner.md)
 - [PackageResponse](workato_platform_cli/client/workato_api/docs/PackageResponse.md)
 - [PicklistRequest](workato_platform_cli/client/workato_api/docs/PicklistRequest.md)
 - [PicklistResponse](workato_platform_cli/client/workato_api/docs/PicklistResponse.md)
 - [PlatformConnector](workato_platform_cli/client/workato_api/docs/PlatformConnector.md)
 - [PlatformConnectorListResponse](workato_platform_cli/client/workato_api/docs/PlatformConnectorListResponse.md)
 - [Project](workato_platform_cli/client/workato_api/docs/Project.md)
 - [Recipe](workato_platform_cli/client/workato_api/docs/Recipe.md)
 - [RecipeConfigInner](workato_platform_cli/client/workato_api/docs/RecipeConfigInner.md)
 - [RecipeConnectionUpdateRequest](workato_platform_cli/client/workato_api/docs/RecipeConnectionUpdateRequest.md)
 - [RecipeListResponse](workato_platform_cli/client/workato_api/docs/RecipeListResponse.md)
 - [RecipeStartResponse](workato_platform_cli/client/workato_api/docs/RecipeStartResponse.md)
 - [RuntimeUserConnectionCreateRequest](workato_platform_cli/client/workato_api/docs/RuntimeUserConnectionCreateRequest.md)
 - [RuntimeUserConnectionResponse](workato_platform_cli/client/workato_api/docs/RuntimeUserConnectionResponse.md)
 - [RuntimeUserConnectionResponseData](workato_platform_cli/client/workato_api/docs/RuntimeUserConnectionResponseData.md)
 - [SuccessResponse](workato_platform_cli/client/workato_api/docs/SuccessResponse.md)
 - [UpsertProjectPropertiesRequest](workato_platform_cli/client/workato_api/docs/UpsertProjectPropertiesRequest.md)
 - [User](workato_platform_cli/client/workato_api/docs/User.md)
 - [ValidationError](workato_platform_cli/client/workato_api/docs/ValidationError.md)
 - [ValidationErrorErrorsValue](workato_platform_cli/client/workato_api/docs/ValidationErrorErrorsValue.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="BearerAuth"></a>
### BearerAuth

- **Type**: Bearer authentication


## Author




