"""collection type not nullable

Revision ID: b74cd7a31b69
Revises: ace6189b4a68
Create Date: 2021-04-21 15:40:24.263298

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "b74cd7a31b69"
down_revision = "ace6189b4a68"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###

    # All collection_types that were null should now be 'collection'
    # until this is changed later
    op.execute("UPDATE collection SET collection_type='collection' WHERE collection_type is null")

    op.alter_column("collection", "collection_type", existing_type=sa.VARCHAR(), nullable=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column("collection", "collection_type", existing_type=sa.VARCHAR(), nullable=True)

    op.execute("UPDATE collection SET collection_type=null WHERE collection_type = 'collection'")
    # ### end Alembic commands ###
