"""migrate molecule table

Revision ID: fd76a1459fa3
Revises: 2a334994fcb3
Create Date: 2021-10-12 10:31:53.993770

"""

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "fd76a1459fa3"
down_revision = "2a334994fcb3"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "molecule", "molecule_hash", existing_type=sa.VARCHAR(), type_=sa.CHAR(length=40), existing_nullable=True
    )
    op.alter_column(
        "molecule",
        "identifiers",
        existing_type=postgresql.JSON(astext_type=sa.Text()),
        type_=postgresql.JSONB(astext_type=sa.Text()),
        existing_nullable=True,
    )

    op.alter_column("molecule", "fix_com", existing_type=sa.BOOLEAN(), nullable=False)
    op.alter_column("molecule", "fix_orientation", existing_type=sa.BOOLEAN(), nullable=False)

    op.create_index("ix_molecule_identifiers", "molecule", ["identifiers"], unique=False, postgresql_using="gin")
    op.drop_column("molecule", "molecular_formula")
    # ### end Alembic commands ###


def downgrade():
    raise RuntimeError("Cannot downgrade")
