"""migrate keywords constraints

Revision ID: d36e2ec09f27
Revises: 651954cbdec6
Create Date: 2021-11-03 12:05:20.152697

"""

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = "d36e2ec09f27"
down_revision = "651954cbdec6"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_keywords_hash_index", table_name="keywords")
    op.create_unique_constraint("ux_keywords_hash_index", "keywords", ["hash_index"])

    op.alter_column("keywords", "values", existing_type=postgresql.JSON(astext_type=sa.Text()), nullable=False)
    op.alter_column("keywords", "lowercase", existing_type=sa.BOOLEAN(), nullable=False)
    op.alter_column("keywords", "exact_floats", existing_type=sa.BOOLEAN(), nullable=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column("keywords", "exact_floats", existing_type=sa.BOOLEAN(), nullable=True)
    op.alter_column("keywords", "lowercase", existing_type=sa.BOOLEAN(), nullable=True)
    op.alter_column("keywords", "values", existing_type=postgresql.JSON(astext_type=sa.Text()), nullable=True)
    op.drop_constraint("ux_keywords_hash_index", "keywords", type_="unique")
    op.create_index("ix_keywords_hash_index", "keywords", ["hash_index"], unique=False)
    # ### end Alembic commands ###
