"""add record info backup table

Revision ID: 7fb1093c30ca
Revises: cdd9f3dc10e3
Create Date: 2021-12-11 09:14:04.907844

"""

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = "7fb1093c30ca"
down_revision = "cdd9f3dc10e3"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    status_enum = postgresql.ENUM(
        "complete",
        "waiting",
        "running",
        "error",
        "cancelled",
        "deleted",
        "invalid",
        name="recordstatusenum",
        create_type=False,
    )

    op.create_table(
        "record_info_backup",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("record_id", sa.Integer(), nullable=False),
        sa.Column("old_status", status_enum, nullable=False),
        sa.Column("old_tag", sa.String(), nullable=True),
        sa.Column("old_priority", sa.Integer(), nullable=True),
        sa.Column("modified_on", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(["record_id"], ["base_record.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("record_info_backup")
    # ### end Alembic commands ###
