"""Fix pkey on alembic_version

Revision ID: 92ace6197b01
Revises: 6137120ef60f
Create Date: 2022-03-08 10:27:22.538234

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "92ace6197b01"
down_revision = "6137120ef60f"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute("ALTER TABLE alembic_version DROP CONSTRAINT IF EXISTS alembic_version_pkey")
    op.execute("ALTER TABLE alembic_version DROP CONSTRAINT IF EXISTS alembic_version_pkc")
    op.execute("DROP INDEX IF EXISTS alembic_version_pkey")
    op.execute("DROP INDEX IF EXISTS alembic_version_pkc")

    op.execute("CREATE UNIQUE INDEX alembic_version_pkc ON alembic_version USING btree (version_num)")
    op.execute(
        "ALTER TABLE alembic_version ADD CONSTRAINT alembic_version_pkc PRIMARY KEY USING INDEX alembic_version_pkc"
    )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    raise RuntimeError("Cannot downgrade")
    # ### end Alembic commands ###
