"""make_reaction_service_flexible

Revision ID: c3cbccb2d572
Revises: f26c30450fdd
Create Date: 2022-05-12 14:56:15.632423

"""

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "c3cbccb2d572"
down_revision = "f26c30450fdd"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    ####################################################
    # Safe to assume we don't have anything to migrate
    # (since this is happening between major versions,
    #  and the previous version didn't have reactions)
    ####################################################

    op.create_table(
        "reaction_specification",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("program", sa.String(), nullable=False),
        sa.Column("singlepoint_specification_id", sa.Integer(), nullable=True),
        sa.Column("optimization_specification_id", sa.Integer(), nullable=True),
        sa.Column("keywords", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.CheckConstraint("program = LOWER(program)", name="ck_reaction_specification_program_lower"),
        sa.CheckConstraint(
            "singlepoint_specification_id IS NOT NULL OR optimization_specification_id IS NOT NULL",
            name="ck_reaction_specification_specs",
        ),
        sa.ForeignKeyConstraint(
            ["optimization_specification_id"],
            ["optimization_specification.id"],
        ),
        sa.ForeignKeyConstraint(
            ["singlepoint_specification_id"],
            ["qc_specification.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint(
            "singlepoint_specification_id",
            "optimization_specification_id",
            "keywords",
            name="ux_reaction_specification_keys",
        ),
    )
    op.create_index("ix_reaction_specification_keywords", "reaction_specification", ["keywords"], unique=False)
    op.create_index(
        "ix_reaction_specification_optimization_specification_id",
        "reaction_specification",
        ["optimization_specification_id"],
        unique=False,
    )
    op.create_index("ix_reaction_specification_program", "reaction_specification", ["program"], unique=False)
    op.create_index(
        "ix_reaction_specification_singlepoint_specification_id",
        "reaction_specification",
        ["singlepoint_specification_id"],
        unique=False,
    )
    op.add_column("reaction_component", sa.Column("coefficient", postgresql.DOUBLE_PRECISION(), nullable=False))
    op.add_column("reaction_component", sa.Column("optimization_id", sa.Integer(), nullable=True))
    op.alter_column("reaction_component", "singlepoint_id", existing_type=sa.INTEGER(), nullable=True)
    op.create_index("ix_reaction_component_optimization_id", "reaction_component", ["optimization_id"], unique=False)
    op.create_index("ix_reaction_component_singlepoint_id", "reaction_component", ["singlepoint_id"], unique=False)
    op.drop_constraint("reaction_component_reaction_id_molecule_id_fkey", "reaction_component", type_="foreignkey")
    op.create_foreign_key(None, "reaction_component", "optimization_record", ["optimization_id"], ["id"])
    op.drop_constraint("reaction_record_specification_id_fkey", "reaction_record", type_="foreignkey")
    op.create_foreign_key(None, "reaction_record", "reaction_specification", ["specification_id"], ["id"])
    op.drop_table("reaction_stoichiometry")
    # ### end Alembic commands ###


def downgrade():
    raise RuntimeError("Cannot downgrade")
