"""Add groups to users

Revision ID: 148fef89c2ec
Revises: 6128f0430433
Create Date: 2022-09-26 10:23:26.632594

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "148fef89c2ec"
down_revision = "6128f0430433"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "group",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("groupname", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("groupname", name="ux_group_groupname"),
    )
    op.create_table(
        "user_groups",
        sa.Column("user_id", sa.Integer(), nullable=False),
        sa.Column("group_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["group_id"],
            ["group.id"],
            ondelete="cascade",
        ),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user.id"],
            ondelete="cascade",
        ),
        sa.PrimaryKeyConstraint("user_id", "group_id"),
    )

    op.add_column("base_record", sa.Column("owner_user_id", sa.Integer(), nullable=True))
    op.add_column("base_record", sa.Column("owner_group_id", sa.Integer(), nullable=True))
    op.create_index("ix_base_record_owner_user_id", "base_record", ["owner_user_id"], unique=False)
    op.create_index("ix_base_record_owner_group_id", "base_record", ["owner_group_id"], unique=False)
    op.create_foreign_key(None, "base_record", "user", ["owner_user_id"], ["id"])
    op.create_foreign_key(None, "base_record", "group", ["owner_group_id"], ["id"])
    op.create_foreign_key(
        None, "base_record", "user_groups", ["owner_user_id", "owner_group_id"], ["user_id", "group_id"]
    )

    op.add_column("base_dataset", sa.Column("owner_user_id", sa.Integer(), nullable=True))
    op.add_column("base_dataset", sa.Column("owner_group_id", sa.Integer(), nullable=True))
    op.create_index("ix_base_dataset_owner_group_id", "base_dataset", ["owner_group_id"], unique=False)
    op.create_index("ix_base_dataset_owner_user_id", "base_dataset", ["owner_user_id"], unique=False)
    op.create_foreign_key(None, "base_dataset", "user", ["owner_user_id"], ["id"])
    op.create_foreign_key(None, "base_dataset", "group", ["owner_group_id"], ["id"])
    op.create_foreign_key(
        None, "base_dataset", "user_groups", ["owner_user_id", "owner_group_id"], ["user_id", "group_id"]
    )

    op.add_column("record_comment", sa.Column("user_id", sa.Integer(), nullable=True))
    op.create_foreign_key(None, "record_comment", "user", ["user_id"], ["id"])

    op.add_column("internal_jobs", sa.Column("user_id", sa.Integer(), nullable=True))
    op.create_index("ix_internal_jobs_user_id", "internal_jobs", ["user_id"], unique=False)
    op.create_foreign_key(None, "internal_jobs", "user", ["user_id"], ["id"], ondelete="cascade")

    op.add_column("access_log", sa.Column("user_id", sa.Integer(), nullable=True))
    op.create_index("ix_access_log_user_id", "access_log", ["user_id"], unique=False)
    op.create_foreign_key(None, "access_log", "user", ["user_id"], ["id"])

    op.add_column("internal_error_log", sa.Column("user_id", sa.Integer(), nullable=True))
    op.create_index("ix_internal_error_log_user_id", "internal_error_log", ["user_id"], unique=False)
    op.create_foreign_key(None, "internal_error_log", "user", ["user_id"], ["id"])

    op.execute(
        sa.text(
            """
        UPDATE access_log
        SET user_id = u.id
        FROM "user" as u
        WHERE user = u.username;
    """
        )
    )

    op.execute(
        sa.text(
            """
        UPDATE internal_error_log
        SET user_id = u.id
        FROM "user" as u
        WHERE user = u.username;
    """
        )
    )

    op.execute(
        sa.text(
            """
        UPDATE record_comment
        SET user_id = u.id
        FROM "user" as u
        WHERE record_comment.username = u.username;
    """
        )
    )

    op.drop_column("access_log", "user")
    op.drop_column("internal_error_log", "user")
    op.drop_column("internal_jobs", "user")
    op.drop_column("record_comment", "username")

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    raise RuntimeError("Cannot downgrade")
    # ### end Alembic commands ###
