"""Add additional_singlepoint_keywords to neb dataset

Revision ID: 3cc95f9dc02c
Revises: 981f69781d65
Create Date: 2022-10-20 11:13:52.166018

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "3cc95f9dc02c"
down_revision = "981f69781d65"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "neb_dataset_entry",
        sa.Column("additional_singlepoint_keywords", postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    )

    op.execute(sa.text("UPDATE neb_dataset_entry SET additional_singlepoint_keywords = '{}'::jsonb"))

    op.alter_column("neb_dataset_entry", "additional_singlepoint_keywords", nullable=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("neb_dataset_entry", "additional_singlepoint_keywords")
    # ### end Alembic commands ###
