"""Some columns not nullable in access log

Revision ID: 84e421577a1a
Revises: e645774b4c62
Create Date: 2023-03-17 13:15:51.493867

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "84e421577a1a"
down_revision = "e645774b4c62"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###

    op.execute(sa.text("UPDATE access_log SET request_duration = 0.0 WHERE request_duration IS NULL"))
    op.execute(sa.text("UPDATE access_log SET request_bytes = 0.0 WHERE request_bytes IS NULL"))
    op.execute(sa.text("UPDATE access_log SET response_bytes = 0.0 WHERE response_bytes IS NULL"))

    op.alter_column("access_log", "request_duration", existing_type=sa.DOUBLE_PRECISION(precision=53), nullable=False)
    op.alter_column("access_log", "request_bytes", existing_type=sa.BIGINT(), nullable=False)
    op.alter_column("access_log", "response_bytes", existing_type=sa.BIGINT(), nullable=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column("access_log", "response_bytes", existing_type=sa.BIGINT(), nullable=True)
    op.alter_column("access_log", "request_bytes", existing_type=sa.BIGINT(), nullable=True)
    op.alter_column("access_log", "request_duration", existing_type=sa.DOUBLE_PRECISION(precision=53), nullable=True)
    # ### end Alembic commands ###
