"""move geolocation

Revision ID: f9d784e816d2
Revises: 698131e6ffd5
Create Date: 2023-05-16 08:41:51.101634

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "f9d784e816d2"
down_revision = "698131e6ffd5"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "server_stats_metadata",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("date_value", sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )

    # Reset internal jobs - will be recreated on server startup
    op.execute(sa.text("DELETE FROM internal_jobs WHERE status IN ('running', 'waiting')"))

    op.execute(
        sa.text(
            """INSERT INTO server_stats_metadata (name, date_value)
                          VALUES ('last_geolocated_date', now() AT TIME ZONE 'utc')
                     """
        )
    )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("server_stats_metadata")
    # ### end Alembic commands ###
