"""add module to access log and remove access_type

Revision ID: b03545e6292a
Revises: 1638db43303c
Create Date: 2023-06-14 09:16:54.987767

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "b03545e6292a"
down_revision = "1638db43303c"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("access_log", sa.Column("module", sa.String(), nullable=True))
    op.create_index("ix_access_log_module", "access_log", ["module"], unique=False)

    op.execute(sa.text("UPDATE access_log SET module = 'compute' WHERE access_type LIKE '%api/v1/tasks%'"))
    op.execute(sa.text("UPDATE access_log SET module = 'auth' WHERE access_type LIKE '%auth/v1/tasks%'"))
    op.execute(sa.text("UPDATE access_log SET module = 'dashboard' WHERE access_type LIKE '%dashboard/v1%'"))
    op.execute(sa.text("UPDATE access_log SET module = 'old' WHERE access_type IS NULL"))
    op.drop_column("access_log", "access_type")
    op.alter_column("access_log", "access_date", new_column_name="timestamp")
    op.alter_column("access_log", "access_method", new_column_name="method")
    op.execute(sa.text("ALTER INDEX ix_access_log_access_date RENAME TO ix_access_log_timestamp"))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("access_log", sa.Column("access_type", sa.VARCHAR(), autoincrement=False, nullable=False))
    op.drop_index("ix_access_log_module", table_name="access_log")
    op.drop_column("access_log", "module")
    op.alter_column("access_log", "timestamp", new_column_name="access_date")
    op.alter_column("access_log", "method", new_column_name="access_method")
    op.execute(sa.text("ALTER INDEX ix_access_log_timestamp RENAME TO ix_access_log_access_date"))
    # ### end Alembic commands ###
