"""Add trigger for internal jobs notification

Revision ID: 1abf80db6c19
Revises: 64cae90ab9fe
Create Date: 2023-06-29 17:42:51.293964

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "1abf80db6c19"
down_revision = "64cae90ab9fe"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute(
        sa.text(
            """
    CREATE OR REPLACE FUNCTION public.qca_internal_jobs_notify()
    RETURNS trigger
    LANGUAGE plpgsql
    AS $function$
        BEGIN
          PERFORM pg_notify('check_internal_jobs', '');
          RETURN NEW;
        END
        $function$
    ;
        """
        )
    )

    op.execute(
        sa.text(
            "CREATE TRIGGER qca_internal_jobs_insert_tr AFTER INSERT ON public.internal_jobs FOR EACH ROW EXECUTE FUNCTION qca_internal_jobs_notify();"
        )
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute(sa.text("DROP TRIGGER qca_internal_jobs_insert_tr ON public.internal_jobs;"))
    op.execute(sa.text("DROP FUNCTION public.qca_internal_jobs_notify();"))
    # ### end Alembic commands ###
