"""Use computed column for dataset lname

Revision ID: 13cb230def11
Revises: d1ee87a66b71
Create Date: 2023-09-14 18:50:20.067940

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "13cb230def11"
down_revision = "d1ee87a66b71"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute(sa.text("ALTER TABLE base_dataset DROP COLUMN lname;"))
    op.execute(
        sa.text(
            "ALTER TABLE base_dataset ADD COLUMN lname CHARACTER VARYING(100) NOT NULL GENERATED ALWAYS AS (lower((name)::text)) stored;"
        )
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute(sa.text("ALTER TABLE base_dataset DROP COLUMN lname;"))
    op.execute(sa.text("ALTER TABLE base_dataset ADD COLUMN lname CHARACTER VARYING(100)"))
    op.execute(sa.text("UPDATE base_dataset SET lname = lower(name)"))
    op.alter_column("base_dataset", "lname", nullable=False)
    op.create_unique_constraint("ux_base_dataset_dataset_type_lname", "base_dataset", ["dataset_type", "lname"])

    # ### end Alembic commands ###
