"""remove explicit fix_ columns in molecule

Revision ID: 49cfda6eb87e
Revises: de44b1b34097
Create Date: 2024-01-06 19:18:04.534992

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "49cfda6eb87e"
down_revision = "de44b1b34097"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("molecule", "fix_orientation")
    op.drop_column("molecule", "fix_com")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("molecule", sa.Column("fix_com", sa.BOOLEAN(), autoincrement=False, nullable=True))
    op.add_column("molecule", sa.Column("fix_orientation", sa.BOOLEAN(), autoincrement=False, nullable=True))
    op.execute(sa.text("UPDATE molecule SET fix_com = True, fix_orientation = True"))
    op.alter_column("molecule", "fix_com", nullable=False)
    op.alter_column("molecule", "fix_orientation", nullable=False)
    # ### end Alembic commands ###
