"""Remove server stats log

Revision ID: 73b4838a6839
Revises: 75b80763e901
Create Date: 2024-05-06 10:54:44.383709

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "73b4838a6839"
down_revision = "75b80763e901"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_server_stats_log_timestamp", table_name="server_stats_log", postgresql_using="brin")
    op.drop_table("server_stats_log")

    op.execute("DELETE FROM internal_jobs WHERE name = 'update_server_stats'")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "server_stats_log",
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column("timestamp", postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=False),
        sa.Column("collection_count", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("molecule_count", sa.BIGINT(), autoincrement=False, nullable=True),
        sa.Column("record_count", sa.BIGINT(), autoincrement=False, nullable=True),
        sa.Column("outputstore_count", sa.BIGINT(), autoincrement=False, nullable=True),
        sa.Column("access_count", sa.BIGINT(), autoincrement=False, nullable=True),
        sa.Column("db_total_size", sa.BIGINT(), autoincrement=False, nullable=True),
        sa.Column("db_table_size", sa.BIGINT(), autoincrement=False, nullable=True),
        sa.Column("db_index_size", sa.BIGINT(), autoincrement=False, nullable=True),
        sa.Column("db_table_information", postgresql.JSON(astext_type=sa.Text()), autoincrement=False, nullable=True),
        sa.Column("error_count", sa.BIGINT(), autoincrement=False, nullable=True),
        sa.Column("service_queue_status", postgresql.JSON(astext_type=sa.Text()), autoincrement=False, nullable=True),
        sa.Column("task_queue_status", postgresql.JSON(astext_type=sa.Text()), autoincrement=False, nullable=True),
        sa.PrimaryKeyConstraint("id", name="server_stats_log_pkey"),
    )
    op.create_index(
        "ix_server_stats_log_timestamp", "server_stats_log", ["timestamp"], unique=False, postgresql_using="brin"
    )
    # ### end Alembic commands ###
