"""record extras not nullable

Revision ID: 03c96181c90f
Revises: 73b4838a6839
Create Date: 2024-10-30 11:07:37.641631

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "03c96181c90f"
down_revision = "73b4838a6839"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute("""UPDATE base_record SET extras = '{}' WHERE extras IS NULL""")
    op.alter_column("base_record", "extras", existing_type=postgresql.JSONB(astext_type=sa.Text()), nullable=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###

    # No need to set extras to null - empty dict is still just fine

    op.alter_column("base_record", "extras", existing_type=postgresql.JSONB(astext_type=sa.Text()), nullable=True)
    # ### end Alembic commands ###
