"""Torsiondrive spec hashing

Revision ID: 518ee94f4749
Revises: e04bf1eedfbc
Create Date: 2024-12-17 15:18:40.252669

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

from migration_helpers.hashing import hash_dict_1

# revision identifiers, used by Alembic.
revision = "518ee94f4749"
down_revision = "e04bf1eedfbc"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "torsiondrive_specification", sa.Column("protocols", postgresql.JSONB(astext_type=sa.Text()), nullable=True)
    )
    op.add_column("torsiondrive_specification", sa.Column("specification_hash", sa.String(), nullable=True))

    # Generate hashes for existing specs
    conn = op.get_bind()
    res = conn.execute(sa.text(f"SELECT id, program, keywords FROM torsiondrive_specification;"))
    all_spec = res.fetchall()
    for spec_id, program, keywords in all_spec:
        d = {
            "program": program,
            "keywords": keywords,
            "protocols": {},  # Default for now
        }
        h = hash_dict_1(d)
        op.execute(
            sa.text(f"""UPDATE torsiondrive_specification SET specification_hash = '{h}' WHERE id = {spec_id};""")
        )

    op.execute(sa.text("UPDATE torsiondrive_specification SET protocols = '{}'::JSONB"))

    op.alter_column("torsiondrive_specification", "specification_hash", nullable=False)
    op.alter_column("torsiondrive_specification", "protocols", nullable=False)
    op.drop_constraint("ux_torsiondrive_specification_keys", "torsiondrive_specification", type_="unique")
    op.drop_column("torsiondrive_specification", "keywords_hash")
    op.create_unique_constraint(
        "ux_torsiondrive_specification_keys",
        "torsiondrive_specification",
        ["specification_hash", "optimization_specification_id"],
    )
    # ### end Alembic commands ###


def downgrade():
    raise RuntimeError("Downgrade not supported.")
