"""Add repeat_delay to internal_jobs

Revision ID: e798462e0c03
Revises: 0587bb0220aa
Create Date: 2025-01-02 08:48:50.123907

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "e798462e0c03"
down_revision = "0587bb0220aa"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("internal_jobs", sa.Column("repeat_delay", sa.Integer(), nullable=True))

    # Remove old periodic tasks
    op.execute(
        """DELETE FROM internal_jobs WHERE status IN ('waiting', 'running') AND name IN (
                       'delete_old_internal_jobs',
                       'delete_old_access_log',
                       'iterate_services',
                       'geolocate_accesses',
                       'check_manager_heartbeats',
                       'update_geoip2_file'
                  )
               """
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("internal_jobs", "repeat_delay")
    # ### end Alembic commands ###
