"""Add external files table

Revision ID: 02afa97249c7
Revises: c13116948b54
Create Date: 2025-01-03 10:01:55.717905

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "02afa97249c7"
down_revision = "c13116948b54"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "external_file",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("created_on", sa.TIMESTAMP(), nullable=False),
        sa.Column("status", sa.Enum("available", "processing", name="externalfilestatusenum"), nullable=False),
        sa.Column("file_type", sa.Enum("dataset_attachment", name="externalfiletypeenum"), nullable=False),
        sa.Column("bucket", sa.String(), nullable=False),
        sa.Column("file_name", sa.String(), nullable=False),
        sa.Column("object_key", sa.String(), nullable=False),
        sa.Column("sha256sum", sa.String(), nullable=False),
        sa.Column("file_size", sa.BigInteger(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("provenance", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("external_file")
    # ### end Alembic commands ###
