"""Add dataset internal jobs

Revision ID: 5f6f804e11d3
Revises: 84285e3620fd
Create Date: 2025-01-09 16:25:50.187495

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "5f6f804e11d3"
down_revision = "84285e3620fd"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "dataset_internal_job",
        sa.Column("internal_job_id", sa.Integer(), nullable=False),
        sa.Column("dataset_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(["dataset_id"], ["base_dataset.id"], ondelete="cascade"),
        sa.ForeignKeyConstraint(["internal_job_id"], ["internal_jobs.id"], ondelete="cascade"),
        sa.PrimaryKeyConstraint("internal_job_id", "dataset_id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("dataset_internal_job")
    # ### end Alembic commands ###
