"""Remove unused columns from datasets

Revision ID: 236316a77635
Revises: d5988aa750ae
Create Date: 2025-03-13 15:38:25.315717

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "236316a77635"
down_revision = "d5988aa750ae"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("base_dataset", "group")
    op.drop_column("base_dataset", "extras")
    op.drop_column("base_dataset", "visibility")

    # Rename metadata to extras
    op.alter_column("base_dataset", "metadata", new_column_name="extras")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column("base_dataset", "extras", new_column_name="metadata")
    op.add_column("base_dataset", sa.Column("visibility", sa.BOOLEAN(), autoincrement=False, nullable=False))
    op.add_column(
        "base_dataset", sa.Column("extras", postgresql.JSON(astext_type=sa.Text()), autoincrement=False, nullable=False)
    )
    op.add_column("base_dataset", sa.Column("group", sa.VARCHAR(length=100), autoincrement=False, nullable=False))
    # ### end Alembic commands ###
