"""Rename tag and priority columns

Revision ID: 2abde51b4bc7
Revises: 236316a77635
Create Date: 2025-03-14 12:58:18.463114

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "2abde51b4bc7"
down_revision = "236316a77635"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column("record_info_backup", "old_tag", new_column_name="old_compute_tag")
    op.alter_column("record_info_backup", "old_priority", new_column_name="old_compute_priority")

    op.alter_column("service_queue", "tag", new_column_name="compute_tag")
    op.alter_column("service_queue", "priority", new_column_name="compute_priority")
    op.drop_index("ix_service_queue_tag", table_name="service_queue")
    op.create_index("ix_service_queue_compute_tag", "service_queue", ["compute_tag"], unique=False)

    op.alter_column("task_queue", "tag", new_column_name="compute_tag")
    op.alter_column("task_queue", "priority", new_column_name="compute_priority")
    op.drop_index("ix_task_queue_sort", table_name="task_queue", postgresql_where="(available = true)")
    op.create_index(
        "ix_task_queue_sort",
        "task_queue",
        [sa.text("compute_priority DESC"), sa.text("sort_date ASC"), sa.text("id ASC"), "compute_tag"],
        unique=False,
        postgresql_where=sa.text("available = true"),
    )
    op.drop_index("ix_task_queue_tag", table_name="task_queue")
    op.create_index("ix_task_queue_tag", "task_queue", ["compute_tag"], unique=False)

    op.drop_constraint("ck_task_queue_tag_lower", "task_queue")
    op.create_check_constraint(
        "ck_task_queue_compute_tag_lower",
        "task_queue",
        sa.column("compute_tag").cast(sa.TEXT) == sa.func.lower(sa.column("compute_tag").cast(sa.TEXT)),
    )

    op.drop_constraint("ck_service_queue_tag_lower", "service_queue")
    op.create_check_constraint(
        "ck_service_queue_compute_tag_lower",
        "service_queue",
        sa.column("compute_tag").cast(sa.TEXT) == sa.func.lower(sa.column("compute_tag").cast(sa.TEXT)),
    )

    op.alter_column("base_dataset", "default_tag", new_column_name="default_compute_tag")
    op.alter_column("base_dataset", "default_priority", new_column_name="default_compute_priority")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column("record_info_backup", "old_compute_tag", new_column_name="old_tag")
    op.alter_column("record_info_backup", "old_compute_priority", new_column_name="old_priority")

    op.alter_column("service_queue", "compute_tag", new_column_name="tag")
    op.alter_column("service_queue", "compute_priority", new_column_name="priority")
    op.drop_index("ix_service_queue_compute_tag", table_name="service_queue")
    op.create_index("ix_service_queue_tag", "service_queue", ["tag"], unique=False)

    op.alter_column("task_queue", "compute_tag", new_column_name="tag")
    op.alter_column("task_queue", "compute_priority", new_column_name="priority")
    op.drop_index("ix_task_queue_tag", table_name="task_queue")
    op.create_index("ix_task_queue_tag", "task_queue", ["tag"], unique=False)
    op.drop_index("ix_task_queue_sort", table_name="task_queue", postgresql_where=sa.text("available = true"))
    op.create_index(
        "ix_task_queue_sort",
        "task_queue",
        [sa.text("priority DESC"), "sort_date", "id", "tag"],
        unique=False,
        postgresql_where="(available = true)",
    )

    op.drop_constraint("ck_task_queue_compute_tag_lower", "task_queue")
    op.create_check_constraint(
        "ck_task_queue_tag_lower",
        "task_queue",
        sa.column("tag").cast(sa.TEXT) == sa.func.lower(sa.column("tag").cast(sa.TEXT)),
    )

    op.drop_constraint("ck_service_queue_compute_tag_lower", "service_queue")
    op.create_check_constraint(
        "ck_service_queue_tag_lower",
        "service_queue",
        sa.column("tag").cast(sa.TEXT) == sa.func.lower(sa.column("tag").cast(sa.TEXT)),
    )

    op.alter_column("base_dataset", "default_compute_tag", new_column_name="default_tag")
    op.alter_column("base_dataset", "default_compute_priority", new_column_name="default_priority")
    # ### end Alembic commands ###
