"""rename tags on managers

Revision ID: 2c3c406a2750
Revises: 2abde51b4bc7
Create Date: 2025-03-21 10:36:19.961734

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "2c3c406a2750"
down_revision = "2abde51b4bc7"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column("compute_manager", "tags", new_column_name="compute_tags")

    op.drop_constraint("ck_compute_manager_tags_lower", "compute_manager")
    op.create_check_constraint(
        "ck_compute_manager_compute_tags_lower",
        "compute_manager",
        sa.column("compute_tags").cast(sa.TEXT) == sa.func.lower(sa.column("compute_tags").cast(sa.TEXT)),
    )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column("compute_manager", "compute_tags", new_column_name="tags")

    op.drop_constraint("ck_compute_manager_tags_lower", "compute_manager")
    op.create_check_constraint(
        "ck_compute_manager_tags_lower",
        "compute_manager",
        sa.column("tags").cast(sa.TEXT) == sa.func.lower(sa.column("tags").cast(sa.TEXT)),
    )
    # ### end Alembic commands ###
