"""add projects tables

Revision ID: a036e75160ea
Revises: db730926b1b9
Create Date: 2025-03-24 20:31:36.029509

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "a036e75160ea"
down_revision = "db730926b1b9"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "project",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=100), nullable=False),
        sa.Column(
            "lname",
            sa.String(length=100),
            sa.Computed(
                "LOWER(name)",
            ),
            nullable=False,
        ),
        sa.Column("description", sa.String(), nullable=False),
        sa.Column("tagline", sa.String(), nullable=False),
        sa.Column("tags", sa.JSON(), nullable=False),
        sa.Column("default_compute_tag", sa.String(), nullable=False),
        sa.Column("default_compute_priority", sa.Integer(), nullable=False),
        sa.Column("extras", sa.JSON(), nullable=False),
        sa.Column("owner_user_id", sa.Integer(), nullable=True),
        sa.Column("owner_group_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["owner_group_id"],
            ["group.id"],
        ),
        sa.ForeignKeyConstraint(
            ["owner_user_id", "owner_group_id"],
            ["user_groups.user_id", "user_groups.group_id"],
        ),
        sa.ForeignKeyConstraint(
            ["owner_user_id"],
            ["user.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("lname", name="ux_project_project_type_lname"),
    )
    op.create_index("ix_project_owner_group_id", "project", ["owner_group_id"], unique=False)
    op.create_index("ix_project_owner_user_id", "project", ["owner_user_id"], unique=False)
    op.create_table(
        "project_attachment",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("project_id", sa.Integer(), nullable=False),
        sa.Column("attachment_type", sa.Enum("other", name="projectattachmenttype"), nullable=False),
        sa.Column("tags", sa.JSON(), nullable=False),
        sa.ForeignKeyConstraint(["id"], ["external_file.id"], ondelete="cascade"),
        sa.ForeignKeyConstraint(["project_id"], ["project.id"], ondelete="cascade"),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index("ix_project_attachment_project_id", "project_attachment", ["project_id"], unique=False)
    op.create_table(
        "project_dataset",
        sa.Column("project_id", sa.Integer(), nullable=False),
        sa.Column("dataset_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["dataset_id"],
            ["base_dataset.id"],
        ),
        sa.ForeignKeyConstraint(["project_id"], ["project.id"], ondelete="cascade"),
        sa.PrimaryKeyConstraint("project_id", "dataset_id"),
    )
    op.create_index("ix_project_dataset_dataset_id", "project_dataset", ["dataset_id"], unique=False)
    op.create_table(
        "project_internal_job",
        sa.Column("internal_job_id", sa.Integer(), nullable=False),
        sa.Column("project_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(["internal_job_id"], ["internal_jobs.id"], ondelete="cascade"),
        sa.ForeignKeyConstraint(["project_id"], ["project.id"], ondelete="cascade"),
        sa.PrimaryKeyConstraint("internal_job_id", "project_id"),
    )
    op.create_table(
        "project_molecule",
        sa.Column("project_id", sa.Integer(), nullable=False),
        sa.Column("molecule_id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column(
            "lname",
            sa.String(length=100),
            sa.Computed(
                "LOWER(name)",
            ),
            nullable=False,
        ),
        sa.Column("description", sa.String(), nullable=False),
        sa.Column("tags", sa.JSON(), nullable=False),
        sa.ForeignKeyConstraint(
            ["molecule_id"],
            ["molecule.id"],
        ),
        sa.ForeignKeyConstraint(["project_id"], ["project.id"], ondelete="cascade"),
        sa.PrimaryKeyConstraint("project_id", "lname"),
    )
    op.create_index("ix_project_molecule_molecule_id", "project_molecule", ["molecule_id"], unique=False)
    op.create_table(
        "project_record",
        sa.Column("project_id", sa.Integer(), nullable=False),
        sa.Column("record_id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column(
            "lname",
            sa.String(length=100),
            sa.Computed(
                "LOWER(name)",
            ),
            nullable=False,
        ),
        sa.Column("description", sa.String(), nullable=False),
        sa.Column("tags", sa.JSON(), nullable=False),
        sa.ForeignKeyConstraint(["project_id"], ["project.id"], ondelete="cascade"),
        sa.ForeignKeyConstraint(
            ["record_id"],
            ["base_record.id"],
        ),
        sa.PrimaryKeyConstraint("project_id", "lname"),
    )
    op.create_index("ix_project_record_record_id", "project_record", ["record_id"], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_project_record_record_id", table_name="project_record")
    op.drop_table("project_record")
    op.drop_index("ix_project_molecule_molecule_id", table_name="project_molecule")
    op.drop_table("project_molecule")
    op.drop_table("project_internal_job")
    op.drop_index("ix_project_dataset_dataset_id", table_name="project_dataset")
    op.drop_table("project_dataset")
    op.drop_index("ix_project_attachment_project_id", table_name="project_attachment")
    op.drop_table("project_attachment")
    op.drop_index("ix_project_owner_user_id", table_name="project")
    op.drop_index("ix_project_owner_group_id", table_name="project")
    op.drop_table("project")
    # ### end Alembic commands ###
