"""add user id to session table

Revision ID: 1136ef3ba3ef
Revises: 521464fa93ca
Create Date: 2025-04-05 09:47:58.918236

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "1136ef3ba3ef"
down_revision = "521464fa93ca"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute("DELETE FROM user_session")
    op.add_column("user_session", sa.Column("user_id", sa.Integer(), nullable=False))
    op.create_index("ix_user_session_user_id", "user_session", ["user_id"], unique=False)
    op.create_foreign_key(None, "user_session", "user", ["user_id"], ["id"], ondelete="cascade")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, "user_session", type_="foreignkey")
    op.drop_index("ix_user_session_user_id", table_name="user_session")
    op.drop_column("user_session", "user_id")
    # ### end Alembic commands ###
