"""add public id to sessions table

Revision ID: 8738641e0b90
Revises: b664ee54c62a
Create Date: 2025-04-05 20:19:36.318495

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "8738641e0b90"
down_revision = "b664ee54c62a"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("user_session", sa.Column("public_id", sa.Integer(), nullable=False))
    op.create_unique_constraint("ux_user_session_session_id", "user_session", ["session_id"])

    op.execute(sa.text("""create sequence user_session_public_id_seq"""))
    op.drop_constraint("user_session_pkey", "user_session")

    op.execute(
        sa.text(
            """ALTER TABLE user_session ALTER COLUMN public_id SET DEFAULT nextval('user_session_public_id_seq'::regclass)"""
        )
    )
    op.execute(sa.text("""ALTER SEQUENCE user_session_public_id_seq OWNED BY user_session.public_id"""))
    op.execute(sa.text("""CREATE UNIQUE INDEX user_session_pkey ON user_session USING btree (public_id)"""))
    op.execute(
        sa.text(
            """alter table user_session add constraint user_session_pkey PRIMARY KEY using index user_session_pkey"""
        )
    )

    # ### end Alembic commands ###


def downgrade():
    raise RuntimeError("Downgrade is not supported")
