"""change session data column type

Revision ID: e15456ce68e2
Revises: 8738641e0b90
Create Date: 2025-04-06 09:17:25.122270

"""

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "e15456ce68e2"
down_revision = "8738641e0b90"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute("DELETE FROM user_session")
    op.add_column("user_session", sa.Column("session_key", sa.String(), nullable=False))

    op.drop_column("user_session", "session_data")
    op.add_column("user_session", sa.Column("session_data", postgresql.JSONB(astext_type=sa.Text()), nullable=False))

    op.drop_constraint("ux_user_session_session_id", "user_session", type_="unique")
    op.create_unique_constraint("ux_user_session_session_key", "user_session", ["session_key"])
    op.drop_column("user_session", "session_id")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("user_session", sa.Column("session_id", sa.VARCHAR(), autoincrement=False, nullable=False))
    op.drop_constraint("ux_user_session_session_key", "user_session", type_="unique")
    op.create_unique_constraint("ux_user_session_session_id", "user_session", ["session_id"])

    op.drop_column("user_session", "session_data")
    op.add_column("user_session", sa.Column("session_data", postgresql.BYTEA(), nullable=False))

    op.drop_column("user_session", "session_key")
    # ### end Alembic commands ###
