"""remove role table

Revision ID: db730926b1b9
Revises: e15456ce68e2
Create Date: 2025-04-08 12:04:09.860028

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "db730926b1b9"
down_revision = "e15456ce68e2"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("user", sa.Column("role", sa.String(), nullable=True))
    op.execute(
        sa.text(
            """UPDATE "user" SET role = ri.rolename
                          FROM role ri
                          WHERE ri.id = "user".role_id"""
        )
    )

    op.alter_column("user", "role", nullable=False)

    op.drop_constraint("user_role_id_fkey", "user", type_="foreignkey")
    op.drop_table("role")
    op.drop_column("user", "role_id")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    raise NotImplementedError("Cannot downgrade")
    # ### end Alembic commands ###
