"""rename owner_user, remove owner_group

Revision ID: c5a3bed43646
Revises: db730926b1b9
Create Date: 2025-04-11 13:04:03.146646

"""

from alembic import op

# revision identifiers, used by Alembic.
revision = "c5a3bed43646"
down_revision = "db730926b1b9"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_base_dataset_owner_group_id", table_name="base_dataset")
    op.drop_index("ix_base_dataset_owner_user_id", table_name="base_dataset")
    op.drop_constraint("base_dataset_owner_user_id_fkey", "base_dataset", type_="foreignkey")
    op.drop_constraint("base_dataset_owner_user_id_owner_group_id_fkey", "base_dataset", type_="foreignkey")
    op.drop_constraint("base_dataset_owner_group_id_fkey", "base_dataset", type_="foreignkey")
    op.alter_column("base_dataset", "owner_user_id", new_column_name="creator_user_id")
    op.drop_column("base_dataset", "owner_group_id")
    op.create_index("ix_base_dataset_creator_user_id", "base_dataset", ["creator_user_id"], unique=False)
    op.create_foreign_key(None, "base_dataset", "user", ["creator_user_id"], ["id"])

    op.drop_index("ix_base_record_owner_group_id", table_name="base_record")
    op.drop_index("ix_base_record_owner_user_id", table_name="base_record")
    op.drop_constraint("base_record_owner_group_id_fkey", "base_record", type_="foreignkey")
    op.drop_constraint("base_record_owner_user_id_fkey", "base_record", type_="foreignkey")
    op.drop_constraint("base_record_owner_user_id_owner_group_id_fkey", "base_record", type_="foreignkey")
    op.drop_column("base_record", "owner_group_id")
    op.alter_column("base_record", "owner_user_id", new_column_name="creator_user_id")
    op.create_index("ix_base_record_creator_user_id", "base_record", ["creator_user_id"], unique=False)
    op.create_foreign_key(None, "base_record", "user", ["creator_user_id"], ["id"])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    raise NotImplementedError("Downgrade is not supported")
    # ### end Alembic commands ###
