"""use views for dataset records

Revision ID: 5ae71b845526
Revises: ee68b4a1c346
Create Date: 2025-04-15 19:43:41.069422

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "5ae71b845526"
down_revision = "ee68b4a1c346"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute(
        sa.text(
            """
                create or replace view "public"."dataset_direct_records_view" as  SELECT base_dataset.id AS dataset_id,
                    singlepoint_dataset_record.entry_name,
                    singlepoint_dataset_record.specification_name,
                    singlepoint_dataset_record.record_id
                   FROM (base_dataset
                     JOIN singlepoint_dataset_record ON ((base_dataset.id = singlepoint_dataset_record.dataset_id)))
                  WHERE ((base_dataset.dataset_type)::text = 'singlepoint'::text)
                UNION
                 SELECT base_dataset.id AS dataset_id,
                    optimization_dataset_record.entry_name,
                    optimization_dataset_record.specification_name,
                    optimization_dataset_record.record_id
                   FROM (base_dataset
                     JOIN optimization_dataset_record ON ((base_dataset.id = optimization_dataset_record.dataset_id)))
                  WHERE ((base_dataset.dataset_type)::text = 'optimization'::text)
                UNION
                 SELECT base_dataset.id AS dataset_id,
                    gridoptimization_dataset_record.entry_name,
                    gridoptimization_dataset_record.specification_name,
                    gridoptimization_dataset_record.record_id
                   FROM (base_dataset
                     JOIN gridoptimization_dataset_record ON ((base_dataset.id = gridoptimization_dataset_record.dataset_id)))
                  WHERE ((base_dataset.dataset_type)::text = 'gridoptimization'::text)
                UNION
                 SELECT base_dataset.id AS dataset_id,
                    torsiondrive_dataset_record.entry_name,
                    torsiondrive_dataset_record.specification_name,
                    torsiondrive_dataset_record.record_id
                   FROM (base_dataset
                     JOIN torsiondrive_dataset_record ON ((base_dataset.id = torsiondrive_dataset_record.dataset_id)))
                  WHERE ((base_dataset.dataset_type)::text = 'torsiondrive'::text)
                UNION
                 SELECT base_dataset.id AS dataset_id,
                    manybody_dataset_record.entry_name,
                    manybody_dataset_record.specification_name,
                    manybody_dataset_record.record_id
                   FROM (base_dataset
                     JOIN manybody_dataset_record ON ((base_dataset.id = manybody_dataset_record.dataset_id)))
                  WHERE ((base_dataset.dataset_type)::text = 'manybody'::text)
                UNION
                 SELECT base_dataset.id AS dataset_id,
                    reaction_dataset_record.entry_name,
                    reaction_dataset_record.specification_name,
                    reaction_dataset_record.record_id
                   FROM (base_dataset
                     JOIN reaction_dataset_record ON ((base_dataset.id = reaction_dataset_record.dataset_id)))
                  WHERE ((base_dataset.dataset_type)::text = 'reaction'::text)
                UNION
                 SELECT base_dataset.id AS dataset_id,
                    neb_dataset_record.entry_name,
                    neb_dataset_record.specification_name,
                    neb_dataset_record.record_id
                   FROM (base_dataset
                     JOIN neb_dataset_record ON ((base_dataset.id = neb_dataset_record.dataset_id)))
                  WHERE ((base_dataset.dataset_type)::text = 'neb'::text);
    """
        )
    )

    op.execute(
        sa.text(
            """
              create or replace view "public"."dataset_records_view" as  SELECT dataset_direct_records_view.dataset_id,
                  dataset_direct_records_view.record_id
                 FROM dataset_direct_records_view
              UNION
               SELECT dataset_direct_records_view.dataset_id,
                  record_children_view.child_id AS record_id
                 FROM (dataset_direct_records_view
                   JOIN record_children_view ON ((dataset_direct_records_view.record_id = record_children_view.parent_id)));
    """
        )
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute(sa.text("DROP VIEW dataset_records_view;"))
    op.execute(sa.text("DROP VIEW dataset_direct_records_view;"))
    # ### end Alembic commands ###
