"""use views for record parents/children

Revision ID: ee68b4a1c346
Revises: c5a3bed43646
Create Date: 2025-04-15 16:12:00.052936

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "ee68b4a1c346"
down_revision = "c5a3bed43646"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute(
        sa.text(
            """
                create or replace view "public"."record_children_view" as  SELECT base_record.id AS parent_id,
                    optimization_trajectory.singlepoint_id AS child_id
                   FROM (base_record
                     JOIN optimization_trajectory ON ((base_record.id = optimization_trajectory.optimization_id)))
                  WHERE (base_record.record_type = 'optimization')
                UNION
                 SELECT base_record.id AS parent_id,
                    gridoptimization_optimization.optimization_id AS child_id
                   FROM (base_record
                     JOIN gridoptimization_optimization ON ((base_record.id = gridoptimization_optimization.gridoptimization_id)))
                  WHERE (base_record.record_type = 'gridoptimization')
                UNION
                 SELECT base_record.id AS parent_id,
                    optimization_trajectory.singlepoint_id AS child_id
                   FROM ((base_record
                     JOIN gridoptimization_optimization ON ((base_record.id = gridoptimization_optimization.gridoptimization_id)))
                     JOIN optimization_trajectory ON ((optimization_trajectory.optimization_id = gridoptimization_optimization.optimization_id)))
                  WHERE (base_record.record_type = 'gridoptimization')
                UNION
                 SELECT base_record.id AS parent_id,
                    torsiondrive_optimization.optimization_id AS child_id
                   FROM (base_record
                     JOIN torsiondrive_optimization ON ((base_record.id = torsiondrive_optimization.torsiondrive_id)))
                  WHERE (base_record.record_type = 'torsiondrive')
                UNION
                 SELECT base_record.id AS parent_id,
                    optimization_trajectory.singlepoint_id AS child_id
                   FROM ((base_record
                     JOIN torsiondrive_optimization ON ((base_record.id = torsiondrive_optimization.torsiondrive_id)))
                     JOIN optimization_trajectory ON ((optimization_trajectory.optimization_id = torsiondrive_optimization.optimization_id)))
                  WHERE (base_record.record_type = 'torsiondrive')
                UNION
                 SELECT base_record.id AS parent_id,
                    manybody_cluster.singlepoint_id AS child_id
                   FROM (base_record
                     JOIN manybody_cluster ON ((base_record.id = manybody_cluster.manybody_id)))
                  WHERE (base_record.record_type = 'manybody')
                UNION
                 SELECT base_record.id AS parent_id,
                    reaction_component.singlepoint_id AS child_id
                   FROM (base_record
                     JOIN reaction_component ON ((base_record.id = reaction_component.reaction_id)))
                  WHERE ((base_record.record_type = 'reaction') AND (reaction_component.singlepoint_id IS NOT NULL))
                UNION
                 SELECT base_record.id AS parent_id,
                    reaction_component.optimization_id AS child_id
                   FROM (base_record
                     JOIN reaction_component ON ((base_record.id = reaction_component.reaction_id)))
                  WHERE ((base_record.record_type = 'reaction') AND (reaction_component.optimization_id IS NOT NULL))
                UNION
                 SELECT base_record.id AS parent_id,
                    optimization_trajectory.singlepoint_id AS child_id
                   FROM ((base_record
                     JOIN reaction_component ON ((base_record.id = reaction_component.reaction_id)))
                     JOIN optimization_trajectory ON ((optimization_trajectory.optimization_id = reaction_component.optimization_id)))
                  WHERE ((base_record.record_type = 'reaction') AND (reaction_component.optimization_id IS NOT NULL))
                UNION
                 SELECT base_record.id AS parent_id,
                    neb_singlepoints.singlepoint_id AS child_id
                   FROM (base_record
                     JOIN neb_singlepoints ON ((base_record.id = neb_singlepoints.neb_id)))
                  WHERE (base_record.record_type = 'neb')
                UNION
                 SELECT base_record.id AS parent_id,
                    neb_optimizations.optimization_id AS child_id
                   FROM (base_record
                     JOIN neb_optimizations ON ((base_record.id = neb_optimizations.neb_id)))
                  WHERE (base_record.record_type = 'neb')
                UNION
                 SELECT base_record.id AS parent_id,
                    optimization_trajectory.singlepoint_id AS child_id
                   FROM ((base_record
                     JOIN neb_optimizations ON ((base_record.id = neb_optimizations.neb_id)))
                     JOIN optimization_trajectory ON ((optimization_trajectory.optimization_id = neb_optimizations.optimization_id)))
                  WHERE (base_record.record_type = 'neb');
            """
        )
    )

    op.execute(
        sa.text(
            """
                create or replace view "public"."record_direct_children_view" as  SELECT base_record.id AS parent_id,
                    optimization_trajectory.singlepoint_id AS child_id
                   FROM (base_record
                     JOIN optimization_trajectory ON ((base_record.id = optimization_trajectory.optimization_id)))
                  WHERE (base_record.record_type = 'optimization')
                UNION
                 SELECT base_record.id AS parent_id,
                    gridoptimization_optimization.optimization_id AS child_id
                   FROM (base_record
                     JOIN gridoptimization_optimization ON ((base_record.id = gridoptimization_optimization.gridoptimization_id)))
                  WHERE (base_record.record_type = 'gridoptimization')
                UNION
                 SELECT base_record.id AS parent_id,
                    torsiondrive_optimization.optimization_id AS child_id
                   FROM (base_record
                     JOIN torsiondrive_optimization ON ((base_record.id = torsiondrive_optimization.torsiondrive_id)))
                  WHERE (base_record.record_type = 'torsiondrive')
                UNION
                 SELECT base_record.id AS parent_id,
                    manybody_cluster.singlepoint_id AS child_id
                   FROM (base_record
                     JOIN manybody_cluster ON ((base_record.id = manybody_cluster.manybody_id)))
                  WHERE (base_record.record_type = 'manybody')
                UNION
                 SELECT base_record.id AS parent_id,
                    reaction_component.singlepoint_id AS child_id
                   FROM (base_record
                     JOIN reaction_component ON ((base_record.id = reaction_component.reaction_id)))
                  WHERE ((base_record.record_type = 'reaction') AND (reaction_component.singlepoint_id IS NOT NULL))
                UNION
                 SELECT base_record.id AS parent_id,
                    reaction_component.optimization_id AS child_id
                   FROM (base_record
                     JOIN reaction_component ON ((base_record.id = reaction_component.reaction_id)))
                  WHERE ((base_record.record_type = 'reaction') AND (reaction_component.optimization_id IS NOT NULL))
                UNION
                 SELECT base_record.id AS parent_id,
                    neb_singlepoints.singlepoint_id AS child_id
                   FROM (base_record
                     JOIN neb_singlepoints ON ((base_record.id = neb_singlepoints.neb_id)))
                  WHERE (base_record.record_type = 'neb')
                UNION
                 SELECT base_record.id AS parent_id,
                    neb_optimizations.optimization_id AS child_id
                   FROM (base_record
                     JOIN neb_optimizations ON ((base_record.id = neb_optimizations.neb_id)))
                  WHERE (base_record.record_type = 'neb');
            """
        )
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute(sa.text("""drop view record_direct_children_view;"""))
    op.execute(sa.text("""drop view record_children_view;"""))
    # ### end Alembic commands ###
