"""add more info to project tables

Revision ID: 4d5ad63ad478
Revises: 0390661b91bf
Create Date: 2025-04-21 15:56:32.589003

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "4d5ad63ad478"
down_revision = "0390661b91bf"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("project_dataset", sa.Column("name", sa.String(), nullable=False))
    op.add_column(
        "project_dataset",
        sa.Column(
            "lname",
            sa.String(length=100),
            sa.Computed(
                "LOWER(name)",
            ),
            nullable=False,
        ),
    )
    op.add_column("project_dataset", sa.Column("description", sa.String(), nullable=False))
    op.add_column("project_dataset", sa.Column("tagline", sa.String(), nullable=False))
    op.add_column("project_dataset", sa.Column("tags", sa.JSON(), nullable=False))

    op.drop_constraint("project_dataset_pkey", "project_dataset", type_="primary")
    op.create_primary_key(
        "project_dataset_pkey",
        "project_dataset",
        ["project_id", "lname"],
    )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    raise NotImplementedError("Cannot downgrade")
    # ### end Alembic commands ###
