"""remove project molecules

Revision ID: a6a708376a1e
Revises: 4d5ad63ad478
Create Date: 2025-04-27 10:42:26.756827

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "a6a708376a1e"
down_revision = "4d5ad63ad478"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_project_molecule_molecule_id", table_name="project_molecule")
    op.drop_table("project_molecule")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "project_molecule",
        sa.Column("project_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("molecule_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("name", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column(
            "lname",
            sa.VARCHAR(length=100),
            sa.Computed("lower((name)::text)", persisted=True),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column("description", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("tags", postgresql.JSON(astext_type=sa.Text()), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(["molecule_id"], ["molecule.id"], name="project_molecule_molecule_id_fkey"),
        sa.ForeignKeyConstraint(
            ["project_id"], ["project.id"], name="project_molecule_project_id_fkey", ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("project_id", "lname", name="project_molecule_pkey"),
    )
    op.create_index("ix_project_molecule_molecule_id", "project_molecule", ["molecule_id"], unique=False)
    # ### end Alembic commands ###
