"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

from __future__ import annotations
import dataclasses
import dateutil.parser
from .labelfiletypeenum import LabelFileTypeEnum
from .objectstateenum import ObjectStateEnum
from .trackingstatusenum import TrackingStatusEnum
from .transactionstatusenum import TransactionStatusEnum
from dataclasses_json import Undefined, dataclass_json
from datetime import datetime
from enum import Enum
from shippo import utils
from typing import List, Optional


@dataclasses.dataclass
class TransactionMessages:
    pass

class ResponseType(str, Enum):
    STANDARD = 'standard'


@dataclass_json(undefined=Undefined.EXCLUDE)
@dataclasses.dataclass
class Transaction:
    commercial_invoice_url: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('commercial_invoice_url'), 'exclude': lambda f: f is None }})
    r"""A URL pointing to the commercial invoice as a 8.5x11 inch PDF file.
    A value will only be returned if the Transactions has been processed successfully and if the shipment is international.
    """
    eta: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('eta'), 'exclude': lambda f: f is None }})
    r"""The estimated time of arrival according to the carrier."""
    label_file_type: Optional[LabelFileTypeEnum] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('label_file_type'), 'exclude': lambda f: f is None }})
    r"""Print format of the <a href=\\"https://docs.goshippo.com/docs/shipments/shippinglabelsizes/\\">label</a>. If empty, will use the default format set from
    <a href=\"https://apps.goshippo.com/settings/labels\">the Shippo dashboard.</a>
    """
    label_url: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('label_url'), 'exclude': lambda f: f is None }})
    r"""A URL pointing directly to the label in the format you've set in your settings.
    A value will only be returned if the Transactions has been processed successfully.
    """
    messages: Optional[List[TransactionMessages]] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('messages'), 'exclude': lambda f: f is None }})
    r"""An array containing elements of the following schema:<br>
    `code` (string): an identifier for the corresponding message (not always available)<br>
    `message` (string): a publishable message containing further information.
    """
    metadata: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('metadata'), 'exclude': lambda f: f is None }})
    r"""A string of up to 100 characters that can be filled with any additional information you want to
    attach to the object.
    """
    object_created: Optional[datetime] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('object_created'), 'encoder': utils.datetimeisoformat(True), 'decoder': dateutil.parser.isoparse, 'exclude': lambda f: f is None }})
    r"""Date and time of Transaction creation."""
    object_id: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('object_id'), 'exclude': lambda f: f is None }})
    r"""Unique identifier of the given Transaction object."""
    object_owner: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('object_owner'), 'exclude': lambda f: f is None }})
    r"""Username of the user who created the Transaction object."""
    object_state: Optional[ObjectStateEnum] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('object_state'), 'exclude': lambda f: f is None }})
    r"""Indicates the validity of the enclosing object"""
    object_updated: Optional[datetime] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('object_updated'), 'encoder': utils.datetimeisoformat(True), 'decoder': dateutil.parser.isoparse, 'exclude': lambda f: f is None }})
    r"""Date and time of last Transaction update."""
    qr_code_url: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('qr_code_url'), 'exclude': lambda f: f is None }})
    r"""A URL pointing directly to the QR code in PNG format.
    A value will only be returned if requested using qr_code_requested flag and the carrier provides such an option.
    """
    status: Optional[TransactionStatusEnum] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('status'), 'exclude': lambda f: f is None }})
    r"""Indicates the status of the Transaction."""
    test: Optional[bool] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('test'), 'exclude': lambda f: f is None }})
    r"""Indicates whether the object has been created in test mode."""
    tracking_number: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('tracking_number'), 'exclude': lambda f: f is None }})
    r"""The carrier-specific tracking number that can be used to track the Shipment.
    A value will only be returned if the Rate is for a trackable Shipment and if the Transactions has been processed successfully.
    """
    tracking_status: Optional[TrackingStatusEnum] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('tracking_status'), 'exclude': lambda f: f is None }})
    r"""Indicates the high level status of the shipment."""
    tracking_url_provider: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('tracking_url_provider'), 'exclude': lambda f: f is None }})
    r"""A link to track this item on the carrier-provided tracking website.
    A value will only be returned if tracking is available and the carrier provides such a service.
    """
    rate: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('rate'), 'exclude': lambda f: f is None }})
    r"""ID of the Rate object for which a Label has to be obtained.
    Please note that only rates that are not older than 7 days can be purchased in order to ensure up-to-date pricing.
    """
    response_type: Optional[ResponseType] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('responseType'), 'exclude': lambda f: f is None }})
    

