
#THIS FILE IS AUTOMATICALLY GENERATED. PLEASE DO NOT CHANGE MANUALLY

from aipha_geo_solutions import operators as ao
import numpy as np
import os


class AIPHAConnector:
	def __init__(self,
	             all_params,
	             itertable_params, 
	             itertable_iotypes, 
	             iterable_file_types, 
	             unique_id, 
	             processing_folder, 
	             name,
	             folder_level_operator,
	             call_stack):
		self.connections = {}
		self.call_stack = call_stack
		assert(len(itertable_params) == len(itertable_iotypes))
		assert(len(itertable_params) == len(iterable_file_types))
		for idx in range(len(itertable_params)):
			this_param = itertable_params[idx]
			this_iotype = itertable_iotypes[idx]
			this_file_type = iterable_file_types[idx]
			this_value = '__auto__'
			if this_param in all_params:
				this_value = all_params[this_param]
			this_val = {'param': this_param, 'iotype': this_iotype, 'file_type': this_file_type, 'value': this_value}
			self.connections[this_param] = this_val
		self.unique_id = unique_id
		self.processing_folder = processing_folder
		self.name = name
		self.folder_level_operator = folder_level_operator

	def get_connection_subset(self, iotype = 'out'):
		subset = {}
		for idx in self.connections:
			if self.connections[idx]['iotype'] == iotype:
				subset[idx] = self.connections[idx]
		return subset

	def _get_connection(self, key, iotype = 'out'):
		subset = self.get_connection_subset(iotype)
		print(subset, iotype)
		if isinstance(key, int) or isinstance(key, float):
			print(key)
			if key < len(subset):
				return list(subset.values())[int(key)]
			else:
				raise KeyError('Key ' + str(key) + ' not found in connections.')
		elif isinstance(key, str):
			if key in subset:
				return subset[key]
			else:
				raise KeyError('Key ' + str(key) + ' not found in connections.')
		else:
			raise KeyError('Keytype ' + str(key) + ' not supported.')

	def io(self, key, iotype = 'out'):
		return self._get_connection(key, iotype)

	def get_connections(self):
		return self.connections

	def _resolve_out_connections(self, dict):
		for idx in dict:
			if dict[idx] == '__auto__':
				if idx in self.connections:
					if self.connections[idx]['iotype'] == 'out':
						out_name = os.path.join(self.processing_folder, self.unique_id + '_' + self.name + '_' + idx)
						if not self.folder_level_operator:
							out_name += '.' + self.connections[idx]['file_type']
						dict[idx] = out_name
						self.connections[idx]['value'] = out_name
		return dict

	def _find_in_call_stack(self, key, iotype = 'out', file_type = 'laz', is_folder_level = False):
		this_file_type = self.connections[key]['file_type']
		has_output = False
		out_value = '__auto__'
		for idx in range(len(self.call_stack) -1, -1, -1):
			if self.call_stack[idx].get_executed() == True:
				operator = self.call_stack[idx]
				operator_connections = operator.get_connector().get_connection_subset(iotype)
				folder_level_operator = operator.is_folder_level_operator()
				if folder_level_operator != is_folder_level:
					continue
				for idx2 in operator_connections:
					if operator_connections[idx2]['file_type'] == this_file_type:
						has_output = True
						out_value = operator_connections[idx2]['value']
						break
				if has_output:
					break
		if has_output:
			if out_value[-1] == ' ':
				out_value = out_value[:-1]
			if not is_folder_level:
				assert(out_value.endswith(this_file_type))
			else:
				assert('.' not in out_value)
			return out_value

		raise RuntimeError('Was not able to automatically resolve connection: ' + key + ' in ' + self.name)

	def _resolve_in_connections(self, dict):
		for idx in dict:
			if dict[idx] == '__auto__':
				if idx in self.connections:
					if self.connections[idx]['iotype'] == 'in':
						in_name = self._find_in_call_stack(idx, 'out', self.connections[idx]['file_type'], self.folder_level_operator)
						dict[idx] = in_name
		return dict

	def resolve_auto_connections(self, dict):
		dict = self._resolve_out_connections(dict)
		return self._resolve_in_connections(dict)


class AIPHAOperator:
	 def __init__(self,
	   connector,
	   parameters,
	   result_promise,
	   processing_class,
	   scope,
	   folder_level_operator = False,
	   unique_id = 0,
	   executed = False):

		 self.connector = connector
		 self.parameters = parameters
		 self.result_promise = result_promise
		 self.executed = executed
		 self.unique_id = unique_id
		 self.processing_class = processing_class
		 self.scope = scope
		 self.folder_level_operator = folder_level_operator

	 def is_folder_level_operator(self):
		 return self.folder_level_operator

	 def get_executed(self):
		 return self.executed

	 def set_executed(self, executed):
		 self.executed = executed

	 def get_connector(self):
		 return self.connector

	 def io(self, key, iotype = 'out'):
			 return self.connector.io(key, iotype=iotype)['value']

	 def get_result_promise(self):
		 return self.result_promise

	 def get_parameters(self):
		 return self.parameters

	 def get_parameter(self, key):
		 return self.parameters[key]

	 def _check_valid_type(self, filetype):
		 if filetype.endswith('npy') or filetype.endswith('txt') or filetype.endswith('labels'):
			 return True
		 return False

	 def _check_op_is_value_type(self, op, output_key = 0):
		 if op.folder_level_operator:
			 con = op.get_connector().io(output_key, 'out')
			 file_type = con['file_type']
			 if self._check_valid_type(file_type):
				 return True
		 else:
			 file = op.io(output_key, 'out')
			 print(file)
			 if self._check_valid_type(file):
				 return True
		 return False

	 def __getitem__(self, *args, output_key = 0, blocking=True):
		 if not self._check_op_is_value_type(self, output_key):
			 raise RuntimeError('Cannot use slice operator on non-value type. Please convert from {scope} to value type first.')
		 slices_str = ''
		 print(args)
		 indices = args[0]
		 this_file = self.io(output_key, 'out')
		 if isinstance(indices, AIPHAOperator):
			 mask_file = indices.io(0, 'out')
			 if self.folder_level_operator:
				 return self.processing_class.val.mask_subset(this_file, mask_file, folder_parallel_processing=True)
			 else:
				 return self.processing_class.val.mask_subset(this_file, mask_file, folder_parallel_processing=False)
		
		 for idx in indices:
			 print(type(idx), idx)
			 if isinstance(idx, int):
			   slices_str += str(idx) + ','
			 elif isinstance(idx, slice):
			   slices_str += str(idx.start) + ':' + str(idx.stop) + ':' + str(idx.step) + ','
			 else:
			   raise RuntimeError('Invalid slice operator.')
		 slices_str = slices_str[:-1]
		 if self.folder_level_operator:
			 op = self.processing_class.val.resize_slice_matrix(this_file, indices=slices_str, folder_parallel_processing=True)
		 else:
			 op = self.processing_class.val.resize_slice_matrix(this_file, indices=slices_str, folder_parallel_processing=False)
		 if blocking:
			 self.processing_class.execute()
		 return op

	 def __setitem__(self, *args, output_key = 0, blocking=True):
		 if not self._check_op_is_value_type(self, output_key):
			 raise RuntimeError('Cannot use slice operator on non-value type. Please convert from {scope} to value type first.')
		 slices_str = ''
		 indices = args[0]
		 assignment_val = args[1]
		 this_file = self.io(output_key, 'out')
		 if isinstance(indices, AIPHAOperator):
			 mask_file = indices.io(0, 'out')
			 if isinstance(assignment_val, int) or isinstance(assignment_val, float):
				 if self.folder_level_operator:
					 return self.processing_class.val.masked_assign_constant(this_file, path_mask_in=mask_file, constant=assignment_val, folder_parallel_processing=True)
				 else:
					 return self.processing_class.val.masked_assign_constant(this_file, path_mask_in=mask_file, constant=assignment_val, folder_parallel_processing=False)
			 value_file = assignment_val.io(0, 'out')
			 if self.folder_level_operator:
				 return self.processing_class.val.values_masked_assign(this_file, value_file, path_mask_in=mask_file, folder_parallel_processing=True)
			 else:
				 return self.processing_class.val.values_masked_assign(this_file, value_file, path_mask_in=mask_file, folder_parallel_processing=False)
		 else:
			 for idx in indices:
				 if isinstance(idx, int):
				   slices_str += str(idx) + ','
				 elif isinstance(idx, slice):
				   slices_str += str(idx.start) + ':' + str(idx.stop) + ':' + str(idx.step) + ','
				 else:
				   raise RuntimeError('Invalid slice operator.')
			 slices_str = slices_str[:-1]
			 if isinstance(assignment_val, int) or isinstance(assignment_val, float):
				 if self.folder_level_operator:
					 return self.processing_class.val.sliced_assign_constant(this_file, indices=slices_str, constant=assignment_val, folder_parallel_processing=True)
				 else:
					 return self.processing_class.val.sliced_assign_constant(this_file, indices=slices_str, constant=assignment_val, folder_parallel_processing=False)
			 value_file = assignment_val.io(0, 'out')
			 if self.folder_level_operator:
				 return self.processing_class.val.values_sliced_assign(this_file, value_file, indices=slices_str, folder_parallel_processing=True)
			 else:
				 return self.processing_class.val.values_sliced_assign(this_file, value_file, indices=slices_str, folder_parallel_processing=False)

	 def _is_value_type(self, value):
		 if isinstance(value, int):
			 return True
		 if isinstance(value, float):
			 return True
		 if isinstance(value, str):
			 return True
		 return False

	 def _perform_operator(self, other, fv, fc, this_output_key, other_output_key, blocking=True):
		 if not self._check_op_is_value_type(self, this_output_key):
			 raise RuntimeError('Cannot use slice operator on non-value type. Please convert from {scope} to value type first.')
		 if not isinstance(other, AIPHAOperator) and not self._is_value_type(other):
			 raise RuntimeError('Invalid type for arithmetic operator.')
		 if isinstance(other, AIPHAOperator):
			 if not self._check_op_is_value_type(other, other_output_key):
				 raise RuntimeError('Cannot use slice operator on non-value type. Please convert from {scope} to value type first.')
			 if self.folder_level_operator != other.folder_level_operator:
				 raise RuntimeError('Cannot use arithmetic operator on operators with different folder level.')
		 if self.folder_level_operator:
			 if self._is_value_type(other):
				 op = fc(self.io(this_output_key, 'out'), constant=other, folder_parallel_processing=True)
			 else:
				 op = fv(self.io(this_output_key, 'out'), other.io(other_output_key, 'out'), folder_parallel_processing = True)
		 else:
			 if self._is_value_type(other):
				 op = fc(self.io(this_output_key, 'out'), constant=other, folder_parallel_processing=False)
			 else:
				 op = fv(self.io(this_output_key, 'out'), other.io(other_output_key, 'out'), folder_parallel_processing = False)
		 if blocking:
			 self.processing_class.execute()
		 return op

	 def __add__(self, other, this_output_key = 0, other_output_key = 0, blocking=True):
		 ffc = self.processing_class.val.add_constant
		 ffv = self.processing_class.val.values_add
		 return self._perform_operator(other, ffv, ffc, this_output_key, other_output_key, blocking)

	 def __sub__(self, other, this_output_key = 0, other_output_key = 0, blocking=True):
		 ffc = self.processing_class.val.subtract_constant
		 ffv = self.processing_class.val.values_subtract
		 return self._perform_operator(other, ffv, ffc, this_output_key, other_output_key, blocking)

	 def __mul__(self, other, this_output_key = 0, other_output_key = 0, blocking=True):
		 ffc = self.processing_class.val.multiply_constant
		 ffv = self.processing_class.val.values_multiply
		 return self._perform_operator(other, ffv, ffc, this_output_key, other_output_key, blocking)

	 def __truediv__(self, other, this_output_key = 0, other_output_key = 0, blocking=True):
		 ffc = self.processing_class.val.divide_constant
		 ffv = self.processing_class.val.values_divide
		 return self._perform_operator(other, ffv, ffc, this_output_key, other_output_key, blocking)

	 def __eq__(self, other, this_output_key = 0, other_output_key = 0, blocking=True):
		 ffc = self.processing_class.val.equal_constant
		 ffv = self.processing_class.val.values_equal
		 return self._perform_operator(other, ffv, ffc, this_output_key, other_output_key, blocking)

	 def __ne__(self, other, this_output_key = 0, other_output_key = 0, blocking=True):
		 ffc = self.processing_class.val.not_equal_constant
		 ffv = self.processing_class.val.values_not_equal
		 return self._perform_operator(other, ffv, ffc, this_output_key, other_output_key, blocking)

	 def __lt__(self, other, this_output_key = 0, other_output_key = 0, blocking=True):
		 ffc = self.processing_class.val.less_constant
		 ffv = self.processing_class.val.values_less
		 return self._perform_operator(other, ffv, ffc, this_output_key, other_output_key, blocking)

	 def __gt__(self, other, this_output_key = 0, other_output_key = 0, blocking=True):
		 ffc = self.processing_class.val.greater_constant
		 ffv = self.processing_class.val.values_greater
		 return self._perform_operator(other, ffv, ffc, this_output_key, other_output_key, blocking)

	 def __ge__(self, other, this_output_key = 0, other_output_key = 0, blocking=True):
		 ffc = self.processing_class.val.greater_equal_constant
		 ffv = self.processing_class.val.values_greater_equal
		 return self._perform_operator(other, ffv, ffc, this_output_key, other_output_key, blocking)

	 def __le__(self, other, this_output_key = 0, other_output_key = 0, blocking=True):
		 ffc = self.processing_class.val.less_equal_constant
		 ffv = self.processing_class.val.values_less_equal
		 return self._perform_operator(other, ffv, ffc, this_output_key, other_output_key, blocking)


class AIPHAProcessing:
	 '''
        AIPHAProcessing class for data processing with AIPHA API.
	 '''

	 def __init__(self, 
                client, 
                processing_folder = 'processing', 
                worker_instance_type = 'P2', 
                manager_instance_type = 'small'):

		 ''' 
			 :param client: AIPHA client object
			 :param processing_folder: folder for processing
			 :param worker_instance_type: instance type for worker
			 :param manager_instance_type: instance type for manager

		 '''

		 self.client = client
		 self.processing_folder = processing_folder
		 self.call_stack = []
		 self.worker_instance_type = worker_instance_type
		 self.manager_instance_type = manager_instance_type
		 self.unique_id = -1
		 self.random_number = np.random.randint(0, 1000)
		 self._init_inner_classes()
		 self._create_processing_folder()

	 def _add_call_stack(self, operator : AIPHAOperator):
		 self.call_stack.append(operator)
		 while len(self.call_stack) > 100:
			 if self.call_stack[0].get_executed():
				 self.call_stack = self.call_stack[1:]
			 else:
				 break

	 def _get_call_stack(self):
		 return self.call_stack

	 def get_instance_types(self):
		 return self.worker_instance_type, self.manager_instance_type

	 def set_instance_types(self, worker_instance_type, manager_instance_type='small'):
		 self.worker_instance_type = worker_instance_type
		 self.manager_instance_type = manager_instance_type

	 def get_unique_id(self):
		 self.unique_id += 1
		 return str(self.random_number) + '_' + str(self.unique_id)

	 def execute(self):
		 ''' 
         Execute the call stack.
		 '''

		 pids = []
		 for idx in range(len(self.call_stack)):
			 operator = self.call_stack[idx]
			 if operator.get_executed() == False:
				 pids.append(operator.get_result_promise())
				 operator.set_executed(True)
		 ao.wait_for_completion(self.client, pids)

	 def _check_folder_level_processing(self, folder_parallel_processing, params_dict, has_file_parameter):
		 if folder_parallel_processing == '__auto__':
			 if not has_file_parameter:
				 return False
			 for param in params_dict:
				 if '.' in params_dict[param]:
					 return False
			 return True
		 if folder_parallel_processing == True:
			 return True
		 if folder_parallel_processing == False:
			 return False

	 def _remap_parameters(self, params_dict, params_map):
		 out_dict = {}
		 for idx in params_dict:    
			 if idx in params_map:
				 out_dict[params_map[idx]] = params_dict[idx]
			 else:
				 out_dict[idx] = params_dict[idx]
		 return out_dict


	 def _get_param_subset(self, params, names):
		 params_subset = {}
		 for name in names:
			 params_subset[name] = params[name]
		 return params_subset

	 class ml3d:
		 ''' 
         Namespace for ml3d functions.
		 '''

		 def __init__(self, outer_class):
			 self.outer_class = outer_class
			 self.client = outer_class.client
			 self.processing_folder = outer_class.processing_folder
			 self._get_call_stack = outer_class._get_call_stack
			 self._add_call_stack = outer_class._add_call_stack
			 self.get_unique_id = outer_class.get_unique_id
			 self.worker_instance_type, self.manager_instance_type = outer_class.get_instance_types()
			 self._check_folder_level_processing = outer_class._check_folder_level_processing
			 self._remap_parameters = outer_class._remap_parameters
			 self._get_param_subset = outer_class._get_param_subset


		 def evaluate_semantic_segmentation(self,
			prediction_path='__auto__', 
			ground_truth_path='__auto__', 
			class_names='1,2,3,4', 
			invalid_label=0,
			extension_prediction_path = '.labels',
			extension_ground_truth_path = '.labels',
			folder_parallel_processing = '__auto__'):
			 '''
				Evaluate semantic segmentation
				
				:param prediction_path: Path to prediction folder or folder
				:param ground_truth_path: Path to ground truth folder or folder
				:param class_names: class names
				:param invalid_label: Invalid label
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_prediction_path', 'extension_ground_truth_path']
			 iterable_names = ['prediction_path','ground_truth_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'prediction_path': 'prediction_folder', 'ground_truth_path': 'ground_truth_folder', 'class_names': 'class_names', 'invalid_label': 'invalid_label'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['prediction_folder', 'ground_truth_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['labels', 'labels']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'evaluate_semantic_segmentation_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ml3d.evaluate_semantic_segmentation_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'prediction_path': 'prediction_path', 'ground_truth_path': 'ground_truth_path', 'class_names': 'class_names', 'invalid_label': 'invalid_label'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['prediction_path', 'ground_truth_path']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['labels', 'labels']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'evaluate_semantic_segmentation',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ml3d.evaluate_semantic_segmentation(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def semantic_training_scf(self,
			data_in_path='__auto__', 
			out_model_parameters_path='trained_model/model_1', 
			class_names='1,2,3,4,5,6,7,8', 
			feature_names='red,green,blue', 
			point_names='x,y,z', 
			label_name='classification', 
			max_epochs=500, 
			learning_rate=1e-2, 
			learning_rate_decay=0.95, 
			feature_dimensions='16,64,128,256,512', 
			batch_size=2,
			extension_data_in_path = '',
			folder_parallel_processing = '__auto__'):
			 '''
				semantic training scf
				
				:param data_in_path:  folder to folder that contains the training data
				:param out_model_parameters_path:  path to model
				:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
				:param feature_names: comma separated list of features that are provided
				:param point_names: comma separated list of point identifiers in (las/laz)
				:param label_name: label name for (las/laz)
				:param max_epochs: maximum number of epochs
				:param learning_rate: learning rate
				:param learning_rate_decay: learning rate decay
				:param feature_dimensions: feature dimensions
				:param batch_size: batch_size
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_data_in_path']
			 iterable_names = ['data_in_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'data_in_path': 'data_in_folder', 'out_model_parameters_path': 'out_model_parameters_path', 'class_names': 'class_names', 'feature_names': 'feature_names', 'point_names': 'point_names', 'label_name': 'label_name', 'max_epochs': 'max_epochs', 'learning_rate': 'learning_rate', 'learning_rate_decay': 'learning_rate_decay', 'feature_dimensions': 'feature_dimensions', 'batch_size': 'batch_size'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['data_in_folder']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_training_scf_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ml3d.semantic_training_scf_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'data_in_path': 'data_in_path', 'out_model_parameters_path': 'out_model_parameters_path', 'class_names': 'class_names', 'feature_names': 'feature_names', 'point_names': 'point_names', 'label_name': 'label_name', 'max_epochs': 'max_epochs', 'learning_rate': 'learning_rate', 'learning_rate_decay': 'learning_rate_decay', 'feature_dimensions': 'feature_dimensions', 'batch_size': 'batch_size'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['data_in_path']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_training_scf',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ml3d.semantic_training_scf(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def semantic_inference_scf(self,
			data_in_path='__auto__', 
			class_names='1,2,3,4,5,6,7,8', 
			feature_names='red,green,blue', 
			point_names='x,y,z', 
			label_name='classification', 
			feature_dimensions='12,48,96,192,384', 
			batch_size=2, 
			results_labels_path='__auto__', 
			in_model_parameters_path='results/Log_2022-11-10_11-42-05', 
			results_probabilities_path='__auto__', 
			number_of_votes=5,
			extension_data_in_path = '.laz',
			extension_results_labels_path = '.labels',
			extension_results_probabilities_path = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				semantic inference scf
				
				:param data_in_path:  folder to folder that contains the training data
				:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
				:param feature_names: comma separated list of features that are provided
				:param point_names: comma separated list of point identifiers in (las/laz)
				:param label_name: label name for (las/laz)
				:param feature_dimensions: feature dimensions
				:param batch_size: batch_size
				:param results_labels_path:  folder to labels
				:param in_model_parameters_path:  path to model
				:param results_probabilities_path:  folder to probabilities
				:param number_of_votes: number of votes to vote for a class
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_data_in_path', 'extension_results_labels_path', 'extension_results_probabilities_path']
			 iterable_names = ['data_in_path','results_labels_path','results_probabilities_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'data_in_path': 'data_in_folder', 'class_names': 'class_names', 'feature_names': 'feature_names', 'point_names': 'point_names', 'label_name': 'label_name', 'feature_dimensions': 'feature_dimensions', 'batch_size': 'batch_size', 'results_labels_path': 'results_labels_folder', 'in_model_parameters_path': 'in_model_parameters_path', 'results_probabilities_path': 'results_probabilities_folder', 'number_of_votes': 'number_of_votes'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['data_in_folder', 'results_labels_folder', 'results_probabilities_folder']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'labels', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_inference_scf_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ml3d.semantic_inference_scf_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'data_in_path': 'data_in_path', 'class_names': 'class_names', 'feature_names': 'feature_names', 'point_names': 'point_names', 'label_name': 'label_name', 'feature_dimensions': 'feature_dimensions', 'batch_size': 'batch_size', 'results_labels_path': 'results_labels_path', 'in_model_parameters_path': 'in_model_parameters_path', 'results_probabilities_path': 'results_probabilities_path', 'number_of_votes': 'number_of_votes'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['data_in_path', 'results_labels_path', 'results_probabilities_path']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'labels', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_inference_scf',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ml3d.semantic_inference_scf(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def knn_classification(self,
			in_path_to_points='__auto__', 
			in_path_from_points='__auto__', 
			out_path_labels='__auto__', 
			out_path_probs='__auto__', 
			k=3, 
			max_distance=1.0, 
			to_points_names='X,Y,Z', 
			from_point_names='X,Y,Z', 
			from_class_name='classification',
			extension_in_path_to_points = '.laz',
			extension_in_path_from_points = '.laz',
			extension_out_path_labels = '.labels',
			extension_out_path_probs = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				knn classification
				
				:param in_path_to_points: input point cloud to be labeled
				:param in_path_from_points: input reference point cloud
				:param out_path_labels: out class labels
				:param out_path_probs: out class probabilities
				:param k: number of neighbors
				:param max_distance: maximum distance
				:param to_points_names: names of points to be labeled
				:param from_point_names: names of reference points
				:param from_class_name: name of reference classification
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_path_to_points', 'extension_in_path_from_points', 'extension_out_path_labels', 'extension_out_path_probs']
			 iterable_names = ['in_path_to_points','in_path_from_points','out_path_labels','out_path_probs']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_path_to_points': 'in_folder_to_points', 'in_path_from_points': 'in_folder_from_points', 'out_path_labels': 'out_folder_labels', 'out_path_probs': 'out_folder_probs', 'k': 'k', 'max_distance': 'max_distance', 'to_points_names': 'to_points_names', 'from_point_names': 'from_point_names', 'from_class_name': 'from_class_name'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_folder_to_points', 'in_folder_from_points', 'out_folder_labels', 'out_folder_probs']
				 itertable_iotypes = ['in', 'in', 'out', 'out']
				 iterable_file_types = ['laz', 'laz', 'labels', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'knn_classification_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ml3d.knn_classification_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_path_to_points': 'in_path_to_points', 'in_path_from_points': 'in_path_from_points', 'out_path_labels': 'out_path_labels', 'out_path_probs': 'out_path_probs', 'k': 'k', 'max_distance': 'max_distance', 'to_points_names': 'to_points_names', 'from_point_names': 'from_point_names', 'from_class_name': 'from_class_name'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_path_to_points', 'in_path_from_points', 'out_path_labels', 'out_path_probs']
				 itertable_iotypes = ['in', 'in', 'out', 'out']
				 iterable_file_types = ['laz', 'laz', 'labels', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'knn_classification',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ml3d.knn_classification(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def semantic_training_rfcr(self,
			data_in_path='__auto__', 
			out_model_parameters_path='trained_model/model_1', 
			class_names='1,2,3,4,5,6,7,8', 
			feature_names='red,green,blue', 
			point_names='x,y,z', 
			label_name='classification', 
			resolution=0.06, 
			max_epochs=500, 
			learning_rate=0.01, 
			batch_size=10, 
			learning_rate_decay=0.1, 
			learning_momentum=0.98, 
			learning_gradient_clip_norm=100, 
			first_features_dim=128,
			extension_data_in_path = '',
			folder_parallel_processing = '__auto__'):
			 '''
				semantic training rfcr
				
				:param data_in_path:  folder to folder that contains the training data
				:param out_model_parameters_path:  path to model
				:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
				:param feature_names: comma separated list of features that are provided
				:param point_names: comma separated list of point identifiers in (las/laz)
				:param label_name: label name for (las/laz)
				:param resolution: resolution of the subsampled point cloud
				:param max_epochs: maximum number of epochs
				:param learning_rate: learning rate
				:param batch_size: batch size
				:param learning_rate_decay: learning rate decay
				:param learning_momentum: learning momentum
				:param learning_gradient_clip_norm: learning gradient clip threshold
				:param first_features_dim: first features dimension
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_data_in_path']
			 iterable_names = ['data_in_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'data_in_path': 'data_in_folder', 'out_model_parameters_path': 'out_model_parameters_path', 'class_names': 'class_names', 'feature_names': 'feature_names', 'point_names': 'point_names', 'label_name': 'label_name', 'resolution': 'resolution', 'max_epochs': 'max_epochs', 'learning_rate': 'learning_rate', 'batch_size': 'batch_size', 'learning_rate_decay': 'learning_rate_decay', 'learning_momentum': 'learning_momentum', 'learning_gradient_clip_norm': 'learning_gradient_clip_norm', 'first_features_dim': 'first_features_dim'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['data_in_folder']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_training_rfcr_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ml3d.semantic_training_rfcr_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'data_in_path': 'data_in_path', 'out_model_parameters_path': 'out_model_parameters_path', 'class_names': 'class_names', 'feature_names': 'feature_names', 'point_names': 'point_names', 'label_name': 'label_name', 'resolution': 'resolution', 'max_epochs': 'max_epochs', 'learning_rate': 'learning_rate', 'batch_size': 'batch_size', 'learning_rate_decay': 'learning_rate_decay', 'learning_momentum': 'learning_momentum', 'learning_gradient_clip_norm': 'learning_gradient_clip_norm', 'first_features_dim': 'first_features_dim'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['data_in_path']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_training_rfcr',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ml3d.semantic_training_rfcr(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def semantic_inference_rfcr(self,
			data_in_path='__auto__', 
			results_labels_path='__auto__', 
			results_probabilities_path='__auto__', 
			in_model_parameters_path='results/Log_2022-11-10_11-42-05', 
			number_of_votes=5, 
			feature_names='red,green,blue', 
			point_names='x,y,z',
			extension_data_in_path = '.laz',
			extension_results_labels_path = '.labels',
			extension_results_probabilities_path = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				semantic inference rfcr
				
				:param data_in_path:  folder to data
				:param results_labels_path:  folder to labels
				:param results_probabilities_path:  folder to probabilities
				:param in_model_parameters_path:  path to model
				:param number_of_votes: number of votes to vote for a class
				:param feature_names: comma separated list of features that are provided
				:param point_names: comma separated list of point identifiers in (las/laz)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_data_in_path', 'extension_results_labels_path', 'extension_results_probabilities_path']
			 iterable_names = ['data_in_path','results_labels_path','results_probabilities_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'data_in_path': 'data_in_folder', 'results_labels_path': 'results_labels_folder', 'results_probabilities_path': 'results_probabilities_folder', 'in_model_parameters_path': 'in_model_parameters_path', 'number_of_votes': 'number_of_votes', 'feature_names': 'feature_names', 'point_names': 'point_names'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['data_in_folder', 'results_labels_folder', 'results_probabilities_folder']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'labels', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_inference_rfcr_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ml3d.semantic_inference_rfcr_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'data_in_path': 'data_in_path', 'results_labels_path': 'results_labels_path', 'results_probabilities_path': 'results_probabilities_path', 'in_model_parameters_path': 'in_model_parameters_path', 'number_of_votes': 'number_of_votes', 'feature_names': 'feature_names', 'point_names': 'point_names'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['data_in_path', 'results_labels_path', 'results_probabilities_path']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'labels', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_inference_rfcr',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ml3d.semantic_inference_rfcr(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def semantic_inference_pt_v2m2(self,
			data_in_path='__auto__', 
			in_model_parameters_path='trained_model/model_ptv2m2', 
			out_label_path='__auto__', 
			out_probability_path='__auto__', 
			class_names='1,2,3,4,5,6,7,8', 
			feature_names='red,green,blue', 
			point_names='X,Y,Z', 
			label_name='classification', 
			resolution=0.05, 
			number_of_votes=5,
			extension_data_in_path = '.laz',
			extension_out_label_path = '.labels',
			extension_out_probability_path = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				PT v2m2 Inference
				
				:param data_in_path:  folder that contains the test data
				:param in_model_parameters_path:  path to model
				:param out_label_path:  folder that contains the results
				:param out_probability_path:  folder that contains the results
				:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
				:param feature_names: comma separated list of features that are provided
				:param point_names: comma separated list of point identifiers in (las/laz)
				:param label_name: label name for (las/laz)
				:param resolution: resolution of the subsampled point cloud
				:param number_of_votes: number of votes
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_data_in_path', 'extension_out_label_path', 'extension_out_probability_path']
			 iterable_names = ['data_in_path','out_label_path','out_probability_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'data_in_path': 'data_in_folder', 'in_model_parameters_path': 'in_model_parameters_path', 'out_label_path': 'out_label_folder', 'out_probability_path': 'out_probability_folder', 'class_names': 'class_names', 'feature_names': 'feature_names', 'point_names': 'point_names', 'label_name': 'label_name', 'resolution': 'resolution', 'number_of_votes': 'number_of_votes'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['data_in_folder', 'out_label_folder', 'out_probability_folder']
				 itertable_iotypes = ['in', 'out', 'out']
				 iterable_file_types = ['laz', 'labels', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_inference_pt_v2m2_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ml3d.semantic_inference_pt_v2m2_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'data_in_path': 'data_in_path', 'in_model_parameters_path': 'in_model_parameters_path', 'out_label_path': 'out_label_path', 'out_probability_path': 'out_probability_path', 'class_names': 'class_names', 'feature_names': 'feature_names', 'point_names': 'point_names', 'label_name': 'label_name', 'resolution': 'resolution', 'number_of_votes': 'number_of_votes'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['data_in_path', 'out_label_path', 'out_probability_path']
				 itertable_iotypes = ['in', 'out', 'out']
				 iterable_file_types = ['laz', 'labels', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_inference_pt_v2m2',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ml3d.semantic_inference_pt_v2m2(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def semantic_inference_pt_v3m1(self,
			data_in_path='__auto__', 
			in_model_parameters_path='trained_model/model_ptv2m2', 
			out_label_path='__auto__', 
			out_probability_path='__auto__', 
			class_names='1,2,3,4,5,6,7,8', 
			feature_names='red,green,blue', 
			point_names='X,Y,Z', 
			label_name='classification', 
			resolution=0.05, 
			number_of_votes=5,
			extension_data_in_path = '.laz',
			extension_out_label_path = '.labels',
			extension_out_probability_path = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				PT v3m1 Inference
				
				:param data_in_path:  folder that contains the test data
				:param in_model_parameters_path:  path to model
				:param out_label_path:  folder that contains the results
				:param out_probability_path:  folder that contains the results
				:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
				:param feature_names: comma separated list of features that are provided
				:param point_names: comma separated list of point identifiers in (las/laz)
				:param label_name: label name for (las/laz)
				:param resolution: resolution of the subsampled point cloud
				:param number_of_votes: number of votes
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_data_in_path', 'extension_out_label_path', 'extension_out_probability_path']
			 iterable_names = ['data_in_path','out_label_path','out_probability_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'data_in_path': 'data_in_folder', 'in_model_parameters_path': 'in_model_parameters_path', 'out_label_path': 'out_label_folder', 'out_probability_path': 'out_probability_folder', 'class_names': 'class_names', 'feature_names': 'feature_names', 'point_names': 'point_names', 'label_name': 'label_name', 'resolution': 'resolution', 'number_of_votes': 'number_of_votes'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['data_in_folder', 'out_label_folder', 'out_probability_folder']
				 itertable_iotypes = ['in', 'out', 'out']
				 iterable_file_types = ['laz', 'labels', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_inference_pt_v3m1_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ml3d.semantic_inference_pt_v3m1_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'data_in_path': 'data_in_path', 'in_model_parameters_path': 'in_model_parameters_path', 'out_label_path': 'out_label_path', 'out_probability_path': 'out_probability_path', 'class_names': 'class_names', 'feature_names': 'feature_names', 'point_names': 'point_names', 'label_name': 'label_name', 'resolution': 'resolution', 'number_of_votes': 'number_of_votes'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['data_in_path', 'out_label_path', 'out_probability_path']
				 itertable_iotypes = ['in', 'out', 'out']
				 iterable_file_types = ['laz', 'labels', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_inference_pt_v3m1',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ml3d.semantic_inference_pt_v3m1(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def semantic_inference_spunet(self,
			data_in_path='__auto__', 
			in_model_parameters_path='trained_model/model_1', 
			out_label_path='__auto__', 
			out_probability_path='__auto__', 
			class_names='1,2,3,4,5,6,7,8', 
			feature_names='red,green,blue', 
			point_names='X,Y,Z', 
			label_name='classification', 
			resolution=0.05, 
			channels='32,64,128,256,256,128,96,96', 
			layers='2,3,4,6,2,2,2,2', 
			number_of_votes=5,
			extension_data_in_path = '.laz',
			extension_out_label_path = '.labels',
			extension_out_probability_path = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Spunet Inference
				
				:param data_in_path:  folder that contains the test data
				:param in_model_parameters_path:  path to model
				:param out_label_path:  folder that contains the results
				:param out_probability_path:  folder that contains the results
				:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
				:param feature_names: comma separated list of features that are provided
				:param point_names: comma separated list of point identifiers in (las/laz)
				:param label_name: label name for (las/laz)
				:param resolution: resolution of the subsampled point cloud
				:param channels: comma separated list of channels
				:param layers: comma separated list of layers
				:param number_of_votes: number of votes
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_data_in_path', 'extension_out_label_path', 'extension_out_probability_path']
			 iterable_names = ['data_in_path','out_label_path','out_probability_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'data_in_path': 'data_in_folder', 'in_model_parameters_path': 'in_model_parameters_path', 'out_label_path': 'out_label_folder', 'out_probability_path': 'out_probability_folder', 'class_names': 'class_names', 'feature_names': 'feature_names', 'point_names': 'point_names', 'label_name': 'label_name', 'resolution': 'resolution', 'channels': 'channels', 'layers': 'layers', 'number_of_votes': 'number_of_votes'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['data_in_folder', 'out_label_folder', 'out_probability_folder']
				 itertable_iotypes = ['in', 'out', 'out']
				 iterable_file_types = ['laz', 'labels', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_inference_spunet_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ml3d.semantic_inference_spunet_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'data_in_path': 'data_in_path', 'in_model_parameters_path': 'in_model_parameters_path', 'out_label_path': 'out_label_path', 'out_probability_path': 'out_probability_path', 'class_names': 'class_names', 'feature_names': 'feature_names', 'point_names': 'point_names', 'label_name': 'label_name', 'resolution': 'resolution', 'channels': 'channels', 'layers': 'layers', 'number_of_votes': 'number_of_votes'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['data_in_path', 'out_label_path', 'out_probability_path']
				 itertable_iotypes = ['in', 'out', 'out']
				 iterable_file_types = ['laz', 'labels', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_inference_spunet',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ml3d.semantic_inference_spunet(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def semantic_training_pt_v2m2(self,
			data_in_path='__auto__', 
			out_model_parameters_path='trained_model/model_ptv2m2', 
			class_names='1,2,3,4,5,6,7,8', 
			feature_names='red,green,blue', 
			point_names='X,Y,Z', 
			label_name='classification', 
			resolution=0.05, 
			max_epochs=500, 
			learning_rate=0.01, 
			batch_size=10, 
			final_div_factor=100, 
			div_factor=10, 
			weight_decay=0.005,
			extension_data_in_path = '',
			folder_parallel_processing = '__auto__'):
			 '''
				Pt v2m2 Training
				
				:param data_in_path:  folder to folder that contains the training data
				:param out_model_parameters_path:  path to model
				:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
				:param feature_names: comma separated list of features that are provided
				:param point_names: comma separated list of point identifiers in (las/laz)
				:param label_name: label name for (las/laz)
				:param resolution: resolution of the subsampled point cloud
				:param max_epochs: maximum number of epochs
				:param learning_rate: learning rate
				:param batch_size: batch size
				:param final_div_factor: final div factor for learning rate
				:param div_factor: div factor for learning rate
				:param weight_decay: weight decay
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_data_in_path']
			 iterable_names = ['data_in_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'data_in_path': 'data_in_folder', 'out_model_parameters_path': 'out_model_parameters_path', 'class_names': 'class_names', 'feature_names': 'feature_names', 'point_names': 'point_names', 'label_name': 'label_name', 'resolution': 'resolution', 'max_epochs': 'max_epochs', 'learning_rate': 'learning_rate', 'batch_size': 'batch_size', 'final_div_factor': 'final_div_factor', 'div_factor': 'div_factor', 'weight_decay': 'weight_decay'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['data_in_folder']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_training_pt_v2m2_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ml3d.semantic_training_pt_v2m2_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'data_in_path': 'data_in_path', 'out_model_parameters_path': 'out_model_parameters_path', 'class_names': 'class_names', 'feature_names': 'feature_names', 'point_names': 'point_names', 'label_name': 'label_name', 'resolution': 'resolution', 'max_epochs': 'max_epochs', 'learning_rate': 'learning_rate', 'batch_size': 'batch_size', 'final_div_factor': 'final_div_factor', 'div_factor': 'div_factor', 'weight_decay': 'weight_decay'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['data_in_path']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_training_pt_v2m2',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ml3d.semantic_training_pt_v2m2(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def semantic_training_pt_v3m1(self,
			data_in_path='__auto__', 
			out_model_parameters_path='trained_model/model_ptv2m2', 
			class_names='1,2,3,4,5,6,7,8', 
			feature_names='red,green,blue', 
			point_names='X,Y,Z', 
			label_name='classification', 
			resolution=0.05, 
			max_epochs=500, 
			learning_rate=0.01, 
			batch_size=10, 
			final_div_factor=100, 
			div_factor=10, 
			weight_decay=0.005,
			extension_data_in_path = '',
			folder_parallel_processing = '__auto__'):
			 '''
				Pt v3m1 Training
				
				:param data_in_path:  folder to folder that contains the training data
				:param out_model_parameters_path:  path to model
				:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
				:param feature_names: comma separated list of features that are provided
				:param point_names: comma separated list of point identifiers in (las/laz)
				:param label_name: label name for (las/laz)
				:param resolution: resolution of the subsampled point cloud
				:param max_epochs: maximum number of epochs
				:param learning_rate: learning rate
				:param batch_size: batch size
				:param final_div_factor: final div factor for learning rate
				:param div_factor: div factor for learning rate
				:param weight_decay: weight decay
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_data_in_path']
			 iterable_names = ['data_in_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'data_in_path': 'data_in_folder', 'out_model_parameters_path': 'out_model_parameters_path', 'class_names': 'class_names', 'feature_names': 'feature_names', 'point_names': 'point_names', 'label_name': 'label_name', 'resolution': 'resolution', 'max_epochs': 'max_epochs', 'learning_rate': 'learning_rate', 'batch_size': 'batch_size', 'final_div_factor': 'final_div_factor', 'div_factor': 'div_factor', 'weight_decay': 'weight_decay'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['data_in_folder']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_training_pt_v3m1_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ml3d.semantic_training_pt_v3m1_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'data_in_path': 'data_in_path', 'out_model_parameters_path': 'out_model_parameters_path', 'class_names': 'class_names', 'feature_names': 'feature_names', 'point_names': 'point_names', 'label_name': 'label_name', 'resolution': 'resolution', 'max_epochs': 'max_epochs', 'learning_rate': 'learning_rate', 'batch_size': 'batch_size', 'final_div_factor': 'final_div_factor', 'div_factor': 'div_factor', 'weight_decay': 'weight_decay'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['data_in_path']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_training_pt_v3m1',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ml3d.semantic_training_pt_v3m1(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def semantic_training_spunet(self,
			data_in_path='__auto__', 
			out_model_parameters_path='trained_model/model_1', 
			class_names='1,2,3,4,5,6,7,8', 
			feature_names='red,green,blue', 
			point_names='X,Y,Z', 
			label_name='classification', 
			resolution=0.05, 
			max_epochs=500, 
			learning_rate=0.01, 
			batch_size=10, 
			final_div_factor=100, 
			div_factor=10, 
			weight_decay=0.005, 
			channels='32,64,128,256,256,128,96,96', 
			layers='2,3,4,6,2,2,2,2',
			extension_data_in_path = '',
			folder_parallel_processing = '__auto__'):
			 '''
				Spunet Training
				
				:param data_in_path:  folder to folder that contains the training data
				:param out_model_parameters_path:  path to model
				:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
				:param feature_names: comma separated list of features that are provided
				:param point_names: comma separated list of point identifiers in (las/laz)
				:param label_name: label name for (las/laz)
				:param resolution: resolution of the subsampled point cloud
				:param max_epochs: maximum number of epochs
				:param learning_rate: learning rate
				:param batch_size: batch size
				:param final_div_factor: final div factor for learning rate
				:param div_factor: div factor for learning rate
				:param weight_decay: weight decay
				:param channels: comma separated list of channels
				:param layers: comma separated list of layers
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_data_in_path']
			 iterable_names = ['data_in_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'data_in_path': 'data_in_folder', 'out_model_parameters_path': 'out_model_parameters_path', 'class_names': 'class_names', 'feature_names': 'feature_names', 'point_names': 'point_names', 'label_name': 'label_name', 'resolution': 'resolution', 'max_epochs': 'max_epochs', 'learning_rate': 'learning_rate', 'batch_size': 'batch_size', 'final_div_factor': 'final_div_factor', 'div_factor': 'div_factor', 'weight_decay': 'weight_decay', 'channels': 'channels', 'layers': 'layers'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['data_in_folder']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_training_spunet_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ml3d.semantic_training_spunet_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'data_in_path': 'data_in_path', 'out_model_parameters_path': 'out_model_parameters_path', 'class_names': 'class_names', 'feature_names': 'feature_names', 'point_names': 'point_names', 'label_name': 'label_name', 'resolution': 'resolution', 'max_epochs': 'max_epochs', 'learning_rate': 'learning_rate', 'batch_size': 'batch_size', 'final_div_factor': 'final_div_factor', 'div_factor': 'div_factor', 'weight_decay': 'weight_decay', 'channels': 'channels', 'layers': 'layers'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['data_in_path']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'semantic_training_spunet',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ml3d.semantic_training_spunet(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def wireframe_estimation_inference(self,
			in_paths='__auto__', 
			out_result_paths='__auto__', 
			in_model_path='parameters_wireframe', 
			knn_line=15, 
			mode_wireframe_estimation='knn unassigned', 
			num_votes=10, 
			rotation_axis='z',
			extension_in_files = '',
			extension_out_result_files = '',
			folder_parallel_processing = '__auto__'):
			 '''
				[hidden] Wireframe estimation inference
				
				:param in_paths: input folders or directory with training data
				:param out_result_paths: output folders containing the wireframes
				:param in_model_path:  model path
				:param knn_line: knn line
				:param mode_wireframe_estimation: mode for wireframe estimation
				:param num_votes: number of votes for wireframe estimation
				:param rotation_axis: rotation axis
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_files', 'extension_out_result_files']
			 iterable_names = ['in_paths','out_result_paths']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_paths': 'in_folders', 'out_result_paths': 'out_result_folders', 'in_model_path': 'in_model_path', 'knn_line': 'knn_line', 'mode_wireframe_estimation': 'mode_wireframe_estimation', 'num_votes': 'num_votes', 'rotation_axis': 'rotation_axis'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_folders', 'out_result_folders']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'wireframe_estimation_inference_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ml3d.wireframe_estimation_inference_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_paths': 'in_files', 'out_result_paths': 'out_result_files', 'in_model_path': 'in_model_path', 'knn_line': 'knn_line', 'mode_wireframe_estimation': 'mode_wireframe_estimation', 'num_votes': 'num_votes', 'rotation_axis': 'rotation_axis'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_files', 'out_result_files']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'wireframe_estimation_inference',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ml3d.wireframe_estimation_inference(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def vertices_estimation_inference(self,
			in_paths='__auto__', 
			out_paths='__auto__', 
			in_model_path='parameters_model_test', 
			batch_size=1,
			extension_in_files = '',
			extension_out_files = '',
			folder_parallel_processing = '__auto__'):
			 '''
				vertices estimation inference
				
				:param in_paths: input folders or directory with training data
				:param out_paths: output folders containing the vertices
				:param in_model_path:  model path
				:param batch_size: batch size for training
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_files', 'extension_out_files']
			 iterable_names = ['in_paths','out_paths']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_paths': 'in_folders', 'out_paths': 'out_folders', 'in_model_path': 'in_model_path', 'batch_size': 'batch_size'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_folders', 'out_folders']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'vertices_estimation_inference_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ml3d.vertices_estimation_inference_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_paths': 'in_files', 'out_paths': 'out_files', 'in_model_path': 'in_model_path', 'batch_size': 'batch_size'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_files', 'out_files']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'vertices_estimation_inference',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ml3d.vertices_estimation_inference(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def wireframe_estimation_training(self,
			in_path='data_train', 
			in_wireframe_path='data_train_wireframe', 
			out_model_path='parameters_wireframe_14A_bce_interpolation', 
			voxel_size=0.02, 
			zero_centering='True', 
			point_names='X,Y,Z', 
			feature_names='', 
			label_names='classification', 
			num_classes=1, 
			label_scales='0.01', 
			learning_rate=5e-6, 
			learning_decay=0.999, 
			num_epochs=2000000, 
			regularization_decay=1e-10, 
			batch_size=5 , 
			save_after_epochs=1, 
			backbone_type='MinkUNet14A', 
			head_type_prob='HeadPointwise', 
			criterion_type_prob='BCEMean', 
			hidden_layers=8, 
			max_interpolation_distance=0.75, 
			dist_threshold=0.35, 
			score_threshold=0.5, 
			point_estimation_layers=3, 
			point_estimation_channels=32, 
			criterion_type_point='L1Mean', 
			wireframe_criterion_type='BCEMean', 
			wireframe_estimation_layers=3, 
			wireframe_estimation_channels=32, 
			weight_pred=2, 
			weight_prob=6.5, 
			weight_reconstruction=4.5, 
			weight_wireframe=9, 
			knn_line=10, 
			distance_line=0.3, 
			probabilistic='True', 
			store_in_memory='True', 
			mode_wireframe_estimation='knn', 
			maximum_wireframe_samples=2500, 
			wireframe_subsampling=5, 
			wireframe_extrapolation_sampling=2, 
			only_train_wireframe='False',

			folder_parallel_processing = '__auto__'):
			 '''
				[hidden] wireframe estimation training
				
				:param in_path: input directory with training data
				:param in_wireframe_path: input directory with corresponding wireframe data
				:param out_model_path:  model path
				:param voxel_size: voxel size
				:param zero_centering: zero centering
				:param point_names: point names
				:param feature_names: feature names
				:param label_names: label names
				:param num_classes: number of classes
				:param label_scales: label scales
				:param learning_rate: learning rate
				:param learning_decay: learning rate decay
				:param num_epochs: number of epochs
				:param regularization_decay: regularization decay
				:param batch_size: batch size for training
				:param save_after_epochs: save after epochs
				:param backbone_type: model type of backbone network
				:param head_type_prob: model type of head network
				:param criterion_type_prob: model type of criterion
				:param hidden_layers: number of hidden layers
				:param max_interpolation_distance: maximum distance to interpolate occluded points
				:param dist_threshold: distance threshold for non-maxima suppression
				:param score_threshold: score threshold for non-maxima suppression
				:param point_estimation_layers: number of hidden layers for point estimation
				:param point_estimation_channels: number of channels for point estimation
				:param criterion_type_point: model type of criterion for point estimation
				:param wireframe_criterion_type: model type of criterion for wireframe estimation
				:param wireframe_estimation_layers: number of hidden layers for wireframe estimation
				:param wireframe_estimation_channels: number of channels for wireframe estimation
				:param weight_pred: weight for point estimation
				:param weight_prob: weight for probability estimation
				:param weight_reconstruction: weight for reconstruction
				:param weight_wireframe: weight for wireframe estimation
				:param knn_line: number of nearest neighbours for line estimation
				:param distance_line: distance threshold for line estimation
				:param probabilistic: probabilistic
				:param store_in_memory: store in memory
				:param mode_wireframe_estimation: wireframe mode
				:param maximum_wireframe_samples: maximum number of wireframe samples
				:param wireframe_subsampling: wireframe subsampling factor
				:param wireframe_extrapolation_sampling: wireframe extrapolation sampling factor
				:param only_train_wireframe: only train wireframe
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = []
			 iterable_names = []
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_path': 'in_path', 'in_wireframe_path': 'in_wireframe_path', 'out_model_path': 'out_model_path', 'voxel_size': 'voxel_size', 'zero_centering': 'zero_centering', 'point_names': 'point_names', 'feature_names': 'feature_names', 'label_names': 'label_names', 'num_classes': 'num_classes', 'label_scales': 'label_scales', 'learning_rate': 'learning_rate', 'learning_decay': 'learning_decay', 'num_epochs': 'num_epochs', 'regularization_decay': 'regularization_decay', 'batch_size': 'batch_size', 'save_after_epochs': 'save_after_epochs', 'backbone_type': 'backbone_type', 'head_type_prob': 'head_type_prob', 'criterion_type_prob': 'criterion_type_prob', 'hidden_layers': 'hidden_layers', 'max_interpolation_distance': 'max_interpolation_distance', 'dist_threshold': 'dist_threshold', 'score_threshold': 'score_threshold', 'point_estimation_layers': 'point_estimation_layers', 'point_estimation_channels': 'point_estimation_channels', 'criterion_type_point': 'criterion_type_point', 'wireframe_criterion_type': 'wireframe_criterion_type', 'wireframe_estimation_layers': 'wireframe_estimation_layers', 'wireframe_estimation_channels': 'wireframe_estimation_channels', 'weight_pred': 'weight_pred', 'weight_prob': 'weight_prob', 'weight_reconstruction': 'weight_reconstruction', 'weight_wireframe': 'weight_wireframe', 'knn_line': 'knn_line', 'distance_line': 'distance_line', 'probabilistic': 'probabilistic', 'store_in_memory': 'store_in_memory', 'mode_wireframe_estimation': 'mode_wireframe_estimation', 'maximum_wireframe_samples': 'maximum_wireframe_samples', 'wireframe_subsampling': 'wireframe_subsampling', 'wireframe_extrapolation_sampling': 'wireframe_extrapolation_sampling', 'only_train_wireframe': 'only_train_wireframe'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'wireframe_estimation_training_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ml3d.wireframe_estimation_training_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_path': 'in_folder', 'in_wireframe_path': 'in_wireframe_folder', 'out_model_path': 'out_model_path', 'voxel_size': 'voxel_size', 'zero_centering': 'zero_centering', 'point_names': 'point_names', 'feature_names': 'feature_names', 'label_names': 'label_names', 'num_classes': 'num_classes', 'label_scales': 'label_scales', 'learning_rate': 'learning_rate', 'learning_decay': 'learning_decay', 'num_epochs': 'num_epochs', 'regularization_decay': 'regularization_decay', 'batch_size': 'batch_size', 'save_after_epochs': 'save_after_epochs', 'backbone_type': 'backbone_type', 'head_type_prob': 'head_type_prob', 'criterion_type_prob': 'criterion_type_prob', 'hidden_layers': 'hidden_layers', 'max_interpolation_distance': 'max_interpolation_distance', 'dist_threshold': 'dist_threshold', 'score_threshold': 'score_threshold', 'point_estimation_layers': 'point_estimation_layers', 'point_estimation_channels': 'point_estimation_channels', 'criterion_type_point': 'criterion_type_point', 'wireframe_criterion_type': 'wireframe_criterion_type', 'wireframe_estimation_layers': 'wireframe_estimation_layers', 'wireframe_estimation_channels': 'wireframe_estimation_channels', 'weight_pred': 'weight_pred', 'weight_prob': 'weight_prob', 'weight_reconstruction': 'weight_reconstruction', 'weight_wireframe': 'weight_wireframe', 'knn_line': 'knn_line', 'distance_line': 'distance_line', 'probabilistic': 'probabilistic', 'store_in_memory': 'store_in_memory', 'mode_wireframe_estimation': 'mode_wireframe_estimation', 'maximum_wireframe_samples': 'maximum_wireframe_samples', 'wireframe_subsampling': 'wireframe_subsampling', 'wireframe_extrapolation_sampling': 'wireframe_extrapolation_sampling', 'only_train_wireframe': 'only_train_wireframe'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'wireframe_estimation_training',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ml3d.wireframe_estimation_training(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def universal_training(self,
			in_path='data_train', 
			out_model_path='parameters_model_test', 
			voxel_size=0.02, 
			zero_centering='True', 
			point_names='X,Y,Z', 
			feature_names='', 
			label_names='classification', 
			num_classes=1, 
			label_scales='0.01', 
			learning_rate=3e-6, 
			learning_decay=0.9999, 
			num_epochs=200000, 
			regularization_decay=1e-9, 
			batch_size=2, 
			save_after_epochs=100, 
			backbone_type='MinkUNet14A', 
			head_type='HeadPointwise', 
			criterion_type='L1Sum', 
			probabilistic='True', 
			hidden_layers=8, 
			store_in_memory='True',

			folder_parallel_processing = '__auto__'):
			 '''
				universal training
				
				:param in_path: input directory with training data
				:param out_model_path:  model path
				:param voxel_size: voxel size
				:param zero_centering: zero centering
				:param point_names: point names
				:param feature_names: feature names
				:param label_names: label names
				:param num_classes: number of classes
				:param label_scales: label scales
				:param learning_rate: learning rate
				:param learning_decay: learning rate decay
				:param num_epochs: number of epochs
				:param regularization_decay: regularization decay
				:param batch_size: batch size for training
				:param save_after_epochs: save after epochs
				:param backbone_type: model type of backbone network
				:param head_type: model type of head network
				:param criterion_type: model type of criterion
				:param probabilistic: estimate probabilities: labels in [0,1]
				:param hidden_layers: number of hidden layers
				:param store_in_memory: store training data in memory
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = []
			 iterable_names = []
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_path': 'in_path', 'out_model_path': 'out_model_path', 'voxel_size': 'voxel_size', 'zero_centering': 'zero_centering', 'point_names': 'point_names', 'feature_names': 'feature_names', 'label_names': 'label_names', 'num_classes': 'num_classes', 'label_scales': 'label_scales', 'learning_rate': 'learning_rate', 'learning_decay': 'learning_decay', 'num_epochs': 'num_epochs', 'regularization_decay': 'regularization_decay', 'batch_size': 'batch_size', 'save_after_epochs': 'save_after_epochs', 'backbone_type': 'backbone_type', 'head_type': 'head_type', 'criterion_type': 'criterion_type', 'probabilistic': 'probabilistic', 'hidden_layers': 'hidden_layers', 'store_in_memory': 'store_in_memory'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'universal_training_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ml3d.universal_training_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_path': 'in_folder', 'out_model_path': 'out_model_path', 'voxel_size': 'voxel_size', 'zero_centering': 'zero_centering', 'point_names': 'point_names', 'feature_names': 'feature_names', 'label_names': 'label_names', 'num_classes': 'num_classes', 'label_scales': 'label_scales', 'learning_rate': 'learning_rate', 'learning_decay': 'learning_decay', 'num_epochs': 'num_epochs', 'regularization_decay': 'regularization_decay', 'batch_size': 'batch_size', 'save_after_epochs': 'save_after_epochs', 'backbone_type': 'backbone_type', 'head_type': 'head_type', 'criterion_type': 'criterion_type', 'probabilistic': 'probabilistic', 'hidden_layers': 'hidden_layers', 'store_in_memory': 'store_in_memory'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'universal_training',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ml3d.universal_training(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def vertices_estimation_training(self,
			in_path='data_train', 
			in_vertices_path='data_train_vertices', 
			out_model_path='parameters_model_test', 
			voxel_size=0.02, 
			zero_centering='True', 
			point_names='X,Y,Z', 
			feature_names='', 
			label_names='classification', 
			num_classes=1, 
			label_scales='0.01', 
			learning_rate=1e-5, 
			learning_decay=0.999, 
			num_epochs=2000000, 
			regularization_decay=1e-9, 
			batch_size=5 , 
			save_after_epochs=100, 
			backbone_type='MinkUNet14A', 
			head_type_prob='HeadPointwise', 
			criterion_type_prob='BCEMean', 
			hidden_layers=8, 
			max_interpolation_distance=0.75, 
			dist_threshold=0.35, 
			score_threshold=0.4, 
			point_estimation_layers=3, 
			point_estimation_channels=8, 
			criterion_type_point='L1Mean', 
			weight_pred=1.0, 
			weight_prob=2.0, 
			weight_reconstruction=4.0, 
			probabilistic='True',

			folder_parallel_processing = '__auto__'):
			 '''
				vertices estimation training
				
				:param in_path: input directory with training data
				:param in_vertices_path: input directory with corresponding vertex data
				:param out_model_path:  model path
				:param voxel_size: voxel size
				:param zero_centering: zero centering
				:param point_names: point names
				:param feature_names: feature names
				:param label_names: label names
				:param num_classes: number of classes
				:param label_scales: label scales
				:param learning_rate: learning rate
				:param learning_decay: learning rate decay
				:param num_epochs: number of epochs
				:param regularization_decay: regularization decay
				:param batch_size: batch size for training
				:param save_after_epochs: save after epochs
				:param backbone_type: model type of backbone network
				:param head_type_prob: model type of head network
				:param criterion_type_prob: model type of criterion
				:param hidden_layers: number of hidden layers
				:param max_interpolation_distance: maximum distance to interpolate occluded points
				:param dist_threshold: distance threshold for non-maximum suppression
				:param score_threshold: score threshold for non-maximum suppression
				:param point_estimation_layers: number of hidden layers for point estimation
				:param point_estimation_channels: number of channels for point estimation
				:param criterion_type_point: model type of criterion for point estimation
				:param weight_pred: weight for point estimation
				:param weight_prob: weight for probability estimation
				:param weight_reconstruction: weight for reconstruction estimation
				:param probabilistic: probabilistic
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = []
			 iterable_names = []
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_path': 'in_path', 'in_vertices_path': 'in_vertices_path', 'out_model_path': 'out_model_path', 'voxel_size': 'voxel_size', 'zero_centering': 'zero_centering', 'point_names': 'point_names', 'feature_names': 'feature_names', 'label_names': 'label_names', 'num_classes': 'num_classes', 'label_scales': 'label_scales', 'learning_rate': 'learning_rate', 'learning_decay': 'learning_decay', 'num_epochs': 'num_epochs', 'regularization_decay': 'regularization_decay', 'batch_size': 'batch_size', 'save_after_epochs': 'save_after_epochs', 'backbone_type': 'backbone_type', 'head_type_prob': 'head_type_prob', 'criterion_type_prob': 'criterion_type_prob', 'hidden_layers': 'hidden_layers', 'max_interpolation_distance': 'max_interpolation_distance', 'dist_threshold': 'dist_threshold', 'score_threshold': 'score_threshold', 'point_estimation_layers': 'point_estimation_layers', 'point_estimation_channels': 'point_estimation_channels', 'criterion_type_point': 'criterion_type_point', 'weight_pred': 'weight_pred', 'weight_prob': 'weight_prob', 'weight_reconstruction': 'weight_reconstruction', 'probabilistic': 'probabilistic'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'vertices_estimation_training_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ml3d.vertices_estimation_training_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_path': 'in_folder', 'in_vertices_path': 'in_vertices_folder', 'out_model_path': 'out_model_path', 'voxel_size': 'voxel_size', 'zero_centering': 'zero_centering', 'point_names': 'point_names', 'feature_names': 'feature_names', 'label_names': 'label_names', 'num_classes': 'num_classes', 'label_scales': 'label_scales', 'learning_rate': 'learning_rate', 'learning_decay': 'learning_decay', 'num_epochs': 'num_epochs', 'regularization_decay': 'regularization_decay', 'batch_size': 'batch_size', 'save_after_epochs': 'save_after_epochs', 'backbone_type': 'backbone_type', 'head_type_prob': 'head_type_prob', 'criterion_type_prob': 'criterion_type_prob', 'hidden_layers': 'hidden_layers', 'max_interpolation_distance': 'max_interpolation_distance', 'dist_threshold': 'dist_threshold', 'score_threshold': 'score_threshold', 'point_estimation_layers': 'point_estimation_layers', 'point_estimation_channels': 'point_estimation_channels', 'criterion_type_point': 'criterion_type_point', 'weight_pred': 'weight_pred', 'weight_prob': 'weight_prob', 'weight_reconstruction': 'weight_reconstruction', 'probabilistic': 'probabilistic'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'vertices_estimation_training',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ml3d.vertices_estimation_training(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def universal_inference(self,
			in_paths='__auto__', 
			out_paths='__auto__', 
			in_model_path='parameters_model',
			extension_in_files = '',
			extension_out_files = '',
			folder_parallel_processing = '__auto__'):
			 '''
				universal inference
				
				:param in_paths: input folders with training data
				:param out_paths: output folders with training data
				:param in_model_path:  model path
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_files', 'extension_out_files']
			 iterable_names = ['in_paths','out_paths']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_paths': 'in_folders', 'out_paths': 'out_folders', 'in_model_path': 'in_model_path'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_folders', 'out_folders']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'universal_inference_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ml3d.universal_inference_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_paths': 'in_files', 'out_paths': 'out_files', 'in_model_path': 'in_model_path'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_files', 'out_files']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'universal_inference',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ml3d.universal_inference(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ml3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



	 class sys:
		 ''' 
         Namespace for sys functions.
		 '''

		 def __init__(self, outer_class):
			 self.outer_class = outer_class
			 self.client = outer_class.client
			 self.processing_folder = outer_class.processing_folder
			 self._get_call_stack = outer_class._get_call_stack
			 self._add_call_stack = outer_class._add_call_stack
			 self.get_unique_id = outer_class.get_unique_id
			 self.worker_instance_type, self.manager_instance_type = outer_class.get_instance_types()
			 self._check_folder_level_processing = outer_class._check_folder_level_processing
			 self._remap_parameters = outer_class._remap_parameters
			 self._get_param_subset = outer_class._get_param_subset


		 def create_directory_in_cloud(self,
			destination='__auto__',
			extension_destination = '',
			folder_parallel_processing = '__auto__'):
			 '''
				create directory in cloud
				
				:param destination: Destionation location on host. default folder: ./data
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_destination']
			 iterable_names = ['destination']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'destination': 'folder_destination'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['destination']
				 itertable_iotypes = ['out']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'create_directory_in_cloud_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.sys.create_directory_in_cloud_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'destination': 'destination'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['destination']
				 itertable_iotypes = ['out']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'create_directory_in_cloud',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.sys.create_directory_in_cloud(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def upload_data_from_cloud(self,
			url='__auto__', 
			target='__auto__', 
			protocol='', 
			username='', 
			password='', 
			port=21,
			extension_url = '',
			extension_target = '',
			folder_parallel_processing = '__auto__'):
			 '''
				upload data from cloud
				
				:param url: destination URL
				:param target: Target location on host for upload. default folder: ./data
				:param protocol: protocol: : automatically try to infer protocol, ftp: ftp, sftp: sftp
				:param username: Username
				:param password: Password
				:param port: port
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_url', 'extension_target']
			 iterable_names = ['url','target']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'url': 'url', 'target': 'folder_target', 'protocol': 'protocol', 'username': 'username', 'password': 'password', 'port': 'port'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['url', 'target']
				 itertable_iotypes = ['in', 'in']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'upload_data_from_cloud_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.sys.upload_data_from_cloud_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'url': 'url', 'target': 'target', 'protocol': 'protocol', 'username': 'username', 'password': 'password', 'port': 'port'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['url', 'target']
				 itertable_iotypes = ['in', 'in']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'upload_data_from_cloud',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.sys.upload_data_from_cloud(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def select_corresponding_path(self,
			original_path='__auto__', 
			original_identifier_path='__auto__', 
			corresponding_path='__auto__', 
			output_path='__auto__', 
			selection_criteria='oldest', 
			default_value='__original__',
			extension_original_file = '.txt',
			extension_original_identifier_file = '.txt',
			extension_corresponding_file = '.txt',
			extension_output_file = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				select corresponding path
				
				:param original_path: original folders
				:param original_identifier_path: original identifiers
				:param corresponding_path: corresponding folders
				:param output_path: output folder
				:param selection_criteria: selection criteria: [oldest, newest, shortest, longest]
				:param default_value: default value if no corresponding path is found
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_original_file', 'extension_original_identifier_file', 'extension_corresponding_file', 'extension_output_file']
			 iterable_names = ['original_path','original_identifier_path','corresponding_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'original_path': 'original_folder', 'original_identifier_path': 'original_identifier_folder', 'corresponding_path': 'corresponding_folder', 'output_path': 'output_folder', 'selection_criteria': 'selection_criteria', 'default_value': 'default_value'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['original_folder', 'original_identifier_folder', 'corresponding_folder', 'output_folder']
				 itertable_iotypes = ['in', 'in', 'in', 'out']
				 iterable_file_types = ['txt', 'txt', 'txt', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'select_corresponding_path_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.sys.select_corresponding_path_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'original_path': 'original_file', 'original_identifier_path': 'original_identifier_file', 'corresponding_path': 'corresponding_file', 'output_path': 'output_file', 'selection_criteria': 'selection_criteria', 'default_value': 'default_value'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['original_file', 'original_identifier_file', 'corresponding_file', 'output_file']
				 itertable_iotypes = ['in', 'in', 'in', 'out']
				 iterable_file_types = ['txt', 'txt', 'txt', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'select_corresponding_path',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.sys.select_corresponding_path(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def remove_files_from_cloud(self,
			target='__auto__',
			extension_target = '',
			folder_parallel_processing = '__auto__'):
			 '''
				remove files from cloud
				
				:param target: Target to be deleted
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_target']
			 iterable_names = ['target']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'target': 'folder_target'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['target']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'remove_files_from_cloud_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.sys.remove_files_from_cloud_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'target': 'target'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['target']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'remove_files_from_cloud',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.sys.remove_files_from_cloud(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def split_path(self,
			in_path='__auto__', 
			out_path='__auto__', 
			split_type='filename',
			extension_in_path = '',
			extension_out_path = '',
			folder_parallel_processing = '__auto__'):
			 '''
				split path
				
				:param in_path: input folder
				:param out_path: output folder
				:param split_type: split type: [filename, dirname, basename, ext]
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_path', 'extension_out_path']
			 iterable_names = ['in_path','out_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_path': 'in_folder', 'out_path': 'out_folder', 'split_type': 'split_type'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_folder', 'out_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'split_path_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.sys.split_path_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_path': 'in_path', 'out_path': 'out_path', 'split_type': 'split_type'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_path', 'out_path']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'split_path',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.sys.split_path(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def find_file_paths(self,
			input_paths='__auto__', 
			output_paths='__auto__', 
			search_path='/search_folder', 
			replace_in='', 
			replace_out='', 
			substrings='',
			extension_input_files = '.txt',
			extension_output_files = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				find file paths
				
				:param input_paths: File containing the list of foldernames
				:param output_paths: Path to save the modified folderlist
				:param search_path:  Folder to traverse for finding files
				:param replace_in: The part to replace in the filenames
				:param replace_out: The new part to replace with
				:param substrings:  a list of substrings that need to occure in the file paths to be vallid
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_input_files', 'extension_output_files']
			 iterable_names = ['input_paths','output_paths']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'input_paths': 'input_folders', 'output_paths': 'output_folders', 'search_path': 'search_path', 'replace_in': 'replace_in', 'replace_out': 'replace_out', 'substrings': 'substrings'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['input_folders', 'output_folders']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['txt', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'find_file_paths_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.sys.find_file_paths_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'input_paths': 'input_files', 'output_paths': 'output_files', 'search_path': 'search_folder', 'replace_in': 'replace_in', 'replace_out': 'replace_out', 'substrings': 'substrings'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['input_files', 'output_files']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['txt', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'find_file_paths',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.sys.find_file_paths(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def move_file_in_cloud(self,
			target='__auto__', 
			destination='__auto__',
			extension_target = '',
			extension_destination = '',
			folder_parallel_processing = '__auto__'):
			 '''
				move file in cloud
				
				:param target: Target to be moved
				:param destination: Destination
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_target', 'extension_destination']
			 iterable_names = ['target','destination']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'target': 'folder_target', 'destination': 'folder_destination'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['target', 'destination']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'move_file_in_cloud_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.sys.move_file_in_cloud_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'target': 'target', 'destination': 'destination'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['target', 'destination']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'move_file_in_cloud',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.sys.move_file_in_cloud(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def copy_file_in_cloud(self,
			target='__auto__', 
			destination='__auto__',
			extension_target = '',
			extension_destination = '',
			folder_parallel_processing = '__auto__'):
			 '''
				copy file in cloud
				
				:param target: Target to be moved
				:param destination: Destination
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_target', 'extension_destination']
			 iterable_names = ['target','destination']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'target': 'folder_target', 'destination': 'folder_destination'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['target', 'destination']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'copy_file_in_cloud_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.sys.copy_file_in_cloud_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'target': 'target', 'destination': 'destination'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['target', 'destination']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'copy_file_in_cloud',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.sys.copy_file_in_cloud(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def touch_file_in_cloud(self,
			target='__auto__',
			extension_target = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				touch file in cloud
				
				:param target: File to be touched
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_target']
			 iterable_names = ['target']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'target': 'folder_target'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['target']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'touch_file_in_cloud_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.sys.touch_file_in_cloud_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'target': 'target'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['target']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'touch_file_in_cloud',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.sys.touch_file_in_cloud(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def select_by_identifier(self,
			original_path='original_folder', 
			original_identifier_path='__auto__', 
			output_path='output_folder',
			extension_original_identifier_file = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				select by identifier
				
				:param original_path: original folder
				:param original_identifier_path: original identifiers
				:param output_path: output folder
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_original_identifier_file']
			 iterable_names = ['original_identifier_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'original_path': 'original_path', 'original_identifier_path': 'original_identifier_folder', 'output_path': 'output_path'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['original_identifier_folder']
				 itertable_iotypes = ['out']
				 iterable_file_types = ['txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'select_by_identifier_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.sys.select_by_identifier_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'original_path': 'original_folder', 'original_identifier_path': 'original_identifier_file', 'output_path': 'output_folder'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['original_identifier_file']
				 itertable_iotypes = ['out']
				 iterable_file_types = ['txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'select_by_identifier',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.sys.select_by_identifier(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def recursive_list(self,
			target='__auto__', 
			destination='__auto__',
			extension_target = '',
			extension_destination = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				recursive list
				
				:param target: Target folder to be listed recursively
				:param destination: Output folder
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_target', 'extension_destination']
			 iterable_names = ['target','destination']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'target': 'folder_target', 'destination': 'folder_destination'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['target', 'destination']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'recursive_list_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.sys.recursive_list_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'target': 'target', 'destination': 'destination'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['target', 'destination']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'recursive_list',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.sys.recursive_list(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def rename_file_in_cloud(self,
			target='__auto__', 
			prefix='', 
			suffix='', 
			replace_from='', 
			replace_to='', 
			replace_count=0,
			extension_target = '',
			folder_parallel_processing = '__auto__'):
			 '''
				rename file in cloud
				
				:param target: Target to be renamed
				:param prefix: add prefix
				:param suffix: add suffix
				:param replace_from: replace string in filename
				:param replace_to: replace string in filename
				:param replace_count: replace string in filename
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_target']
			 iterable_names = ['target']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'target': 'folder_target', 'prefix': 'prefix', 'suffix': 'suffix', 'replace_from': 'replace_from', 'replace_to': 'replace_to', 'replace_count': 'replace_count'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['target']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'rename_file_in_cloud_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.sys.rename_file_in_cloud_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'target': 'target', 'prefix': 'prefix', 'suffix': 'suffix', 'replace_from': 'replace_from', 'replace_to': 'replace_to', 'replace_count': 'replace_count'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['target']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'rename_file_in_cloud',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.sys.rename_file_in_cloud(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def list_files_in_cloud(self,
			target='__auto__', 
			path_out='__auto__',
			extension_target = '',
			extension_file_out = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				list files in cloud
				
				:param target: Target to be listet
				:param path_out: output_folder
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_target', 'extension_file_out']
			 iterable_names = ['target','path_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'target': 'folder_target', 'path_out': 'folder_out'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['target', 'folder_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'list_files_in_cloud_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.sys.list_files_in_cloud_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'target': 'target', 'path_out': 'file_out'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['target', 'file_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'list_files_in_cloud',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.sys.list_files_in_cloud(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def download_data_to_cloud(self,
			url='__auto__', 
			destination='__auto__', 
			protocol='', 
			download_type=0, 
			username='', 
			password='', 
			port=21,
			extension_url = '',
			extension_destination = '',
			folder_parallel_processing = '__auto__'):
			 '''
				download data to cloud
				
				:param url: URL to data
				:param destination: Destionation location on host. default folder: ./data
				:param protocol: protocol: : automatically try to infer protocol, ftp: ftp, sftp: sftp
				:param download_type: download type: 0: all files from folder, 1: individual file
				:param username: Username
				:param password: Password
				:param port: port
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_url', 'extension_destination']
			 iterable_names = ['url','destination']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'url': 'url', 'destination': 'folder_destination', 'protocol': 'protocol', 'download_type': 'download_type', 'username': 'username', 'password': 'password', 'port': 'port'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['url', 'destination']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'download_data_to_cloud_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.sys.download_data_to_cloud_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'url': 'url', 'destination': 'destination', 'protocol': 'protocol', 'download_type': 'download_type', 'username': 'username', 'password': 'password', 'port': 'port'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['url', 'destination']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'download_data_to_cloud',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.sys.download_data_to_cloud(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def upload_from_aipha_to_host(self,
			url='__auto__', 
			port='22', 
			username='ubuntu', 
			identity_path='', 
			target='__auto__', 
			location='file.laz',
			extension_url = '.1',
			extension_target = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				Upload a path to a host via ssh
				
				:param url: Url to host
				:param port: Port to host
				:param username: Username to host
				:param identity_path:  Path to identity file on aipha
				:param target: Path to upload from aipha
				:param location: Location of file to upload on host
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_url', 'extension_target']
			 iterable_names = ['url','target']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'url': 'url', 'port': 'port', 'username': 'username', 'identity_path': 'identity_path', 'target': 'folder_target', 'location': 'location'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['url', 'target']
				 itertable_iotypes = ['in', 'in']
				 iterable_file_types = ['1', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'upload_from_aipha_to_host_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.sys.upload_from_aipha_to_host_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'url': 'url', 'port': 'port', 'username': 'username', 'identity_path': 'identity_file', 'target': 'target', 'location': 'location'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['url', 'target']
				 itertable_iotypes = ['in', 'in']
				 iterable_file_types = ['1', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'upload_from_aipha_to_host',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.sys.upload_from_aipha_to_host(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def download_from_host_to_aipha(self,
			url='__auto__', 
			port='22', 
			username='ubuntu', 
			identity_path='', 
			location='file.laz', 
			destination='__auto__',
			extension_url = '.1',
			extension_destination = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				Download a path from a host via ssh
				
				:param url: Url to host
				:param port: Port to host
				:param username: Username to host
				:param identity_path:  Path to identity file on aipha
				:param location: Path to download from host
				:param destination: Location to upload to aipha
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_url', 'extension_destination']
			 iterable_names = ['url','destination']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'url': 'url', 'port': 'port', 'username': 'username', 'identity_path': 'identity_path', 'location': 'location', 'destination': 'folder_destination'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['url', 'destination']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['1', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'download_from_host_to_aipha_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.sys.download_from_host_to_aipha_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'url': 'url', 'port': 'port', 'username': 'username', 'identity_path': 'identity_file', 'location': 'location', 'destination': 'destination'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['url', 'destination']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['1', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'download_from_host_to_aipha',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.sys.download_from_host_to_aipha(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def download_from_s3_to_aipha(self,
			access_key_id='YOUR_KEY_ID', 
			secret_access_key='YOUR_SECRET_KEY', 
			aws_region='eu-central-1', 
			location='file.laz', 
			destination='__auto__', 
			bucket_name='Your S3 bucket',
			extension_destination = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				Download a path from a S3 bucket
				
				:param access_key_id: AWS access key ID
				:param secret_access_key: AWS secret access key
				:param aws_region: AWS region
				:param location: Path to download from s3
				:param destination: Location to upload to aipha
				:param bucket_name: S3 bucket name
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_destination']
			 iterable_names = ['destination']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'access_key_id': 'access_key_id', 'secret_access_key': 'secret_access_key', 'aws_region': 'aws_region', 'location': 'location', 'destination': 'folder_destination', 'bucket_name': 'bucket_name'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['destination']
				 itertable_iotypes = ['out']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'download_from_s3_to_aipha_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.sys.download_from_s3_to_aipha_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'access_key_id': 'access_key_id', 'secret_access_key': 'secret_access_key', 'aws_region': 'aws_region', 'location': 'location', 'destination': 'destination', 'bucket_name': 'bucket_name'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['destination']
				 itertable_iotypes = ['out']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'download_from_s3_to_aipha',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.sys.download_from_s3_to_aipha(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def upload_from_aipha_to_s3(self,
			access_key_id='YOUR_KEY_ID', 
			secret_access_key='YOUR_SECRET_KEY', 
			aws_region='eu-central-1', 
			target='__auto__', 
			location='file.laz', 
			bucket_name='Your S3 bucket',
			extension_target = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				Upload a path to a S3 bucket
				
				:param access_key_id: AWS access key ID
				:param secret_access_key: AWS secret access key
				:param aws_region: AWS region
				:param target: Path to upload from aipha
				:param location: Location of file to upload on s3
				:param bucket_name: S3 bucket name
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_target']
			 iterable_names = ['target']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'access_key_id': 'access_key_id', 'secret_access_key': 'secret_access_key', 'aws_region': 'aws_region', 'target': 'folder_target', 'location': 'location', 'bucket_name': 'bucket_name'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['target']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'upload_from_aipha_to_s3_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.sys.upload_from_aipha_to_s3_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'access_key_id': 'access_key_id', 'secret_access_key': 'secret_access_key', 'aws_region': 'aws_region', 'target': 'target', 'location': 'location', 'bucket_name': 'bucket_name'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['target']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'upload_from_aipha_to_s3',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.sys.upload_from_aipha_to_s3(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'sys',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



	 class tdp:
		 ''' 
         Namespace for tdp functions.
		 '''

		 def __init__(self, outer_class):
			 self.outer_class = outer_class
			 self.client = outer_class.client
			 self.processing_folder = outer_class.processing_folder
			 self._get_call_stack = outer_class._get_call_stack
			 self._add_call_stack = outer_class._add_call_stack
			 self.get_unique_id = outer_class.get_unique_id
			 self.worker_instance_type, self.manager_instance_type = outer_class.get_instance_types()
			 self._check_folder_level_processing = outer_class._check_folder_level_processing
			 self._remap_parameters = outer_class._remap_parameters
			 self._get_param_subset = outer_class._get_param_subset


		 def point_cloud_classification_inference(self,
			path_in='__auto__', 
			path_out='__auto__', 
			model_path='network_parameters', 
			cols_data='X,Y,Z', 
			cols_labels='classification',
			extension_file_in = '.laz',
			extension_file_out = '.labels',
			folder_parallel_processing = '__auto__'):
			 '''
				point cloud classification inference
				
				:param path_in: input folder
				:param path_out: results folder
				:param model_path:  path to model
				:param cols_data: attributes used
				:param cols_labels: label name
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_in', 'extension_file_out']
			 iterable_names = ['path_in','path_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_in': 'folder_in', 'path_out': 'folder_out', 'model_path': 'model_path', 'cols_data': 'cols_data', 'cols_labels': 'cols_labels'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_in', 'folder_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'labels']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'point_cloud_classification_inference_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.tdp.point_cloud_classification_inference_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'tdp',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_in': 'file_in', 'path_out': 'file_out', 'model_path': 'model_path', 'cols_data': 'cols_data', 'cols_labels': 'cols_labels'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_in', 'file_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'labels']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'point_cloud_classification_inference',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.tdp.point_cloud_classification_inference(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'tdp',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def convert_laz_point_formats(self,
			path_in='__auto__', 
			path_out='__auto__', 
			format=7,
			extension_file_in = '.laz',
			extension_file_out = '.labels',
			folder_parallel_processing = '__auto__'):
			 '''
				convert laz point formats
				
				:param path_in: input folder
				:param path_out: results folder
				:param format: format
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_in', 'extension_file_out']
			 iterable_names = ['path_in','path_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_in': 'folder_in', 'path_out': 'folder_out', 'format': 'format'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_in', 'folder_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'labels']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'convert_laz_point_formats_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.tdp.convert_laz_point_formats_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'tdp',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_in': 'file_in', 'path_out': 'file_out', 'format': 'format'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_in', 'file_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'labels']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'convert_laz_point_formats',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.tdp.convert_laz_point_formats(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'tdp',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def segment_objects(self,
			in_points_path='__auto__', 
			in_labels_path='__auto__', 
			out_directory='segmented_object', 
			out_prefix='object', 
			label_col='classification', 
			object_class=68, 
			max_distance=2, 
			min_points=100,
			extension_in_points_file = '',
			extension_in_labels_file = '',
			folder_parallel_processing = '__auto__'):
			 '''
				segment objects
				
				:param in_points_path: input folder points
				:param in_labels_path: input folder labels
				:param out_directory: output directory
				:param out_prefix: output filename prefix
				:param label_col: label column id
				:param object_class: obejct class
				:param max_distance: maximum distance for segmentation
				:param min_points: minimum number of points
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_points_file', 'extension_in_labels_file']
			 iterable_names = ['in_points_path','in_labels_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_points_path': 'in_points_folder', 'in_labels_path': 'in_labels_folder', 'out_directory': 'out_directory', 'out_prefix': 'out_prefix', 'label_col': 'label_col', 'object_class': 'object_class', 'max_distance': 'max_distance', 'min_points': 'min_points'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_points_folder', 'in_labels_folder']
				 itertable_iotypes = ['in', 'in']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'segment_objects_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.tdp.segment_objects_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'tdp',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_points_path': 'in_points_file', 'in_labels_path': 'in_labels_file', 'out_directory': 'out_directory', 'out_prefix': 'out_prefix', 'label_col': 'label_col', 'object_class': 'object_class', 'max_distance': 'max_distance', 'min_points': 'min_points'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_points_file', 'in_labels_file']
				 itertable_iotypes = ['in', 'in']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'segment_objects',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.tdp.segment_objects(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'tdp',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def point_cloud_filter_label_noise(self,
			path_in_data='__auto__', 
			path_in_labels='__auto__', 
			path_out='__auto__', 
			k_nearest_neighbours=5, 
			sigma=10., 
			dim=3, 
			invalid_label=0,
			extension_file_in_data = '.laz',
			extension_file_in_labels = '.labels',
			extension_file_out = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				point cloud filter label noise
				
				:param path_in_data: input folder data
				:param path_in_labels: input folder labels
				:param path_out: output folder
				:param k_nearest_neighbours: k nearest neighbours
				:param sigma: sigma
				:param dim: dim
				:param invalid_label: invalid class label
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_in_data', 'extension_file_in_labels', 'extension_file_out']
			 iterable_names = ['path_in_data','path_in_labels','path_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_in_data': 'folder_in_data', 'path_in_labels': 'folder_in_labels', 'path_out': 'folder_out', 'k_nearest_neighbours': 'k_nearest_neighbours', 'sigma': 'sigma', 'dim': 'dim', 'invalid_label': 'invalid_label'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_in_data', 'folder_in_labels', 'folder_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'labels', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'point_cloud_filter_label_noise_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.tdp.point_cloud_filter_label_noise_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'tdp',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_in_data': 'file_in_data', 'path_in_labels': 'file_in_labels', 'path_out': 'file_out', 'k_nearest_neighbours': 'k_nearest_neighbours', 'sigma': 'sigma', 'dim': 'dim', 'invalid_label': 'invalid_label'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_in_data', 'file_in_labels', 'file_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'labels', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'point_cloud_filter_label_noise',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.tdp.point_cloud_filter_label_noise(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'tdp',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def tower_displacement(self,
			laz_in_path_new='__auto__', 
			laz_in_path_old='__auto__', 
			laz_in_path_ref='__auto__', 
			tower_name='', 
			year_new='2022', 
			year_old='2020', 
			year_ref='2018', 
			results_out_path='__auto__', 
			plots_out_path='plots/',
			extension_laz_in_file_new = '.laz',
			extension_laz_in_file_old = '.laz',
			extension_laz_in_file_ref = '.laz',
			extension_results_out_file = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				tower displacement
				
				:param laz_in_path_new: laz input folder new data
				:param laz_in_path_old: laz input folder last data
				:param laz_in_path_ref: laz input folder first data
				:param tower_name: tower name
				:param year_new: year of new data
				:param year_old: year of old data
				:param year_ref: year of reference data
				:param results_out_path: result folder folder
				:param plots_out_path:  result folder path
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_laz_in_file_new', 'extension_laz_in_file_old', 'extension_laz_in_file_ref', 'extension_results_out_file']
			 iterable_names = ['laz_in_path_new','laz_in_path_old','laz_in_path_ref','results_out_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'laz_in_path_new': 'laz_in_folder_new', 'laz_in_path_old': 'laz_in_folder_old', 'laz_in_path_ref': 'laz_in_folder_ref', 'tower_name': 'tower_name', 'year_new': 'year_new', 'year_old': 'year_old', 'year_ref': 'year_ref', 'results_out_path': 'results_out_folder', 'plots_out_path': 'plots_out_path'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['laz_in_folder_new', 'laz_in_folder_old', 'laz_in_folder_ref', 'results_out_folder']
				 itertable_iotypes = ['in', 'in', 'in', 'out']
				 iterable_file_types = ['laz', 'laz', 'laz', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'tower_displacement_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.tdp.tower_displacement_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'tdp',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'laz_in_path_new': 'laz_in_file_new', 'laz_in_path_old': 'laz_in_file_old', 'laz_in_path_ref': 'laz_in_file_ref', 'tower_name': 'tower_name', 'year_new': 'year_new', 'year_old': 'year_old', 'year_ref': 'year_ref', 'results_out_path': 'results_out_file', 'plots_out_path': 'plots_out_path'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['laz_in_file_new', 'laz_in_file_old', 'laz_in_file_ref', 'results_out_file']
				 itertable_iotypes = ['in', 'in', 'in', 'out']
				 iterable_file_types = ['laz', 'laz', 'laz', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'tower_displacement',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.tdp.tower_displacement(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'tdp',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def merge_and_split_results_csv(self,
			new_tower_path='new_paths.txt', 
			last_tower_path='last_paths.txt', 
			reference_tower_path='reference_paths.txt', 
			results_path_csv='results.csv', 
			results_plots_path='results_plots', 
			merged_results_path_csv='results/Reports_2023', 
			resturctured_plots_path='results/10-Plots-Tragwerke', 
			input_path_structure_path='input_file_structure.txt', 
			year='2023',

			folder_parallel_processing = '__auto__'):
			 '''
				[atr] Merge results csv
				
				:param new_tower_path:  input new path data
				:param last_tower_path:  input last path 
				:param reference_tower_path:  input reference path 
				:param results_path_csv:  input results.csv path 
				:param results_plots_path:  input results_plots path 
				:param merged_results_path_csv:  output path 
				:param resturctured_plots_path:  output path 
				:param input_path_structure_path:  input file structure path 
				:param year: year 
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = []
			 iterable_names = []
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'new_tower_path': 'new_tower_path', 'last_tower_path': 'last_tower_path', 'reference_tower_path': 'reference_tower_path', 'results_path_csv': 'results_path_csv', 'results_plots_path': 'results_plots_path', 'merged_results_path_csv': 'merged_results_path_csv', 'resturctured_plots_path': 'resturctured_plots_path', 'input_path_structure_path': 'input_path_structure_path', 'year': 'year'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'merge_and_split_results_csv_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.tdp.merge_and_split_results_csv_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'tdp',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'new_tower_path': 'new_tower_path', 'last_tower_path': 'last_tower_path', 'reference_tower_path': 'reference_tower_path', 'results_path_csv': 'results_path_csv', 'results_plots_path': 'results_plots_path', 'merged_results_path_csv': 'merged_results_path_csv', 'resturctured_plots_path': 'resturctured_plots_path', 'input_path_structure_path': 'input_file_structure_path', 'year': 'year'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'merge_and_split_results_csv',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.tdp.merge_and_split_results_csv(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'tdp',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



	 class ops3d:
		 ''' 
         Namespace for ops3d functions.
		 '''

		 def __init__(self, outer_class):
			 self.outer_class = outer_class
			 self.client = outer_class.client
			 self.processing_folder = outer_class.processing_folder
			 self._get_call_stack = outer_class._get_call_stack
			 self._add_call_stack = outer_class._add_call_stack
			 self.get_unique_id = outer_class.get_unique_id
			 self.worker_instance_type, self.manager_instance_type = outer_class.get_instance_types()
			 self._check_folder_level_processing = outer_class._check_folder_level_processing
			 self._remap_parameters = outer_class._remap_parameters
			 self._get_param_subset = outer_class._get_param_subset


		 def uniform_downsampling(self,
			path_in='__auto__', 
			path_out='__auto__', 
			k=3, 
			dtype='',
			extension_file_in = '.laz',
			extension_file_out = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				uniform downsampling
				
				:param path_in: input folder data
				:param path_out: output folder
				:param k: k
				:param dtype: values from point cloud, e.g. X,Y,Z
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_in', 'extension_file_out']
			 iterable_names = ['path_in','path_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_in': 'folder_in', 'path_out': 'folder_out', 'k': 'k', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_in', 'folder_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'uniform_downsampling_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.uniform_downsampling_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_in': 'file_in', 'path_out': 'file_out', 'k': 'k', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_in', 'file_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'uniform_downsampling',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.uniform_downsampling(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def make_laz_from_values(self,
			path_values_in='__auto__', 
			path_points_out='__auto__', 
			dtype='X,Y,Z', 
			scale='0.01,0.01,0.01', 
			point_format=7,
			extension_file_values_in = '.npy',
			extension_file_points_out = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				make laz from values
				
				:param path_values_in: input folder data
				:param path_points_out: output folder
				:param dtype: data channels
				:param scale: scale value
				:param point_format: point format
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_values_in', 'extension_file_points_out']
			 iterable_names = ['path_values_in','path_points_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_values_in': 'folder_values_in', 'path_points_out': 'folder_points_out', 'dtype': 'dtype', 'scale': 'scale', 'point_format': 'point_format'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_values_in', 'folder_points_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'make_laz_from_values_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.make_laz_from_values_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_values_in': 'file_values_in', 'path_points_out': 'file_points_out', 'dtype': 'dtype', 'scale': 'scale', 'point_format': 'point_format'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_values_in', 'file_points_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'make_laz_from_values',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.make_laz_from_values(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def get_bounding_box(self,
			in_path='__auto__', 
			dimension=3, 
			out_path='__auto__',
			extension_in_file = '.laz',
			extension_out_file = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Get bounding box from las or laz file
				
				:param in_path: Input .laz folder folder
				:param dimension: Dimension of the point cloud
				:param out_path: Output bounding box folder folder
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_file', 'extension_out_file']
			 iterable_names = ['in_path','out_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_path': 'in_folder', 'dimension': 'dimension', 'out_path': 'out_folder'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_folder', 'out_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'get_bounding_box_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.get_bounding_box_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_path': 'in_file', 'dimension': 'dimension', 'out_path': 'out_file'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_file', 'out_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'get_bounding_box',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.get_bounding_box(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def iterative_outlier_removal(self,
			path_in='segmented_object', 
			path_out='iterative_outlier_removal', 
			decay_factor=0.98, 
			iteration_count=10, 
			max_num_processes=0,

			folder_parallel_processing = '__auto__'):
			 '''
				iterative outlier removal
				
				:param path_in: input folder
				:param path_out: output folder
				:param decay_factor: maximum quantile
				:param iteration_count: minimum quantile
				:param max_num_processes: Number of parallel processes
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = []
			 iterable_names = []
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_in': 'path_in', 'path_out': 'path_out', 'decay_factor': 'decay_factor', 'iteration_count': 'iteration_count', 'max_num_processes': 'max_num_processes'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'iterative_outlier_removal_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.iterative_outlier_removal_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_in': 'folder_in', 'path_out': 'folder_out', 'decay_factor': 'decay_factor', 'iteration_count': 'iteration_count', 'max_num_processes': 'max_num_processes'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'iterative_outlier_removal',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.iterative_outlier_removal(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def crop_and_merge_polygons(self,
			point_cloud_paths='__auto__', 
			polygon_path='__auto__', 
			output_path='__auto__',
			extension_point_cloud_files = '.laz',
			extension_polygon_file = '.pickle',
			extension_output_file = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				crop and merge polygons
				
				:param point_cloud_paths: Input folder folder for the point clouds
				:param polygon_path: Input folder folder for the polygon (pickle)
				:param output_path: Output folder folder for the cropped point cloud
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_point_cloud_files', 'extension_polygon_file', 'extension_output_file']
			 iterable_names = ['point_cloud_paths','polygon_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'point_cloud_paths': 'point_cloud_folders', 'polygon_path': 'polygon_folder', 'output_path': 'output_folder'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['point_cloud_folders', 'polygon_folder', 'output_folder']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'pickle', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'crop_and_merge_polygons_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.crop_and_merge_polygons_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'point_cloud_paths': 'point_cloud_files', 'polygon_path': 'polygon_file', 'output_path': 'output_file'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['point_cloud_files', 'polygon_file', 'output_file']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'pickle', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'crop_and_merge_polygons',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.crop_and_merge_polygons(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def get_point_values(self,
			path_source_in='__auto__', 
			path_labels_out='__auto__', 
			dtype='classification', 
			decomposed_labels='True',
			extension_file_source_in = '.laz',
			extension_file_labels_out = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				get point values
				
				:param path_source_in: input folder [.laz or .las]
				:param path_labels_out: output folder [.txt or .npy]
				:param dtype: type
				:param decomposed_labels: type
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_source_in', 'extension_file_labels_out']
			 iterable_names = ['path_source_in','path_labels_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_source_in': 'folder_source_in', 'path_labels_out': 'folder_labels_out', 'dtype': 'dtype', 'decomposed_labels': 'decomposed_labels'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_source_in', 'folder_labels_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'get_point_values_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.get_point_values_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_source_in': 'file_source_in', 'path_labels_out': 'file_labels_out', 'dtype': 'dtype', 'decomposed_labels': 'decomposed_labels'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_source_in', 'file_labels_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'get_point_values',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.get_point_values(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def density_based_clustering(self,
			pathname='__auto__', 
			cluster_id_pathname='__auto__', 
			cluster_centers_pathname='__auto__', 
			wireframe_pathname='__auto__', 
			epsilon=0.25, 
			min_samples=0, 
			dim=3, 
			wireframe='False',
			extension_filename = '.laz',
			extension_cluster_id_filename = '.npy',
			extension_cluster_centers_filename = '.laz',
			extension_wireframe_filename = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Density-based Point Cloud Clustering
				
				:param pathname: Input .laz folder folder
				:param cluster_id_pathname: Output cluster IDs folder folder
				:param cluster_centers_pathname: Output cluster centers .laz folder folder
				:param wireframe_pathname: Output wireframe connections folder folder
				:param epsilon: DBSCAN epsilon
				:param min_samples: DBSCAN min_samples
				:param dim: Point dimension
				:param wireframe: Whether to compute wireframe connections
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_filename', 'extension_cluster_id_filename', 'extension_cluster_centers_filename', 'extension_wireframe_filename']
			 iterable_names = ['pathname','cluster_id_pathname','cluster_centers_pathname','wireframe_pathname']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'pathname': 'foldername', 'cluster_id_pathname': 'cluster_id_foldername', 'cluster_centers_pathname': 'cluster_centers_foldername', 'wireframe_pathname': 'wireframe_foldername', 'epsilon': 'epsilon', 'min_samples': 'min_samples', 'dim': 'dim', 'wireframe': 'wireframe'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['foldername', 'cluster_id_foldername', 'cluster_centers_foldername', 'wireframe_foldername']
				 itertable_iotypes = ['in', 'in', 'in', 'out']
				 iterable_file_types = ['laz', 'npy', 'laz', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'density_based_clustering_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.density_based_clustering_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'pathname': 'filename', 'cluster_id_pathname': 'cluster_id_filename', 'cluster_centers_pathname': 'cluster_centers_filename', 'wireframe_pathname': 'wireframe_filename', 'epsilon': 'epsilon', 'min_samples': 'min_samples', 'dim': 'dim', 'wireframe': 'wireframe'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['filename', 'cluster_id_filename', 'cluster_centers_filename', 'wireframe_filename']
				 itertable_iotypes = ['in', 'in', 'in', 'out']
				 iterable_file_types = ['laz', 'npy', 'laz', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'density_based_clustering',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.density_based_clustering(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def retile_point_cloud_to_grid(self,
			in_path_points='__auto__', 
			in_path_grids='grid1.npy,grid2.npy,grid3.npy', 
			out_path_points='out.laz,out2.laz',
			extension_in_path_points = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				retile point clouds to grid
				
				:param in_path_points: Output folder for mapping that contains the point clouds (including neighbouring point clouds) that are used to generate slices from point cloud x
				:param in_path_grids:  Output path for mapping that contains the tiles that are generated from point cloud x
				:param out_path_points:  Output path to retiled point clouds
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_path_points']
			 iterable_names = ['in_path_points']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_path_points': 'in_folder_points', 'in_path_grids': 'in_path_grids', 'out_path_points': 'out_path_points'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_folder_points']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'retile_point_cloud_to_grid_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.retile_point_cloud_to_grid_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_path_points': 'in_path_points', 'in_path_grids': 'in_path_grids', 'out_path_points': 'out_path_points'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_path_points']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'retile_point_cloud_to_grid',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.retile_point_cloud_to_grid(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def make_line_model_from_points(self,
			path_in='segmented_object', 
			path_out='vobject_coordinates3D', 
			dim=3, 
			max_num_processes=0,

			folder_parallel_processing = '__auto__'):
			 '''
				make line model from points
				
				:param path_in: input folder data
				:param path_out: output folder
				:param dim: dimension
				:param max_num_processes: maximum number of processes
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = []
			 iterable_names = []
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_in': 'path_in', 'path_out': 'path_out', 'dim': 'dim', 'max_num_processes': 'max_num_processes'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'make_line_model_from_points_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.make_line_model_from_points_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_in': 'folder_in', 'path_out': 'folder_out', 'dim': 'dim', 'max_num_processes': 'max_num_processes'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'make_line_model_from_points',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.make_line_model_from_points(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def fit_line_model(self,
			path_in='segmented_object', 
			path_out='fit_line_model', 
			residual_threshold=30.05, 
			min_samples=2, 
			max_trials=1, 
			max_dim=3, 
			max_num_processes=0,

			folder_parallel_processing = '__auto__'):
			 '''
				fit line model
				
				:param path_in: input folder
				:param path_out: output folder
				:param residual_threshold: maximum quantile
				:param min_samples: minimum quantile
				:param max_trials: maximum number of trials
				:param max_dim: max_dim 0: x, 1: y, 3: z
				:param max_num_processes: Number of parallel processes
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = []
			 iterable_names = []
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_in': 'path_in', 'path_out': 'path_out', 'residual_threshold': 'residual_threshold', 'min_samples': 'min_samples', 'max_trials': 'max_trials', 'max_dim': 'max_dim', 'max_num_processes': 'max_num_processes'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'fit_line_model_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.fit_line_model_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_in': 'folder_in', 'path_out': 'folder_out', 'residual_threshold': 'residual_threshold', 'min_samples': 'min_samples', 'max_trials': 'max_trials', 'max_dim': 'max_dim', 'max_num_processes': 'max_num_processes'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'fit_line_model',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.fit_line_model(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def iterative_closest_point(self,
			path_source_in='__auto__', 
			path_target_in='__auto__', 
			path_source_out='__auto__', 
			path_trafo_out='__auto__', 
			metric='point2point', 
			threshold=0.2, 
			max_correspondences=5,
			extension_file_source_in = '.laz',
			extension_file_target_in = '.laz',
			extension_file_source_out = '.laz',
			extension_file_trafo_out = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				iterative closest point
				
				:param path_source_in: input source folder
				:param path_target_in: input target folder
				:param path_source_out: output folder
				:param path_trafo_out: output transformation
				:param metric: [max, min, same]: same value range relative to maximum point [max], relative to minimum point [min] or absolute coordinates [same]
				:param threshold: threshold to crop values
				:param max_correspondences: threshold max nearest neighbours
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_source_in', 'extension_file_target_in', 'extension_file_source_out', 'extension_file_trafo_out']
			 iterable_names = ['path_source_in','path_target_in','path_source_out','path_trafo_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_source_in': 'folder_source_in', 'path_target_in': 'folder_folder_target_in', 'path_source_out': 'folder_source_out', 'path_trafo_out': 'folder_trafo_out', 'metric': 'metric', 'threshold': 'threshold', 'max_correspondences': 'max_correspondences'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_source_in', 'folder_target_in', 'folder_source_out', 'folder_trafo_out']
				 itertable_iotypes = ['in', 'in', 'in', 'out']
				 iterable_file_types = ['laz', 'laz', 'laz', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'iterative_closest_point_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.iterative_closest_point_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_source_in': 'file_source_in', 'path_target_in': 'file_target_in', 'path_source_out': 'file_source_out', 'path_trafo_out': 'file_trafo_out', 'metric': 'metric', 'threshold': 'threshold', 'max_correspondences': 'max_correspondences'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_source_in', 'file_target_in', 'file_source_out', 'file_trafo_out']
				 itertable_iotypes = ['in', 'in', 'in', 'out']
				 iterable_file_types = ['laz', 'laz', 'laz', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'iterative_closest_point',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.iterative_closest_point(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def crop_points_to_polygon(self,
			in_points_path='__auto__', 
			in_polygon_path='__auto__', 
			out_path='__auto__',
			extension_in_points_file = '.laz',
			extension_in_polygon_file = '.pickle',
			extension_out_file = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				crop points to polygon
				
				:param in_points_path: Input folder folder for the point cloud
				:param in_polygon_path: Input folder folder for the polygon (pickle)
				:param out_path: Output folder folder for the cropped point cloud
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_points_file', 'extension_in_polygon_file', 'extension_out_file']
			 iterable_names = ['in_points_path','in_polygon_path','out_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_points_path': 'in_points_folder', 'in_polygon_path': 'in_polygon_folder', 'out_path': 'out_folder'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_points_folder', 'in_polygon_folder', 'out_folder']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'pickle', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'crop_points_to_polygon_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.crop_points_to_polygon_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_points_path': 'in_points_file', 'in_polygon_path': 'in_polygon_file', 'out_path': 'out_file'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_points_file', 'in_polygon_file', 'out_file']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'pickle', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'crop_points_to_polygon',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.crop_points_to_polygon(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def retile_grid_to_point_cloud(self,
			in_path_grid='point_cloud_grid', 
			in_path_mapping='__auto__', 
			out_path_points='__auto__',
			extension_in_path_mapping = '.txt',
			extension_out_path_points = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				retile point clouds to grid
				
				:param in_path_grid:  folder that contains the retiled point clouds
				:param in_path_mapping: Mapping that specifies, which point clouds of the grid intersect with the original point cloud
				:param out_path_points: Output folder for the merged point cloud
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_path_mapping', 'extension_out_path_points']
			 iterable_names = ['in_path_mapping','out_path_points']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_path_grid': 'in_path_grid', 'in_path_mapping': 'in_folder_mapping', 'out_path_points': 'out_folder_points'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_folder_mapping', 'out_folder_points']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['txt', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'retile_grid_to_point_cloud_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.retile_grid_to_point_cloud_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_path_grid': 'in_path_grid', 'in_path_mapping': 'in_path_mapping', 'out_path_points': 'out_path_points'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_path_mapping', 'out_path_points']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['txt', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'retile_grid_to_point_cloud',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.retile_grid_to_point_cloud(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def filter_label_noise(self,
			path_in_data='__auto__', 
			path_in_labels='__auto__', 
			path_out='__auto__', 
			k_nearest_neighbours=5, 
			sigma=10., 
			dim=3, 
			invalid_label=0,
			extension_file_in_data = '.laz',
			extension_file_in_labels = '.labels',
			extension_file_out = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				filter label noise
				
				:param path_in_data: input folder data
				:param path_in_labels: input folder labels
				:param path_out: output folder
				:param k_nearest_neighbours: k nearest neighbours
				:param sigma: sigma
				:param dim: dim
				:param invalid_label: invalid class label
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_in_data', 'extension_file_in_labels', 'extension_file_out']
			 iterable_names = ['path_in_data','path_in_labels','path_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_in_data': 'folder_in_data', 'path_in_labels': 'folder_in_labels', 'path_out': 'folder_out', 'k_nearest_neighbours': 'k_nearest_neighbours', 'sigma': 'sigma', 'dim': 'dim', 'invalid_label': 'invalid_label'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_in_data', 'folder_in_labels', 'folder_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'labels', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'filter_label_noise_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.filter_label_noise_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_in_data': 'file_in_data', 'path_in_labels': 'file_in_labels', 'path_out': 'file_out', 'k_nearest_neighbours': 'k_nearest_neighbours', 'sigma': 'sigma', 'dim': 'dim', 'invalid_label': 'invalid_label'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_in_data', 'file_in_labels', 'file_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'labels', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'filter_label_noise',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.filter_label_noise(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def crop_circle(self,
			in_path='__auto__', 
			out_path='__auto__', 
			latitude=1, 
			longitude=1, 
			lat_lon_path='__auto__', 
			radius=75, 
			cols='', 
			max_num_processes=0,
			extension_in_file = '.laz',
			extension_out_file = '.laz',
			extension_lat_lon_file = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				crop circle
				
				:param in_path: input folder
				:param out_path: output folder
				:param latitude: latitude
				:param longitude: longitude
				:param lat_lon_path: (optional) folder with lat lon coordinates
				:param radius: radius for cropping
				:param cols: columns to be used, leave empty for all
				:param max_num_processes: maximum number of processes
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_file', 'extension_out_file', 'extension_lat_lon_file']
			 iterable_names = ['in_path','out_path','lat_lon_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_path': 'in_folder', 'out_path': 'out_folder', 'latitude': 'latitude', 'longitude': 'longitude', 'lat_lon_path': 'lat_lon_folder', 'radius': 'radius', 'cols': 'cols', 'max_num_processes': 'max_num_processes'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_folder', 'out_folder', 'lat_lon_folder']
				 itertable_iotypes = ['in', 'out', 'out']
				 iterable_file_types = ['laz', 'laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'crop_circle_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.crop_circle_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_path': 'in_file', 'out_path': 'out_file', 'latitude': 'latitude', 'longitude': 'longitude', 'lat_lon_path': 'lat_lon_file', 'radius': 'radius', 'cols': 'cols', 'max_num_processes': 'max_num_processes'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_file', 'out_file', 'lat_lon_file']
				 itertable_iotypes = ['in', 'out', 'out']
				 iterable_file_types = ['laz', 'laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'crop_circle',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.crop_circle(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def select_points_by_value(self,
			path_source_in='__auto__', 
			min_value=1, 
			max_value=1, 
			attribute='classification', 
			path_source_out='__auto__', 
			keep_empty='True',
			extension_file_source_in = '',
			extension_file_source_out = '',
			folder_parallel_processing = '__auto__'):
			 '''
				Selects points by value of attribute
				
				:param path_source_in: input folder data
				:param min_value: minimum value
				:param max_value: maximum value
				:param attribute: feature for selection
				:param path_source_out: output folder
				:param keep_empty: save empty files
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_source_in', 'extension_file_source_out']
			 iterable_names = ['path_source_in','path_source_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_source_in': 'folder_source_in', 'min_value': 'min_value', 'max_value': 'max_value', 'attribute': 'attribute', 'path_source_out': 'folder_source_out', 'keep_empty': 'keep_empty'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_source_in', 'folder_source_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'select_points_by_value_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.select_points_by_value_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_source_in': 'file_source_in', 'min_value': 'min_value', 'max_value': 'max_value', 'attribute': 'attribute', 'path_source_out': 'file_source_out', 'keep_empty': 'keep_empty'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_source_in', 'file_source_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'select_points_by_value',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.select_points_by_value(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def uniform_down_sampling_voxel(self,
			input_path='__auto__', 
			cols='', 
			output_path='__auto__', 
			voxel_size=0.05,
			extension_input_file = '.laz',
			extension_output_file = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				Uniform down sampling of point cloud using voxel grids
				
				:param input_path: Input point cloud folder
				:param cols: Columns to read from input file, default is all columns
				:param output_path: Output point cloud folder
				:param voxel_size: voxel size
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_input_file', 'extension_output_file']
			 iterable_names = ['input_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'input_path': 'input_folder', 'cols': 'cols', 'output_path': 'output_folder', 'voxel_size': 'voxel_size'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['input_folder', 'output_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'uniform_down_sampling_voxel_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.uniform_down_sampling_voxel_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'input_path': 'input_file', 'cols': 'cols', 'output_path': 'output_file', 'voxel_size': 'voxel_size'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['input_file', 'output_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'uniform_down_sampling_voxel',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.uniform_down_sampling_voxel(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def filter_label_disagreement_knn(self,
			path_points_in='__auto__', 
			path_labels_in='__auto__', 
			path_label_disagrement_in='__auto__', 
			path_label_disagrement_out='__auto__', 
			distance=2, 
			classes_to_compare='2', 
			comparison_type='2', 
			class_to_filter=1, 
			dim_data=3, 
			knn=2, 
			comparison_axis=-1, 
			invalid_label=0,
			extension_file_points_in = '.laz',
			extension_file_labels_in = '.npy',
			extension_file_label_disagrement_in = '.npy',
			extension_file_label_disagrement_out = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				filter label disagreement knn
				
				:param path_points_in: input folder [.laz or .las]
				:param path_labels_in: input folder [.txt or .npy]
				:param path_label_disagrement_in: input folder[.txt or .npy]
				:param path_label_disagrement_out: output folder [.txt or .npy]
				:param distance: distance threshold
				:param classes_to_compare: classes to compare, comma separated
				:param comparison_type: [ge: greater equal, le: less equal]
				:param class_to_filter: class to filter
				:param dim_data: Dimensions to use: 3: x,y,z; 2: x, y
				:param knn: k-nearest-neighbours
				:param comparison_axis: axis to compare: -1: eucledian distance; 0, 1 or 2: distance along x, y or z axis
				:param invalid_label: invalid label
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_points_in', 'extension_file_labels_in', 'extension_file_label_disagrement_in', 'extension_file_label_disagrement_out']
			 iterable_names = ['path_points_in','path_labels_in','path_label_disagrement_in','path_label_disagrement_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_points_in': 'folder_points_in', 'path_labels_in': 'folder_labels_in', 'path_label_disagrement_in': 'folder_label_disagrement_in', 'path_label_disagrement_out': 'folder_label_disagrement_out', 'distance': 'distance', 'classes_to_compare': 'classes_to_compare', 'comparison_type': 'comparison_type', 'class_to_filter': 'class_to_filter', 'dim_data': 'dim_data', 'knn': 'knn', 'comparison_axis': 'comparison_axis', 'invalid_label': 'invalid_label'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_points_in', 'folder_labels_in', 'folder_label_disagrement_in', 'folder_label_disagrement_out']
				 itertable_iotypes = ['in', 'in', 'in', 'out']
				 iterable_file_types = ['laz', 'npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'filter_label_disagreement_knn_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.filter_label_disagreement_knn_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_points_in': 'file_points_in', 'path_labels_in': 'file_labels_in', 'path_label_disagrement_in': 'file_label_disagrement_in', 'path_label_disagrement_out': 'file_label_disagrement_out', 'distance': 'distance', 'classes_to_compare': 'classes_to_compare', 'comparison_type': 'comparison_type', 'class_to_filter': 'class_to_filter', 'dim_data': 'dim_data', 'knn': 'knn', 'comparison_axis': 'comparison_axis', 'invalid_label': 'invalid_label'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_points_in', 'file_labels_in', 'file_label_disagrement_in', 'file_label_disagrement_out']
				 itertable_iotypes = ['in', 'in', 'in', 'out']
				 iterable_file_types = ['laz', 'npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'filter_label_disagreement_knn',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.filter_label_disagreement_knn(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def assign_point_labels(self,
			path_source_in='__auto__', 
			path_labels_in='__auto__', 
			path_source_out='__auto__', 
			dtype='classification', 
			all_type='',
			extension_file_source_in = '.laz',
			extension_file_labels_in = '.npy',
			extension_file_source_out = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				assign point labels
				
				:param path_source_in: input folder data
				:param path_labels_in: input folder labels
				:param path_source_out: output folder
				:param dtype: value
				:param all_type: values to load
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_source_in', 'extension_file_labels_in', 'extension_file_source_out']
			 iterable_names = ['path_source_in','path_labels_in','path_source_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_source_in': 'folder_source_in', 'path_labels_in': 'folder_labels_in', 'path_source_out': 'folder_source_out', 'dtype': 'dtype', 'all_type': 'all_type'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_source_in', 'folder_labels_in', 'folder_source_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'npy', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'assign_point_labels_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.assign_point_labels_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_source_in': 'file_source_in', 'path_labels_in': 'file_labels_in', 'path_source_out': 'file_source_out', 'dtype': 'dtype', 'all_type': 'all_type'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_source_in', 'file_labels_in', 'file_source_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'npy', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'assign_point_labels',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.assign_point_labels(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def quantile_filter(self,
			path_in='segmented_object', 
			path_out='quantile_filterd', 
			max_quantile=0.995, 
			min_quantile=0.3, 
			axis=2, 
			max_num_processes=0,

			folder_parallel_processing = '__auto__'):
			 '''
				quantile filter
				
				:param path_in: input folder
				:param path_out: output folder
				:param max_quantile: maximum quantile
				:param min_quantile: minimum quantile
				:param axis: axis 0: x, 1: y, 2: z
				:param max_num_processes: Number of parallel processes
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = []
			 iterable_names = []
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_in': 'path_in', 'path_out': 'path_out', 'max_quantile': 'max_quantile', 'min_quantile': 'min_quantile', 'axis': 'axis', 'max_num_processes': 'max_num_processes'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'quantile_filter_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.quantile_filter_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_in': 'folder_in', 'path_out': 'folder_out', 'max_quantile': 'max_quantile', 'min_quantile': 'min_quantile', 'axis': 'axis', 'max_num_processes': 'max_num_processes'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'quantile_filter',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.quantile_filter(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def retile_generate_grid_locally(self,
			in_path='__auto__', 
			dimension=3, 
			grid_size='20,20,50', 
			offset_factor=0., 
			reference_point='', 
			out_path_tiles='__auto__', 
			out_path_mapping_slice_point_cloud='__auto__', 
			out_path_mapping_point_cloud_to_tiles='__auto__', 
			out_path_mapping_tiles_to_point_cloud='__auto__',
			extension_in_path = '.laz',
			extension_out_path_tiles = '',
			extension_out_path_mapping_slice_point_cloud = '.txt',
			extension_out_path_mapping_point_cloud_to_tiles = '.txt',
			extension_out_path_mapping_tiles_to_point_cloud = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				Create grid for retileing individual point clouds
				
				:param in_path: folder to laz folders to be retiled
				:param dimension: Dimension to be retiled (x,y) or (x,y,z)
				:param grid_size: Grid size for retileing
				:param offset_factor: Offset factor for grid generation
				:param reference_point: Reference point for grid generation, empty for default (min_x, min_y, min_z)
				:param out_path_tiles: Output bounding box / tiles folder
				:param out_path_mapping_slice_point_cloud: Output folder for mapping that contains the point clouds (including neighbouring point clouds) that are used to generate slices from point cloud x
				:param out_path_mapping_point_cloud_to_tiles: Output folder for mapping that contains the tiles that are generated from point cloud x
				:param out_path_mapping_tiles_to_point_cloud: Output folder for mapping that contains the point clouds that are used to generate tile x
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_path', 'extension_out_path_tiles', 'extension_out_path_mapping_slice_point_cloud', 'extension_out_path_mapping_point_cloud_to_tiles', 'extension_out_path_mapping_tiles_to_point_cloud']
			 iterable_names = ['in_path','out_path_tiles','out_path_mapping_slice_point_cloud','out_path_mapping_point_cloud_to_tiles','out_path_mapping_tiles_to_point_cloud']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_path': 'in_folder', 'dimension': 'dimension', 'grid_size': 'grid_size', 'offset_factor': 'offset_factor', 'reference_point': 'reference_point', 'out_path_tiles': 'out_folder_tiles', 'out_path_mapping_slice_point_cloud': 'out_folder_mapping_slice_point_cloud', 'out_path_mapping_point_cloud_to_tiles': 'out_folder_mapping_point_cloud_to_tiles', 'out_path_mapping_tiles_to_point_cloud': 'out_folder_mapping_tiles_to_point_cloud'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_folder', 'out_folder_tiles', 'out_folder_mapping_slice_point_cloud', 'out_folder_mapping_point_cloud_to_tiles', 'out_folder_mapping_tiles_to_point_cloud']
				 itertable_iotypes = ['in', 'out', 'out', 'out', 'out']
				 iterable_file_types = ['laz', 'laz', 'txt', 'txt', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'retile_generate_grid_locally_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.retile_generate_grid_locally_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_path': 'in_path', 'dimension': 'dimension', 'grid_size': 'grid_size', 'offset_factor': 'offset_factor', 'reference_point': 'reference_point', 'out_path_tiles': 'out_path_tiles', 'out_path_mapping_slice_point_cloud': 'out_path_mapping_slice_point_cloud', 'out_path_mapping_point_cloud_to_tiles': 'out_path_mapping_point_cloud_to_tiles', 'out_path_mapping_tiles_to_point_cloud': 'out_path_mapping_tiles_to_point_cloud'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_path', 'out_path_tiles', 'out_path_mapping_slice_point_cloud', 'out_path_mapping_point_cloud_to_tiles', 'out_path_mapping_tiles_to_point_cloud']
				 itertable_iotypes = ['in', 'out', 'out', 'out', 'out']
				 iterable_file_types = ['laz', 'laz', 'txt', 'txt', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'retile_generate_grid_locally',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.retile_generate_grid_locally(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def align_points(self,
			path_source_in='segmented_object', 
			path_transformation_in='transformations', 
			path_source_out='aligned_points',

			folder_parallel_processing = '__auto__'):
			 '''
				align points
				
				:param path_source_in: input folder data
				:param path_transformation_in: input folder transformation
				:param path_source_out: output folder
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = []
			 iterable_names = []
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_source_in': 'path_source_in', 'path_transformation_in': 'path_transformation_in', 'path_source_out': 'path_source_out'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'align_points_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.align_points_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_source_in': 'folder_source_in', 'path_transformation_in': 'folder_transformation_in', 'path_source_out': 'folder_source_out'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'align_points',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.align_points(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def uniform_down_sampling(self,
			input_path='__auto__', 
			cols='', 
			output_path='__auto__', 
			every_k_points=2,
			extension_input_file = '.laz',
			extension_output_file = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				Uniform down sampling of point cloud
				
				:param input_path: Input point cloud folder
				:param cols: Columns to read from input file, default is all columns
				:param output_path: Output point cloud folder
				:param every_k_points: Keep every k points
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_input_file', 'extension_output_file']
			 iterable_names = ['input_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'input_path': 'input_folder', 'cols': 'cols', 'output_path': 'output_folder', 'every_k_points': 'every_k_points'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['input_folder', 'output_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'uniform_down_sampling_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.uniform_down_sampling_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'input_path': 'input_file', 'cols': 'cols', 'output_path': 'output_file', 'every_k_points': 'every_k_points'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['input_file', 'output_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'uniform_down_sampling',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.uniform_down_sampling(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def voxel_downsampling(self,
			path_in='__auto__', 
			path_out='__auto__', 
			voxel_size=0.1, 
			dtype='',
			extension_file_in = '.laz',
			extension_file_out = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				deprecated, please use unfiorm_down_sampling_voxel instead!
				
				:param path_in: input folder data
				:param path_out: output folder
				:param voxel_size: voxel size
				:param dtype: values from point cloud, e.g. X,Y,Z
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_in', 'extension_file_out']
			 iterable_names = ['path_in','path_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_in': 'folder_in', 'path_out': 'folder_out', 'voxel_size': 'voxel_size', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_in', 'folder_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'voxel_downsampling_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.voxel_downsampling_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_in': 'file_in', 'path_out': 'file_out', 'voxel_size': 'voxel_size', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_in', 'file_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'voxel_downsampling',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.voxel_downsampling(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def get_meta_data(self,
			in_path='__auto__', 
			out_path='__auto__',
			extension_in_file = '.laz',
			extension_out_file = '.json',
			folder_parallel_processing = '__auto__'):
			 '''
				Get meta data from las or laz file
				
				:param in_path: Input .laz folder folder
				:param out_path: Output meta data folder folder
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_file', 'extension_out_file']
			 iterable_names = ['in_path','out_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_path': 'in_folder', 'out_path': 'out_folder'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_folder', 'out_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'json']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'get_meta_data_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.get_meta_data_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_path': 'in_file', 'out_path': 'out_file'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_file', 'out_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'json']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'get_meta_data',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.get_meta_data(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def select_center_object(self,
			in_directory='laz_files', 
			out_path='__auto__', 
			latitude=1, 
			longitude=1,
			extension_out_file = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				select center object
				
				:param in_directory: input directory
				:param out_path: output folder
				:param latitude: latitude
				:param longitude: longitude
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_out_file']
			 iterable_names = ['out_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_directory': 'in_directory', 'out_path': 'out_folder', 'latitude': 'latitude', 'longitude': 'longitude'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['out_folder']
				 itertable_iotypes = ['out']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'select_center_object_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.select_center_object_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_directory': 'in_directory', 'out_path': 'out_file', 'latitude': 'latitude', 'longitude': 'longitude'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['out_file']
				 itertable_iotypes = ['out']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'select_center_object',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.select_center_object(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def crop_to_equal_value_range(self,
			path1_in='segmented_object1', 
			path2_in='segmented_object2', 
			path1_out='crop_relative_height1', 
			path2_out='crop_relative_height2', 
			reference='max', 
			axis=2, 
			max_num_processes=0,

			folder_parallel_processing = '__auto__'):
			 '''
				crop to equal value range
				
				:param path1_in: input folder
				:param path2_in: input folder
				:param path1_out: output folder
				:param path2_out: output folder
				:param reference: [max, min, same]: same value range relative to maximum point [max], relative to minimum point [min] or absolute coordinates [same]
				:param axis: axis to crop values
				:param max_num_processes: Number of parallel processes
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = []
			 iterable_names = []
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path1_in': 'path1_in', 'path2_in': 'path2_in', 'path1_out': 'path1_out', 'path2_out': 'path2_out', 'reference': 'reference', 'axis': 'axis', 'max_num_processes': 'max_num_processes'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'crop_to_equal_value_range_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.crop_to_equal_value_range_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path1_in': 'folder1_in', 'path2_in': 'folder2_in', 'path1_out': 'folder1_out', 'path2_out': 'folder2_out', 'reference': 'reference', 'axis': 'axis', 'max_num_processes': 'max_num_processes'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'crop_to_equal_value_range',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.crop_to_equal_value_range(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def retile_generate_grid_globally(self,
			in_paths='__auto__', 
			dimension=3, 
			grid_size='20,20,50', 
			offset_factor=0., 
			reference_point='', 
			out_path_tiles='__auto__', 
			out_path_mapping_slice_point_cloud='slices', 
			out_path_mapping_point_cloud_to_tiles='mapping_point_cloud_to_tiles', 
			out_path_mapping_tiles_to_point_cloud='mapping_tiles_to_point_cloud',
			extension_in_paths = '.laz',
			extension_out_path_tiles = '',
			folder_parallel_processing = '__auto__'):
			 '''
				Create grid for retileing point clouds over multiple georeferenced point clouds
				
				:param in_paths: folder to laz folders to be retiled
				:param dimension: Dimension to be retiled (x,y) or (x,y,z)
				:param grid_size: Grid size for retileing
				:param offset_factor: Offset factor for grid generation
				:param reference_point: Reference point for grid generation, empty for default (min_x, min_y, min_z)
				:param out_path_tiles: Output bounding box / tiles folder
				:param out_path_mapping_slice_point_cloud:  Output path for mapping that contains the point clouds (including neighbouring point clouds) that are used to generate slices from point cloud x
				:param out_path_mapping_point_cloud_to_tiles:  Output path for mapping that contains the tiles that are generated from point cloud x
				:param out_path_mapping_tiles_to_point_cloud:  Output path for mapping that contains the point clouds that are used to generate tile x
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_paths', 'extension_out_path_tiles']
			 iterable_names = ['in_paths','out_path_tiles']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_paths': 'in_folders', 'dimension': 'dimension', 'grid_size': 'grid_size', 'offset_factor': 'offset_factor', 'reference_point': 'reference_point', 'out_path_tiles': 'out_folder_tiles', 'out_path_mapping_slice_point_cloud': 'out_path_mapping_slice_point_cloud', 'out_path_mapping_point_cloud_to_tiles': 'out_path_mapping_point_cloud_to_tiles', 'out_path_mapping_tiles_to_point_cloud': 'out_path_mapping_tiles_to_point_cloud'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_folders', 'out_folder_tiles']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'retile_generate_grid_globally_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.retile_generate_grid_globally_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_paths': 'in_paths', 'dimension': 'dimension', 'grid_size': 'grid_size', 'offset_factor': 'offset_factor', 'reference_point': 'reference_point', 'out_path_tiles': 'out_path_tiles', 'out_path_mapping_slice_point_cloud': 'out_folder_mapping_slice_point_cloud', 'out_path_mapping_point_cloud_to_tiles': 'out_folder_mapping_point_cloud_to_tiles', 'out_path_mapping_tiles_to_point_cloud': 'out_folder_mapping_tiles_to_point_cloud'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_paths', 'out_path_tiles']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'retile_generate_grid_globally',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.retile_generate_grid_globally(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def point_cloud_to_dsm(self,
			path_points_in='__auto__', 
			path_dsm_out='__auto__', 
			path_dtm_out='__auto__', 
			path_chm_out='__auto__', 
			grid_size=0.5,
			extension_file_points_in = '.laz',
			extension_file_dsm_out = '.tif',
			extension_file_dtm_out = '.tif',
			extension_file_chm_out = '.tif',
			folder_parallel_processing = '__auto__'):
			 '''
				point cloud to dsm
				
				:param path_points_in: input points
				:param path_dsm_out: dsm folder
				:param path_dtm_out: dtm folder
				:param path_chm_out: chm folder
				:param grid_size: grid size
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_points_in', 'extension_file_dsm_out', 'extension_file_dtm_out', 'extension_file_chm_out']
			 iterable_names = ['path_points_in','path_dsm_out','path_dtm_out','path_chm_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_points_in': 'folder_points_in', 'path_dsm_out': 'folder_dsm_out', 'path_dtm_out': 'folder_dtm_out', 'path_chm_out': 'folder_chm_out', 'grid_size': 'grid_size'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_points_in', 'folder_dsm_out', 'folder_dtm_out', 'folder_chm_out']
				 itertable_iotypes = ['in', 'in', 'in', 'out']
				 iterable_file_types = ['laz', 'tif', 'tif', 'tif']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'point_cloud_to_dsm_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.ops3d.point_cloud_to_dsm_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_points_in': 'file_points_in', 'path_dsm_out': 'file_dsm_out', 'path_dtm_out': 'file_dtm_out', 'path_chm_out': 'file_chm_out', 'grid_size': 'grid_size'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_points_in', 'file_dsm_out', 'file_dtm_out', 'file_chm_out']
				 itertable_iotypes = ['in', 'in', 'in', 'out']
				 iterable_file_types = ['laz', 'tif', 'tif', 'tif']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'point_cloud_to_dsm',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.ops3d.point_cloud_to_dsm(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'ops3d',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



	 class qc:
		 ''' 
         Namespace for qc functions.
		 '''

		 def __init__(self, outer_class):
			 self.outer_class = outer_class
			 self.client = outer_class.client
			 self.processing_folder = outer_class.processing_folder
			 self._get_call_stack = outer_class._get_call_stack
			 self._add_call_stack = outer_class._add_call_stack
			 self.get_unique_id = outer_class.get_unique_id
			 self.worker_instance_type, self.manager_instance_type = outer_class.get_instance_types()
			 self._check_folder_level_processing = outer_class._check_folder_level_processing
			 self._remap_parameters = outer_class._remap_parameters
			 self._get_param_subset = outer_class._get_param_subset


		 def report_qc_classification(self,
			in_path='__auto__', 
			out_path='__auto__', 
			error_classes='148,149', 
			error_names='Line,Tower', 
			keep_error_free='True',
			extension_in_file = '.laz',
			extension_out_file = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				report qc classification
				
				:param in_path: folder with erroneous points
				:param out_path: output report folder
				:param error_classes: error classes
				:param error_names: error names
				:param keep_error_free: Save empty files?
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_file', 'extension_out_file']
			 iterable_names = ['in_path','out_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_path': 'in_folder', 'out_path': 'out_folder', 'error_classes': 'error_classes', 'error_names': 'error_names', 'keep_error_free': 'keep_error_free'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_folder', 'out_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'report_qc_classification_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.qc.report_qc_classification_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'qc',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_path': 'in_file', 'out_path': 'out_file', 'error_classes': 'error_classes', 'error_names': 'error_names', 'keep_error_free': 'keep_error_free'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_file', 'out_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'report_qc_classification',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.qc.report_qc_classification(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'qc',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def report_image_completeness(self,
			in_path='__auto__', 
			in_meta_data_path='__auto__', 
			out_path='__auto__', 
			grid_size=0.5, 
			populated_class=1, 
			small_holes_class=100, 
			large_holes_class=255, 
			keep_error_free='True',
			extension_in_file = '.txt',
			extension_in_meta_data_file = '.json',
			extension_out_file = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				report image completeness
				
				:param in_path: folder with count of classes
				:param in_meta_data_path: folder with metadata
				:param out_path: output report folder
				:param grid_size: grid size
				:param populated_class: populated class
				:param small_holes_class: small holes class
				:param large_holes_class: large holes class
				:param keep_error_free: Save empty files?
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_file', 'extension_in_meta_data_file', 'extension_out_file']
			 iterable_names = ['in_path','in_meta_data_path','out_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_path': 'in_folder', 'in_meta_data_path': 'in_meta_data_folder', 'out_path': 'out_folder', 'grid_size': 'grid_size', 'populated_class': 'populated_class', 'small_holes_class': 'small_holes_class', 'large_holes_class': 'large_holes_class', 'keep_error_free': 'keep_error_free'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_folder', 'in_meta_data_folder', 'out_folder']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['txt', 'json', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'report_image_completeness_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.qc.report_image_completeness_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'qc',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_path': 'in_file', 'in_meta_data_path': 'in_meta_data_file', 'out_path': 'out_file', 'grid_size': 'grid_size', 'populated_class': 'populated_class', 'small_holes_class': 'small_holes_class', 'large_holes_class': 'large_holes_class', 'keep_error_free': 'keep_error_free'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_file', 'in_meta_data_file', 'out_file']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['txt', 'json', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'report_image_completeness',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.qc.report_image_completeness(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'qc',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def report_vegetation_occurance(self,
			in_path='__auto__', 
			out_path='__auto__', 
			ground_classes_old='2,3,6,7,15', 
			ground_classes_new='1,3,9,11,15', 
			vegetation_old='6,7,15', 
			vegetation_new='9,11,15', 
			keep_error_free='True',
			extension_in_file = '.txt',
			extension_out_file = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				report vegetation occurance
				
				:param in_path: folder with erroneous points
				:param out_path: output report folder
				:param ground_classes_old: ground classes
				:param ground_classes_new: ground classes
				:param vegetation_old: vegetation old classes
				:param vegetation_new: vegetation new classes
				:param keep_error_free: Save empty files?
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_file', 'extension_out_file']
			 iterable_names = ['in_path','out_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_path': 'in_folder', 'out_path': 'out_folder', 'ground_classes_old': 'ground_classes_old', 'ground_classes_new': 'ground_classes_new', 'vegetation_old': 'vegetation_old', 'vegetation_new': 'vegetation_new', 'keep_error_free': 'keep_error_free'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_folder', 'out_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['txt', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'report_vegetation_occurance_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.qc.report_vegetation_occurance_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'qc',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_path': 'in_file', 'out_path': 'out_file', 'ground_classes_old': 'ground_classes_old', 'ground_classes_new': 'ground_classes_new', 'vegetation_old': 'vegetation_old', 'vegetation_new': 'vegetation_new', 'keep_error_free': 'keep_error_free'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_file', 'out_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['txt', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'report_vegetation_occurance',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.qc.report_vegetation_occurance(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'qc',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def report_lidar_completeness(self,
			in_path='__auto__', 
			out_path='__auto__', 
			grid_size=0.5, 
			populated_class=1, 
			small_holes_class=100, 
			large_holes_class=255, 
			keep_error_free='True',
			extension_in_file = '.txt',
			extension_out_file = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				report lidar completeness
				
				:param in_path: folder with erroneous points
				:param out_path: output report folder
				:param grid_size: grid size
				:param populated_class: populated class
				:param small_holes_class: small holes class
				:param large_holes_class: large holes class
				:param keep_error_free: Save empty files?
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_file', 'extension_out_file']
			 iterable_names = ['in_path','out_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_path': 'in_folder', 'out_path': 'out_folder', 'grid_size': 'grid_size', 'populated_class': 'populated_class', 'small_holes_class': 'small_holes_class', 'large_holes_class': 'large_holes_class', 'keep_error_free': 'keep_error_free'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_folder', 'out_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['txt', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'report_lidar_completeness_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.qc.report_lidar_completeness_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'qc',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_path': 'in_file', 'out_path': 'out_file', 'grid_size': 'grid_size', 'populated_class': 'populated_class', 'small_holes_class': 'small_holes_class', 'large_holes_class': 'large_holes_class', 'keep_error_free': 'keep_error_free'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_file', 'out_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['txt', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'report_lidar_completeness',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.qc.report_lidar_completeness(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'qc',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



	 class val:
		 ''' 
         Namespace for val functions.
		 '''

		 def __init__(self, outer_class):
			 self.outer_class = outer_class
			 self.client = outer_class.client
			 self.processing_folder = outer_class.processing_folder
			 self._get_call_stack = outer_class._get_call_stack
			 self._add_call_stack = outer_class._add_call_stack
			 self.get_unique_id = outer_class.get_unique_id
			 self.worker_instance_type, self.manager_instance_type = outer_class.get_instance_types()
			 self._check_folder_level_processing = outer_class._check_folder_level_processing
			 self._remap_parameters = outer_class._remap_parameters
			 self._get_param_subset = outer_class._get_param_subset


		 def equal_constant(self,
			inpath='__auto__', 
			outpath='__auto__', 
			dtype='float', 
			constant=1,
			extension_infile = '.npy',
			extension_outfile = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Equal operator on a matrix.
				
				:param inpath: Input folder folder
				:param outpath: Output folder folder
				:param dtype: Data type of the matrix (default: float)
				:param constant: Value to compare (default: 1)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_infile', 'extension_outfile']
			 iterable_names = ['inpath','outpath']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'inpath': 'infolder', 'outpath': 'outfolder', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['infolder', 'outfolder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'equal_constant_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.equal_constant_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'inpath': 'infile', 'outpath': 'outfile', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['infile', 'outfile']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'equal_constant',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.equal_constant(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def values_divide(self,
			path_values1_in='__auto__', 
			path_values2_in='__auto__', 
			path_values_out='__auto__', 
			ignore_label=float('nan'), 
			value_subset1=float('nan'),
			extension_file_values1_in = '.npy',
			extension_file_values2_in = '.npy',
			extension_file_values_out = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				values divide
				
				:param path_values1_in: input folder [.npy or .txt]
				:param path_values2_in: input folder [.npy or .txt]
				:param path_values_out: output folder [.txt or .npy]
				:param ignore_label: ignore value default: nan
				:param value_subset1: ignore value default: nan
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_values1_in', 'extension_file_values2_in', 'extension_file_values_out']
			 iterable_names = ['path_values1_in','path_values2_in','path_values_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_values1_in': 'folder_values1_in', 'path_values2_in': 'folder_values2_in', 'path_values_out': 'folder_values_out', 'ignore_label': 'ignore_label', 'value_subset1': 'value_subset1'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_values1_in', 'folder_values2_in', 'folder_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_divide_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.values_divide_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_values1_in': 'file_values1_in', 'path_values2_in': 'file_values2_in', 'path_values_out': 'file_values_out', 'ignore_label': 'ignore_label', 'value_subset1': 'value_subset1'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_values1_in', 'file_values2_in', 'file_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_divide',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.values_divide(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def divide_constant(self,
			inpath='__auto__', 
			outpath='__auto__', 
			dtype='float', 
			constant=1.0,
			extension_infile = '.npy',
			extension_outfile = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Divide a constant value from a matrix.
				
				:param inpath: Input folder folder
				:param outpath: Output folder folder
				:param dtype: Data type of the matrix (default: float)
				:param constant: Constant value to divide (default: 1.0)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_infile', 'extension_outfile']
			 iterable_names = ['inpath','outpath']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'inpath': 'infolder', 'outpath': 'outfolder', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['infolder', 'outfolder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'divide_constant_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.divide_constant_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'inpath': 'infile', 'outpath': 'outfile', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['infile', 'outfile']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'divide_constant',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.divide_constant(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def values_less(self,
			inpath1='__auto__', 
			inpath2='__auto__', 
			outpath='__auto__', 
			dtype='float',
			extension_infile1 = '.npy',
			extension_infile2 = '.npy',
			extension_outfile = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Elementwiese less operator on a matrix.
				
				:param inpath1: Input folder folder
				:param inpath2: Input folder folder
				:param outpath: Output folder folder
				:param dtype: Data type of the matrix (default: float)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_infile1', 'extension_infile2', 'extension_outfile']
			 iterable_names = ['inpath1','inpath2','outpath']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'inpath1': 'infolder1', 'inpath2': 'infolder2', 'outpath': 'outfolder', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['infolder1', 'infolder2', 'outfolder']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_less_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.values_less_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'inpath1': 'infile1', 'inpath2': 'infile2', 'outpath': 'outfile', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['infile1', 'infile2', 'outfile']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_less',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.values_less(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def add_constant(self,
			inpath='__auto__', 
			outpath='__auto__', 
			dtype='float', 
			constant=0.0,
			extension_infile = '.npy',
			extension_outfile = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Add a constant value to a matrix.
				
				:param inpath: Input folder folder
				:param outpath: Output folder folder
				:param dtype: Data type of the matrix (default: float)
				:param constant: Constant value to add (default: 0.0)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_infile', 'extension_outfile']
			 iterable_names = ['inpath','outpath']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'inpath': 'infolder', 'outpath': 'outfolder', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['infolder', 'outfolder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'add_constant_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.add_constant_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'inpath': 'infile', 'outpath': 'outfile', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['infile', 'outfile']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'add_constant',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.add_constant(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def values_less_equal(self,
			inpath1='__auto__', 
			inpath2='__auto__', 
			outpath='__auto__', 
			dtype='float',
			extension_infile1 = '.npy',
			extension_infile2 = '.npy',
			extension_outfile = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Elementwiese less equal operator on a matrix.
				
				:param inpath1: Input folder folder
				:param inpath2: Input folder folder
				:param outpath: Output folder folder
				:param dtype: Data type of the matrix (default: float)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_infile1', 'extension_infile2', 'extension_outfile']
			 iterable_names = ['inpath1','inpath2','outpath']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'inpath1': 'infolder1', 'inpath2': 'infolder2', 'outpath': 'outfolder', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['infolder1', 'infolder2', 'outfolder']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_less_equal_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.values_less_equal_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'inpath1': 'infile1', 'inpath2': 'infile2', 'outpath': 'outfile', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['infile1', 'infile2', 'outfile']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_less_equal',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.values_less_equal(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def values_sliced_assign(self,
			path_in='__auto__', 
			path_out='__auto__', 
			indices=':', 
			path_values_in='__auto__', 
			default_value=0.0,
			extension_file_in = '.npy',
			extension_file_out = '.txt',
			extension_file_values_in = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				values sliced assign
				
				:param path_in: input folder [.txt or .npy]
				:param path_out: output folder [.txt or .npy]
				:param indices: indices to slice
				:param path_values_in: input folder [.txt or .npy]
				:param default_value: default value to assign
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_in', 'extension_file_out', 'extension_file_values_in']
			 iterable_names = ['path_in','path_out','path_values_in']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_in': 'folder_in', 'path_out': 'folder_out', 'indices': 'indices', 'path_values_in': 'folder_values_in', 'default_value': 'default_value'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_in', 'folder_out', 'folder_values_in']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'txt', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_sliced_assign_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.values_sliced_assign_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_in': 'file_in', 'path_out': 'file_out', 'indices': 'indices', 'path_values_in': 'file_values_in', 'default_value': 'default_value'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_in', 'file_out', 'file_values_in']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'txt', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_sliced_assign',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.values_sliced_assign(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def masked_assign_constant(self,
			path_values_in='__auto__', 
			constant=0.0, 
			path_mask_in='__auto__', 
			path_values_out='__auto__',
			extension_file_values_in = '.npy',
			extension_file_mask_in = '.npy',
			extension_file_values_out = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				masked assign constant
				
				:param path_values_in: input folder [.txt or .npy]
				:param constant: constant value to assign
				:param path_mask_in: input folder that contains [0,1] values
				:param path_values_out: output folder [.txt or .npy]
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_values_in', 'extension_file_mask_in', 'extension_file_values_out']
			 iterable_names = ['path_values_in','path_mask_in','path_values_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_values_in': 'folder_values_in', 'constant': 'constant', 'path_mask_in': 'folder_mask_in', 'path_values_out': 'folder_values_out'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_values_in', 'folder_mask_in', 'folder_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'masked_assign_constant_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.masked_assign_constant_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_values_in': 'file_values_in', 'constant': 'constant', 'path_mask_in': 'file_mask_in', 'path_values_out': 'file_values_out'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_values_in', 'file_mask_in', 'file_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'masked_assign_constant',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.masked_assign_constant(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def greater_equal_constant(self,
			inpath='__auto__', 
			outpath='__auto__', 
			dtype='float', 
			constant=1,
			extension_infile = '.npy',
			extension_outfile = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Greater equal operator on a matrix.
				
				:param inpath: Input folder folder
				:param outpath: Output folder folder
				:param dtype: Data type of the matrix (default: float)
				:param constant: Value to compare (default: 1)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_infile', 'extension_outfile']
			 iterable_names = ['inpath','outpath']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'inpath': 'infolder', 'outpath': 'outfolder', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['infolder', 'outfolder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'greater_equal_constant_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.greater_equal_constant_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'inpath': 'infile', 'outpath': 'outfile', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['infile', 'outfile']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'greater_equal_constant',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.greater_equal_constant(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def values_not_equal(self,
			path_values1_in='__auto__', 
			path_values2_in='__auto__', 
			path_values_out='__auto__', 
			ignore_label=float('nan'), 
			value_subset1=float('nan'),
			extension_file_values1_in = '.npy',
			extension_file_values2_in = '.npy',
			extension_file_values_out = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				values not equal
				
				:param path_values1_in: input folder [.npy or .txt]
				:param path_values2_in: input folder [.npy or .txt]
				:param path_values_out: output folder [.txt or .npy]
				:param ignore_label: ignore value default: nan
				:param value_subset1: ignore value default: nan
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_values1_in', 'extension_file_values2_in', 'extension_file_values_out']
			 iterable_names = ['path_values1_in','path_values2_in','path_values_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_values1_in': 'folder_values1_in', 'path_values2_in': 'folder_values2_in', 'path_values_out': 'folder_values_out', 'ignore_label': 'ignore_label', 'value_subset1': 'value_subset1'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_values1_in', 'folder_values2_in', 'folder_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_not_equal_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.values_not_equal_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_values1_in': 'file_values1_in', 'path_values2_in': 'file_values2_in', 'path_values_out': 'file_values_out', 'ignore_label': 'ignore_label', 'value_subset1': 'value_subset1'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_values1_in', 'file_values2_in', 'file_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_not_equal',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.values_not_equal(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def min(self,
			inpath='__auto__', 
			outpath='__auto__', 
			dtype='float',
			extension_infile = '.npy',
			extension_outfile = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Minimum of a matrix.
				
				:param inpath: Input folder folder
				:param outpath: Output folder folder
				:param dtype: Data type of the matrix (default: float)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_infile', 'extension_outfile']
			 iterable_names = ['inpath','outpath']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'inpath': 'infolder', 'outpath': 'outfolder', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['infolder', 'outfolder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'min_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.min_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'inpath': 'infile', 'outpath': 'outfile', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['infile', 'outfile']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'min',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.min(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def values_masked_assign(self,
			path_values1_in='__auto__', 
			path_values2_in='__auto__', 
			path_mask_in='__auto__', 
			path_values_out='__auto__',
			extension_file_values1_in = '.npy',
			extension_file_values2_in = '.npy',
			extension_file_mask_in = '.npy',
			extension_file_values_out = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				values masked assign
				
				:param path_values1_in: input folder [.txt or .npy]
				:param path_values2_in: input folder [.txt or .npy]
				:param path_mask_in: input folder that contains [0,1] values
				:param path_values_out: output folder [.txt or .npy]
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_values1_in', 'extension_file_values2_in', 'extension_file_mask_in', 'extension_file_values_out']
			 iterable_names = ['path_values1_in','path_values2_in','path_mask_in','path_values_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_values1_in': 'folder_values1_in', 'path_values2_in': 'folder_values2_in', 'path_mask_in': 'folder_mask_in', 'path_values_out': 'folder_values_out'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_values1_in', 'folder_values2_in', 'folder_mask_in', 'folder_values_out']
				 itertable_iotypes = ['in', 'in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_masked_assign_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.values_masked_assign_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_values1_in': 'file_values1_in', 'path_values2_in': 'file_values2_in', 'path_mask_in': 'file_mask_in', 'path_values_out': 'file_values_out'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_values1_in', 'file_values2_in', 'file_mask_in', 'file_values_out']
				 itertable_iotypes = ['in', 'in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_masked_assign',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.values_masked_assign(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def replace_strings(self,
			path_in='__auto__', 
			path_out='__auto__', 
			replace_from='', 
			replace_to='',
			extension_file_in = '.txt',
			extension_file_out = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				Substrings replacement in an ASCII file
				
				:param path_in: Path to the input folder
				:param path_out: Path to the output folder
				:param replace_from: Comma-separated list of substrings to replace
				:param replace_to: Comma-separated list of replacement substrings
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_in', 'extension_file_out']
			 iterable_names = ['path_in','path_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_in': 'folder_in', 'path_out': 'folder_out', 'replace_from': 'replace_from', 'replace_to': 'replace_to'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_in', 'folder_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['txt', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'replace_strings_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.replace_strings_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_in': 'file_in', 'path_out': 'file_out', 'replace_from': 'replace_from', 'replace_to': 'replace_to'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_in', 'file_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['txt', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'replace_strings',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.replace_strings(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def values_greater_equal(self,
			inpath1='__auto__', 
			inpath2='__auto__', 
			outpath='__auto__', 
			dtype='float',
			extension_infile1 = '.npy',
			extension_infile2 = '.npy',
			extension_outfile = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Elementwiese greater equal operator on a matrix.
				
				:param inpath1: Input folder folder
				:param inpath2: Input folder folder
				:param outpath: Output folder folder
				:param dtype: Data type of the matrix (default: float)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_infile1', 'extension_infile2', 'extension_outfile']
			 iterable_names = ['inpath1','inpath2','outpath']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'inpath1': 'infolder1', 'inpath2': 'infolder2', 'outpath': 'outfolder', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['infolder1', 'infolder2', 'outfolder']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_greater_equal_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.values_greater_equal_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'inpath1': 'infile1', 'inpath2': 'infile2', 'outpath': 'outfile', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['infile1', 'infile2', 'outfile']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_greater_equal',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.values_greater_equal(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def max(self,
			inpath='__auto__', 
			outpath='__auto__', 
			dtype='float',
			extension_infile = '.npy',
			extension_outfile = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Maximum of a matrix.
				
				:param inpath: Input folder folder
				:param outpath: Output folder folder
				:param dtype: Data type of the matrix (default: float)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_infile', 'extension_outfile']
			 iterable_names = ['inpath','outpath']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'inpath': 'infolder', 'outpath': 'outfolder', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['infolder', 'outfolder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'max_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.max_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'inpath': 'infile', 'outpath': 'outfile', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['infile', 'outfile']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'max',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.max(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def less_constant(self,
			inpath='__auto__', 
			outpath='__auto__', 
			dtype='float', 
			constant=1,
			extension_infile = '.npy',
			extension_outfile = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Less operator on a matrix.
				
				:param inpath: Input folder folder
				:param outpath: Output folder folder
				:param dtype: Data type of the matrix (default: float)
				:param constant: Value to compare (default: 1)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_infile', 'extension_outfile']
			 iterable_names = ['inpath','outpath']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'inpath': 'infolder', 'outpath': 'outfolder', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['infolder', 'outfolder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'less_constant_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.less_constant_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'inpath': 'infile', 'outpath': 'outfile', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['infile', 'outfile']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'less_constant',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.less_constant(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def subtract_constant(self,
			inpath='__auto__', 
			outpath='__auto__', 
			dtype='float', 
			constant=0.0,
			extension_infile = '.npy',
			extension_outfile = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Subtract a constant value from a matrix.
				
				:param inpath: Input folder folder
				:param outpath: Output folder folder
				:param dtype: Data type of the matrix (default: float)
				:param constant: Constant value to subtract (default: 0.0)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_infile', 'extension_outfile']
			 iterable_names = ['inpath','outpath']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'inpath': 'infolder', 'outpath': 'outfolder', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['infolder', 'outfolder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'subtract_constant_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.subtract_constant_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'inpath': 'infile', 'outpath': 'outfile', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['infile', 'outfile']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'subtract_constant',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.subtract_constant(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def values_hstack(self,
			path_values1_in='__auto__', 
			path_values2_in='__auto__', 
			path_values_out='__auto__', 
			dtype='str',
			extension_file_values1_in = '.npy',
			extension_file_values2_in = '.npy',
			extension_file_values_out = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				values hstack
				
				:param path_values1_in: input folder [.npy, .labels or .txt]
				:param path_values2_in: input folder [.npy, .labels or .txt]
				:param path_values_out: output folder [.txt or .npy]
				:param dtype: data type
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_values1_in', 'extension_file_values2_in', 'extension_file_values_out']
			 iterable_names = ['path_values1_in','path_values2_in','path_values_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_values1_in': 'folder_values1_in', 'path_values2_in': 'folder_values2_in', 'path_values_out': 'folder_values_out', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_values1_in', 'folder_values2_in', 'folder_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_hstack_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.values_hstack_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_values1_in': 'file_values1_in', 'path_values2_in': 'file_values2_in', 'path_values_out': 'file_values_out', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_values1_in', 'file_values2_in', 'file_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_hstack',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.values_hstack(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def resize_slice_matrix(self,
			pathname_in='__auto__', 
			pathname_out='__auto__', 
			dtype='float', 
			indices=':,124:,:3', 
			default_value=0.0,
			extension_filename_in = '.npy',
			extension_filename_out = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Resize and slice a matrix based on indices.
				
				:param pathname_in: Input folder folder for the matrix
				:param pathname_out: Output folder folder for the resized and sliced matrix
				:param dtype: Data type of the matrix (default: float)
				:param indices: Indices to slice the matrix (in NumPy slicing convention)
				:param default_value: Default value to fill when resizing (default: 0.0)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_filename_in', 'extension_filename_out']
			 iterable_names = ['pathname_in','pathname_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'pathname_in': 'foldername_in', 'pathname_out': 'foldername_out', 'dtype': 'dtype', 'indices': 'indices', 'default_value': 'default_value'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['foldername_in', 'foldername_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'resize_slice_matrix_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.resize_slice_matrix_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'pathname_in': 'filename_in', 'pathname_out': 'filename_out', 'dtype': 'dtype', 'indices': 'indices', 'default_value': 'default_value'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['filename_in', 'filename_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'resize_slice_matrix',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.resize_slice_matrix(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def sum(self,
			inpath='__auto__', 
			outpath='__auto__', 
			dtype='float', 
			axis=-1,
			extension_infile = '.npy',
			extension_outfile = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Sum all values of a matrix.
				
				:param inpath: Input folder folder
				:param outpath: Output folder folder
				:param dtype: Data type of the matrix (default: float)
				:param axis: axis to sum [default -1: no axis is used]
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_infile', 'extension_outfile']
			 iterable_names = ['inpath','outpath']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'inpath': 'infolder', 'outpath': 'outfolder', 'dtype': 'dtype', 'axis': 'axis'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['infolder', 'outfolder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'sum_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.sum_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'inpath': 'infile', 'outpath': 'outfile', 'dtype': 'dtype', 'axis': 'axis'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['infile', 'outfile']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'sum',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.sum(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def greater_constant(self,
			inpath='__auto__', 
			outpath='__auto__', 
			dtype='float', 
			constant=1,
			extension_infile = '.npy',
			extension_outfile = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Greater operator on a matrix.
				
				:param inpath: Input folder folder
				:param outpath: Output folder folder
				:param dtype: Data type of the matrix (default: float)
				:param constant: Value to compare (default: 1)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_infile', 'extension_outfile']
			 iterable_names = ['inpath','outpath']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'inpath': 'infolder', 'outpath': 'outfolder', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['infolder', 'outfolder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'greater_constant_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.greater_constant_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'inpath': 'infile', 'outpath': 'outfile', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['infile', 'outfile']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'greater_constant',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.greater_constant(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def connected_components_labeling(self,
			pathname_in='__auto__', 
			pathname_out='__auto__', 
			dtype='float', 
			no_type=0.0, 
			value=1.0,
			extension_filename_in = '.npy',
			extension_filename_out = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Perform connected components labeling on a matrix.
				
				:param pathname_in: Input folder folder for the matrix
				:param pathname_out: Output folder folder for the labeled matrix
				:param dtype: Data type of the matrix (default: float)
				:param no_type: Value representing no_type in the matrix (default: 0.0)
				:param value: Value representing value in the matrix (default: 1.0)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_filename_in', 'extension_filename_out']
			 iterable_names = ['pathname_in','pathname_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'pathname_in': 'foldername_in', 'pathname_out': 'foldername_out', 'dtype': 'dtype', 'no_type': 'no_type', 'value': 'value'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['foldername_in', 'foldername_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'connected_components_labeling_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.connected_components_labeling_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'pathname_in': 'filename_in', 'pathname_out': 'filename_out', 'dtype': 'dtype', 'no_type': 'no_type', 'value': 'value'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['filename_in', 'filename_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'connected_components_labeling',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.connected_components_labeling(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def values_distance(self,
			pathname_is='__auto__', 
			pathname_should='__auto__', 
			output_path='__auto__', 
			dtype='float', 
			no_type=0.0, 
			value=1.0, 
			gridsize=1.0,
			extension_filename_is = '.npy',
			extension_filename_should = '.npy',
			extension_output_file = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Compute Euclidean distance from is matrix to should matrix.
				
				:param pathname_is: Input folder folder for is matrix
				:param pathname_should: Input folder folder for should matrix
				:param output_path: Output folder folder for distances matrix
				:param dtype: Data type of the matrices (default: float)
				:param no_type: Value representing no_type in the matrices (default: 0.0)
				:param value: Value representing value in the matrices (default: 1.0)
				:param gridsize: Resolution of the spatial grid in meters (default: 1.0)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_filename_is', 'extension_filename_should', 'extension_output_file']
			 iterable_names = ['pathname_is','pathname_should','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'pathname_is': 'foldername_is', 'pathname_should': 'foldername_should', 'output_path': 'output_folder', 'dtype': 'dtype', 'no_type': 'no_type', 'value': 'value', 'gridsize': 'gridsize'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['foldername_is', 'foldername_should', 'output_folder']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_distance_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.values_distance_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'pathname_is': 'filename_is', 'pathname_should': 'filename_should', 'output_path': 'output_file', 'dtype': 'dtype', 'no_type': 'no_type', 'value': 'value', 'gridsize': 'gridsize'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['filename_is', 'filename_should', 'output_file']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_distance',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.values_distance(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def values_greater(self,
			inpath1='__auto__', 
			inpath2='__auto__', 
			outpath='__auto__', 
			dtype='float',
			extension_infile1 = '.npy',
			extension_infile2 = '.npy',
			extension_outfile = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Elementwiese greater operator on a matrix.
				
				:param inpath1: Input folder folder
				:param inpath2: Input folder folder
				:param outpath: Output folder folder
				:param dtype: Data type of the matrix (default: float)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_infile1', 'extension_infile2', 'extension_outfile']
			 iterable_names = ['inpath1','inpath2','outpath']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'inpath1': 'infolder1', 'inpath2': 'infolder2', 'outpath': 'outfolder', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['infolder1', 'infolder2', 'outfolder']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_greater_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.values_greater_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'inpath1': 'infile1', 'inpath2': 'infile2', 'outpath': 'outfile', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['infile1', 'infile2', 'outfile']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_greater',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.values_greater(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def values_add(self,
			path_values1_in='__auto__', 
			path_values2_in='__auto__', 
			path_values_out='__auto__', 
			ignore_label=float('nan'), 
			value_subset1=float('nan'),
			extension_file_values1_in = '.npy',
			extension_file_values2_in = '.npy',
			extension_file_values_out = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				values add
				
				:param path_values1_in: input folder [.npy, .labels or .txt]
				:param path_values2_in: input folder [.npy, .labels or .txt]
				:param path_values_out: output folder [.txt or .npy]
				:param ignore_label: ignore value default: nan
				:param value_subset1: ignore value default: nan
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_values1_in', 'extension_file_values2_in', 'extension_file_values_out']
			 iterable_names = ['path_values1_in','path_values2_in','path_values_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_values1_in': 'folder_values1_in', 'path_values2_in': 'folder_values2_in', 'path_values_out': 'folder_values_out', 'ignore_label': 'ignore_label', 'value_subset1': 'value_subset1'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_values1_in', 'folder_values2_in', 'folder_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_add_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.values_add_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_values1_in': 'file_values1_in', 'path_values2_in': 'file_values2_in', 'path_values_out': 'file_values_out', 'ignore_label': 'ignore_label', 'value_subset1': 'value_subset1'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_values1_in', 'file_values2_in', 'file_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_add',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.values_add(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def argmax(self,
			inpath='__auto__', 
			outpath='__auto__', 
			dtype='float', 
			axis=-1,
			extension_infile = '.npy',
			extension_outfile = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Argmax of a matrix.
				
				:param inpath: Input folder folder
				:param outpath: Output folder folder
				:param dtype: Data type of the matrix (default: float)
				:param axis: Axis to find the argmax (default: None)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_infile', 'extension_outfile']
			 iterable_names = ['inpath','outpath']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'inpath': 'infolder', 'outpath': 'outfolder', 'dtype': 'dtype', 'axis': 'axis'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['infolder', 'outfolder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'argmax_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.argmax_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'inpath': 'infile', 'outpath': 'outfile', 'dtype': 'dtype', 'axis': 'axis'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['infile', 'outfile']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'argmax',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.argmax(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def argmin(self,
			inpath='__auto__', 
			outpath='__auto__', 
			dtype='float', 
			axis=-1,
			extension_infile = '.npy',
			extension_outfile = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Argmin of a matrix.
				
				:param inpath: Input folder folder
				:param outpath: Output folder folder
				:param dtype: Data type of the matrix (default: float)
				:param axis: Axis to find the argmax (default: None)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_infile', 'extension_outfile']
			 iterable_names = ['inpath','outpath']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'inpath': 'infolder', 'outpath': 'outfolder', 'dtype': 'dtype', 'axis': 'axis'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['infolder', 'outfolder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'argmin_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.argmin_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'inpath': 'infile', 'outpath': 'outfile', 'dtype': 'dtype', 'axis': 'axis'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['infile', 'outfile']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'argmin',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.argmin(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def not_equal_constant(self,
			inpath='__auto__', 
			outpath='__auto__', 
			dtype='float', 
			constant=1,
			extension_infile = '.npy',
			extension_outfile = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Not equal operator on a matrix.
				
				:param inpath: Input folder folder
				:param outpath: Output folder folder
				:param dtype: Data type of the matrix (default: float)
				:param constant: Value to compare (default: 1)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_infile', 'extension_outfile']
			 iterable_names = ['inpath','outpath']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'inpath': 'infolder', 'outpath': 'outfolder', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['infolder', 'outfolder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'not_equal_constant_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.not_equal_constant_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'inpath': 'infile', 'outpath': 'outfile', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['infile', 'outfile']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'not_equal_constant',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.not_equal_constant(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def multiply_constant(self,
			inpath='__auto__', 
			outpath='__auto__', 
			dtype='float', 
			constant=1.0,
			extension_infile = '.npy',
			extension_outfile = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Multiply a constant value from a matrix.
				
				:param inpath: Input folder folder
				:param outpath: Output folder folder
				:param dtype: Data type of the matrix (default: float)
				:param constant: Constant value to multiply (default: 1.0)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_infile', 'extension_outfile']
			 iterable_names = ['inpath','outpath']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'inpath': 'infolder', 'outpath': 'outfolder', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['infolder', 'outfolder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'multiply_constant_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.multiply_constant_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'inpath': 'infile', 'outpath': 'outfile', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['infile', 'outfile']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'multiply_constant',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.multiply_constant(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def values_assign(self,
			path_values1_in='__auto__', 
			path_values2_in='__auto__', 
			path_values_out='__auto__', 
			ignore_label=float('nan'), 
			value_subset1=float('nan'),
			extension_file_values1_in = '.npy',
			extension_file_values2_in = '.npy',
			extension_file_values_out = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				values assign
				
				:param path_values1_in: input folder [.npy or .txt]
				:param path_values2_in: input folder [.npy or .txt]
				:param path_values_out: output folder [.txt or .npy]
				:param ignore_label: ignore value default: nan
				:param value_subset1: ignore value default: nan
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_values1_in', 'extension_file_values2_in', 'extension_file_values_out']
			 iterable_names = ['path_values1_in','path_values2_in','path_values_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_values1_in': 'folder_values1_in', 'path_values2_in': 'folder_values2_in', 'path_values_out': 'folder_values_out', 'ignore_label': 'ignore_label', 'value_subset1': 'value_subset1'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_values1_in', 'folder_values2_in', 'folder_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_assign_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.values_assign_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_values1_in': 'file_values1_in', 'path_values2_in': 'file_values2_in', 'path_values_out': 'file_values_out', 'ignore_label': 'ignore_label', 'value_subset1': 'value_subset1'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_values1_in', 'file_values2_in', 'file_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_assign',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.values_assign(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def sliced_assign_constant(self,
			path_in='__auto__', 
			path_out='__auto__', 
			indices=':', 
			constant=0.0,
			extension_file_in = '.npy',
			extension_file_out = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				sliced assign constant
				
				:param path_in: input folder [.txt or .npy]
				:param path_out: output folder [.txt or .npy]
				:param indices: indices to slice
				:param constant: constant value to assign
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_in', 'extension_file_out']
			 iterable_names = ['path_in','path_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_in': 'folder_in', 'path_out': 'folder_out', 'indices': 'indices', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_in', 'folder_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'sliced_assign_constant_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.sliced_assign_constant_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_in': 'file_in', 'path_out': 'file_out', 'indices': 'indices', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_in', 'file_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'sliced_assign_constant',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.sliced_assign_constant(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def count_unique_values(self,
			pathname_in='__auto__', 
			pathname_out='__auto__', 
			dtype='float', 
			ignore='nan',
			extension_filename_in = '.npy',
			extension_filename_out = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Count unique occurrences of values in a matrix.
				
				:param pathname_in: Input folder folder for the matrix
				:param pathname_out: Output folder folder for the unique counts matrix
				:param dtype: Data type of the matrix (default: float)
				:param ignore: Data value to ignore
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_filename_in', 'extension_filename_out']
			 iterable_names = ['pathname_in','pathname_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'pathname_in': 'foldername_in', 'pathname_out': 'foldername_out', 'dtype': 'dtype', 'ignore': 'ignore'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['foldername_in', 'foldername_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'count_unique_values_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.count_unique_values_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'pathname_in': 'filename_in', 'pathname_out': 'filename_out', 'dtype': 'dtype', 'ignore': 'ignore'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['filename_in', 'filename_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'count_unique_values',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.count_unique_values(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def replace_in_string_array(self,
			path_in='__auto__', 
			path_out='__auto__', 
			tokens_to_replace='', 
			replacement_tokens='',
			extension_file_in = '.txt',
			extension_file_out = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				Replace tokens in a string array
				
				:param path_in: Input foldername
				:param path_out: Output foldername
				:param tokens_to_replace: Tokens to replace, comma separated
				:param replacement_tokens: Replacement tokens, comma separated
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_in', 'extension_file_out']
			 iterable_names = ['path_in','path_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_in': 'folder_in', 'path_out': 'folder_out', 'tokens_to_replace': 'tokens_to_replace', 'replacement_tokens': 'replacement_tokens'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_in', 'folder_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['txt', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'replace_in_string_array_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.replace_in_string_array_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_in': 'file_in', 'path_out': 'file_out', 'tokens_to_replace': 'tokens_to_replace', 'replacement_tokens': 'replacement_tokens'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_in', 'file_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['txt', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'replace_in_string_array',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.replace_in_string_array(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def hstack(self,
			path_values_in='__auto__', 
			path_values_out='__auto__', 
			dtype='str',
			extension_file_values_in = '.npy',
			extension_file_values_out = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				hstack
				
				:param path_values_in: input folder [.npy, .labels or .txt]
				:param path_values_out: output folder [.txt or .npy]
				:param dtype: data type
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_values_in', 'extension_file_values_out']
			 iterable_names = ['path_values_in','path_values_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_values_in': 'folder_values_in', 'path_values_out': 'folder_values_out', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_values_in', 'folder_values_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'hstack_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.hstack_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_values_in': 'file_values_in', 'path_values_out': 'file_values_out', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_values_in', 'file_values_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'hstack',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.hstack(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def mask_subset(self,
			path_values1_in='__auto__', 
			path_mask_in='__auto__', 
			path_values_out='__auto__',
			extension_file_values1_in = '.npy',
			extension_file_mask_in = '.npy',
			extension_file_values_out = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				mask subset
				
				:param path_values1_in: input folder [.txt or .npy]
				:param path_mask_in: input folder that contains [0,1] values
				:param path_values_out: output folder [.txt or .npy]
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_values1_in', 'extension_file_mask_in', 'extension_file_values_out']
			 iterable_names = ['path_values1_in','path_mask_in','path_values_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_values1_in': 'folder_values1_in', 'path_mask_in': 'folder_mask_in', 'path_values_out': 'folder_values_out'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_values1_in', 'folder_mask_in', 'folder_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'mask_subset_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.mask_subset_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_values1_in': 'file_values1_in', 'path_mask_in': 'file_mask_in', 'path_values_out': 'file_values_out'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_values1_in', 'file_mask_in', 'file_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'mask_subset',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.mask_subset(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def values_multiply(self,
			path_values1_in='__auto__', 
			path_values2_in='__auto__', 
			path_values_out='__auto__', 
			ignore_label=float('nan'), 
			value_subset1=float('nan'),
			extension_file_values1_in = '.npy',
			extension_file_values2_in = '.npy',
			extension_file_values_out = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				values multiply
				
				:param path_values1_in: input folder [.npy or .txt]
				:param path_values2_in: input folder [.npy or .txt]
				:param path_values_out: output folder [.txt or .npy]
				:param ignore_label: ignore value default: nan
				:param value_subset1: ignore value default: nan
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_values1_in', 'extension_file_values2_in', 'extension_file_values_out']
			 iterable_names = ['path_values1_in','path_values2_in','path_values_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_values1_in': 'folder_values1_in', 'path_values2_in': 'folder_values2_in', 'path_values_out': 'folder_values_out', 'ignore_label': 'ignore_label', 'value_subset1': 'value_subset1'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_values1_in', 'folder_values2_in', 'folder_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_multiply_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.values_multiply_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_values1_in': 'file_values1_in', 'path_values2_in': 'file_values2_in', 'path_values_out': 'file_values_out', 'ignore_label': 'ignore_label', 'value_subset1': 'value_subset1'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_values1_in', 'file_values2_in', 'file_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_multiply',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.values_multiply(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def slice_string_array(self,
			path_in='__auto__', 
			path_out='__auto__', 
			slices='',
			extension_file_in = '.txt',
			extension_file_out = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				Slice a string array
				
				:param path_in: Input foldername
				:param path_out: Output foldername
				:param slices: Slices to take
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_in', 'extension_file_out']
			 iterable_names = ['path_in','path_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_in': 'folder_in', 'path_out': 'folder_out', 'slices': 'slices'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_in', 'folder_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['txt', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'slice_string_array_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.slice_string_array_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_in': 'file_in', 'path_out': 'file_out', 'slices': 'slices'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_in', 'file_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['txt', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'slice_string_array',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.slice_string_array(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def values_equal(self,
			path_values1_in='__auto__', 
			path_values2_in='__auto__', 
			path_values_out='__auto__', 
			ignore_label=float('nan'), 
			value_subset1=float('nan'),
			extension_file_values1_in = '.npy',
			extension_file_values2_in = '.npy',
			extension_file_values_out = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				values equal
				
				:param path_values1_in: input folder [.npy or .txt]
				:param path_values2_in: input folder [.npy or .txt]
				:param path_values_out: output folder [.txt or .npy]
				:param ignore_label: ignore value default: nan
				:param value_subset1: ignore value default: nan
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_values1_in', 'extension_file_values2_in', 'extension_file_values_out']
			 iterable_names = ['path_values1_in','path_values2_in','path_values_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_values1_in': 'folder_values1_in', 'path_values2_in': 'folder_values2_in', 'path_values_out': 'folder_values_out', 'ignore_label': 'ignore_label', 'value_subset1': 'value_subset1'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_values1_in', 'folder_values2_in', 'folder_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_equal_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.values_equal_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_values1_in': 'file_values1_in', 'path_values2_in': 'file_values2_in', 'path_values_out': 'file_values_out', 'ignore_label': 'ignore_label', 'value_subset1': 'value_subset1'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_values1_in', 'file_values2_in', 'file_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_equal',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.values_equal(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def less_equal_constant(self,
			inpath='__auto__', 
			outpath='__auto__', 
			dtype='float', 
			constant=1,
			extension_infile = '.npy',
			extension_outfile = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Less equal operator on a matrix.
				
				:param inpath: Input folder folder
				:param outpath: Output folder folder
				:param dtype: Data type of the matrix (default: float)
				:param constant: Value to compare (default: 1)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_infile', 'extension_outfile']
			 iterable_names = ['inpath','outpath']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'inpath': 'infolder', 'outpath': 'outfolder', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['infolder', 'outfolder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'less_equal_constant_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.less_equal_constant_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'inpath': 'infile', 'outpath': 'outfile', 'dtype': 'dtype', 'constant': 'constant'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['infile', 'outfile']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'less_equal_constant',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.less_equal_constant(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def vstack(self,
			path_values_in='__auto__', 
			path_values_out='__auto__', 
			dtype='str',
			extension_file_values_in = '.npy',
			extension_file_values_out = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				vstack
				
				:param path_values_in: input folder [.npy, .labels or .txt]
				:param path_values_out: output folder [.txt or .npy]
				:param dtype: data type
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_values_in', 'extension_file_values_out']
			 iterable_names = ['path_values_in','path_values_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_values_in': 'folder_values_in', 'path_values_out': 'folder_values_out', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_values_in', 'folder_values_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'vstack_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.vstack_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_values_in': 'file_values_in', 'path_values_out': 'file_values_out', 'dtype': 'dtype'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_values_in', 'file_values_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'vstack',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.vstack(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def remap_values(self,
			path_values_in='__auto__', 
			path_values_out='__auto__', 
			map_in='1,2,3,4', 
			map_out='3,1,2,2', 
			dtype_in='int32', 
			dtype_out='int32', 
			unmapped='0',
			extension_file_values_in = '.npy',
			extension_file_values_out = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				remap values
				
				:param path_values_in: input folder [.txt, .labels or .npy]
				:param path_values_out: output folder [.txt, .labels or .npy]
				:param map_in: map in
				:param map_out: map out
				:param dtype_in: data type input
				:param dtype_out: data type output
				:param unmapped: default value for values where no mapping exists
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_values_in', 'extension_file_values_out']
			 iterable_names = ['path_values_in','path_values_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_values_in': 'folder_values_in', 'path_values_out': 'folder_values_out', 'map_in': 'map_in', 'map_out': 'map_out', 'dtype_in': 'dtype_in', 'dtype_out': 'dtype_out', 'unmapped': 'unmapped'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_values_in', 'folder_values_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'remap_values_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.remap_values_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_values_in': 'file_values_in', 'path_values_out': 'file_values_out', 'map_in': 'map_in', 'map_out': 'map_out', 'dtype_in': 'dtype_in', 'dtype_out': 'dtype_out', 'unmapped': 'unmapped'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_values_in', 'file_values_out']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'remap_values',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.remap_values(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def values_subtract(self,
			path_values1_in='__auto__', 
			path_values2_in='__auto__', 
			path_values_out='__auto__', 
			ignore_label=float('nan'), 
			value_subset1=float('nan'),
			extension_file_values1_in = '.npy',
			extension_file_values2_in = '.npy',
			extension_file_values_out = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				values subtract
				
				:param path_values1_in: input folder [.npy or .txt]
				:param path_values2_in: input folder [.npy or .txt]
				:param path_values_out: output folder [.txt or .npy]
				:param ignore_label: ignore value default: nan
				:param value_subset1: ignore value default: nan
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_values1_in', 'extension_file_values2_in', 'extension_file_values_out']
			 iterable_names = ['path_values1_in','path_values2_in','path_values_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_values1_in': 'folder_values1_in', 'path_values2_in': 'folder_values2_in', 'path_values_out': 'folder_values_out', 'ignore_label': 'ignore_label', 'value_subset1': 'value_subset1'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_values1_in', 'folder_values2_in', 'folder_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_subtract_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.val.values_subtract_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_values1_in': 'file_values1_in', 'path_values2_in': 'file_values2_in', 'path_values_out': 'file_values_out', 'ignore_label': 'ignore_label', 'value_subset1': 'value_subset1'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_values1_in', 'file_values2_in', 'file_values_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['npy', 'npy', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'values_subtract',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.val.values_subtract(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'val',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



	 class fvo:
		 ''' 
         Namespace for fvo functions.
		 '''

		 def __init__(self, outer_class):
			 self.outer_class = outer_class
			 self.client = outer_class.client
			 self.processing_folder = outer_class.processing_folder
			 self._get_call_stack = outer_class._get_call_stack
			 self._add_call_stack = outer_class._add_call_stack
			 self.get_unique_id = outer_class.get_unique_id
			 self.worker_instance_type, self.manager_instance_type = outer_class.get_instance_types()
			 self._check_folder_level_processing = outer_class._check_folder_level_processing
			 self._remap_parameters = outer_class._remap_parameters
			 self._get_param_subset = outer_class._get_param_subset


		 def model_swap_axis(self,
			input_path='__auto__', 
			output_path='__auto__',
			extension_input_file = '.dxf',
			extension_output_file = '.dxf',
			folder_parallel_processing = '__auto__'):
			 '''
				model swap axis
				
				:param input_path: input dxf folder folder
				:param output_path: output dxf folder folder
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_input_file', 'extension_output_file']
			 iterable_names = ['input_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'input_path': 'input_folder', 'output_path': 'output_folder'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['input_folder', 'output_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['dxf', 'dxf']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'model_swap_axis_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.fvo.model_swap_axis_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'input_path': 'input_file', 'output_path': 'output_file'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['input_file', 'output_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['dxf', 'dxf']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'model_swap_axis',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.fvo.model_swap_axis(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def estimate_vobject_coordinates(self,
			path_source_in='__auto__', 
			path_trafo_out='__auto__', 
			path_source_out='__auto__',
			extension_file_source_in = '.laz',
			extension_file_trafo_out = '.txt',
			extension_file_source_out = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				estimate vobject coordinates
				
				:param path_source_in: input folder data
				:param path_trafo_out: output trafo
				:param path_source_out: output folder data
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_file_source_in', 'extension_file_trafo_out', 'extension_file_source_out']
			 iterable_names = ['path_source_in','path_trafo_out','path_source_out']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_source_in': 'folder_source_in', 'path_trafo_out': 'folder_trafo_out', 'path_source_out': 'folder_source_out'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['folder_source_in', 'folder_trafo_out', 'folder_source_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'txt', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'estimate_vobject_coordinates_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.fvo.estimate_vobject_coordinates_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_source_in': 'file_source_in', 'path_trafo_out': 'file_trafo_out', 'path_source_out': 'file_source_out'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['file_source_in', 'file_trafo_out', 'file_source_out']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'txt', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'estimate_vobject_coordinates',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.fvo.estimate_vobject_coordinates(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def filter_valid_vertices(self,
			input_path='__auto__', 
			input_path2='__auto__', 
			input_path_features='__auto__', 
			output_path='__auto__', 
			output_path_features='__auto__', 
			min_distance=0.0, 
			max_distance=100,
			extension_input_file = '.laz',
			extension_input_file2 = '.laz',
			extension_input_file_features = '.npy',
			extension_output_file = '.laz',
			extension_output_file_features = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Filter valid vertices from a DXF file.
				
				:param input_path: Input laz or txt folder to filter.
				:param input_path2: Input laz or txt folder as reference.
				:param input_path_features: Input features folder.
				:param output_path: Output laz or txt folder.
				:param output_path_features: Output features folder.
				:param min_distance: Minimum distance.
				:param max_distance: Maximum distance.
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_input_file', 'extension_input_file2', 'extension_input_file_features', 'extension_output_file', 'extension_output_file_features']
			 iterable_names = ['input_path','input_path2','input_path_features','output_path','output_path_features']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'input_path': 'input_folder', 'input_path2': 'input_folder2', 'input_path_features': 'input_folder_features', 'output_path': 'output_folder', 'output_path_features': 'output_folder_features', 'min_distance': 'min_distance', 'max_distance': 'max_distance'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['input_folder', 'input_folder2', 'input_folder_features', 'output_folder', 'output_folder_features']
				 itertable_iotypes = ['in', 'in', 'in', 'out', 'out']
				 iterable_file_types = ['laz', 'laz', 'npy', 'laz', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'filter_valid_vertices_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.fvo.filter_valid_vertices_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'input_path': 'input_file', 'input_path2': 'input_file2', 'input_path_features': 'input_file_features', 'output_path': 'output_file', 'output_path_features': 'output_file_features', 'min_distance': 'min_distance', 'max_distance': 'max_distance'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['input_file', 'input_file2', 'input_file_features', 'output_file', 'output_file_features']
				 itertable_iotypes = ['in', 'in', 'in', 'out', 'out']
				 iterable_file_types = ['laz', 'laz', 'npy', 'laz', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'filter_valid_vertices',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.fvo.filter_valid_vertices(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def align_top(self,
			input_path='__auto__', 
			target_path='__auto__', 
			output_path='__auto__',
			extension_input_file = '.laz',
			extension_target_file = '.laz',
			extension_output_file = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				Zero centering of XYZ points in a LAZ file
				
				:param input_path: input LAZ folder folder
				:param target_path: input LAZ folder folder
				:param output_path: output LAZ folder folder
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_input_file', 'extension_target_file', 'extension_output_file']
			 iterable_names = ['input_path','target_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'input_path': 'input_folder', 'target_path': 'folder_target_folder', 'output_path': 'output_folder'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['input_folder', 'target_folder', 'output_folder']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'align_top_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.fvo.align_top_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'input_path': 'input_file', 'target_path': 'target_file', 'output_path': 'output_file'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['input_file', 'target_file', 'output_file']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'align_top',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.fvo.align_top(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def optimize_model_graph(self,
			in_dxf_path='__auto__', 
			in_point_cloud_path='__auto__', 
			out_dxf_path='__auto__', 
			max_distance=0.35, 
			num_iterations=4,
			extension_in_dxf_file = '.dxf',
			extension_in_point_cloud_file = '.laz',
			extension_out_dxf_file = '.dxf',
			folder_parallel_processing = '__auto__'):
			 '''
				Optimize the graph of a 3D model.
				
				:param in_dxf_path: input folder
				:param in_point_cloud_path: input folder
				:param out_dxf_path: output folder
				:param max_distance: Maximum distance between a point and a graph node for the point to be considered a candidate for merging with the graph node.
				:param num_iterations: Number of iterations to run the optimization.
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_dxf_file', 'extension_in_point_cloud_file', 'extension_out_dxf_file']
			 iterable_names = ['in_dxf_path','in_point_cloud_path','out_dxf_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_dxf_path': 'in_dxf_folder', 'in_point_cloud_path': 'in_point_cloud_folder', 'out_dxf_path': 'out_dxf_folder', 'max_distance': 'max_distance', 'num_iterations': 'num_iterations'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_dxf_folder', 'in_point_cloud_folder', 'out_dxf_folder']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['dxf', 'laz', 'dxf']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'optimize_model_graph_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.fvo.optimize_model_graph_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_dxf_path': 'in_dxf_file', 'in_point_cloud_path': 'in_point_cloud_file', 'out_dxf_path': 'out_dxf_file', 'max_distance': 'max_distance', 'num_iterations': 'num_iterations'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_dxf_file', 'in_point_cloud_file', 'out_dxf_file']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['dxf', 'laz', 'dxf']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'optimize_model_graph',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.fvo.optimize_model_graph(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def simplify_model(self,
			in_path='__auto__', 
			out_path='__auto__', 
			layers='1', 
			distance=0.25,
			extension_in_file = '.dxf',
			extension_out_file = '.dxf',
			folder_parallel_processing = '__auto__'):
			 '''
				Simplify a 3D model
				
				:param in_path: input folder
				:param out_path: output folder
				:param layers: layers to be processed
				:param distance: Distance threshold for corner point suppression.
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_file', 'extension_out_file']
			 iterable_names = ['in_path','out_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_path': 'in_folder', 'out_path': 'out_folder', 'layers': 'layers', 'distance': 'distance'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_folder', 'out_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['dxf', 'dxf']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'simplify_model_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.fvo.simplify_model_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_path': 'in_file', 'out_path': 'out_file', 'layers': 'layers', 'distance': 'distance'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_file', 'out_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['dxf', 'dxf']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'simplify_model',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.fvo.simplify_model(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def connect_neighbouring_vertices_unassigned(self,
			input_path='__auto__', 
			input_vertices='vertices.laz', 
			output_path='__auto__', 
			max_line_distance=0.5, 
			max_line_distance_corner=0.23, 
			min_samples=3,
			extension_input_file = '.laz',
			extension_output_file = '.dxf',
			folder_parallel_processing = '__auto__'):
			 '''
				Connect neighbouring vertices in a point cloud
				
				:param input_path: Input folder with all 3D points
				:param input_vertices: Input vertices
				:param output_path: Output model
				:param max_line_distance: Maximum distance between line and points to be considered as inlier
				:param max_line_distance_corner: Maximum distance between vertices and points to be considered as inlier
				:param min_samples: Minimum number of points to fit a line
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_input_file', 'extension_output_file']
			 iterable_names = ['input_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'input_path': 'input_folder', 'input_vertices': 'input_vertices', 'output_path': 'output_folder', 'max_line_distance': 'max_line_distance', 'max_line_distance_corner': 'max_line_distance_corner', 'min_samples': 'min_samples'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['input_folder', 'output_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'dxf']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'connect_neighbouring_vertices_unassigned_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.fvo.connect_neighbouring_vertices_unassigned_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'input_path': 'input_file', 'input_vertices': 'input_vertices', 'output_path': 'output_file', 'max_line_distance': 'max_line_distance', 'max_line_distance_corner': 'max_line_distance_corner', 'min_samples': 'min_samples'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['input_file', 'output_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'dxf']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'connect_neighbouring_vertices_unassigned',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.fvo.connect_neighbouring_vertices_unassigned(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def export_vertices(self,
			in_path='__auto__', 
			out_path='__auto__',
			extension_in_file = '.laz',
			extension_out_file = '.dxf',
			folder_parallel_processing = '__auto__'):
			 '''
				Export a 3D model from a point cloud
				
				:param in_path: input folder with edges encoded in the intensity field.
				:param out_path: output folder
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_file', 'extension_out_file']
			 iterable_names = ['in_path','out_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_path': 'in_folder', 'out_path': 'out_folder'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_folder', 'out_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'dxf']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'export_vertices_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.fvo.export_vertices_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_path': 'in_file', 'out_path': 'out_file'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_file', 'out_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'dxf']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'export_vertices',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.fvo.export_vertices(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def zero_centering(self,
			input_path='__auto__', 
			output_path='__auto__',
			extension_input_file = '.laz',
			extension_output_file = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				Zero centering of XYZ points in a LAZ file
				
				:param input_path: input LAZ folder folder
				:param output_path: output LAZ folder folder
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_input_file', 'extension_output_file']
			 iterable_names = ['input_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'input_path': 'input_folder', 'output_path': 'output_folder'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['input_folder', 'output_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'zero_centering_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.fvo.zero_centering_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'input_path': 'input_file', 'output_path': 'output_file'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['input_file', 'output_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'zero_centering',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.fvo.zero_centering(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def evaluate_model(self,
			data_is='is.laz', 
			model_is='is.dxf', 
			model_target='__auto__', 
			vertex_target_distance=0.5,
			extension_model_target = '.dxf',
			folder_parallel_processing = '__auto__'):
			 '''
				Compare two 3D models
				
				:param data_is: input file
				:param model_is: input file
				:param model_target: output folder
				:param vertex_target_distance: Distance threshold for corner point suppression.
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_model_target']
			 iterable_names = ['model_target']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'data_is': 'data_is', 'model_is': 'model_is', 'model_target': 'model_folder_target', 'vertex_target_distance': 'vertex_target_distance'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['model_target']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['dxf']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'evaluate_model_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.fvo.evaluate_model_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'data_is': 'data_is', 'model_is': 'model_is', 'model_target': 'model_target', 'vertex_target_distance': 'vertex_target_distance'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['model_target']
				 itertable_iotypes = ['in']
				 iterable_file_types = ['dxf']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'evaluate_model',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.fvo.evaluate_model(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def import_vertices(self,
			in_path='__auto__', 
			layer='-1', 
			out_path='__auto__',
			extension_in_file = '.dxf',
			extension_out_file = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				Extract visible face3d vertices from a DXF file.
				
				:param in_path: Input DXF folder folder
				:param layer: Layer names as comma-separated list
				:param out_path: Output folder folder
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_in_file', 'extension_out_file']
			 iterable_names = ['in_path','out_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'in_path': 'in_folder', 'layer': 'layer', 'out_path': 'out_folder'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['in_folder', 'out_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['dxf', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'import_vertices_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.fvo.import_vertices_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'in_path': 'in_file', 'layer': 'layer', 'out_path': 'out_file'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['in_file', 'out_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['dxf', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'import_vertices',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.fvo.import_vertices(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def likelihood(self,
			input_path='__auto__', 
			points_path='__auto__', 
			output_path='__auto__', 
			max_distance=0.5, 
			missing_distance=1.5, 
			missing_knn=2,
			extension_input_file = '.laz',
			extension_points_file = '.laz',
			extension_output_file = '.laz',
			folder_parallel_processing = '__auto__'):
			 '''
				Compute class conditional probability distribution
				
				:param input_path: input LAZ folder folder
				:param points_path: input LAZ folder folder
				:param output_path: output LAZ folder folder
				:param max_distance: probability max distance
				:param missing_distance: interpolate missing points distance
				:param missing_knn: interpolate number missing neighbours
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_input_file', 'extension_points_file', 'extension_output_file']
			 iterable_names = ['input_path','points_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'input_path': 'input_folder', 'points_path': 'points_folder', 'output_path': 'output_folder', 'max_distance': 'max_distance', 'missing_distance': 'missing_distance', 'missing_knn': 'missing_knn'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['input_folder', 'points_folder', 'output_folder']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'likelihood_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.fvo.likelihood_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'input_path': 'input_file', 'points_path': 'points_file', 'output_path': 'output_file', 'max_distance': 'max_distance', 'missing_distance': 'missing_distance', 'missing_knn': 'missing_knn'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['input_file', 'points_file', 'output_file']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'laz', 'laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'likelihood',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.fvo.likelihood(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'fvo',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



	 class shp:
		 ''' 
         Namespace for shp functions.
		 '''

		 def __init__(self, outer_class):
			 self.outer_class = outer_class
			 self.client = outer_class.client
			 self.processing_folder = outer_class.processing_folder
			 self._get_call_stack = outer_class._get_call_stack
			 self._add_call_stack = outer_class._add_call_stack
			 self.get_unique_id = outer_class.get_unique_id
			 self.worker_instance_type, self.manager_instance_type = outer_class.get_instance_types()
			 self._check_folder_level_processing = outer_class._check_folder_level_processing
			 self._remap_parameters = outer_class._remap_parameters
			 self._get_param_subset = outer_class._get_param_subset


		 def intersecting_polygons(self,
			input_path='__auto__', 
			comparison_path='polygons', 
			output_path='__auto__',
			extension_input_file = '.pickle',
			extension_output_file = '.txt',
			folder_parallel_processing = '__auto__'):
			 '''
				intersecting polygons
				
				:param input_path: Input folder for the polygon
				:param comparison_path:  Input folder containing polygons for comparison
				:param output_path: Output folder for the list of intersecting polygon foldernames
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_input_file', 'extension_output_file']
			 iterable_names = ['input_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'input_path': 'input_folder', 'comparison_path': 'comparison_path', 'output_path': 'output_folder'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['input_folder', 'output_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['pickle', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'intersecting_polygons_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.shp.intersecting_polygons_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'shp',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'input_path': 'input_file', 'comparison_path': 'comparison_folder', 'output_path': 'output_file'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['input_file', 'output_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['pickle', 'txt']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'intersecting_polygons',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.shp.intersecting_polygons(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'shp',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def extract_multipolygons_from_shp(self,
			shp_path='__auto__', 
			out_polygon_path='polygons/', 
			out_attributes_path='attributes/', 
			shape_id=-1, 
			name_id=0,
			extension_shp_file = '',
			folder_parallel_processing = '__auto__'):
			 '''
				extract multipolygons from shp
				
				:param shp_path: input shp folder
				:param out_polygon_path: folder with polygons from shape file
				:param out_attributes_path: folder with records from shape file
				:param shape_id: id of polygon: [-1 parses all polygons]
				:param name_id: id of polygon: [-1 ignores name]
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_shp_file']
			 iterable_names = ['shp_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'shp_path': 'shp_folder', 'out_polygon_path': 'out_polygon_path', 'out_attributes_path': 'out_attributes_path', 'shape_id': 'shape_id', 'name_id': 'name_id'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['shp_folder']
				 itertable_iotypes = ['out']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'extract_multipolygons_from_shp_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.shp.extract_multipolygons_from_shp_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'shp',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'shp_path': 'shp_file', 'out_polygon_path': 'out_polygon_folder', 'out_attributes_path': 'out_attributes_folder', 'shape_id': 'shape_id', 'name_id': 'name_id'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['shp_file']
				 itertable_iotypes = ['out']
				 iterable_file_types = ['laz']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'extract_multipolygons_from_shp',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.shp.extract_multipolygons_from_shp(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'shp',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def wireframe_to_dxf(self,
			input_path='__auto__', 
			edges_path='__auto__', 
			output_path='__auto__',
			extension_input_file = '.laz',
			extension_edges_file = '.npy',
			extension_output_file = '.dxf',
			folder_parallel_processing = '__auto__'):
			 '''
				wireframe to dxf
				
				:param input_path: Input folder for the vertices
				:param edges_path: Input folder for the edges
				:param output_path: Output folder for the dxf model
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_input_file', 'extension_edges_file', 'extension_output_file']
			 iterable_names = ['input_path','edges_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'input_path': 'input_folder', 'edges_path': 'edges_folder', 'output_path': 'output_folder'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['input_folder', 'edges_folder', 'output_folder']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'npy', 'dxf']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'wireframe_to_dxf_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.shp.wireframe_to_dxf_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'shp',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'input_path': 'input_file', 'edges_path': 'edges_file', 'output_path': 'output_file'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['input_file', 'edges_file', 'output_file']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['laz', 'npy', 'dxf']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'wireframe_to_dxf',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.shp.wireframe_to_dxf(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'shp',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def make_polygon_from_json(self,
			input_path='__auto__', 
			output_path='__auto__', 
			point_identifiers='min_x,min_y;min_x,max_y;max_x,max_y;max_x,min_y',
			extension_input_file = '.json',
			extension_output_file = '.pickle',
			folder_parallel_processing = '__auto__'):
			 '''
				make polygon from json
				
				:param input_path: Input folder for the json folder
				:param output_path: Output folder for the polygon folder
				:param point_identifiers: Point identifiers for the polygon
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_input_file', 'extension_output_file']
			 iterable_names = ['input_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'input_path': 'input_folder', 'output_path': 'output_folder', 'point_identifiers': 'point_identifiers'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['input_folder', 'output_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['json', 'pickle']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'make_polygon_from_json_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.shp.make_polygon_from_json_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'shp',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'input_path': 'input_file', 'output_path': 'output_file', 'point_identifiers': 'point_identifiers'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['input_file', 'output_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['json', 'pickle']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'make_polygon_from_json',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.shp.make_polygon_from_json(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'shp',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



	 class image:
		 ''' 
         Namespace for image functions.
		 '''

		 def __init__(self, outer_class):
			 self.outer_class = outer_class
			 self.client = outer_class.client
			 self.processing_folder = outer_class.processing_folder
			 self._get_call_stack = outer_class._get_call_stack
			 self._add_call_stack = outer_class._add_call_stack
			 self.get_unique_id = outer_class.get_unique_id
			 self.worker_instance_type, self.manager_instance_type = outer_class.get_instance_types()
			 self._check_folder_level_processing = outer_class._check_folder_level_processing
			 self._remap_parameters = outer_class._remap_parameters
			 self._get_param_subset = outer_class._get_param_subset


		 def retile_images(self,
			path_reference='.', 
			path_to_retile='.', 
			output_path='out1', 
			extension_ref='.tif', 
			extension_ret='.tif',

			folder_parallel_processing = '__auto__'):
			 '''
				retile images
				
				:param path_reference: Reference folder with image dimensions and geolocations that should be used for retiling
				:param path_to_retile: Folder with images that should be retiled to match reference
				:param output_path: Folder with retiled images
				:param extension_ref: file extension
				:param extension_ret: file extension
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = []
			 iterable_names = []
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, False)
			 print(folder_parallel_processing, iterable_subset_dict, False)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'path_reference': 'path_reference', 'path_to_retile': 'path_to_retile', 'output_path': 'output_path', 'extension_ref': 'extension_ref', 'extension_ret': 'extension_ret'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'retile_images_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.image.retile_images_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'image',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'path_reference': 'folder_reference', 'path_to_retile': 'folder_to_retile', 'output_path': 'output_folder', 'extension_ref': 'extension_ref', 'extension_ret': 'extension_ret'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['']
				 itertable_iotypes = ['']
				 iterable_file_types = ['']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'retile_images',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.image.retile_images(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'image',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def canny_edge_detection(self,
			input_path='__auto__', 
			output_path='__auto__', 
			sigma=1.0, 
			low_threshold=0.1, 
			high_threshold=0.2, 
			values_subset='',
			extension_input_file = '.tif',
			extension_output_file = '.tif',
			folder_parallel_processing = '__auto__'):
			 '''
				Perform Canny edge detection on a georeferenced image and save the detected edges as a raster.
				
				:param input_path: Input image folder
				:param output_path: Output edge raster folder
				:param sigma: Standard deviation of the Gaussian filter
				:param low_threshold: Low threshold for hysteresis
				:param high_threshold: High threshold for hysteresis
				:param values_subset: Subset of values to extract contours from, all values by default
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_input_file', 'extension_output_file']
			 iterable_names = ['input_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'input_path': 'input_folder', 'output_path': 'output_folder', 'sigma': 'sigma', 'low_threshold': 'low_threshold', 'high_threshold': 'high_threshold', 'values_subset': 'values_subset'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['input_folder', 'output_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['tif', 'tif']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'canny_edge_detection_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.image.canny_edge_detection_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'image',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'input_path': 'input_file', 'output_path': 'output_file', 'sigma': 'sigma', 'low_threshold': 'low_threshold', 'high_threshold': 'high_threshold', 'values_subset': 'values_subset'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['input_file', 'output_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['tif', 'tif']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'canny_edge_detection',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.image.canny_edge_detection(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'image',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def image_metadata(self,
			input_path='__auto__', 
			output_path='__auto__',
			extension_input_file = '.tif',
			extension_output_file = '.json',
			folder_parallel_processing = '__auto__'):
			 '''
				Obtain metadata of a georeferenced image and save it as a JSON file.
				
				:param input_path: Input georeferenced image folder
				:param output_path: Output JSON folder
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_input_file', 'extension_output_file']
			 iterable_names = ['input_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'input_path': 'input_folder', 'output_path': 'output_folder'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['input_folder', 'output_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['tif', 'json']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'image_metadata_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.image.image_metadata_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'image',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'input_path': 'input_file', 'output_path': 'output_file'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['input_file', 'output_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['tif', 'json']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'image_metadata',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.image.image_metadata(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'image',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def resize_image(self,
			input_path='__auto__', 
			output_path='__auto__', 
			new_grid_size=1., 
			compression='None',
			extension_input_file = '.tif',
			extension_output_file = '.tif',
			folder_parallel_processing = '__auto__'):
			 '''
				resize image
				
				:param input_path: Input georeferenced image folder
				:param output_path: Output georeferenced image folder
				:param new_grid_size: New grid size in meters
				:param compression: Compression method (e.g., deflate, lzw)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_input_file', 'extension_output_file']
			 iterable_names = ['input_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'input_path': 'input_folder', 'output_path': 'output_folder', 'new_grid_size': 'new_grid_size', 'compression': 'compression'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['input_folder', 'output_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['tif', 'tif']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'resize_image_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.image.resize_image_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'image',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'input_path': 'input_file', 'output_path': 'output_file', 'new_grid_size': 'new_grid_size', 'compression': 'compression'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['input_file', 'output_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['tif', 'tif']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'resize_image',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.image.resize_image(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'image',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def extract_contours(self,
			input_path='__auto__', 
			value=0.5, 
			output_path='__auto__', 
			values_subset='',
			extension_input_file = '.tif',
			extension_output_file = '.shp',
			folder_parallel_processing = '__auto__'):
			 '''
				Extract contours from a georeferenced image and save them as a shapefile.
				
				:param input_path: Input georeferenced image folder
				:param value: Contour value
				:param output_path: Output shapefolder
				:param values_subset: Subset of contour values, default is all values
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_input_file', 'extension_output_file']
			 iterable_names = ['input_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'input_path': 'input_folder', 'value': 'value', 'output_path': 'output_folder', 'values_subset': 'values_subset'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['input_folder', 'output_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['tif', 'shp']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'extract_contours_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.image.extract_contours_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'image',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'input_path': 'input_file', 'value': 'value', 'output_path': 'output_file', 'values_subset': 'values_subset'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['input_file', 'output_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['tif', 'shp']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'extract_contours',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.image.extract_contours(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'image',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def matrix_to_image(self,
			input_path='__auto__', 
			output_path='__auto__', 
			data_type='uint8',
			extension_input_file = '.npy',
			extension_output_file = '.tif',
			folder_parallel_processing = '__auto__'):
			 '''
				Convert a matrix to an image.
				
				:param input_path: Input matrix folder (either .npy or .txt)
				:param output_path: Output image folder
				:param data_type: Data type of the output image
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_input_file', 'extension_output_file']
			 iterable_names = ['input_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'input_path': 'input_folder', 'output_path': 'output_folder', 'data_type': 'data_type'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['input_folder', 'output_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'tif']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'matrix_to_image_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.image.matrix_to_image_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'image',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'input_path': 'input_file', 'output_path': 'output_file', 'data_type': 'data_type'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['input_file', 'output_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['npy', 'tif']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'matrix_to_image',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.image.matrix_to_image(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'image',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def image_to_matrix(self,
			input_path='__auto__', 
			output_path='__auto__',
			extension_input_file = '.tif',
			extension_output_file = '.npy',
			folder_parallel_processing = '__auto__'):
			 '''
				Convert an image to a matrix.
				
				:param input_path: Input image folder
				:param output_path: Output matrix folder (either .npy or .txt)
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_input_file', 'extension_output_file']
			 iterable_names = ['input_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'input_path': 'input_folder', 'output_path': 'output_folder'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['input_folder', 'output_folder']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['tif', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'image_to_matrix_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.image.image_to_matrix_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'image',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'input_path': 'input_file', 'output_path': 'output_file'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['input_file', 'output_file']
				 itertable_iotypes = ['in', 'out']
				 iterable_file_types = ['tif', 'npy']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'image_to_matrix',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.image.image_to_matrix(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'image',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def polygon_to_image(self,
			geotiff_path='__auto__', 
			pickle_path='__auto__', 
			output_path='__auto__',
			extension_geotiff_file = '.tif',
			extension_pickle_file = '.pickle',
			extension_output_file = '.tif',
			folder_parallel_processing = '__auto__'):
			 '''
				Generate an image of a multipolygon filled inside.
				
				:param geotiff_path: Geotiff folder with size and resolution information
				:param pickle_path: Pickle folder containing the Shapely polygon
				:param output_path: Output georeferenced TIFF image
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_geotiff_file', 'extension_pickle_file', 'extension_output_file']
			 iterable_names = ['geotiff_path','pickle_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'geotiff_path': 'geotiff_folder', 'pickle_path': 'pickle_folder', 'output_path': 'output_folder'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['geotiff_folder', 'pickle_folder', 'output_folder']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['tif', 'pickle', 'tif']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'polygon_to_image_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.image.polygon_to_image_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'image',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'geotiff_path': 'geotiff_file', 'pickle_path': 'pickle_file', 'output_path': 'output_file'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['geotiff_file', 'pickle_file', 'output_file']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['tif', 'pickle', 'tif']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'polygon_to_image',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.image.polygon_to_image(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'image',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



		 def assign_georeference(self,
			georeferenced_path='__auto__', 
			unreferenced_path='__auto__', 
			output_path='__auto__',
			extension_georeferenced_file = '.tif',
			extension_unreferenced_file = '.tif',
			extension_output_file = '.tif',
			folder_parallel_processing = '__auto__'):
			 '''
				Assign georeference from a georeferenced image to an unreferenced image.
				
				:param georeferenced_path: Georeferenced image folder
				:param unreferenced_path: Unreferenced image folder
				:param output_path: Output georeferenced image folder
				
			 '''
			 params_dict = locals().copy()
			 params_dict.pop('self')
			 print(params_dict)
			 extension_names = ['extension_georeferenced_file', 'extension_unreferenced_file', 'extension_output_file']
			 iterable_names = ['georeferenced_path','unreferenced_path','output_path']
			 print(iterable_names, params_dict)
			 iterable_subset_dict = self._get_param_subset(params_dict, iterable_names)
			 folder_level_processing = self._check_folder_level_processing(folder_parallel_processing, iterable_subset_dict, True)
			 print(folder_parallel_processing, iterable_subset_dict, True)
			 params_dict.pop('folder_parallel_processing')
			 if folder_level_processing:
				 params_folder_mapping = {'georeferenced_path': 'georeferenced_folder', 'unreferenced_path': 'unreferenced_folder', 'output_path': 'output_folder'}
				 params_dict = self._remap_parameters(params_dict, params_folder_mapping)

				 itertable_params = ['georeferenced_folder', 'unreferenced_folder', 'output_folder']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['tif', 'tif', 'tif']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'assign_georeference_folder',
				                True,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['worker_instance_type'] = self.worker_instance_type,
				 params_dict['manager_instance_type'] = self.manager_instance_type 
				 result_promise = ao.image.assign_georeference_folder(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'image',
				                          True,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    
			 else:
				 params_file_mapping = {'georeferenced_path': 'georeferenced_file', 'unreferenced_path': 'unreferenced_file', 'output_path': 'output_file'}
				 params_dict = self._remap_parameters(params_dict, params_file_mapping)
				 for ext in extension_names:
					 params_dict.pop(ext)

				 itertable_params = ['georeferenced_file', 'unreferenced_file', 'output_file']
				 itertable_iotypes = ['in', 'in', 'out']
				 iterable_file_types = ['tif', 'tif', 'tif']
				 uid = self.get_unique_id()
				 connector = AIPHAConnector(
				                params_dict,
				                itertable_params, 
				                itertable_iotypes, 
				                iterable_file_types,
				                uid,
				                self.processing_folder,
				                'assign_georeference',
				                False,
				                self._get_call_stack()
				                )
				 params_dict = connector.resolve_auto_connections(params_dict)
				 params_dict['client'] = self.client
				 params_dict['instance_type'] = self.worker_instance_type 
				 result_promise = ao.image.assign_georeference(**params_dict)
				 operator = AIPHAOperator(connector, 
				                          params_dict, 
				                          result_promise, 
				                          self.outer_class, 
				                          'image',
				                          False,
				                          uid)
				 self._add_call_stack(operator)
				 return operator

    



	 def _init_inner_classes(self):
		 self.ml3d = self.ml3d(self)
		 self.sys = self.sys(self)
		 self.tdp = self.tdp(self)
		 self.ops3d = self.ops3d(self)
		 self.qc = self.qc(self)
		 self.val = self.val(self)
		 self.fvo = self.fvo(self)
		 self.shp = self.shp(self)
		 self.image = self.image(self)


	 def _create_processing_folder(self):
		 self.sys.create_directory_in_cloud(self.processing_folder)
		 self.execute()

	 def create_operator_from_path(self, path, extension = '', is_folder_level = '__auto__'):
		 '''
			 Create an "operator" pointing to a path.

			 :param path: path to file or folder
			 :param extension: extension of file
			 :param is_folder_level: if True, the operator will be executed massive parallel for each file in a folder level, if False, the operator will be executed on file level, if '__auto__', the operator will be executed on folder level if the path is a folder, otherwise on file level
		 '''
		 if is_folder_level == '__auto__':
			 if '.' in path:
				 is_folder_level = False
			 else:
				 is_folder_level = True
		 unique_id = self.get_unique_id()
		 connector = AIPHAConnector(
                 {'path': path},    
	             ['path'], 
	             ['out'], 
	             [extension.replace('.', '')], 
	             unique_id, 
	             self.processing_folder, 
	             'path',
	             is_folder_level,
	             self._get_call_stack()
		 )
		 op = AIPHAOperator(connector,
		                    {}, 
		                    None, 
		                    self, 
		                    'path',
		                    is_folder_level,
		                    unique_id,
		                    True
		 )
		 self._add_call_stack(op)
		 return op

