# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/cli/init.ipynb.

# %% auto 0
__all__ = ['main']

# %% ../../nbs/cli/init.ipynb 2
from pathlib import Path
import sys

from fastcore.script import *
from fastcore.xtras import mkdir
from fastcore.style import S

from ..inout import write_toml


from marisco.configs import (
    base_path, 
    CONFIGS,  
    CFG_FNAME
)

from marisco.utils import (
    download_file,
    download_files_in_folder
    )


# %% ../../nbs/cli/init.ipynb 3
@call_parse
def main():
    "Create configuration files & download lookup tables"
    path = base_path()
    if path.exists():
        msg = S.red('Configuration files already exist. Do you want to overwrite them? (y/[n]): ')
        if not input(msg).lower().startswith('y'): 
            sys.exit(1)

    mkdir(path, overwrite=True)
    for k, v in CONFIGS['dirs'].items():
        mkdir(v, parents=True, overwrite=True)
            
    # Write configs dictionary as `.toml` in base path
    # using config dictionary literals during initialization
    write_toml(path / CFG_FNAME, CONFIGS)
    
    owner, repo = CONFIGS['gh'].values()
    # Download luts (look-up table) to base path
    print('Downloading look-up tables ...')
    download_files_in_folder(owner, repo,
                             src_dir=CONFIGS['paths']['luts'], 
                             dest_dir=CONFIGS['dirs']['lut'])
    
    # Download MARIS NetCDF template
    print('Downloading MARIS NetCDF template ...')
    download_file(owner, repo,
                  src_dir=CONFIGS['paths']['nc_template'], 
                  dest_dir=str(base_path()),
                  fname=CONFIGS['names']['nc_template'])
