import numpy as np
import datetime

limits = {
    "TIMESTAMP": {
        "Description": "ISO timestamp – short format",
        "Units": "YYYYMMDDHHMM",
        "Min": 198001010000,
        "Max": int(f"{datetime.datetime.now():%Y%m%d%H%M}"),
    },
    "TIMESTAMP_END": {
        "Description": "ISO timestamp end of averaging period - short format (12-digit integer)",
        "Units": "YYYYMMDDHHMM",
        "Min": 198001010000,
        "Max": int(f"{datetime.datetime.now():%Y%m%d%H%M}"),
    },
    "TIMESTAMP_START": {
        "Description": "ISO timestamp start of averaging period - short format (12-digit integer)",
        "Units": "YYYYMMDDHHMM",
        "Min": 198001010000,
        "Max": int(f"{datetime.datetime.now():%Y%m%d%H%M}"),
    },
    "COND_WATER": {
        "Description": "Conductivity (i.e., electrical conductivity) of water",
        "Units": "µS cm-1",
        "Min": 0.0,
        "Max": 10000.0,
    },
    "DO": {
        "Description": "Dissolved oxygen in water",
        "Units": "µmol L-1",
        "Min": 0.0,
        "Max": np.nan,
    },
    "PCH4": {
        "Description": "Dissolved methane (CH4) in water",
        "Units": "nmolCH4 mol-1",
        "Min": 0.0,
        "Max": np.nan,
    },
    "PCO2": {
        "Description": "Dissolved carbon dioxide (CO2) in water",
        "Units": "µmolCO2 mol-1",
        "Min": 0.0,
        "Max": 10000.0,
    },
    "PN2O": {
        "Description": "Dissolved nitrous oxide (N2O) in water",
        "Units": "nmolN2O mol-1",
        "Min": 0.0,
        "Max": np.nan,
    },
    "PPFD_UW_IN": {
        "Description": "Photosynthetic photon flux density, underwater, incoming",
        "Units": "µmolPhotons m-2 s-1",
        "Min": 0.0,
        "Max": 2400.0,
    },
    "TW": {
        "Description": "Water temperature",
        "Units": "deg C",
        "Min": -20.0,
        "Max": 50.0,
    },
    "DBH": {
        "Description": "Diameter of tree measured at breast height (1.3m)\xa0with continuous dendrometers",
        "Units": "cm",
        "Min": 0.0,
        "Max": 500.0,
    },
    "LEAF_WET": {
        "Description": "Leaf wetness, range 0-100",
        "Units": "%",
        "Min": 0.0,
        "Max": 100.0,
    },
    "SAP_DT": {
        "Description": "Difference of probes temperature for sapflow measurements",
        "Units": "deg C",
        "Min": -10.0,
        "Max": 10.0,
    },
    "SAP_FLOW": {
        "Description": "Sap flow",
        "Units": "mmolH2O m-2 s-1",
        "Min": np.nan,
        "Max": np.nan,
    },
    "T_BOLE": {
        "Description": "Bole temperature",
        "Units": "deg C",
        "Min": -50.0,
        "Max": 70.0,
    },
    "T_CANOPY": {
        "Description": "Temperature of the canopy and/or surface underneath the sensor",
        "Units": "deg C",
        "Min": -50.0,
        "Max": 70.0,
    },
    "FETCH_70": {
        "Description": "Distance at which cross-wind integrated footprint cumulative probability is 70%",
        "Units": "m",
        "Min": 0.0,
        "Max": 10000.0,
    },
    "FETCH_80": {
        "Description": "Distance at which cross-wind integrated footprint cumulative probability is 80%",
        "Units": "m",
        "Min": 0.0,
        "Max": 12000.0,
    },
    "FETCH_90": {
        "Description": "Distance at which cross-wind integrated footprint cumulative probability is 90%",
        "Units": "m",
        "Min": 0.0,
        "Max": 15000.0,
    },
    "FETCH_FILTER": {
        "Description": "Footprint quality flag (i.e., 0, 1): 0 and 1 indicate data measured when wind coming from direction that should be discarded and kept, respectively",
        "Units": "nondimensional",
        "Min": 0.0,
        "Max": 1.0,
    },
    "FETCH_MAX": {
        "Description": "Distance at which footprint contribution is maximum",
        "Units": "m",
        "Min": 0.0,
        "Max": 5000.0,
    },
    "CH4": {
        "Description": "Methane (CH4) mole fraction in wet air",
        "Units": "nmolCH4 mol-1",
        "Min": 0.0,
        "Max": 15000.0,
    },
    "CH4_MIXING_RATIO": {
        "Description": "Methane (CH4) in mole fraction of dry air",
        "Units": "nmolCH4 mol-1",
        "Min": 0.0,
        "Max": 15000.0,
    },
    "CO": {
        "Description": "Carbon Monoxide (CO) mole fraction in wet air",
        "Units": "nmolCO mol-1",
        "Min": 0.0,
        "Max": np.nan,
    },
    "CO2": {
        "Description": "Carbon Dioxide (CO2) mole fraction in wet air",
        "Units": "µmolCO2 mol-1",
        "Min": 150.0,
        "Max": 1200.0,
    },
    "CO2_MIXING_RATIO": {
        "Description": "Carbon Dioxide (CO2) in mole fraction of dry air",
        "Units": "µmolCO2 mol-1",
        "Min": 150.0,
        "Max": 1200.0,
    },
    "CO2_SIGMA": {
        "Description": "Standard deviation of carbon dioxide mole fraction in wet air",
        "Units": "µmolCO2 mol-1",
        "Min": 0.0,
        "Max": 150.0,
    },
    "CO2C13": {
        "Description": "Stable isotopic composition of CO2 - C13 (i.e., d13C of CO2)",
        "Units": "‰ (permil)",
        "Min": np.nan,
        "Max": -6.0,
    },
    "FC": {
        "Description": "Carbon Dioxide (CO2) turbulent flux (no storage correction)",
        "Units": "µmolCO2 m-2 s-1",
        "Min": -100.0,
        "Max": 100.0,
    },
    "FCH4": {
        "Description": "Methane (CH4) turbulent flux (no storage correction)",
        "Units": "nmolCH4 m-2 s-1",
        "Min": -500.0,
        "Max": 4000.0,
    },
    "FN2O": {
        "Description": "Nitrous oxide (N2O) turbulent flux (no storage correction)",
        "Units": "nmolN2O m-2 s-1",
        "Min": np.nan,
        "Max": np.nan,
    },
    "FNO": {
        "Description": "Nitric oxide (NO) turbulent flux (no storage correction)",
        "Units": "nmolNO m-2 s-1",
        "Min": np.nan,
        "Max": np.nan,
    },
    "FNO2": {
        "Description": "Nitrogen dioxide (NO2) turbulent flux (no storage correction)",
        "Units": "nmolNO2 m-2 s-1",
        "Min": np.nan,
        "Max": np.nan,
    },
    "FO3": {
        "Description": "Ozone (O3) turbulent flux (no storage correction)",
        "Units": "nmolO3 m-2 s-1",
        "Min": np.nan,
        "Max": np.nan,
    },
    "H2O": {
        "Description": "Water (H2O) vapor in mole fraction of wet air",
        "Units": "mmolH2O mol-1",
        "Min": 0.0,
        "Max": 100.0,
    },
    "H2O_MIXING_RATIO": {
        "Description": "Water (H2O) vapor in mole fraction of dry air",
        "Units": "mmolH2O mol-1",
        "Min": 0.0,
        "Max": 100.0,
    },
    "H2O_SIGMA": {
        "Description": "Standard deviation of water vapor mole fraction",
        "Units": "mmolH2O mol-1",
        "Min": 0.0,
        "Max": 15.0,
    },
    "N2O": {
        "Description": "Nitrous Oxide (N2O) mole fraction in wet air",
        "Units": "nmolN2O mol-1",
        "Min": 0.0,
        "Max": np.nan,
    },
    "N2O_MIXING_RATIO": {
        "Description": "Nitrous Oxide (N2O) in mole fraction of dry air",
        "Units": "nmolN2O mol-1",
        "Min": 0.0,
        "Max": np.nan,
    },
    "NO": {
        "Description": "Nitric oxide (NO) mole fraction in wet air",
        "Units": "nmolNO mol-1",
        "Min": 0.0,
        "Max": np.nan,
    },
    "NO2": {
        "Description": "Nitrogen dioxide (NO2) mole fraction in wet air",
        "Units": "nmolNO2 mol-1",
        "Min": 0.0,
        "Max": np.nan,
    },
    "O3": {
        "Description": "Ozone (O3) mole fraction in wet air",
        "Units": "nmolO3 mol-1",
        "Min": 0.0,
        "Max": np.nan,
    },
    "SC": {
        "Description": "Carbon Dioxide (CO2) storage flux",
        "Units": "µmolCO2 m-2 s-1",
        "Min": -100.0,
        "Max": 100.0,
    },
    "SCH4": {
        "Description": "Methane (CH4) storage flux",
        "Units": "nmolCH4 m-2 s-1",
        "Min": np.nan,
        "Max": np.nan,
    },
    "SN2O": {
        "Description": "Nitrous oxide (N2O) storage flux",
        "Units": "nmolN2O m-2 s-1",
        "Min": np.nan,
        "Max": np.nan,
    },
    "SNO": {
        "Description": "Nitric oxide (NO) storage flux",
        "Units": "nmolNO m-2 s-1",
        "Min": np.nan,
        "Max": np.nan,
    },
    "SNO2": {
        "Description": "Nitrogen dioxide (NO2) storage flux",
        "Units": "nmolNO2 m-2 s-1",
        "Min": np.nan,
        "Max": np.nan,
    },
    "SO2": {
        "Description": "Sulfur Dioxide (SO2) mole fraction in wet air",
        "Units": "nmolSO2 mol-1",
        "Min": 0.0,
        "Max": np.nan,
    },
    "SO3": {
        "Description": "Ozone (O3) storage flux",
        "Units": "nmolO3 m-2 s-1",
        "Min": np.nan,
        "Max": np.nan,
    },
    "FH2O": {
        "Description": "Water vapor (H2O) turbulent flux (no storage correction)",
        "Units": "mmolH2O m-2 s-1",
        "Min": -10.0,
        "Max": 20.0,
    },
    "G": {
        "Description": "Soil heat flux",
        "Units": "W m-2",
        "Min": -250.0,
        "Max": 400.0,
    },
    "H": {
        "Description": "Sensible heat turbulent flux (no storage correction)",
        "Units": "W m-2",
        "Min": -450.0,
        "Max": 900.0,
    },
    "LE": {
        "Description": "Latent heat turbulent flux (no storage correction)",
        "Units": "W m-2",
        "Min": -450.0,
        "Max": 900.0,
    },
    "SB": {
        "Description": "Heat storage flux in biomass",
        "Units": "W m-2",
        "Min": np.nan,
        "Max": np.nan,
    },
    "SG": {
        "Description": "Heat storage flux in the soil above the soil heat fluxes measurement",
        "Units": "W m-2",
        "Min": -100.0,
        "Max": 250.0,
    },
    "SH": {
        "Description": "Sensible heat (H) storage flux",
        "Units": "W m-2",
        "Min": -150.0,
        "Max": 150.0,
    },
    "SLE": {
        "Description": "Latent heat (LE) storage flux",
        "Units": "W m-2",
        "Min": -150.0,
        "Max": 150.0,
    },
    "PA": {
        "Description": "Atmospheric pressure",
        "Units": "kPa",
        "Min": 60.0,
        "Max": 105.0,
    },
    "PBLH": {
        "Description": "Planetary boundary layer height",
        "Units": "m",
        "Min": 0.0,
        "Max": 3000.0,
    },
    "RH": {
        "Description": "Relative humidity, range 0-100",
        "Units": "%",
        "Min": 0.0,
        "Max": 100.0,
    },
    "T_SONIC": {
        "Description": "Sonic temperature",
        "Units": "deg C",
        "Min": -50.0,
        "Max": 50.0,
    },
    "T_SONIC_SIGMA": {
        "Description": "Standard deviation of sonic temperature",
        "Units": "deg C",
        "Min": 0.0,
        "Max": 5.0,
    },
    "TA": {
        "Description": "Air temperature",
        "Units": "deg C",
        "Min": -50.0,
        "Max": 50.0,
    },
    "VPD": {
        "Description": "Vapor Pressure Deficit",
        "Units": "hPa",
        "Min": 0.0,
        "Max": 80.0,
    },
    "D_SNOW": {"Description": "Snow depth", "Units": "cm", "Min": 0.0, "Max": 500.0},
    "P": {"Description": "Precipitation", "Units": "mm", "Min": 0.0, "Max": 50.0},
    "P_RAIN": {"Description": "Rainfall", "Units": "mm", "Min": 0.0, "Max": 50.0},
    "P_SNOW": {"Description": "Snowfall", "Units": "mm", "Min": 0.0, "Max": 50.0},
    "RUNOFF": {"Description": "Run off", "Units": "mm", "Min": 0.0, "Max": 200.0},
    "STEMFLOW": {
        "Description": "Excess precipitation that drains from outlying branches and leaves and is channeled through the stems to the ground",
        "Units": "mm",
        "Min": 0.0,
        "Max": 200.0,
    },
    "THROUGHFALL": {
        "Description": "Excess precipitation that passes directly through a canopy or drips from wet leaves to the ground",
        "Units": "mm",
        "Min": 0.0,
        "Max": 20.0,
    },
    "ALB": {
        "Description": "Albedo, range 0-100",
        "Units": "%",
        "Min": 0.0,
        "Max": 100.0,
    },
    "APAR": {
        "Description": "Absorbed PAR",
        "Units": "µmolPhoton m-2 s-1",
        "Min": 0.0,
        "Max": 2300.0,
    },
    "ET": {
        "Description": "Evapotranspiration",
        "Units": "mm hr-1",
        "Min": 0.0,
        "Max": 20.0,
    },
    "EVI": {
        "Description": "Enhanced Vegetation Index",
        "Units": "nondimensional",
        "Min": -1.0,
        "Max": 1.0,
    },
    "FAPAR": {
        "Description": "Fraction of absorbed PAR, range 0-100",
        "Units": "%",
        "Min": 0.0,
        "Max": 100.0,
    },
    "FIPAR": {
        "Description": "Fraction of intercepted PAR, range 0-100",
        "Units": "%",
        "Min": 0.0,
        "Max": 100.0,
    },
    "LW_BC_IN": {
        "Description": "Longwave radiation, below canopy incoming",
        "Units": "W m-2",
        "Min": 50.0,
        "Max": 600.0,
    },
    "LW_BC_OUT": {
        "Description": "Longwave radiation, below canopy outgoing",
        "Units": "W m-2",
        "Min": 100.0,
        "Max": 750.0,
    },
    "LW_IN": {
        "Description": "Longwave radiation, incoming",
        "Units": "W m-2",
        "Min": 50.0,
        "Max": 600.0,
    },
    "LW_OUT": {
        "Description": "Longwave radiation, outgoing",
        "Units": "W m-2",
        "Min": 100.0,
        "Max": 750.0,
    },
    "MCRI": {
        "Description": "Carotenoid Reflectance Index (Gitelson et al., 2002)",
        "Units": "nondimensional",
        "Min": 0.0,
        "Max": 10.0,
    },
    "MTCI": {
        "Description": "Meris Terrestrial Chlorophyll Index (Dash and Curran, 2004)",
        "Units": "nondimensional",
        "Min": 0.0,
        "Max": 10.0,
    },
    "NDVI": {
        "Description": "Normalized Difference Vegetation Index",
        "Units": "nondimensional",
        "Min": -1.0,
        "Max": 1.0,
    },
    "NETRAD": {
        "Description": "Net radiation",
        "Units": "W m-2",
        "Min": -200.0,
        "Max": 1100.0,
    },
    "NIRV": {
        "Description": "Near Infrared Vegetation Index (Badgley et al., 2017)",
        "Units": "W m-2 sr-1 nm-1",
        "Min": 0.0,
        "Max": 2.0,
    },
    "PPFD_BC_IN": {
        "Description": "Photosynthetic photon flux density, below canopy incoming",
        "Units": "µmolPhoton m-2 s-1",
        "Min": 0.0,
        "Max": 2400.0,
    },
    "PPFD_BC_OUT": {
        "Description": "Photosynthetic photon flux density, below canopy outgoing",
        "Units": "µmolPhoton m-2 s-1",
        "Min": 0.0,
        "Max": 2000.0,
    },
    "PPFD_DIF": {
        "Description": "Photosynthetic photon flux density, diffuse incoming",
        "Units": "µmolPhoton m-2 s-1",
        "Min": 0.0,
        "Max": 1400.0,
    },
    "PPFD_DIR": {
        "Description": "Photosynthetic photon flux density, direct incoming",
        "Units": "µmolPhoton m-2 s-1",
        "Min": 0.0,
        "Max": 2400.0,
    },
    "PPFD_IN": {
        "Description": "Photosynthetic photon flux density, incoming",
        "Units": "µmolPhoton m-2 s-1",
        "Min": 0.0,
        "Max": 2400.0,
    },
    "PPFD_OUT": {
        "Description": "Photosynthetic photon flux density, outgoing",
        "Units": "µmolPhoton m-2 s-1",
        "Min": 0.0,
        "Max": 2000.0,
    },
    "PRI": {
        "Description": "Photochemical Reflectance Index",
        "Units": "nondimensional",
        "Min": -1.0,
        "Max": 1.0,
    },
    "R_UVA": {
        "Description": "UVA radiation, incoming",
        "Units": "W m-2",
        "Min": 0.0,
        "Max": 85.0,
    },
    "R_UVB": {
        "Description": "UVB radiation, incoming",
        "Units": "W m-2",
        "Min": 0.0,
        "Max": 20.0,
    },
    "REDCI": {
        "Description": "Red Edge Chlorophyll Index",
        "Units": "nondimensional",
        "Min": 0.0,
        "Max": 10.0,
    },
    "REP": {
        "Description": "Red Edge Position (Dash and Curran, 2004)",
        "Units": "nm",
        "Min": 400.0,
        "Max": 800.0,
    },
    "SPEC_NIR_IN": {
        "Description": "Radiation (near infra-red band), incoming (hemispherical)",
        "Units": "W m-2 nm-1",
        "Min": 0.0,
        "Max": 2.0,
    },
    "SPEC_NIR_OUT": {
        "Description": "Radiation (near infra-red band), outgoing",
        "Units": "W m-2 sr-1 nm-1",
        "Min": 0.0,
        "Max": 2.0,
    },
    "SPEC_NIR_REFL": {
        "Description": "Reflectance (near infra-red band)",
        "Units": "nondimensional",
        "Min": 0.0,
        "Max": 1.0,
    },
    "SPEC_PRI_REF_IN": {
        "Description": "Radiation for PRI reference band (e.g., 570 nm), incoming (hemispherical)",
        "Units": "W m-2 nm-1",
        "Min": 0.0,
        "Max": 2.0,
    },
    "SPEC_PRI_REF_OUT": {
        "Description": "Radiation for PRI reference band (e.g., 570 nm), outgoing",
        "Units": "W m-2 sr-1 nm-1",
        "Min": 0.0,
        "Max": 2.0,
    },
    "SPEC_PRI_REF_REFL": {
        "Description": "Reflectance for PRI reference band (e.g., 570 nm)",
        "Units": "nondimensional",
        "Min": 0.0,
        "Max": 1.0,
    },
    "SPEC_PRI_TGT_IN": {
        "Description": "Radiation for PRI target band (e.g., 531 nm), incoming (hemispherical)",
        "Units": "W m-2 nm-1",
        "Min": 0.0,
        "Max": 2.0,
    },
    "SPEC_PRI_TGT_OUT": {
        "Description": "Radiation for PRI target band (e.g., 531 nm), outgoing",
        "Units": "W m-2 sr-1 nm-1",
        "Min": 0.0,
        "Max": 2.0,
    },
    "SPEC_PRI_TGT_REFL": {
        "Description": "Reflectance for PRI target band (e.g., 531 nm)",
        "Units": "nondimensional",
        "Min": 0.0,
        "Max": 1.0,
    },
    "SPEC_RED_IN": {
        "Description": "Radiation (red band), incoming (hemispherical)",
        "Units": "W m-2 nm-1",
        "Min": 0.0,
        "Max": 2.0,
    },
    "SPEC_RED_OUT": {
        "Description": "Radiation (red band), outgoing",
        "Units": "W m-2 sr-1 nm-1",
        "Min": 0.0,
        "Max": 2.0,
    },
    "SPEC_RED_REFL": {
        "Description": "Reflectance (red band)",
        "Units": "nondimensional",
        "Min": 0.0,
        "Max": 1.0,
    },
    "SR": {
        "Description": "Simple Ratio",
        "Units": "nondimensional",
        "Min": 0.0,
        "Max": 10.0,
    },
    "SW_BC_IN": {
        "Description": "Shortwave radiation, below canopy incoming",
        "Units": "W m-2",
        "Min": 0.0,
        "Max": 1300.0,
    },
    "SW_BC_OUT": {
        "Description": "Shortwave radiation, below canopy outgoing",
        "Units": "W m-2",
        "Min": 0.0,
        "Max": 800.0,
    },
    "SW_DIF": {
        "Description": "Shortwave radiation, diffuse incoming",
        "Units": "W m-2",
        "Min": 0.0,
        "Max": 750.0,
    },
    "SW_DIR": {
        "Description": "Shortwave radiation, direct incoming",
        "Units": "W m-2",
        "Min": 0.0,
        "Max": 1300.0,
    },
    "SW_IN": {
        "Description": "Shortwave radiation, incoming",
        "Units": "W m-2",
        "Min": 0.0,
        "Max": 1300.0,
    },
    "SW_OUT": {
        "Description": "Shortwave radiation, outgoing",
        "Units": "W m-2",
        "Min": 0.0,
        "Max": 800.0,
    },
    "TCARI": {
        "Description": "Transformed Chlorophyll Absorption in Reflectance Index",
        "Units": "nondimensional",
        "Min": 0.0,
        "Max": 10.0,
    },
    "SWC": {
        "Description": "Soil water content (volumetric), range 0-100",
        "Units": "%",
        "Min": 0.0,
        "Max": 100.0,
    },
    "SWP": {
        "Description": "Soil water potential",
        "Units": "kPa",
        "Min": -750.0,
        "Max": 0.0,
    },
    "TS": {
        "Description": "Soil temperature",
        "Units": "deg C",
        "Min": -40.0,
        "Max": 65.0,
    },
    "TSN": {
        "Description": "Snow temperature",
        "Units": "deg C",
        "Min": -40.0,
        "Max": 4.0,
    },
    "WTD": {
        "Description": "Water table depth",
        "Units": "m",
        "Min": -10.0,
        "Max": 10.0,
    },
    "MO_LENGTH": {
        "Description": "Monin-Obukhov length",
        "Units": "m",
        "Min": np.nan,
        "Max": np.nan,
    },
    "TAU": {
        "Description": "Momentum flux",
        "Units": "kg m-1 s-2",
        "Min": -10.0,
        "Max": 2.0,
    },
    "U_SIGMA": {
        "Description": "Standard deviation of velocity fluctuations (towards main-wind direction after coordinates rotation)",
        "Units": "m s-1",
        "Min": 0.0,
        "Max": 12.0,
    },
    "USTAR": {
        "Description": "Friction velocity",
        "Units": "m s-1",
        "Min": 0.0,
        "Max": 8.0,
    },
    "V_SIGMA": {
        "Description": "Standard deviation of lateral velocity fluctuations (cross main-wind direction after coordinates rotation)",
        "Units": "m s-1",
        "Min": 0.0,
        "Max": 10.0,
    },
    "W_SIGMA": {
        "Description": "Standard deviation of vertical velocity fluctuations",
        "Units": "m s-1",
        "Min": 0.0,
        "Max": 5.0,
    },
    "WD": {
        "Description": "Wind direction",
        "Units": "Decimal degrees",
        "Min": 0.0,
        "Max": 360.0,
    },
    "WD_SIGMA": {
        "Description": "Standard deviation of wind direction (Yamartino, 1984)",
        "Units": "decimal degree",
        "Min": 0.0,
        "Max": 180.0,
    },
    "WS": {"Description": "Wind speed", "Units": "m s-1", "Min": 0.0, "Max": 40.0},
    "WS_MAX": {
        "Description": "maximum WS in the averaging period",
        "Units": "m s-1",
        "Min": 0.0,
        "Max": 50.0,
    },
    "ZL": {
        "Description": "Monin-Obukhov Stability parameter",
        "Units": "nondimensional",
        "Min": np.nan,
        "Max": np.nan,
    },
    "GPP": {
        "Description": "Gross Primary Productivity",
        "Units": "µmolCO2 m-2 s-1",
        "Min": -30.0,
        "Max": 100.0,
    },
    "NEE": {
        "Description": "Net Ecosystem Exchange",
        "Units": "µmolCO2 m-2 s-1",
        "Min": -100.0,
        "Max": 100.0,
    },
    "RECO": {
        "Description": "Ecosystem Respiration",
        "Units": "µmolCO2 m-2 s-1",
        "Min": -20.0,
        "Max": 50.0,
    },
    "FC_SSITC_TEST": {
        "Description": "Results of the quality flagging for FC according to Foken et al 2004, based on a combination of Steady State and Integral Turbulence Characteristics tests by Foken and Wichura (1996) (i.e., 0, 1, 2)",
        "Units": "nondimensional",
        "Min": 0.0,
        "Max": 2.0,
    },
    "FCH4_SSITC_TEST": {
        "Description": "Results of the quality flagging for FCH4 according to Foken et al 2004, based on a combination of Steady State and Integral Turbulence Characteristics tests by Foken and Wichura (1996) (i.e., 0, 1, 2)",
        "Units": "nondimensional",
        "Min": 0.0,
        "Max": 2.0,
    },
    "FN2O_SSITC_TEST": {
        "Description": "Results of the quality flagging for FN2O according to Foken et al 2004, based on a combination of Steady State and Integral Turbulence Characteristics tests by Foken and Wichura (1996) (i.e., 0, 1, 2)",
        "Units": "nondimensional",
        "Min": 0.0,
        "Max": 2.0,
    },
    "FNO_SSITC_TEST": {
        "Description": "Results of the quality flagging for FNO according to Foken et al 2004, based on a combination of Steady State and Integral Turbulence Characteristics tests by Foken and Wichura (1996) (i.e., 0, 1, 2)",
        "Units": "nondimensional",
        "Min": 0.0,
        "Max": 2.0,
    },
    "FNO2_SSITC_TEST": {
        "Description": "Results of the quality flagging for FNO2 according to Foken et al 2004, based on a combination of Steady State and Integral Turbulence Characteristics tests by Foken and Wichura (1996) (i.e., 0, 1, 2)",
        "Units": "nondimensional",
        "Min": 0.0,
        "Max": 2.0,
    },
    "FO3_SSITC_TEST": {
        "Description": "Results of the quality flagging for FO3 according to Foken et al 2004, based on a combination of Steady State and Integral Turbulence Characteristics tests by Foken and Wichura (1996) (i.e., 0, 1, 2)",
        "Units": "nondimensional",
        "Min": 0.0,
        "Max": 2.0,
    },
    "H_SSITC_TEST": {
        "Description": "Results of the quality flagging for H according to Foken et al 2004, based on a combination of Steady State and Integral Turbulence Characteristics tests by Foken and Wichura (1996) (i.e., 0, 1, 2)",
        "Units": "nondimensional",
        "Min": 0.0,
        "Max": 2.0,
    },
    "LE_SSITC_TEST": {
        "Description": "Results of the quality flagging for LE according to Foken et al 2004, based on a combination of Steady State and Integral Turbulence Characteristics tests by Foken and Wichura (1996) (i.e., 0, 1, 2)",
        "Units": "nondimensional",
        "Min": 0.0,
        "Max": 2.0,
    },
    "TAU_SSITC_TEST": {
        "Description": "Results of the quality flagging for TAU according to Foken et al 2004, based on a combination of Steady State and Integral Turbulence Characteristics tests by Foken and Wichura (1996) (i.e., 0, 1, 2)",
        "Units": "nondimensional",
        "Min": 0.0,
        "Max": 2.0,
    },
}
