import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementApiOperationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy#api_management_name ApiManagementApiOperationPolicy#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy#api_name ApiManagementApiOperationPolicy#api_name}
    */
    readonly apiName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy#operation_id ApiManagementApiOperationPolicy#operation_id}
    */
    readonly operationId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy#resource_group_name ApiManagementApiOperationPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy#xml_content ApiManagementApiOperationPolicy#xml_content}
    */
    readonly xmlContent?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy#xml_link ApiManagementApiOperationPolicy#xml_link}
    */
    readonly xmlLink?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy#timeouts ApiManagementApiOperationPolicy#timeouts}
    */
    readonly timeouts?: ApiManagementApiOperationPolicyTimeouts;
}
export interface ApiManagementApiOperationPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy#create ApiManagementApiOperationPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy#delete ApiManagementApiOperationPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy#read ApiManagementApiOperationPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy#update ApiManagementApiOperationPolicy#update}
    */
    readonly update?: string;
}
export declare function apiManagementApiOperationPolicyTimeoutsToTerraform(struct?: ApiManagementApiOperationPolicyTimeoutsOutputReference | ApiManagementApiOperationPolicyTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiOperationPolicyTimeouts | undefined;
    set internalValue(value: ApiManagementApiOperationPolicyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy azurerm_api_management_api_operation_policy}
*/
export declare class ApiManagementApiOperationPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_api_operation_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy azurerm_api_management_api_operation_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementApiOperationPolicyConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementApiOperationPolicyConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _apiName?;
    get apiName(): string;
    set apiName(value: string);
    get apiNameInput(): string | undefined;
    get id(): string;
    private _operationId?;
    get operationId(): string;
    set operationId(value: string);
    get operationIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _xmlContent?;
    get xmlContent(): string;
    set xmlContent(value: string);
    resetXmlContent(): void;
    get xmlContentInput(): string | undefined;
    private _xmlLink?;
    get xmlLink(): string;
    set xmlLink(value: string);
    resetXmlLink(): void;
    get xmlLinkInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApiManagementApiOperationPolicyTimeoutsOutputReference;
    putTimeouts(value: ApiManagementApiOperationPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApiManagementApiOperationPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
