import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermBlueprintDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_definition#name DataAzurermBlueprintDefinition#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_definition#scope_id DataAzurermBlueprintDefinition#scope_id}
    */
    readonly scopeId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_definition#timeouts DataAzurermBlueprintDefinition#timeouts}
    */
    readonly timeouts?: DataAzurermBlueprintDefinitionTimeouts;
}
export interface DataAzurermBlueprintDefinitionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_definition#read DataAzurermBlueprintDefinition#read}
    */
    readonly read?: string;
}
export declare function dataAzurermBlueprintDefinitionTimeoutsToTerraform(struct?: DataAzurermBlueprintDefinitionTimeoutsOutputReference | DataAzurermBlueprintDefinitionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermBlueprintDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermBlueprintDefinitionTimeouts | undefined;
    set internalValue(value: DataAzurermBlueprintDefinitionTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_definition azurerm_blueprint_definition}
*/
export declare class DataAzurermBlueprintDefinition extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_blueprint_definition";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_definition azurerm_blueprint_definition} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermBlueprintDefinitionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermBlueprintDefinitionConfig);
    get description(): string;
    get displayName(): string;
    get id(): string;
    get lastModified(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    get targetScope(): string;
    get timeCreated(): string;
    get versions(): string[];
    private _timeouts;
    get timeouts(): DataAzurermBlueprintDefinitionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermBlueprintDefinitionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermBlueprintDefinitionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
